/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.protocol.http.Authenticator;
import gnu.java.net.protocol.http.ByteArrayRequestBodyWriter;
import gnu.java.net.protocol.http.Credentials;
import gnu.java.net.protocol.http.HTTPConnection;
import gnu.java.net.protocol.http.Headers;
import gnu.java.net.protocol.http.Request;
import gnu.java.net.protocol.http.Response;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class HTTPURLConnection
extends HttpsURLConnection
implements HandshakeCompletedListener {
    private static final LinkedHashMap connectionPool = new LinkedHashMap();
    static int maxConnections;
    private HTTPConnection connection;
    String proxyHostname;
    int proxyPort;
    String agent;
    boolean keepAlive;
    private Request request;
    private Headers requestHeaders = new Headers();
    private ByteArrayOutputStream requestSink;
    private boolean requestMethodSetExplicitly;
    private Response response;
    private InputStream responseSink;
    private InputStream errorSink;
    private HandshakeCompletedEvent handshakeEvent;

    public void connect() throws IOException {
        boolean retry;
        int ci;
        if (this.connected) {
            return;
        }
        String protocol = this.url.getProtocol();
        boolean secure = "https".equals(protocol);
        String host = this.url.getHost();
        int port = this.url.getPort();
        if (port < 0) {
            port = secure ? 443 : 80;
        }
        String file = this.url.getFile();
        String username = this.url.getUserInfo();
        String password = null;
        if (username != null && (ci = username.indexOf(58)) != -1) {
            password = username.substring(ci + 1);
            username = username.substring(0, ci);
        }
        final Credentials creds = username == null ? null : new Credentials(username, password);
        do {
            retry = false;
            if (this.connection == null) {
                this.connection = this.getConnection(host, port, secure);
                if (secure) {
                    SSLSocketFactory factory = this.getSSLSocketFactory();
                    HostnameVerifier verifier = this.getHostnameVerifier();
                    if (factory != null) {
                        this.connection.setSSLSocketFactory(factory);
                    }
                    this.connection.addHandshakeCompletedListener(this);
                }
            }
            if (this.proxyHostname != null) {
                if (this.proxyPort < 0) {
                    this.proxyPort = secure ? 443 : 80;
                }
                this.connection.setProxy(this.proxyHostname, this.proxyPort);
            }
            try {
                this.request = this.connection.newRequest(this.method, file);
                if (!this.keepAlive) {
                    this.request.setHeader("Connection", "close");
                }
                if (this.agent != null) {
                    this.request.setHeader("User-Agent", this.agent);
                }
                this.request.getHeaders().putAll(this.requestHeaders);
                if (this.requestSink != null) {
                    byte[] content = this.requestSink.toByteArray();
                    ByteArrayRequestBodyWriter writer = new ByteArrayRequestBodyWriter(content);
                    this.request.setRequestBodyWriter(writer);
                }
                if (creds != null) {
                    this.request.setAuthenticator(new Authenticator(){

                        public final Credentials getCredentials(String realm, int attempts) {
                            return attempts < 2 ? creds : null;
                        }
                    });
                }
                this.response = this.request.dispatch();
            }
            catch (IOException ioe) {
                if (this.connection.useCount > 0) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException _) {
                        // empty catch block
                    }
                    this.connection = null;
                    retry = true;
                    continue;
                }
                throw ioe;
            }
            if (this.response.getCodeClass() == 3 && this.getInstanceFollowRedirects()) {
                int ci2;
                int end;
                String location = this.response.getHeader("Location");
                if (location == null) continue;
                String connectionUri = this.connection.getURI();
                int start = connectionUri.length();
                if (location.startsWith(connectionUri) && location.charAt(start) == '/') {
                    file = location.substring(start);
                    retry = true;
                    continue;
                }
                if (location.startsWith("http:")) {
                    this.connection.close();
                    this.connection = null;
                    secure = false;
                    start = 7;
                    end = location.indexOf(47, start);
                    host = location.substring(start, end);
                    ci2 = host.lastIndexOf(58);
                    if (ci2 != -1) {
                        port = Integer.parseInt(host.substring(ci2 + 1));
                        host = host.substring(0, ci2);
                    } else {
                        port = 80;
                    }
                    file = location.substring(end);
                    retry = true;
                    continue;
                }
                if (location.startsWith("https:")) {
                    this.connection.close();
                    this.connection = null;
                    secure = true;
                    start = 8;
                    end = location.indexOf(47, start);
                    host = location.substring(start, end);
                    ci2 = host.lastIndexOf(58);
                    if (ci2 != -1) {
                        port = Integer.parseInt(host.substring(ci2 + 1));
                        host = host.substring(0, ci2);
                    } else {
                        port = 443;
                    }
                    file = location.substring(end);
                    retry = true;
                    continue;
                }
                if (location.length() <= 0) continue;
                if (location.charAt(0) == '/') {
                    file = location;
                } else {
                    int lsi = file.lastIndexOf(47);
                    file = lsi == -1 ? "/" : file.substring(0, lsi + 1);
                    file = file + location;
                }
                retry = true;
                continue;
            }
            this.responseSink = this.response.getBody();
            if (this.response.getCode() != 404) continue;
            this.errorSink = this.responseSink;
            throw new FileNotFoundException(this.url.toString());
        } while (retry);
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HTTPConnection getConnection(String host, int port, boolean secure) throws IOException {
        if (!this.keepAlive) {
            return new HTTPConnection(host, port, secure);
        }
        Object key = HTTPConnection.getPoolKey(host, port, secure);
        LinkedHashMap linkedHashMap = connectionPool;
        synchronized (linkedHashMap) {
            HTTPConnection connection = (HTTPConnection)connectionPool.remove(key);
            if (connection != null) return connection;
            connection = new HTTPConnection(host, port, secure);
            connection.setPool(connectionPool);
            return connection;
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean usingProxy() {
        boolean bl = false;
        if (this.proxyHostname != null) {
            bl = true;
        }
        return bl;
    }

    public void setRequestMethod(String method) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        int len = (method = method.toUpperCase()).length();
        if (len == 0) {
            throw new ProtocolException("Empty method name");
        }
        int i = 0;
        while (i < len) {
            char c = method.charAt(i);
            if (c < 'A' || c > 'Z') {
                throw new ProtocolException("Illegal character '" + c + "' at index " + i);
            }
            ++i;
        }
        this.method = method;
        this.requestMethodSetExplicitly = true;
    }

    public String getRequestProperty(String key) {
        return this.requestHeaders.getValue(key);
    }

    public Map getRequestProperties() {
        return this.requestHeaders;
    }

    public void setRequestProperty(String key, String value) {
        this.requestHeaders.put(key, value);
    }

    public void addRequestProperty(String key, String value) {
        String old = this.requestHeaders.getValue(key);
        if (old == null) {
            this.requestHeaders.put(key, value);
        } else {
            this.requestHeaders.put(key, old + ',' + value);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        if (!this.doOutput) {
            throw new ProtocolException("doOutput is false");
        }
        if (!this.requestMethodSetExplicitly) {
            this.method = "POST";
        }
        if (this.requestSink == null) {
            this.requestSink = new ByteArrayOutputStream();
        }
        return this.requestSink;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("doInput is false");
        }
        return this.responseSink;
    }

    public InputStream getErrorStream() {
        return this.errorSink;
    }

    public Map getHeaderFields() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return null;
            }
        }
        Headers headers = this.response.getHeaders();
        LinkedHashMap ret = new LinkedHashMap();
        ret.put(null, Collections.singletonList(this.getStatusLine(this.response)));
        Iterator i = headers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            ret.put(key, Collections.singletonList(value));
        }
        return Collections.unmodifiableMap(ret);
    }

    String getStatusLine(Response response) {
        return "HTTP/" + response.getMajorVersion() + '.' + response.getMinorVersion() + ' ' + response.getCode() + ' ' + response.getMessage();
    }

    public String getHeaderField(int index) {
        Map.Entry entry;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (index == 0) {
            return this.getStatusLine(this.response);
        }
        Iterator i = this.response.getHeaders().entrySet().iterator();
        int count = 1;
        do {
            if (!i.hasNext()) {
                return null;
            }
            entry = (Map.Entry)i.next();
        } while (++count <= index);
        return (String)entry.getValue();
    }

    public String getHeaderFieldKey(int index) {
        Map.Entry entry;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (index == 0) {
            return null;
        }
        Iterator i = this.response.getHeaders().entrySet().iterator();
        int count = 1;
        do {
            if (!i.hasNext()) {
                return null;
            }
            entry = (Map.Entry)i.next();
        } while (++count <= index);
        return (String)entry.getKey();
    }

    public String getHeaderField(String name) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.response.getHeader(name);
    }

    public long getHeaderFieldDate(String name, long def) {
        Date date;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return def;
            }
        }
        return (date = this.response.getDateHeader(name)) == null ? def : date.getTime();
    }

    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getCode();
    }

    public String getResponseMessage() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getMessage();
    }

    public String getCipherSuite() {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getPeerCertificates();
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        this.handshakeEvent = event;
    }

    public HTTPURLConnection(URL url) throws IOException {
        super(url);
        AccessController.doPrivileged(new GetHTTPPropertiesAction());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class GetHTTPPropertiesAction
    implements PrivilegedAction {
        public Object run() {
            HTTPURLConnection.this.proxyHostname = System.getProperty("http.proxyHost");
            if (HTTPURLConnection.this.proxyHostname != null && HTTPURLConnection.this.proxyHostname.length() > 0) {
                String port = System.getProperty("http.proxyPort");
                if (port != null && port.length() > 0) {
                    HTTPURLConnection.this.proxyPort = Integer.parseInt(port);
                } else {
                    HTTPURLConnection.this.proxyHostname = null;
                    HTTPURLConnection.this.proxyPort = -1;
                }
            }
            HTTPURLConnection.this.agent = System.getProperty("http.agent");
            String ka = System.getProperty("http.keepAlive");
            boolean bl = false;
            if (ka != null && "false".equals(ka)) {
                bl = true;
            }
            HTTPURLConnection.this.keepAlive = bl ^ true;
            String mc = System.getProperty("http.maxConnections");
            maxConnections = mc != null && mc.length() > 0 ? Math.max(Integer.parseInt(mc), 1) : 5;
            return null;
        }

        GetHTTPPropertiesAction() {
        }
    }
}

