/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.DriverInternalError;
import java.net.InetSocketAddress;

public class UnpreparedException
extends DriverInternalError {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public UnpreparedException(InetSocketAddress address, String message) {
        super(String.format("A prepared query was submitted on %s but was not known of that node: %s", address, message));
        this.address = address;
    }

    private UnpreparedException(InetSocketAddress address, String message, UnpreparedException cause) {
        super(message, cause);
        this.address = address;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public UnpreparedException copy() {
        return new UnpreparedException(this.address, this.getMessage(), this);
    }
}

