/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Cells;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.utils.AbstractIterator;

public class ThriftResultsMerger
extends Transformation<UnfilteredRowIterator> {
    private final int nowInSec;

    private ThriftResultsMerger(int nowInSec) {
        this.nowInSec = nowInSec;
    }

    public static UnfilteredPartitionIterator maybeWrap(UnfilteredPartitionIterator iterator, CFMetaData metadata, int nowInSec) {
        if (!metadata.isStaticCompactTable() && !metadata.isSuper()) {
            return iterator;
        }
        return Transformation.apply(iterator, new ThriftResultsMerger(nowInSec));
    }

    public static UnfilteredRowIterator maybeWrap(UnfilteredRowIterator iterator, int nowInSec) {
        if (!iterator.metadata().isStaticCompactTable() && !iterator.metadata().isSuper()) {
            return iterator;
        }
        return iterator.metadata().isSuper() ? Transformation.apply(iterator, new SuperColumnsPartitionMerger(iterator, nowInSec)) : new PartitionMerger(iterator, nowInSec);
    }

    @Override
    public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator iter) {
        return iter.metadata().isSuper() ? Transformation.apply(iter, new SuperColumnsPartitionMerger(iter, this.nowInSec)) : new PartitionMerger(iter, this.nowInSec);
    }

    private static class SuperColumnsPartitionMerger
    extends Transformation {
        private final int nowInSec;
        private final Row.Builder builder;
        private final ColumnDefinition superColumnMapColumn;
        private final AbstractType<?> columnComparator;

        private SuperColumnsPartitionMerger(UnfilteredRowIterator applyTo, int nowInSec) {
            assert (applyTo.metadata().isSuper());
            this.nowInSec = nowInSec;
            this.superColumnMapColumn = applyTo.metadata().compactValueColumn();
            assert (this.superColumnMapColumn != null && this.superColumnMapColumn.type instanceof MapType);
            this.builder = BTreeRow.sortedBuilder();
            this.columnComparator = ((MapType)this.superColumnMapColumn.type).nameComparator();
        }

        @Override
        public Row applyToRow(Row row) {
            PeekingIterator dynamicCells;
            PeekingIterator staticCells = Iterators.peekingIterator(this.simpleCellsIterator(row));
            if (!staticCells.hasNext()) {
                return row;
            }
            this.builder.newRow(row.clustering());
            ComplexColumnData complexData = row.getComplexColumnData(this.superColumnMapColumn);
            if (complexData == null) {
                dynamicCells = Iterators.peekingIterator(Collections.emptyIterator());
            } else {
                dynamicCells = Iterators.peekingIterator(complexData.iterator());
                this.builder.addComplexDeletion(this.superColumnMapColumn, complexData.complexDeletion());
            }
            while (staticCells.hasNext() && dynamicCells.hasNext()) {
                Cell staticCell = (Cell)staticCells.peek();
                Cell dynamicCell = (Cell)dynamicCells.peek();
                int cmp = this.columnComparator.compare(staticCell.column().name.bytes, dynamicCell.path().get(0));
                if (cmp < 0) {
                    this.builder.addCell(this.makeDynamicCell((Cell)staticCells.next()));
                    continue;
                }
                if (cmp > 0) {
                    this.builder.addCell((Cell)dynamicCells.next());
                    continue;
                }
                this.builder.addCell(Cells.reconcile(this.makeDynamicCell((Cell)staticCells.next()), (Cell)dynamicCells.next(), this.nowInSec));
            }
            while (staticCells.hasNext()) {
                this.builder.addCell(this.makeDynamicCell((Cell)staticCells.next()));
            }
            while (dynamicCells.hasNext()) {
                this.builder.addCell((Cell)dynamicCells.next());
            }
            return this.builder.build();
        }

        private Cell makeDynamicCell(Cell staticCell) {
            return new BufferCell(this.superColumnMapColumn, staticCell.timestamp(), staticCell.ttl(), staticCell.localDeletionTime(), staticCell.value(), CellPath.create(staticCell.column().name.bytes));
        }

        private Iterator<Cell> simpleCellsIterator(Row row) {
            final Iterator<Cell> cells = row.cells().iterator();
            return new AbstractIterator<Cell>(){

                @Override
                protected Cell computeNext() {
                    Cell cell;
                    if (cells.hasNext() && (cell = (Cell)cells.next()).column().isSimple()) {
                        return cell;
                    }
                    return (Cell)this.endOfData();
                }
            };
        }
    }

    private static class PartitionMerger
    extends WrappingUnfilteredRowIterator {
        private final int nowInSec;
        private boolean isInit;
        private Iterator<Cell> staticCells;
        private final Row.Builder builder;
        private Row nextToMerge;
        private Unfiltered nextFromWrapped;

        private PartitionMerger(UnfilteredRowIterator results, int nowInSec) {
            super(results);
            assert (results.metadata().isStaticCompactTable());
            this.nowInSec = nowInSec;
            this.builder = BTreeRow.sortedBuilder();
        }

        private void init() {
            assert (!this.isInit);
            Row staticRow = super.staticRow();
            assert (!staticRow.hasComplex());
            this.staticCells = staticRow.cells().iterator();
            this.updateNextToMerge();
            this.isInit = true;
        }

        @Override
        public Row staticRow() {
            return Rows.EMPTY_STATIC_ROW;
        }

        @Override
        public boolean hasNext() {
            if (!this.isInit) {
                this.init();
            }
            return this.nextFromWrapped != null || this.nextToMerge != null || super.hasNext();
        }

        @Override
        public Unfiltered next() {
            if (!this.isInit) {
                this.init();
            }
            if (this.nextFromWrapped == null && super.hasNext()) {
                this.nextFromWrapped = super.next();
            }
            if (this.nextFromWrapped == null) {
                if (this.nextToMerge == null) {
                    throw new NoSuchElementException();
                }
                return this.consumeNextToMerge();
            }
            if (this.nextToMerge == null) {
                return this.consumeNextWrapped();
            }
            int cmp = this.metadata().comparator.compare(this.nextToMerge, this.nextFromWrapped);
            if (cmp < 0) {
                return this.consumeNextToMerge();
            }
            if (cmp > 0) {
                return this.consumeNextWrapped();
            }
            assert (this.nextFromWrapped instanceof Row);
            return Rows.merge((Row)this.consumeNextWrapped(), this.consumeNextToMerge(), this.nowInSec);
        }

        private Unfiltered consumeNextWrapped() {
            Unfiltered toReturn = this.nextFromWrapped;
            this.nextFromWrapped = null;
            return toReturn;
        }

        private Row consumeNextToMerge() {
            Row toReturn = this.nextToMerge;
            this.updateNextToMerge();
            return toReturn;
        }

        private void updateNextToMerge() {
            if (!this.staticCells.hasNext()) {
                this.nextToMerge = null;
                return;
            }
            Cell cell = this.staticCells.next();
            this.builder.newRow(Clustering.make(cell.column().name.bytes));
            this.builder.addCell(new BufferCell(this.metadata().compactValueColumn(), cell.timestamp(), cell.ttl(), cell.localDeletionTime(), cell.value(), cell.path()));
            this.nextToMerge = this.builder.build();
        }
    }
}

