/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.igoweb.igoweb.client.CChannel;
import org.igoweb.igoweb.client.CConvo;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.ChatPane;
import org.igoweb.igoweb.client.swing.ClientPanel;
import org.igoweb.igoweb.client.swing.ClientWindow;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.Prefs;

public class ConvoPanel
extends ClientPanel
implements ActionListener,
EventListener {
    public static final String ALARM_FOR_TELLS_PREF = ":14_`9Lf";
    public static final int DEAD = 0;
    public static final int DISCONNECTED = 1;
    public static final int BUSY = 2;
    public static final int PLAYING = 3;
    public static final int NORMAL = 4;
    public static final int TOURN_PLAYING = 5;
    public static final int NO_CHATS = 6;
    private static AudioClip talkSound = null;
    private static Timer blinkTimer = null;
    private boolean noChats = false;
    private final ChatPane output;
    private final ATextField text = new ATextField(this);
    private final JLabel title;
    private final JButton infoBut = new JButton();
    public final Client client;
    private CConvo convo;
    public final ClientWindow clientWin;

    public ConvoPanel(CConvo convo, Client client, ClientWindow clientWin) {
        this.client = client;
        this.clientWin = clientWin;
        this.convo = convo;
        this.setName(Defs.getString(-903340774, convo.peer.name));
        OutputSaver saver = (OutputSaver)client.objects.get(this.getClass().getName() + ':' + convo.peer.canonName());
        if (saver == null) {
            this.output = new ChatPane(client, convo, 100);
        } else {
            this.output = saver.output;
            this.output.setChannel(convo);
        }
        convo.addListener(this);
        convo.peer.addListener(this);
        this.add("xGrow=t", this.titlePanel);
        this.title = new JLabel(Defs.getString(-903340778 + this.state(convo.peer), convo.peer.name));
        this.titlePanel.add("xGrow=t", this.title);
        this.infoBut.setText(Defs.getString(-903340542, convo.peer.name));
        this.infoBut.addActionListener(this);
        this.titlePanel.add("xGrow=f", this.infoBut);
        this.titlePanel.add(this.popBut);
        this.titlePanel.add(this.closeBut);
        this.closeBut.addActionListener(this);
        this.add("x=0,yGrow=t", this.output);
        this.add("x=0,yGrow=f", this.text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeBut) {
            this.close();
        } else if (source == this.text) {
            String s = this.text.getText();
            if (s.length() > 0) {
                if (s.length() > 1000) {
                    new Errout(Defs.getString(-903340583, 1000.0), (AFrame)this.getTopLevelAncestor());
                } else {
                    this.text.setText("");
                    this.convo.sendChat(s);
                }
            }
        } else if (source == this.infoBut) {
            this.client.requestUserDetails(this.convo.peer.name);
        }
    }

    @Override
    public void close() {
        if (!this.convo.isClosed()) {
            this.convo.sendUnjoinRequest();
        }
        this.clientWin.removeChat(this);
        this.remove(this.output);
        if (this.convo != null) {
            this.convo.sendUnjoinRequest();
            String key = this.getClass().getName() + ':' + this.convo.peer.canonName();
            OutputSaver saver = new OutputSaver(this.client.objects, this.output, key);
            Timer timer = new Timer(30000, saver);
            this.client.objects.put(key, saver);
            timer.setRepeats(false);
            timer.start();
        }
    }

    public User getConvoPeer() {
        return this.convo.peer;
    }

    private void tell(User src, String msg) {
        if (Prefs.getBoolean(ALARM_FOR_TELLS_PREF, true) && blinkTimer == null) {
            AFrame topWin = (AFrame)this.getTopLevelAncestor();
            if (topWin == null) {
                return;
            }
            if (!(topWin.isShowing() && topWin.getState() != 1 && this.clientWin.isActivated() || src == this.client.getMe() || !Defs.isSoundEnabled())) {
                if (talkSound == null) {
                    talkSound = Applet.newAudioClip(this.getClass().getClassLoader().getResource("org/igoweb/igoweb/client/swing/sounds/talk.au"));
                }
                if (talkSound != null) {
                    talkSound.play();
                }
            }
            blinkTimer = new Timer(500, new ActionListener(){
                int blinkIter = 0;

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (++this.blinkIter == 6) {
                        blinkTimer.stop();
                        blinkTimer = null;
                    }
                }
            });
            blinkTimer.setRepeats(true);
            blinkTimer.start();
        }
        if (src != this.client.getMe()) {
            this.emit(65537);
        }
    }

    private void update() {
        int state = this.state(this.convo.peer);
        this.title.setText(Defs.getString(-903340778 + state, this.convo.peer.name));
        this.text.setEnabled(!(state == 0 || state == 1 || this.convo.isClosed() || state == 6 && this.client.getMe().getAuthLevel() < 3 || state == 5 && this.client.getMe().getAuthLevel() < 4 && this.convo.peer.getAuthLevel() < 4));
    }

    private int state(User peer) {
        if (peer.isDeleted()) {
            return 0;
        }
        if (!peer.isConnected()) {
            return 1;
        }
        if (peer.isInTourn()) {
            return 5;
        }
        if (this.noChats) {
            return 6;
        }
        if (peer.isPlaying()) {
            return 3;
        }
        if (peer.isSleeping()) {
            return 2;
        }
        return 4;
    }

    @Override
    public boolean closeForTournament() {
        return this.convo.peer.getAuthLevel() < 4;
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 17: {
                CChannel.Chat chat = (CChannel.Chat)event.arg;
                this.tell(chat.user, chat.text);
                if (!this.noChats || this.client.getMe().getAuthLevel() >= 3) break;
                this.noChats = false;
                this.update();
                break;
            }
            case 16: {
                this.convo.peer.removeListener(this);
                this.update();
                break;
            }
            case 0: {
                System.err.println("FLAGS CHANGED on " + event.source);
                this.update();
                break;
            }
            case 85: {
                if (this.noChats || this.convo.isChatsOk()) break;
                this.noChats = true;
                this.update();
            }
        }
    }

    @Override
    public String getSortKey() {
        return "5";
    }

    private static class OutputSaver
    implements ActionListener {
        private final HashMap<?, ?> hash;
        public final ChatPane output;
        private final String key;

        public OutputSaver(HashMap<?, ?> hash, ChatPane output, String key) {
            this.hash = hash;
            this.output = output;
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.hash.get(this.key) == this) {
                this.hash.remove(this.key);
            }
        }
    }
}

