/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust.issue;

import org.apache.ws.sandbox.security.trust.STSUtil;
import org.apache.ws.sandbox.security.trust.WSTrustException;
import org.apache.ws.sandbox.security.trust.issue.STIssuer;
import org.apache.ws.sandbox.security.trust.message.token.BaseToken;
import org.apache.ws.sandbox.security.trust.message.token.Lifetime;
import org.apache.ws.sandbox.security.trust.message.token.RequestSecurityTokenResponse;
import org.apache.ws.sandbox.security.trust.message.token.RequestType;
import org.apache.ws.sandbox.security.trust.message.token.RequestedSecurityToken;
import org.apache.ws.sandbox.security.trust.message.token.TokenType;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class X509ToSCTIssuer
implements STIssuer {
    X509Security x509;
    int lifeTime = 120;
    Crypto crypto;
    protected String alias = "";

    public Document issue(Document req, Document res) throws Exception {
        Element elemTokenType = (Element)WSSecurityUtil.findElement(req, TokenType.TOKEN.getLocalPart(), TokenType.TOKEN.getNamespaceURI());
        TokenType tokenType = new TokenType(elemTokenType);
        Element elemRequestType = (Element)WSSecurityUtil.findElement(req, RequestType.TOKEN.getLocalPart(), RequestType.TOKEN.getNamespaceURI());
        RequestType requestType = new RequestType(elemRequestType);
        Element elemBase = (Element)WSSecurityUtil.findElement(req, BaseToken.TOKEN.getLocalPart(), BaseToken.TOKEN.getNamespaceURI());
        BaseToken base = new BaseToken(elemBase);
        BinarySecurity binarySecurity = STSUtil.findBinarySecurityToken(req);
        Element sct = this.getSecuritContextToken(res, this.x509);
        RequestSecurityTokenResponse requestSecurityTokenResponse = new RequestSecurityTokenResponse(res);
        RequestedSecurityToken requestedSecurityToken = new RequestedSecurityToken(res);
        TokenType tokenTypeRes = new TokenType(res);
        tokenTypeRes.setValue(tokenType.getValue());
        RequestType requestTypeRes = new RequestType(res);
        requestTypeRes.setValue(requestType.getValue());
        Lifetime lt = new Lifetime(res, this.getLifeTime());
        Element elemEnv = res.getDocumentElement();
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(elemEnv);
        Element elemBody = WSSecurityUtil.findBodyElement(elemEnv.getOwnerDocument(), soapConstants);
        Element cld0 = (Element)elemBody.removeChild((Element)elemBody.getFirstChild());
        return res;
    }

    public abstract Element getSecuritContextToken(Document var1, X509Security var2) throws WSTrustException;

    public int getLifeTime() {
        return this.lifeTime;
    }

    public X509Security getX509() {
        return this.x509;
    }

    public void setLifeTime(int time) {
        this.lifeTime = time;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }
}

