/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZonedDateTime;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.CurrentFunction;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class CurrentDateTime
extends CurrentFunction {
    private final Expression precision;

    public CurrentDateTime(Source source, Expression precision, Configuration configuration) {
        super(source, configuration, CurrentDateTime.nanoPrecision(configuration.now(), precision), DataType.DATETIME);
        this.precision = precision;
    }

    Expression precision() {
        return this.precision;
    }

    @Override
    protected NodeInfo<CurrentDateTime> info() {
        return NodeInfo.create(this, CurrentDateTime::new, this.precision, this.configuration());
    }

    static ZonedDateTime nanoPrecision(ZonedDateTime zdt, Expression precisionExpression) {
        return zdt.withNano(DateUtils.getNanoPrecision(precisionExpression, zdt.getNano()));
    }
}

