/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.comparison;

import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.BinaryComparisonPipe;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.Comparisons;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class BinaryComparison
extends BinaryOperator<Object, Object, Boolean, BinaryComparisonProcessor.BinaryComparisonOperation> {
    protected BinaryComparison(Source source, Expression left, Expression right, BinaryComparisonProcessor.BinaryComparisonOperation operation) {
        super(source, left, right, operation);
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, Expressions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isExact(e, this.sourceText(), paramOrdinal);
    }

    @Override
    protected Expression canonicalize() {
        return this.left().hashCode() > this.right().hashCode() ? this.swapLeftAndRight() : this;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    protected Pipe makePipe() {
        return new BinaryComparisonPipe(this.source(), this, Expressions.pipe(this.left()), Expressions.pipe(this.right()), (BinaryComparisonProcessor.BinaryComparisonOperation)this.function());
    }

    public static Integer compare(Object left, Object right) {
        return Comparisons.compare(left, right);
    }
}

