/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.rng.RngProperty;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.SAXException;

class TestDriver {
    private ValidationDriver driver;
    private ErrorHandlerImpl eh;
    private Localizer localizer = new Localizer(TestDriver.class);
    private int nTests = 0;
    private static final String CORRECT_SCHEMA_NAME = "c.rng";
    private static final String INCORRECT_SCHEMA_NAME = "i.rng";
    private static final String VALID_INSTANCE_SUFFIX = ".v.xml";
    private static final String INVALID_INSTANCE_SUFFIX = ".i.xml";

    TestDriver() {
    }

    public static void main(String[] args) throws IOException {
        System.exit(new TestDriver().doMain(args));
    }

    public int doMain(String[] args) throws IOException {
        long startTime = System.currentTimeMillis();
        this.eh = new ErrorHandlerImpl(System.out);
        OptionParser op = new OptionParser("i", args);
        PropertyMapBuilder properties = new PropertyMapBuilder();
        RngProperty.DATATYPE_LIBRARY_FACTORY.put(properties, new DatatypeLibraryLoader());
        try {
            while (op.moveToNextOption()) {
                switch (op.getOptionChar()) {
                    case 'i': {
                        RngProperty.CHECK_ID_IDREF.add(properties);
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException e) {
            this.eh.print(this.localizer.message("invalid_option", op.getOptionCharString()));
            return 2;
        }
        catch (OptionParser.MissingArgumentException e) {
            this.eh.print(this.localizer.message("option_missing_argument", op.getOptionCharString()));
            return 2;
        }
        args = op.getRemainingArgs();
        this.eh = new ErrorHandlerImpl(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(args[0]))));
        ValidateProperty.ERROR_HANDLER.put(properties, this.eh);
        this.driver = new ValidationDriver(properties.toPropertyMap());
        int result = 0;
        for (int i = 1; i < args.length; ++i) {
            int n = this.runTestSuite(new File(args[i]));
            if (n <= result) continue;
            result = n;
        }
        System.err.println("Number of tests: " + this.nTests);
        System.err.println("Elapsed time: " + (System.currentTimeMillis() - startTime));
        this.eh.close();
        return result;
    }

    public int runTestSuite(File dir) throws IOException {
        int result = 0;
        String[] subdirs = dir.list();
        for (int i = 0; i < subdirs.length; ++i) {
            int n;
            File subdir = new File(dir, subdirs[i]);
            if (!subdir.isDirectory() || (n = this.runTestCase(subdir)) <= result) continue;
            result = n;
        }
        return result;
    }

    private int runTestCase(File dir) throws IOException {
        File f = new File(dir, INCORRECT_SCHEMA_NAME);
        if (f.exists()) {
            if (this.loadSchema(f)) {
                TestDriver.failed(f);
                return 1;
            }
            return 0;
        }
        f = new File(dir, CORRECT_SCHEMA_NAME);
        if (!f.exists()) {
            return 0;
        }
        if (!this.loadSchema(f)) {
            TestDriver.failed(f);
            return 1;
        }
        String[] files = dir.list();
        int result = 0;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].endsWith(VALID_INSTANCE_SUFFIX)) {
                f = new File(dir, files[i]);
                if (this.validateInstance(f)) continue;
                TestDriver.failed(f);
                result = 1;
                continue;
            }
            if (!files[i].endsWith(INVALID_INSTANCE_SUFFIX) || !this.validateInstance(f = new File(dir, files[i]))) continue;
            TestDriver.failed(f);
            result = 1;
        }
        return result;
    }

    private static void failed(File f) {
        System.err.println("Failed: " + f.toString());
    }

    private boolean loadSchema(File schema) throws IOException {
        ++this.nTests;
        try {
            if (this.driver.loadSchema(ValidationDriver.fileInputSource(schema))) {
                return true;
            }
        }
        catch (SAXException e) {
            this.eh.printException(e);
        }
        return false;
    }

    private boolean validateInstance(File instance) throws IOException {
        ++this.nTests;
        try {
            if (this.driver.validate(ValidationDriver.fileInputSource(instance))) {
                return true;
            }
        }
        catch (SAXException e) {
            this.eh.printException(e);
        }
        return false;
    }
}

