/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.ConnectionManager;
import free.jin.I18n;
import free.jin.Jin;
import free.jin.Session;
import free.jin.SessionEvent;
import free.jin.SessionListener;
import free.jin.action.JinAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ActionsMenu
extends JMenu
implements SessionListener,
ListDataListener {
    public ActionsMenu() {
        I18n.get(ActionsMenu.class).initAbstractButton(this, "this");
    }

    public void addNotify() {
        super.addNotify();
        ConnectionManager connectionManager = Jin.getInstance().getConnManager();
        connectionManager.addSessionListener(this);
        Session session = connectionManager.getSession();
        if (session != null) {
            ListModel listModel = session.getPluginContext().getActions();
            listModel.addListDataListener(this);
            this.updateActionMenuItems(listModel);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        ConnectionManager connectionManager = Jin.getInstance().getConnManager();
        connectionManager.removeSessionListener(this);
        Session session = connectionManager.getSession();
        if (session != null) {
            ListModel listModel = session.getPluginContext().getActions();
            listModel.removeListDataListener(this);
            this.removeAll();
        }
    }

    private void updateActionMenuItems(ListModel listModel) {
        this.removeAll();
        for (int i = 0; i < listModel.getSize(); ++i) {
            JinAction jinAction = (JinAction)listModel.getElementAt(i);
            JMenuItem jMenuItem = new JMenuItem(jinAction.getName());
            jMenuItem.addActionListener(new ActionInvoker(jinAction));
            this.add(jMenuItem);
        }
    }

    public void sessionEstablished(SessionEvent sessionEvent) {
        Session session = sessionEvent.getSession();
        ListModel listModel = session.getPluginContext().getActions();
        listModel.addListDataListener(this);
        this.updateActionMenuItems(listModel);
    }

    public void sessionClosed(SessionEvent sessionEvent) {
        Session session = sessionEvent.getSession();
        ListModel listModel = session.getPluginContext().getActions();
        listModel.removeListDataListener(this);
        this.removeAll();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateActionMenuItems((ListModel)listDataEvent.getSource());
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateActionMenuItems((ListModel)listDataEvent.getSource());
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateActionMenuItems((ListModel)listDataEvent.getSource());
    }

    private class ActionInvoker
    implements ActionListener {
        private final JinAction action;

        public ActionInvoker(JinAction jinAction) {
            this.action = jinAction;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.action.go(ActionsMenu.this);
        }
    }
}

