require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_GCC_ARM_MVE_H)) {
    eval 'sub _GCC_ARM_MVE_H () {1;}' unless defined(&_GCC_ARM_MVE_H);
    if((defined(&__ARM_BIG_ENDIAN) ? &__ARM_BIG_ENDIAN : undef)) {
	die("MVE intrinsics are not supported in Big-Endian mode.");
    }
 elsif(!(defined(&__ARM_FEATURE_MVE) ? &__ARM_FEATURE_MVE : undef)) {
	die("MVE feature not supported");
    } else {
	require 'stdint.ph';
	unless(defined(&__cplusplus)) {
	    require 'stdbool.ph';
	}
	require './gcc-10/arm_mve_types.ph';
	unless(defined(&__ARM_MVE_PRESERVE_USER_NAMESPACE)) {
	    eval 'sub vst4q {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst4q($__addr, $__value));
	    }' unless defined(&vst4q);
	    eval 'sub vdupq_n {
	        my($__a) = @_;
    		eval q( &__arm_vdupq_n($__a));
	    }' unless defined(&vdupq_n);
	    eval 'sub vabsq {
	        my($__a) = @_;
    		eval q( &__arm_vabsq($__a));
	    }' unless defined(&vabsq);
	    eval 'sub vclsq {
	        my($__a) = @_;
    		eval q( &__arm_vclsq($__a));
	    }' unless defined(&vclsq);
	    eval 'sub vclzq {
	        my($__a) = @_;
    		eval q( &__arm_vclzq($__a));
	    }' unless defined(&vclzq);
	    eval 'sub vnegq {
	        my($__a) = @_;
    		eval q( &__arm_vnegq($__a));
	    }' unless defined(&vnegq);
	    eval 'sub vaddlvq {
	        my($__a) = @_;
    		eval q( &__arm_vaddlvq($__a));
	    }' unless defined(&vaddlvq);
	    eval 'sub vaddvq {
	        my($__a) = @_;
    		eval q( &__arm_vaddvq($__a));
	    }' unless defined(&vaddvq);
	    eval 'sub vmovlbq {
	        my($__a) = @_;
    		eval q( &__arm_vmovlbq($__a));
	    }' unless defined(&vmovlbq);
	    eval 'sub vmovltq {
	        my($__a) = @_;
    		eval q( &__arm_vmovltq($__a));
	    }' unless defined(&vmovltq);
	    eval 'sub vmvnq {
	        my($__a) = @_;
    		eval q( &__arm_vmvnq($__a));
	    }' unless defined(&vmvnq);
	    eval 'sub vrev16q {
	        my($__a) = @_;
    		eval q( &__arm_vrev16q($__a));
	    }' unless defined(&vrev16q);
	    eval 'sub vrev32q {
	        my($__a) = @_;
    		eval q( &__arm_vrev32q($__a));
	    }' unless defined(&vrev32q);
	    eval 'sub vrev64q {
	        my($__a) = @_;
    		eval q( &__arm_vrev64q($__a));
	    }' unless defined(&vrev64q);
	    eval 'sub vqabsq {
	        my($__a) = @_;
    		eval q( &__arm_vqabsq($__a));
	    }' unless defined(&vqabsq);
	    eval 'sub vqnegq {
	        my($__a) = @_;
    		eval q( &__arm_vqnegq($__a));
	    }' unless defined(&vqnegq);
	    eval 'sub vshrq {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vshrq($__a, $__imm));
	    }' unless defined(&vshrq);
	    eval 'sub vaddlvq_p {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vaddlvq_p($__a, $__p));
	    }' unless defined(&vaddlvq_p);
	    eval 'sub vcmpneq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq($__a, $__b));
	    }' unless defined(&vcmpneq);
	    eval 'sub vshlq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq($__a, $__b));
	    }' unless defined(&vshlq);
	    eval 'sub vsubq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq($__a, $__b));
	    }' unless defined(&vsubq);
	    eval 'sub vrmulhq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmulhq($__a, $__b));
	    }' unless defined(&vrmulhq);
	    eval 'sub vrhaddq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrhaddq($__a, $__b));
	    }' unless defined(&vrhaddq);
	    eval 'sub vqsubq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq($__a, $__b));
	    }' unless defined(&vqsubq);
	    eval 'sub vqaddq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq($__a, $__b));
	    }' unless defined(&vqaddq);
	    eval 'sub vorrq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vorrq($__a, $__b));
	    }' unless defined(&vorrq);
	    eval 'sub vornq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vornq($__a, $__b));
	    }' unless defined(&vornq);
	    eval 'sub vmulq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq($__a, $__b));
	    }' unless defined(&vmulq);
	    eval 'sub vmulltq_int {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulltq_int($__a, $__b));
	    }' unless defined(&vmulltq_int);
	    eval 'sub vmullbq_int {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmullbq_int($__a, $__b));
	    }' unless defined(&vmullbq_int);
	    eval 'sub vmulhq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulhq($__a, $__b));
	    }' unless defined(&vmulhq);
	    eval 'sub vmladavq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavq($__a, $__b));
	    }' unless defined(&vmladavq);
	    eval 'sub vminvq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminvq($__a, $__b));
	    }' unless defined(&vminvq);
	    eval 'sub vminq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminq($__a, $__b));
	    }' unless defined(&vminq);
	    eval 'sub vmaxvq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxvq($__a, $__b));
	    }' unless defined(&vmaxvq);
	    eval 'sub vmaxq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxq($__a, $__b));
	    }' unless defined(&vmaxq);
	    eval 'sub vhsubq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq($__a, $__b));
	    }' unless defined(&vhsubq);
	    eval 'sub vhaddq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq($__a, $__b));
	    }' unless defined(&vhaddq);
	    eval 'sub veorq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_veorq($__a, $__b));
	    }' unless defined(&veorq);
	    eval 'sub vcmphiq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmphiq($__a, $__b));
	    }' unless defined(&vcmphiq);
	    eval 'sub vcmpeqq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq($__a, $__b));
	    }' unless defined(&vcmpeqq);
	    eval 'sub vcmpcsq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpcsq($__a, $__b));
	    }' unless defined(&vcmpcsq);
	    eval 'sub vcaddq_rot90 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot90($__a, $__b));
	    }' unless defined(&vcaddq_rot90);
	    eval 'sub vcaddq_rot270 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot270($__a, $__b));
	    }' unless defined(&vcaddq_rot270);
	    eval 'sub vbicq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbicq($__a, $__b));
	    }' unless defined(&vbicq);
	    eval 'sub vandq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vandq($__a, $__b));
	    }' unless defined(&vandq);
	    eval 'sub vaddvq_p {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vaddvq_p($__a, $__p));
	    }' unless defined(&vaddvq_p);
	    eval 'sub vaddvaq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddvaq($__a, $__b));
	    }' unless defined(&vaddvaq);
	    eval 'sub vaddq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq($__a, $__b));
	    }' unless defined(&vaddq);
	    eval 'sub vabdq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vabdq($__a, $__b));
	    }' unless defined(&vabdq);
	    eval 'sub vshlq_r {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_r($__a, $__b));
	    }' unless defined(&vshlq_r);
	    eval 'sub vrshlq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq($__a, $__b));
	    }' unless defined(&vrshlq);
	    eval 'sub vqshlq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq($__a, $__b));
	    }' unless defined(&vqshlq);
	    eval 'sub vqshlq_r {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_r($__a, $__b));
	    }' unless defined(&vqshlq_r);
	    eval 'sub vqrshlq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq($__a, $__b));
	    }' unless defined(&vqrshlq);
	    eval 'sub vminavq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminavq($__a, $__b));
	    }' unless defined(&vminavq);
	    eval 'sub vminaq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminaq($__a, $__b));
	    }' unless defined(&vminaq);
	    eval 'sub vmaxavq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxavq($__a, $__b));
	    }' unless defined(&vmaxavq);
	    eval 'sub vmaxaq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxaq($__a, $__b));
	    }' unless defined(&vmaxaq);
	    eval 'sub vbrsrq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbrsrq($__a, $__b));
	    }' unless defined(&vbrsrq);
	    eval 'sub vshlq_n {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vshlq_n($__a, $__imm));
	    }' unless defined(&vshlq_n);
	    eval 'sub vrshrq {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vrshrq($__a, $__imm));
	    }' unless defined(&vrshrq);
	    eval 'sub vqshlq_n {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vqshlq_n($__a, $__imm));
	    }' unless defined(&vqshlq_n);
	    eval 'sub vcmpltq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq($__a, $__b));
	    }' unless defined(&vcmpltq);
	    eval 'sub vcmpleq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq($__a, $__b));
	    }' unless defined(&vcmpleq);
	    eval 'sub vcmpgtq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq($__a, $__b));
	    }' unless defined(&vcmpgtq);
	    eval 'sub vcmpgeq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq($__a, $__b));
	    }' unless defined(&vcmpgeq);
	    eval 'sub vqshluq {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vqshluq($__a, $__imm));
	    }' unless defined(&vqshluq);
	    eval 'sub vqrdmulhq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrdmulhq($__a, $__b));
	    }' unless defined(&vqrdmulhq);
	    eval 'sub vqdmulhq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulhq($__a, $__b));
	    }' unless defined(&vqdmulhq);
	    eval 'sub vmlsdavxq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsdavxq($__a, $__b));
	    }' unless defined(&vmlsdavxq);
	    eval 'sub vmlsdavq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsdavq($__a, $__b));
	    }' unless defined(&vmlsdavq);
	    eval 'sub vmladavxq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavxq($__a, $__b));
	    }' unless defined(&vmladavxq);
	    eval 'sub vhcaddq_rot90 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhcaddq_rot90($__a, $__b));
	    }' unless defined(&vhcaddq_rot90);
	    eval 'sub vhcaddq_rot270 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhcaddq_rot270($__a, $__b));
	    }' unless defined(&vhcaddq_rot270);
	    eval 'sub vqmovntq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovntq($__a, $__b));
	    }' unless defined(&vqmovntq);
	    eval 'sub vqmovnbq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovnbq($__a, $__b));
	    }' unless defined(&vqmovnbq);
	    eval 'sub vmulltq_poly {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulltq_poly($__a, $__b));
	    }' unless defined(&vmulltq_poly);
	    eval 'sub vmullbq_poly {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmullbq_poly($__a, $__b));
	    }' unless defined(&vmullbq_poly);
	    eval 'sub vmovntq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmovntq($__a, $__b));
	    }' unless defined(&vmovntq);
	    eval 'sub vmovnbq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmovnbq($__a, $__b));
	    }' unless defined(&vmovnbq);
	    eval 'sub vmlaldavq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlaldavq($__a, $__b));
	    }' unless defined(&vmlaldavq);
	    eval 'sub vqmovuntq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovuntq($__a, $__b));
	    }' unless defined(&vqmovuntq);
	    eval 'sub vqmovunbq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovunbq($__a, $__b));
	    }' unless defined(&vqmovunbq);
	    eval 'sub vshlltq {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vshlltq($__a, $__imm));
	    }' unless defined(&vshlltq);
	    eval 'sub vshllbq {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vshllbq($__a, $__imm));
	    }' unless defined(&vshllbq);
	    eval 'sub vqdmulltq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulltq($__a, $__b));
	    }' unless defined(&vqdmulltq);
	    eval 'sub vqdmullbq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmullbq($__a, $__b));
	    }' unless defined(&vqdmullbq);
	    eval 'sub vmlsldavxq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsldavxq($__a, $__b));
	    }' unless defined(&vmlsldavxq);
	    eval 'sub vmlsldavq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsldavq($__a, $__b));
	    }' unless defined(&vmlsldavq);
	    eval 'sub vmlaldavxq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlaldavxq($__a, $__b));
	    }' unless defined(&vmlaldavxq);
	    eval 'sub vrmlaldavhq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmlaldavhq($__a, $__b));
	    }' unless defined(&vrmlaldavhq);
	    eval 'sub vaddlvaq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddlvaq($__a, $__b));
	    }' unless defined(&vaddlvaq);
	    eval 'sub vrmlsldavhxq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmlsldavhxq($__a, $__b));
	    }' unless defined(&vrmlsldavhxq);
	    eval 'sub vrmlsldavhq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmlsldavhq($__a, $__b));
	    }' unless defined(&vrmlsldavhq);
	    eval 'sub vrmlaldavhxq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmlaldavhxq($__a, $__b));
	    }' unless defined(&vrmlaldavhxq);
	    eval 'sub vabavq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vabavq($__a, $__b, $__c));
	    }' unless defined(&vabavq);
	    eval 'sub vbicq_m_n {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vbicq_m_n($__a, $__imm, $__p));
	    }' unless defined(&vbicq_m_n);
	    eval 'sub vqrshrnbq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vqrshrnbq($__a, $__b, $__imm));
	    }' unless defined(&vqrshrnbq);
	    eval 'sub vqrshrunbq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vqrshrunbq($__a, $__b, $__imm));
	    }' unless defined(&vqrshrunbq);
	    eval 'sub vrmlaldavhaq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vrmlaldavhaq($__a, $__b, $__c));
	    }' unless defined(&vrmlaldavhaq);
	    eval 'sub vshlcq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vshlcq($__a, $__b, $__imm));
	    }' unless defined(&vshlcq);
	    eval 'sub vpselq {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq($__a, $__b, $__p));
	    }' unless defined(&vpselq);
	    eval 'sub vrev64q_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev64q_m($__inactive, $__a, $__p));
	    }' unless defined(&vrev64q_m);
	    eval 'sub vqrdmlashq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqrdmlashq($__a, $__b, $__c));
	    }' unless defined(&vqrdmlashq);
	    eval 'sub vqrdmlahq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqrdmlahq($__a, $__b, $__c));
	    }' unless defined(&vqrdmlahq);
	    eval 'sub vqdmlashq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqdmlashq($__a, $__b, $__c));
	    }' unless defined(&vqdmlashq);
	    eval 'sub vqdmlahq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqdmlahq($__a, $__b, $__c));
	    }' unless defined(&vqdmlahq);
	    eval 'sub vmvnq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmvnq_m($__inactive, $__a, $__p));
	    }' unless defined(&vmvnq_m);
	    eval 'sub vmlasq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlasq($__a, $__b, $__c));
	    }' unless defined(&vmlasq);
	    eval 'sub vmlaq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaq($__a, $__b, $__c));
	    }' unless defined(&vmlaq);
	    eval 'sub vmladavq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavq_p($__a, $__b, $__p));
	    }' unless defined(&vmladavq_p);
	    eval 'sub vmladavaq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaq($__a, $__b, $__c));
	    }' unless defined(&vmladavaq);
	    eval 'sub vminvq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminvq_p($__a, $__b, $__p));
	    }' unless defined(&vminvq_p);
	    eval 'sub vmaxvq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxvq_p($__a, $__b, $__p));
	    }' unless defined(&vmaxvq_p);
	    eval 'sub vdupq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vdupq_m($__inactive, $__a, $__p));
	    }' unless defined(&vdupq_m);
	    eval 'sub vcmpneq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m);
	    eval 'sub vcmphiq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmphiq_m($__a, $__b, $__p));
	    }' unless defined(&vcmphiq_m);
	    eval 'sub vcmpeqq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m);
	    eval 'sub vcmpcsq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpcsq_m($__a, $__b, $__p));
	    }' unless defined(&vcmpcsq_m);
	    eval 'sub vcmpcsq_m_n {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpcsq_m_n($__a, $__b, $__p));
	    }' unless defined(&vcmpcsq_m_n);
	    eval 'sub vclzq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclzq_m($__inactive, $__a, $__p));
	    }' unless defined(&vclzq_m);
	    eval 'sub vaddvaq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddvaq_p($__a, $__b, $__p));
	    }' unless defined(&vaddvaq_p);
	    eval 'sub vsriq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vsriq($__a, $__b, $__imm));
	    }' unless defined(&vsriq);
	    eval 'sub vsliq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vsliq($__a, $__b, $__imm));
	    }' unless defined(&vsliq);
	    eval 'sub vshlq_m_r {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_r($__a, $__b, $__p));
	    }' unless defined(&vshlq_m_r);
	    eval 'sub vrshlq_m_n {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_n($__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_n);
	    eval 'sub vqshlq_m_r {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_r($__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_r);
	    eval 'sub vqrshlq_m_n {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_n($__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_n);
	    eval 'sub vminavq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminavq_p($__a, $__b, $__p));
	    }' unless defined(&vminavq_p);
	    eval 'sub vminaq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminaq_m($__a, $__b, $__p));
	    }' unless defined(&vminaq_m);
	    eval 'sub vmaxavq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxavq_p($__a, $__b, $__p));
	    }' unless defined(&vmaxavq_p);
	    eval 'sub vmaxaq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxaq_m($__a, $__b, $__p));
	    }' unless defined(&vmaxaq_m);
	    eval 'sub vcmpltq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m);
	    eval 'sub vcmpleq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m);
	    eval 'sub vcmpgtq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m);
	    eval 'sub vcmpgeq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m);
	    eval 'sub vqnegq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vqnegq_m($__inactive, $__a, $__p));
	    }' unless defined(&vqnegq_m);
	    eval 'sub vqabsq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vqabsq_m($__inactive, $__a, $__p));
	    }' unless defined(&vqabsq_m);
	    eval 'sub vnegq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vnegq_m($__inactive, $__a, $__p));
	    }' unless defined(&vnegq_m);
	    eval 'sub vmlsdavxq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsdavxq_p($__a, $__b, $__p));
	    }' unless defined(&vmlsdavxq_p);
	    eval 'sub vmlsdavq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsdavq_p($__a, $__b, $__p));
	    }' unless defined(&vmlsdavq_p);
	    eval 'sub vmladavxq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavxq_p($__a, $__b, $__p));
	    }' unless defined(&vmladavxq_p);
	    eval 'sub vclsq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclsq_m($__inactive, $__a, $__p));
	    }' unless defined(&vclsq_m);
	    eval 'sub vabsq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vabsq_m($__inactive, $__a, $__p));
	    }' unless defined(&vabsq_m);
	    eval 'sub vqrdmlsdhxq {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmlsdhxq($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmlsdhxq);
	    eval 'sub vqrdmlsdhq {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmlsdhq($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmlsdhq);
	    eval 'sub vqrdmladhxq {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmladhxq($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmladhxq);
	    eval 'sub vqrdmladhq {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmladhq($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmladhq);
	    eval 'sub vqdmlsdhxq {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmlsdhxq($__inactive, $__a, $__b));
	    }' unless defined(&vqdmlsdhxq);
	    eval 'sub vqdmlsdhq {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmlsdhq($__inactive, $__a, $__b));
	    }' unless defined(&vqdmlsdhq);
	    eval 'sub vqdmladhxq {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmladhxq($__inactive, $__a, $__b));
	    }' unless defined(&vqdmladhxq);
	    eval 'sub vqdmladhq {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmladhq($__inactive, $__a, $__b));
	    }' unless defined(&vqdmladhq);
	    eval 'sub vmlsdavaxq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsdavaxq($__a, $__b, $__c));
	    }' unless defined(&vmlsdavaxq);
	    eval 'sub vmlsdavaq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsdavaq($__a, $__b, $__c));
	    }' unless defined(&vmlsdavaq);
	    eval 'sub vmladavaxq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaxq($__a, $__b, $__c));
	    }' unless defined(&vmladavaxq);
	    eval 'sub vrmlaldavhaxq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vrmlaldavhaxq($__a, $__b, $__c));
	    }' unless defined(&vrmlaldavhaxq);
	    eval 'sub vrmlsldavhaq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vrmlsldavhaq($__a, $__b, $__c));
	    }' unless defined(&vrmlsldavhaq);
	    eval 'sub vrmlsldavhaxq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vrmlsldavhaxq($__a, $__b, $__c));
	    }' unless defined(&vrmlsldavhaxq);
	    eval 'sub vaddlvaq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddlvaq_p($__a, $__b, $__p));
	    }' unless defined(&vaddlvaq_p);
	    eval 'sub vrev16q_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev16q_m($__inactive, $__a, $__p));
	    }' unless defined(&vrev16q_m);
	    eval 'sub vrmlaldavhq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmlaldavhq_p($__a, $__b, $__p));
	    }' unless defined(&vrmlaldavhq_p);
	    eval 'sub vrmlaldavhxq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmlaldavhxq_p($__a, $__b, $__p));
	    }' unless defined(&vrmlaldavhxq_p);
	    eval 'sub vrmlsldavhq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmlsldavhq_p($__a, $__b, $__p));
	    }' unless defined(&vrmlsldavhq_p);
	    eval 'sub vrmlsldavhxq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmlsldavhxq_p($__a, $__b, $__p));
	    }' unless defined(&vrmlsldavhxq_p);
	    eval 'sub vorrq_m_n {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vorrq_m_n($__a, $__imm, $__p));
	    }' unless defined(&vorrq_m_n);
	    eval 'sub vqrshrntq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vqrshrntq($__a, $__b, $__imm));
	    }' unless defined(&vqrshrntq);
	    eval 'sub vqshrnbq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vqshrnbq($__a, $__b, $__imm));
	    }' unless defined(&vqshrnbq);
	    eval 'sub vqshrntq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vqshrntq($__a, $__b, $__imm));
	    }' unless defined(&vqshrntq);
	    eval 'sub vrshrnbq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vrshrnbq($__a, $__b, $__imm));
	    }' unless defined(&vrshrnbq);
	    eval 'sub vrshrntq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vrshrntq($__a, $__b, $__imm));
	    }' unless defined(&vrshrntq);
	    eval 'sub vshrnbq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vshrnbq($__a, $__b, $__imm));
	    }' unless defined(&vshrnbq);
	    eval 'sub vshrntq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vshrntq($__a, $__b, $__imm));
	    }' unless defined(&vshrntq);
	    eval 'sub vmlaldavaq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaldavaq($__a, $__b, $__c));
	    }' unless defined(&vmlaldavaq);
	    eval 'sub vmlaldavaxq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaldavaxq($__a, $__b, $__c));
	    }' unless defined(&vmlaldavaxq);
	    eval 'sub vmlsldavaq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsldavaq($__a, $__b, $__c));
	    }' unless defined(&vmlsldavaq);
	    eval 'sub vmlsldavaxq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsldavaxq($__a, $__b, $__c));
	    }' unless defined(&vmlsldavaxq);
	    eval 'sub vmlaldavq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlaldavq_p($__a, $__b, $__p));
	    }' unless defined(&vmlaldavq_p);
	    eval 'sub vmlaldavxq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlaldavxq_p($__a, $__b, $__p));
	    }' unless defined(&vmlaldavxq_p);
	    eval 'sub vmlsldavq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsldavq_p($__a, $__b, $__p));
	    }' unless defined(&vmlsldavq_p);
	    eval 'sub vmlsldavxq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsldavxq_p($__a, $__b, $__p));
	    }' unless defined(&vmlsldavxq_p);
	    eval 'sub vmovlbq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmovlbq_m($__inactive, $__a, $__p));
	    }' unless defined(&vmovlbq_m);
	    eval 'sub vmovltq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmovltq_m($__inactive, $__a, $__p));
	    }' unless defined(&vmovltq_m);
	    eval 'sub vmovnbq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmovnbq_m($__a, $__b, $__p));
	    }' unless defined(&vmovnbq_m);
	    eval 'sub vmovntq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmovntq_m($__a, $__b, $__p));
	    }' unless defined(&vmovntq_m);
	    eval 'sub vqmovnbq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovnbq_m($__a, $__b, $__p));
	    }' unless defined(&vqmovnbq_m);
	    eval 'sub vqmovntq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovntq_m($__a, $__b, $__p));
	    }' unless defined(&vqmovntq_m);
	    eval 'sub vrev32q_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev32q_m($__inactive, $__a, $__p));
	    }' unless defined(&vrev32q_m);
	    eval 'sub vqrshruntq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vqrshruntq($__a, $__b, $__imm));
	    }' unless defined(&vqrshruntq);
	    eval 'sub vqshrunbq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vqshrunbq($__a, $__b, $__imm));
	    }' unless defined(&vqshrunbq);
	    eval 'sub vqshruntq {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vqshruntq($__a, $__b, $__imm));
	    }' unless defined(&vqshruntq);
	    eval 'sub vqmovunbq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovunbq_m($__a, $__b, $__p));
	    }' unless defined(&vqmovunbq_m);
	    eval 'sub vqmovuntq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovuntq_m($__a, $__b, $__p));
	    }' unless defined(&vqmovuntq_m);
	    eval 'sub vsriq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vsriq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsriq_m);
	    eval 'sub vsubq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m);
	    eval 'sub vqshluq_m {
	        my($__inactive, $__a, $__imm, $__p) = @_;
    		eval q( &__arm_vqshluq_m($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshluq_m);
	    eval 'sub vabavq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vabavq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vabavq_p);
	    eval 'sub vshlq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vshlq_m);
	    eval 'sub vabdq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vabdq_m);
	    eval 'sub vaddq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m);
	    eval 'sub vandq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vandq_m);
	    eval 'sub vbicq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbicq_m);
	    eval 'sub vbrsrq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbrsrq_m);
	    eval 'sub vcaddq_rot270_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_m);
	    eval 'sub vcaddq_rot90_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_m);
	    eval 'sub veorq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&veorq_m);
	    eval 'sub vhaddq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m);
	    eval 'sub vhcaddq_rot270_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot270_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot270_m);
	    eval 'sub vhcaddq_rot90_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot90_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot90_m);
	    eval 'sub vhsubq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m);
	    eval 'sub vmaxq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmaxq_m);
	    eval 'sub vminq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vminq_m);
	    eval 'sub vmladavaq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaq_p);
	    eval 'sub vmladavaxq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaxq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaxq_p);
	    eval 'sub vmlaq_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaq_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaq_m);
	    eval 'sub vmlasq_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlasq_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlasq_m);
	    eval 'sub vmlsdavaq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsdavaq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsdavaq_p);
	    eval 'sub vmlsdavaxq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsdavaxq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsdavaxq_p);
	    eval 'sub vmulhq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulhq_m);
	    eval 'sub vmullbq_int_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_m);
	    eval 'sub vmulltq_int_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_m);
	    eval 'sub vmulq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m);
	    eval 'sub vornq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vornq_m);
	    eval 'sub vorrq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vorrq_m);
	    eval 'sub vqaddq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m);
	    eval 'sub vqdmladhq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmladhq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmladhq_m);
	    eval 'sub vqdmlashq_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqdmlashq_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vqdmlashq_m);
	    eval 'sub vqdmladhxq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmladhxq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmladhxq_m);
	    eval 'sub vqdmlahq_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqdmlahq_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vqdmlahq_m);
	    eval 'sub vqdmlsdhq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmlsdhq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmlsdhq_m);
	    eval 'sub vqdmlsdhxq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmlsdhxq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmlsdhxq_m);
	    eval 'sub vqdmulhq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulhq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulhq_m);
	    eval 'sub vqrdmladhq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmladhq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmladhq_m);
	    eval 'sub vqrdmladhxq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmladhxq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmladhxq_m);
	    eval 'sub vqrdmlahq_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqrdmlahq_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vqrdmlahq_m);
	    eval 'sub vqrdmlashq_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqrdmlashq_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vqrdmlashq_m);
	    eval 'sub vqrdmlsdhq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmlsdhq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmlsdhq_m);
	    eval 'sub vqrdmlsdhxq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmlsdhxq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmlsdhxq_m);
	    eval 'sub vqrdmulhq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmulhq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmulhq_m);
	    eval 'sub vqrshlq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m);
	    eval 'sub vqshlq_m_n {
	        my($__inactive, $__a, $__imm, $__p) = @_;
    		eval q( &__arm_vqshlq_m_n($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshlq_m_n);
	    eval 'sub vqshlq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqshlq_m);
	    eval 'sub vqsubq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m);
	    eval 'sub vrhaddq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrhaddq_m);
	    eval 'sub vrmulhq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrmulhq_m);
	    eval 'sub vrshlq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrshlq_m);
	    eval 'sub vrshrq_m {
	        my($__inactive, $__a, $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_m($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vrshrq_m);
	    eval 'sub vshlq_m_n {
	        my($__inactive, $__a, $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_m_n($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlq_m_n);
	    eval 'sub vshrq_m {
	        my($__inactive, $__a, $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_m($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshrq_m);
	    eval 'sub vsliq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vsliq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsliq_m);
	    eval 'sub vmlaldavaq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaldavaq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaldavaq_p);
	    eval 'sub vmlaldavaxq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaldavaxq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaldavaxq_p);
	    eval 'sub vmlsldavaq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsldavaq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsldavaq_p);
	    eval 'sub vmlsldavaxq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsldavaxq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsldavaxq_p);
	    eval 'sub vmullbq_poly_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_poly_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmullbq_poly_m);
	    eval 'sub vmulltq_poly_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_poly_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulltq_poly_m);
	    eval 'sub vqdmullbq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmullbq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmullbq_m);
	    eval 'sub vqdmulltq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulltq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulltq_m);
	    eval 'sub vqrshrnbq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrnbq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrnbq_m);
	    eval 'sub vqrshrntq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrntq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrntq_m);
	    eval 'sub vqrshrunbq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrunbq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrunbq_m);
	    eval 'sub vqrshruntq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vqrshruntq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshruntq_m);
	    eval 'sub vqshrnbq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vqshrnbq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrnbq_m);
	    eval 'sub vqshrntq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vqshrntq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrntq_m);
	    eval 'sub vqshrunbq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vqshrunbq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrunbq_m);
	    eval 'sub vqshruntq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vqshruntq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshruntq_m);
	    eval 'sub vrmlaldavhaq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vrmlaldavhaq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vrmlaldavhaq_p);
	    eval 'sub vrmlaldavhaxq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vrmlaldavhaxq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vrmlaldavhaxq_p);
	    eval 'sub vrmlsldavhaq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vrmlsldavhaq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vrmlsldavhaq_p);
	    eval 'sub vrmlsldavhaxq_p {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vrmlsldavhaxq_p($__a, $__b, $__c, $__p));
	    }' unless defined(&vrmlsldavhaxq_p);
	    eval 'sub vrshrnbq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vrshrnbq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vrshrnbq_m);
	    eval 'sub vrshrntq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vrshrntq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vrshrntq_m);
	    eval 'sub vshllbq_m {
	        my($__inactive, $__a, $__imm, $__p) = @_;
    		eval q( &__arm_vshllbq_m($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshllbq_m);
	    eval 'sub vshlltq_m {
	        my($__inactive, $__a, $__imm, $__p) = @_;
    		eval q( &__arm_vshlltq_m($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlltq_m);
	    eval 'sub vshrnbq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vshrnbq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshrnbq_m);
	    eval 'sub vshrntq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vshrntq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshrntq_m);
	    eval 'sub vstrbq_scatter_offset {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrbq_scatter_offset($__base, $__offset, $__value));
	    }' unless defined(&vstrbq_scatter_offset);
	    eval 'sub vstrbq {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrbq($__addr, $__value));
	    }' unless defined(&vstrbq);
	    eval 'sub vstrwq_scatter_base {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_base($__addr, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_base);
	    eval 'sub vldrbq_gather_offset {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrbq_gather_offset($__base, $__offset));
	    }' unless defined(&vldrbq_gather_offset);
	    eval 'sub vstrbq_p {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_p($__addr, $__value, $__p));
	    }' unless defined(&vstrbq_p);
	    eval 'sub vstrbq_scatter_offset_p {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_p($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrbq_scatter_offset_p);
	    eval 'sub vstrwq_scatter_base_p {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_base_p($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_base_p);
	    eval 'sub vldrbq_gather_offset_z {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrbq_gather_offset_z($__base, $__offset, $__p));
	    }' unless defined(&vldrbq_gather_offset_z);
	    eval 'sub vld1q {
	        my($__base) = @_;
    		eval q( &__arm_vld1q($__base));
	    }' unless defined(&vld1q);
	    eval 'sub vldrhq_gather_offset {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_offset($__base, $__offset));
	    }' unless defined(&vldrhq_gather_offset);
	    eval 'sub vldrhq_gather_offset_z {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_offset_z($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_offset_z);
	    eval 'sub vldrhq_gather_shifted_offset {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset($__base, $__offset));
	    }' unless defined(&vldrhq_gather_shifted_offset);
	    eval 'sub vldrhq_gather_shifted_offset_z {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_z($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_shifted_offset_z);
	    eval 'sub vldrdq_gather_offset {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrdq_gather_offset($__base, $__offset));
	    }' unless defined(&vldrdq_gather_offset);
	    eval 'sub vldrdq_gather_offset_z {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrdq_gather_offset_z($__base, $__offset, $__p));
	    }' unless defined(&vldrdq_gather_offset_z);
	    eval 'sub vldrdq_gather_shifted_offset {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrdq_gather_shifted_offset($__base, $__offset));
	    }' unless defined(&vldrdq_gather_shifted_offset);
	    eval 'sub vldrdq_gather_shifted_offset_z {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrdq_gather_shifted_offset_z($__base, $__offset, $__p));
	    }' unless defined(&vldrdq_gather_shifted_offset_z);
	    eval 'sub vldrwq_gather_offset {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_offset($__base, $__offset));
	    }' unless defined(&vldrwq_gather_offset);
	    eval 'sub vldrwq_gather_offset_z {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_offset_z($__base, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_offset_z);
	    eval 'sub vldrwq_gather_shifted_offset {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_shifted_offset($__base, $__offset));
	    }' unless defined(&vldrwq_gather_shifted_offset);
	    eval 'sub vldrwq_gather_shifted_offset_z {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_shifted_offset_z($__base, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_shifted_offset_z);
	    eval 'sub vst1q {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst1q($__addr, $__value));
	    }' unless defined(&vst1q);
	    eval 'sub vstrhq_scatter_offset {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_offset($__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_offset);
	    eval 'sub vstrhq_scatter_offset_p {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_p($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_offset_p);
	    eval 'sub vstrhq_scatter_shifted_offset {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset($__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_shifted_offset);
	    eval 'sub vstrhq_scatter_shifted_offset_p {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_p($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_shifted_offset_p);
	    eval 'sub vstrhq {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrhq($__addr, $__value));
	    }' unless defined(&vstrhq);
	    eval 'sub vstrhq_p {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_p($__addr, $__value, $__p));
	    }' unless defined(&vstrhq_p);
	    eval 'sub vstrwq {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrwq($__addr, $__value));
	    }' unless defined(&vstrwq);
	    eval 'sub vstrwq_p {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_p($__addr, $__value, $__p));
	    }' unless defined(&vstrwq_p);
	    eval 'sub vstrdq_scatter_base_p {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_base_p($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_base_p);
	    eval 'sub vstrdq_scatter_base {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_base($__addr, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_base);
	    eval 'sub vstrdq_scatter_offset_p {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_offset_p($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_offset_p);
	    eval 'sub vstrdq_scatter_offset {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_offset($__base, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_offset);
	    eval 'sub vstrdq_scatter_shifted_offset_p {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_shifted_offset_p($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_shifted_offset_p);
	    eval 'sub vstrdq_scatter_shifted_offset {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_shifted_offset($__base, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_shifted_offset);
	    eval 'sub vstrwq_scatter_offset_p {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_offset_p($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_offset_p);
	    eval 'sub vstrwq_scatter_offset {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_offset($__base, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_offset);
	    eval 'sub vstrwq_scatter_shifted_offset_p {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_shifted_offset_p($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_shifted_offset_p);
	    eval 'sub vstrwq_scatter_shifted_offset {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_shifted_offset($__base, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_shifted_offset);
	    eval 'sub vuninitializedq {
	        my($__v) = @_;
    		eval q( &__arm_vuninitializedq($__v));
	    }' unless defined(&vuninitializedq);
	    eval 'sub vreinterpretq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s16($__a));
	    }' unless defined(&vreinterpretq_s16);
	    eval 'sub vreinterpretq_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s32($__a));
	    }' unless defined(&vreinterpretq_s32);
	    eval 'sub vreinterpretq_s64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s64($__a));
	    }' unless defined(&vreinterpretq_s64);
	    eval 'sub vreinterpretq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s8($__a));
	    }' unless defined(&vreinterpretq_s8);
	    eval 'sub vreinterpretq_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u16($__a));
	    }' unless defined(&vreinterpretq_u16);
	    eval 'sub vreinterpretq_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u32($__a));
	    }' unless defined(&vreinterpretq_u32);
	    eval 'sub vreinterpretq_u64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u64($__a));
	    }' unless defined(&vreinterpretq_u64);
	    eval 'sub vreinterpretq_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u8($__a));
	    }' unless defined(&vreinterpretq_u8);
	    eval 'sub vddupq_m {
	        my($__inactive, $__a, $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_m($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vddupq_m);
	    eval 'sub vddupq_u8 {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vddupq_u8($__a, $__imm));
	    }' unless defined(&vddupq_u8);
	    eval 'sub vddupq_u32 {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vddupq_u32($__a, $__imm));
	    }' unless defined(&vddupq_u32);
	    eval 'sub vddupq_u16 {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vddupq_u16($__a, $__imm));
	    }' unless defined(&vddupq_u16);
	    eval 'sub vdwdupq_m {
	        my($__inactive, $__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_m($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_m);
	    eval 'sub vdwdupq_u8 {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vdwdupq_u8($__a, $__b, $__imm));
	    }' unless defined(&vdwdupq_u8);
	    eval 'sub vdwdupq_u32 {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vdwdupq_u32($__a, $__b, $__imm));
	    }' unless defined(&vdwdupq_u32);
	    eval 'sub vdwdupq_u16 {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_vdwdupq_u16($__a, $__b, $__imm));
	    }' unless defined(&vdwdupq_u16);
	    eval 'sub vidupq_m {
	        my($__inactive, $__a, $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_m($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vidupq_m);
	    eval 'sub vidupq_u8 {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vidupq_u8($__a, $__imm));
	    }' unless defined(&vidupq_u8);
	    eval 'sub vidupq_u32 {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vidupq_u32($__a, $__imm));
	    }' unless defined(&vidupq_u32);
	    eval 'sub vidupq_u16 {
	        my($__a, $__imm) = @_;
    		eval q( &__arm_vidupq_u16($__a, $__imm));
	    }' unless defined(&vidupq_u16);
	    eval 'sub viwdupq_m {
	        my($__inactive, $__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_m($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_m);
	    eval 'sub viwdupq_u8 {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_viwdupq_u8($__a, $__b, $__imm));
	    }' unless defined(&viwdupq_u8);
	    eval 'sub viwdupq_u32 {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_viwdupq_u32($__a, $__b, $__imm));
	    }' unless defined(&viwdupq_u32);
	    eval 'sub viwdupq_u16 {
	        my($__a, $__b, $__imm) = @_;
    		eval q( &__arm_viwdupq_u16($__a, $__b, $__imm));
	    }' unless defined(&viwdupq_u16);
	    eval 'sub vstrdq_scatter_base_wb {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_base_wb($__addr, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_base_wb);
	    eval 'sub vstrdq_scatter_base_wb_p {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_base_wb_p($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_base_wb_p);
	    eval 'sub vstrwq_scatter_base_wb_p {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_base_wb_p($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_base_wb_p);
	    eval 'sub vstrwq_scatter_base_wb {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_base_wb($__addr, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_base_wb);
	    eval 'sub vddupq_x_u8 {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_x_u8($__a, $__imm, $__p));
	    }' unless defined(&vddupq_x_u8);
	    eval 'sub vddupq_x_u16 {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_x_u16($__a, $__imm, $__p));
	    }' unless defined(&vddupq_x_u16);
	    eval 'sub vddupq_x_u32 {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_x_u32($__a, $__imm, $__p));
	    }' unless defined(&vddupq_x_u32);
	    eval 'sub vdwdupq_x_u8 {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_x_u8($__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_x_u8);
	    eval 'sub vdwdupq_x_u16 {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_x_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_x_u16);
	    eval 'sub vdwdupq_x_u32 {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_x_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_x_u32);
	    eval 'sub vidupq_x_u8 {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_x_u8($__a, $__imm, $__p));
	    }' unless defined(&vidupq_x_u8);
	    eval 'sub vidupq_x_u16 {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_x_u16($__a, $__imm, $__p));
	    }' unless defined(&vidupq_x_u16);
	    eval 'sub vidupq_x_u32 {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_x_u32($__a, $__imm, $__p));
	    }' unless defined(&vidupq_x_u32);
	    eval 'sub viwdupq_x_u8 {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_x_u8($__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_x_u8);
	    eval 'sub viwdupq_x_u16 {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_x_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_x_u16);
	    eval 'sub viwdupq_x_u32 {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_x_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_x_u32);
	    eval 'sub vminq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_x($__a, $__b, $__p));
	    }' unless defined(&vminq_x);
	    eval 'sub vmaxq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_x($__a, $__b, $__p));
	    }' unless defined(&vmaxq_x);
	    eval 'sub vabdq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_x($__a, $__b, $__p));
	    }' unless defined(&vabdq_x);
	    eval 'sub vabsq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vabsq_x($__a, $__p));
	    }' unless defined(&vabsq_x);
	    eval 'sub vaddq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x($__a, $__b, $__p));
	    }' unless defined(&vaddq_x);
	    eval 'sub vclsq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclsq_x($__a, $__p));
	    }' unless defined(&vclsq_x);
	    eval 'sub vclzq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclzq_x($__a, $__p));
	    }' unless defined(&vclzq_x);
	    eval 'sub vnegq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vnegq_x($__a, $__p));
	    }' unless defined(&vnegq_x);
	    eval 'sub vmulhq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_x($__a, $__b, $__p));
	    }' unless defined(&vmulhq_x);
	    eval 'sub vmullbq_poly_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_poly_x($__a, $__b, $__p));
	    }' unless defined(&vmullbq_poly_x);
	    eval 'sub vmullbq_int_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_x($__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_x);
	    eval 'sub vmulltq_poly_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_poly_x($__a, $__b, $__p));
	    }' unless defined(&vmulltq_poly_x);
	    eval 'sub vmulltq_int_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_x($__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_x);
	    eval 'sub vmulq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x($__a, $__b, $__p));
	    }' unless defined(&vmulq_x);
	    eval 'sub vsubq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x($__a, $__b, $__p));
	    }' unless defined(&vsubq_x);
	    eval 'sub vcaddq_rot90_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_x($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_x);
	    eval 'sub vcaddq_rot270_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_x($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_x);
	    eval 'sub vhaddq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x);
	    eval 'sub vhcaddq_rot90_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot90_x($__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot90_x);
	    eval 'sub vhcaddq_rot270_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot270_x($__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot270_x);
	    eval 'sub vhsubq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x);
	    eval 'sub vrhaddq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_x($__a, $__b, $__p));
	    }' unless defined(&vrhaddq_x);
	    eval 'sub vrmulhq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_x($__a, $__b, $__p));
	    }' unless defined(&vrmulhq_x);
	    eval 'sub vandq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_x($__a, $__b, $__p));
	    }' unless defined(&vandq_x);
	    eval 'sub vbicq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_x($__a, $__b, $__p));
	    }' unless defined(&vbicq_x);
	    eval 'sub vbrsrq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_x($__a, $__b, $__p));
	    }' unless defined(&vbrsrq_x);
	    eval 'sub veorq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_x($__a, $__b, $__p));
	    }' unless defined(&veorq_x);
	    eval 'sub vmovlbq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmovlbq_x($__a, $__p));
	    }' unless defined(&vmovlbq_x);
	    eval 'sub vmovltq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmovltq_x($__a, $__p));
	    }' unless defined(&vmovltq_x);
	    eval 'sub vmvnq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmvnq_x($__a, $__p));
	    }' unless defined(&vmvnq_x);
	    eval 'sub vornq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_x($__a, $__b, $__p));
	    }' unless defined(&vornq_x);
	    eval 'sub vorrq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_x($__a, $__b, $__p));
	    }' unless defined(&vorrq_x);
	    eval 'sub vrev16q_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev16q_x($__a, $__p));
	    }' unless defined(&vrev16q_x);
	    eval 'sub vrev32q_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev32q_x($__a, $__p));
	    }' unless defined(&vrev32q_x);
	    eval 'sub vrev64q_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev64q_x($__a, $__p));
	    }' unless defined(&vrev64q_x);
	    eval 'sub vrshlq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_x($__a, $__b, $__p));
	    }' unless defined(&vrshlq_x);
	    eval 'sub vshllbq_x {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vshllbq_x($__a, $__imm, $__p));
	    }' unless defined(&vshllbq_x);
	    eval 'sub vshlltq_x {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vshlltq_x($__a, $__imm, $__p));
	    }' unless defined(&vshlltq_x);
	    eval 'sub vshlq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_x($__a, $__b, $__p));
	    }' unless defined(&vshlq_x);
	    eval 'sub vshlq_x_n {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_x_n($__a, $__imm, $__p));
	    }' unless defined(&vshlq_x_n);
	    eval 'sub vrshrq_x {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_x($__a, $__imm, $__p));
	    }' unless defined(&vrshrq_x);
	    eval 'sub vshrq_x {
	        my($__a, $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_x($__a, $__imm, $__p));
	    }' unless defined(&vshrq_x);
	    eval 'sub vadciq {
	        my($__a, $__b, $__carry_out) = @_;
    		eval q( &__arm_vadciq($__a, $__b, $__carry_out));
	    }' unless defined(&vadciq);
	    eval 'sub vadciq_m {
	        my($__inactive, $__a, $__b, $__carry_out, $__p) = @_;
    		eval q( &__arm_vadciq_m($__inactive, $__a, $__b, $__carry_out, $__p));
	    }' unless defined(&vadciq_m);
	    eval 'sub vadcq {
	        my($__a, $__b, $__carry) = @_;
    		eval q( &__arm_vadcq($__a, $__b, $__carry));
	    }' unless defined(&vadcq);
	    eval 'sub vadcq_m {
	        my($__inactive, $__a, $__b, $__carry, $__p) = @_;
    		eval q( &__arm_vadcq_m($__inactive, $__a, $__b, $__carry, $__p));
	    }' unless defined(&vadcq_m);
	    eval 'sub vsbciq {
	        my($__a, $__b, $__carry_out) = @_;
    		eval q( &__arm_vsbciq($__a, $__b, $__carry_out));
	    }' unless defined(&vsbciq);
	    eval 'sub vsbciq_m {
	        my($__inactive, $__a, $__b, $__carry_out, $__p) = @_;
    		eval q( &__arm_vsbciq_m($__inactive, $__a, $__b, $__carry_out, $__p));
	    }' unless defined(&vsbciq_m);
	    eval 'sub vsbcq {
	        my($__a, $__b, $__carry) = @_;
    		eval q( &__arm_vsbcq($__a, $__b, $__carry));
	    }' unless defined(&vsbcq);
	    eval 'sub vsbcq_m {
	        my($__inactive, $__a, $__b, $__carry, $__p) = @_;
    		eval q( &__arm_vsbcq_m($__inactive, $__a, $__b, $__carry, $__p));
	    }' unless defined(&vsbcq_m);
	    eval 'sub vst1q_p {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vst1q_p($__addr, $__value, $__p));
	    }' unless defined(&vst1q_p);
	    eval 'sub vst2q {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst2q($__addr, $__value));
	    }' unless defined(&vst2q);
	    eval 'sub vld1q_z {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vld1q_z($__base, $__p));
	    }' unless defined(&vld1q_z);
	    eval 'sub vld2q {
	        my($__addr) = @_;
    		eval q( &__arm_vld2q($__addr));
	    }' unless defined(&vld2q);
	    eval 'sub vld4q {
	        my($__addr) = @_;
    		eval q( &__arm_vld4q($__addr));
	    }' unless defined(&vld4q);
	    eval 'sub vsetq_lane {
	        my($__a, $__b, $__idx) = @_;
    		eval q( &__arm_vsetq_lane($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane);
	    eval 'sub vgetq_lane {
	        my($__a, $__idx) = @_;
    		eval q( &__arm_vgetq_lane($__a, $__idx));
	    }' unless defined(&vgetq_lane);
	    eval 'sub vshlcq_m {
	        my($__a, $__b, $__imm, $__p) = @_;
    		eval q( &__arm_vshlcq_m($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshlcq_m);
	    eval 'sub vrndxq {
	        my($__a) = @_;
    		eval q( &__arm_vrndxq($__a));
	    }' unless defined(&vrndxq);
	    eval 'sub vrndq {
	        my($__a) = @_;
    		eval q( &__arm_vrndq($__a));
	    }' unless defined(&vrndq);
	    eval 'sub vrndpq {
	        my($__a) = @_;
    		eval q( &__arm_vrndpq($__a));
	    }' unless defined(&vrndpq);
	    eval 'sub vrndnq {
	        my($__a) = @_;
    		eval q( &__arm_vrndnq($__a));
	    }' unless defined(&vrndnq);
	    eval 'sub vrndmq {
	        my($__a) = @_;
    		eval q( &__arm_vrndmq($__a));
	    }' unless defined(&vrndmq);
	    eval 'sub vrndaq {
	        my($__a) = @_;
    		eval q( &__arm_vrndaq($__a));
	    }' unless defined(&vrndaq);
	    eval 'sub vcvttq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvttq_f32($__a));
	    }' unless defined(&vcvttq_f32);
	    eval 'sub vcvtbq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtbq_f32($__a));
	    }' unless defined(&vcvtbq_f32);
	    eval 'sub vcvtq {
	        my($__a) = @_;
    		eval q( &__arm_vcvtq($__a));
	    }' unless defined(&vcvtq);
	    eval 'sub vcvtq_n {
	        my($__a, $__imm6) = @_;
    		eval q( &__arm_vcvtq_n($__a, $__imm6));
	    }' unless defined(&vcvtq_n);
	    eval 'sub vminnmvq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmvq($__a, $__b));
	    }' unless defined(&vminnmvq);
	    eval 'sub vminnmq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmq($__a, $__b));
	    }' unless defined(&vminnmq);
	    eval 'sub vminnmavq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmavq($__a, $__b));
	    }' unless defined(&vminnmavq);
	    eval 'sub vminnmaq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmaq($__a, $__b));
	    }' unless defined(&vminnmaq);
	    eval 'sub vmaxnmvq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmvq($__a, $__b));
	    }' unless defined(&vmaxnmvq);
	    eval 'sub vmaxnmq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmq($__a, $__b));
	    }' unless defined(&vmaxnmq);
	    eval 'sub vmaxnmavq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmavq($__a, $__b));
	    }' unless defined(&vmaxnmavq);
	    eval 'sub vmaxnmaq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmaq($__a, $__b));
	    }' unless defined(&vmaxnmaq);
	    eval 'sub vcmulq_rot90 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_rot90($__a, $__b));
	    }' unless defined(&vcmulq_rot90);
	    eval 'sub vcmulq_rot270 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_rot270($__a, $__b));
	    }' unless defined(&vcmulq_rot270);
	    eval 'sub vcmulq_rot180 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_rot180($__a, $__b));
	    }' unless defined(&vcmulq_rot180);
	    eval 'sub vcmulq {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq($__a, $__b));
	    }' unless defined(&vcmulq);
	    eval 'sub vcvtaq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtaq_m($__inactive, $__a, $__p));
	    }' unless defined(&vcvtaq_m);
	    eval 'sub vcvtq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtq_m($__inactive, $__a, $__p));
	    }' unless defined(&vcvtq_m);
	    eval 'sub vcvtbq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcvtbq_m($__a, $__b, $__p));
	    }' unless defined(&vcvtbq_m);
	    eval 'sub vcvttq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcvttq_m($__a, $__b, $__p));
	    }' unless defined(&vcvttq_m);
	    eval 'sub vcmlaq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq($__a, $__b, $__c));
	    }' unless defined(&vcmlaq);
	    eval 'sub vcmlaq_rot180 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_rot180($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_rot180);
	    eval 'sub vcmlaq_rot270 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_rot270($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_rot270);
	    eval 'sub vcmlaq_rot90 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_rot90($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_rot90);
	    eval 'sub vfmaq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmaq($__a, $__b, $__c));
	    }' unless defined(&vfmaq);
	    eval 'sub vfmasq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmasq($__a, $__b, $__c));
	    }' unless defined(&vfmasq);
	    eval 'sub vfmsq {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmsq($__a, $__b, $__c));
	    }' unless defined(&vfmsq);
	    eval 'sub vcvtmq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtmq_m($__inactive, $__a, $__p));
	    }' unless defined(&vcvtmq_m);
	    eval 'sub vcvtnq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtnq_m($__inactive, $__a, $__p));
	    }' unless defined(&vcvtnq_m);
	    eval 'sub vcvtpq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtpq_m($__inactive, $__a, $__p));
	    }' unless defined(&vcvtpq_m);
	    eval 'sub vmaxnmaq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmaq_m($__a, $__b, $__p));
	    }' unless defined(&vmaxnmaq_m);
	    eval 'sub vmaxnmavq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmavq_p($__a, $__b, $__p));
	    }' unless defined(&vmaxnmavq_p);
	    eval 'sub vmaxnmvq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmvq_p($__a, $__b, $__p));
	    }' unless defined(&vmaxnmvq_p);
	    eval 'sub vminnmaq_m {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmaq_m($__a, $__b, $__p));
	    }' unless defined(&vminnmaq_m);
	    eval 'sub vminnmavq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmavq_p($__a, $__b, $__p));
	    }' unless defined(&vminnmavq_p);
	    eval 'sub vminnmvq_p {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmvq_p($__a, $__b, $__p));
	    }' unless defined(&vminnmvq_p);
	    eval 'sub vrndaq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndaq_m($__inactive, $__a, $__p));
	    }' unless defined(&vrndaq_m);
	    eval 'sub vrndmq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndmq_m($__inactive, $__a, $__p));
	    }' unless defined(&vrndmq_m);
	    eval 'sub vrndnq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndnq_m($__inactive, $__a, $__p));
	    }' unless defined(&vrndnq_m);
	    eval 'sub vrndpq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndpq_m($__inactive, $__a, $__p));
	    }' unless defined(&vrndpq_m);
	    eval 'sub vrndq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndq_m($__inactive, $__a, $__p));
	    }' unless defined(&vrndq_m);
	    eval 'sub vrndxq_m {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndxq_m($__inactive, $__a, $__p));
	    }' unless defined(&vrndxq_m);
	    eval 'sub vcvtq_m_n {
	        my($__inactive, $__a, $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_m_n($__inactive, $__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_m_n);
	    eval 'sub vcmlaq_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_m);
	    eval 'sub vcmlaq_rot180_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_rot180_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_rot180_m);
	    eval 'sub vcmlaq_rot270_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_rot270_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_rot270_m);
	    eval 'sub vcmlaq_rot90_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_rot90_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_rot90_m);
	    eval 'sub vcmulq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_m);
	    eval 'sub vcmulq_rot180_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot180_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot180_m);
	    eval 'sub vcmulq_rot270_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot270_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot270_m);
	    eval 'sub vcmulq_rot90_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot90_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot90_m);
	    eval 'sub vfmaq_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmaq_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmaq_m);
	    eval 'sub vfmasq_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmasq_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmasq_m);
	    eval 'sub vfmsq_m {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmsq_m($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmsq_m);
	    eval 'sub vmaxnmq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmaxnmq_m);
	    eval 'sub vminnmq_m {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmq_m($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vminnmq_m);
	    eval 'sub vreinterpretq_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f16($__a));
	    }' unless defined(&vreinterpretq_f16);
	    eval 'sub vreinterpretq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f32($__a));
	    }' unless defined(&vreinterpretq_f32);
	    eval 'sub vminnmq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmq_x($__a, $__b, $__p));
	    }' unless defined(&vminnmq_x);
	    eval 'sub vmaxnmq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmq_x($__a, $__b, $__p));
	    }' unless defined(&vmaxnmq_x);
	    eval 'sub vcmulq_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_x($__a, $__b, $__p));
	    }' unless defined(&vcmulq_x);
	    eval 'sub vcmulq_rot90_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot90_x($__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot90_x);
	    eval 'sub vcmulq_rot180_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot180_x($__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot180_x);
	    eval 'sub vcmulq_rot270_x {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot270_x($__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot270_x);
	    eval 'sub vcvtq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtq_x($__a, $__p));
	    }' unless defined(&vcvtq_x);
	    eval 'sub vcvtq_x_n {
	        my($__a, $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_x_n($__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_x_n);
	    eval 'sub vrndq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndq_x($__a, $__p));
	    }' unless defined(&vrndq_x);
	    eval 'sub vrndnq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndnq_x($__a, $__p));
	    }' unless defined(&vrndnq_x);
	    eval 'sub vrndmq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndmq_x($__a, $__p));
	    }' unless defined(&vrndmq_x);
	    eval 'sub vrndpq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndpq_x($__a, $__p));
	    }' unless defined(&vrndpq_x);
	    eval 'sub vrndaq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndaq_x($__a, $__p));
	    }' unless defined(&vrndaq_x);
	    eval 'sub vrndxq_x {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndxq_x($__a, $__p));
	    }' unless defined(&vrndxq_x);
	    eval 'sub vst4q_s8 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vst4q_s8( $__addr, $__value));
	    }' unless defined(&vst4q_s8);
	    eval 'sub vst4q_s16 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vst4q_s16( $__addr, $__value));
	    }' unless defined(&vst4q_s16);
	    eval 'sub vst4q_s32 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vst4q_s32( $__addr, $__value));
	    }' unless defined(&vst4q_s32);
	    eval 'sub vst4q_u8 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vst4q_u8( $__addr, $__value));
	    }' unless defined(&vst4q_u8);
	    eval 'sub vst4q_u16 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vst4q_u16( $__addr, $__value));
	    }' unless defined(&vst4q_u16);
	    eval 'sub vst4q_u32 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vst4q_u32( $__addr, $__value));
	    }' unless defined(&vst4q_u32);
	    eval 'sub vst4q_f16 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vst4q_f16( $__addr, $__value));
	    }' unless defined(&vst4q_f16);
	    eval 'sub vst4q_f32 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vst4q_f32( $__addr, $__value));
	    }' unless defined(&vst4q_f32);
	    eval 'sub vrndxq_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vrndxq_f16($__a));
	    }' unless defined(&vrndxq_f16);
	    eval 'sub vrndxq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vrndxq_f32($__a));
	    }' unless defined(&vrndxq_f32);
	    eval 'sub vrndq_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vrndq_f16($__a));
	    }' unless defined(&vrndq_f16);
	    eval 'sub vrndq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vrndq_f32($__a));
	    }' unless defined(&vrndq_f32);
	    eval 'sub vrndpq_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vrndpq_f16($__a));
	    }' unless defined(&vrndpq_f16);
	    eval 'sub vrndpq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vrndpq_f32($__a));
	    }' unless defined(&vrndpq_f32);
	    eval 'sub vrndnq_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vrndnq_f16($__a));
	    }' unless defined(&vrndnq_f16);
	    eval 'sub vrndnq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vrndnq_f32($__a));
	    }' unless defined(&vrndnq_f32);
	    eval 'sub vrndmq_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vrndmq_f16($__a));
	    }' unless defined(&vrndmq_f16);
	    eval 'sub vrndmq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vrndmq_f32($__a));
	    }' unless defined(&vrndmq_f32);
	    eval 'sub vrndaq_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vrndaq_f16($__a));
	    }' unless defined(&vrndaq_f16);
	    eval 'sub vrndaq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vrndaq_f32($__a));
	    }' unless defined(&vrndaq_f32);
	    eval 'sub vrev64q_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vrev64q_f16($__a));
	    }' unless defined(&vrev64q_f16);
	    eval 'sub vrev64q_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vrev64q_f32($__a));
	    }' unless defined(&vrev64q_f32);
	    eval 'sub vnegq_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vnegq_f16($__a));
	    }' unless defined(&vnegq_f16);
	    eval 'sub vnegq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vnegq_f32($__a));
	    }' unless defined(&vnegq_f32);
	    eval 'sub vdupq_n_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vdupq_n_f16($__a));
	    }' unless defined(&vdupq_n_f16);
	    eval 'sub vdupq_n_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vdupq_n_f32($__a));
	    }' unless defined(&vdupq_n_f32);
	    eval 'sub vabsq_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vabsq_f16($__a));
	    }' unless defined(&vabsq_f16);
	    eval 'sub vabsq_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vabsq_f32($__a));
	    }' unless defined(&vabsq_f32);
	    eval 'sub vrev32q_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vrev32q_f16($__a));
	    }' unless defined(&vrev32q_f16);
	    eval 'sub vcvttq_f32_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvttq_f32_f16($__a));
	    }' unless defined(&vcvttq_f32_f16);
	    eval 'sub vcvtbq_f32_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtbq_f32_f16($__a));
	    }' unless defined(&vcvtbq_f32_f16);
	    eval 'sub vcvtq_f16_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtq_f16_s16($__a));
	    }' unless defined(&vcvtq_f16_s16);
	    eval 'sub vcvtq_f32_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtq_f32_s32($__a));
	    }' unless defined(&vcvtq_f32_s32);
	    eval 'sub vcvtq_f16_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtq_f16_u16($__a));
	    }' unless defined(&vcvtq_f16_u16);
	    eval 'sub vcvtq_f32_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtq_f32_u32($__a));
	    }' unless defined(&vcvtq_f32_u32);
	    eval 'sub vdupq_n_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vdupq_n_s8($__a));
	    }' unless defined(&vdupq_n_s8);
	    eval 'sub vdupq_n_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vdupq_n_s16($__a));
	    }' unless defined(&vdupq_n_s16);
	    eval 'sub vdupq_n_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vdupq_n_s32($__a));
	    }' unless defined(&vdupq_n_s32);
	    eval 'sub vabsq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vabsq_s8($__a));
	    }' unless defined(&vabsq_s8);
	    eval 'sub vabsq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vabsq_s16($__a));
	    }' unless defined(&vabsq_s16);
	    eval 'sub vabsq_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vabsq_s32($__a));
	    }' unless defined(&vabsq_s32);
	    eval 'sub vclsq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vclsq_s8($__a));
	    }' unless defined(&vclsq_s8);
	    eval 'sub vclsq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vclsq_s16($__a));
	    }' unless defined(&vclsq_s16);
	    eval 'sub vclsq_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vclsq_s32($__a));
	    }' unless defined(&vclsq_s32);
	    eval 'sub vclzq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vclzq_s8($__a));
	    }' unless defined(&vclzq_s8);
	    eval 'sub vclzq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vclzq_s16($__a));
	    }' unless defined(&vclzq_s16);
	    eval 'sub vclzq_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vclzq_s32($__a));
	    }' unless defined(&vclzq_s32);
	    eval 'sub vnegq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vnegq_s8($__a));
	    }' unless defined(&vnegq_s8);
	    eval 'sub vnegq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vnegq_s16($__a));
	    }' unless defined(&vnegq_s16);
	    eval 'sub vnegq_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vnegq_s32($__a));
	    }' unless defined(&vnegq_s32);
	    eval 'sub vaddlvq_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vaddlvq_s32($__a));
	    }' unless defined(&vaddlvq_s32);
	    eval 'sub vaddvq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vaddvq_s8($__a));
	    }' unless defined(&vaddvq_s8);
	    eval 'sub vaddvq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vaddvq_s16($__a));
	    }' unless defined(&vaddvq_s16);
	    eval 'sub vaddvq_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vaddvq_s32($__a));
	    }' unless defined(&vaddvq_s32);
	    eval 'sub vmovlbq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vmovlbq_s8($__a));
	    }' unless defined(&vmovlbq_s8);
	    eval 'sub vmovlbq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vmovlbq_s16($__a));
	    }' unless defined(&vmovlbq_s16);
	    eval 'sub vmovltq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vmovltq_s8($__a));
	    }' unless defined(&vmovltq_s8);
	    eval 'sub vmovltq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vmovltq_s16($__a));
	    }' unless defined(&vmovltq_s16);
	    eval 'sub vmvnq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vmvnq_s8($__a));
	    }' unless defined(&vmvnq_s8);
	    eval 'sub vmvnq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vmvnq_s16($__a));
	    }' unless defined(&vmvnq_s16);
	    eval 'sub vmvnq_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vmvnq_s32($__a));
	    }' unless defined(&vmvnq_s32);
	    eval 'sub vmvnq_n_s16 {
	        my( $__imm) = @_;
    		eval q( &__arm_vmvnq_n_s16( $__imm));
	    }' unless defined(&vmvnq_n_s16);
	    eval 'sub vmvnq_n_s32 {
	        my( $__imm) = @_;
    		eval q( &__arm_vmvnq_n_s32( $__imm));
	    }' unless defined(&vmvnq_n_s32);
	    eval 'sub vrev16q_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vrev16q_s8($__a));
	    }' unless defined(&vrev16q_s8);
	    eval 'sub vrev32q_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vrev32q_s8($__a));
	    }' unless defined(&vrev32q_s8);
	    eval 'sub vrev32q_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vrev32q_s16($__a));
	    }' unless defined(&vrev32q_s16);
	    eval 'sub vrev64q_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vrev64q_s8($__a));
	    }' unless defined(&vrev64q_s8);
	    eval 'sub vrev64q_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vrev64q_s16($__a));
	    }' unless defined(&vrev64q_s16);
	    eval 'sub vrev64q_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vrev64q_s32($__a));
	    }' unless defined(&vrev64q_s32);
	    eval 'sub vqabsq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vqabsq_s8($__a));
	    }' unless defined(&vqabsq_s8);
	    eval 'sub vqabsq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vqabsq_s16($__a));
	    }' unless defined(&vqabsq_s16);
	    eval 'sub vqabsq_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vqabsq_s32($__a));
	    }' unless defined(&vqabsq_s32);
	    eval 'sub vqnegq_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vqnegq_s8($__a));
	    }' unless defined(&vqnegq_s8);
	    eval 'sub vqnegq_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vqnegq_s16($__a));
	    }' unless defined(&vqnegq_s16);
	    eval 'sub vqnegq_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vqnegq_s32($__a));
	    }' unless defined(&vqnegq_s32);
	    eval 'sub vcvtaq_s16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtaq_s16_f16($__a));
	    }' unless defined(&vcvtaq_s16_f16);
	    eval 'sub vcvtaq_s32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtaq_s32_f32($__a));
	    }' unless defined(&vcvtaq_s32_f32);
	    eval 'sub vcvtnq_s16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtnq_s16_f16($__a));
	    }' unless defined(&vcvtnq_s16_f16);
	    eval 'sub vcvtnq_s32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtnq_s32_f32($__a));
	    }' unless defined(&vcvtnq_s32_f32);
	    eval 'sub vcvtpq_s16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtpq_s16_f16($__a));
	    }' unless defined(&vcvtpq_s16_f16);
	    eval 'sub vcvtpq_s32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtpq_s32_f32($__a));
	    }' unless defined(&vcvtpq_s32_f32);
	    eval 'sub vcvtmq_s16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtmq_s16_f16($__a));
	    }' unless defined(&vcvtmq_s16_f16);
	    eval 'sub vcvtmq_s32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtmq_s32_f32($__a));
	    }' unless defined(&vcvtmq_s32_f32);
	    eval 'sub vcvtq_s16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtq_s16_f16($__a));
	    }' unless defined(&vcvtq_s16_f16);
	    eval 'sub vcvtq_s32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtq_s32_f32($__a));
	    }' unless defined(&vcvtq_s32_f32);
	    eval 'sub vrev64q_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vrev64q_u8($__a));
	    }' unless defined(&vrev64q_u8);
	    eval 'sub vrev64q_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vrev64q_u16($__a));
	    }' unless defined(&vrev64q_u16);
	    eval 'sub vrev64q_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vrev64q_u32($__a));
	    }' unless defined(&vrev64q_u32);
	    eval 'sub vmvnq_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vmvnq_u8($__a));
	    }' unless defined(&vmvnq_u8);
	    eval 'sub vmvnq_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vmvnq_u16($__a));
	    }' unless defined(&vmvnq_u16);
	    eval 'sub vmvnq_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vmvnq_u32($__a));
	    }' unless defined(&vmvnq_u32);
	    eval 'sub vdupq_n_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vdupq_n_u8($__a));
	    }' unless defined(&vdupq_n_u8);
	    eval 'sub vdupq_n_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vdupq_n_u16($__a));
	    }' unless defined(&vdupq_n_u16);
	    eval 'sub vdupq_n_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vdupq_n_u32($__a));
	    }' unless defined(&vdupq_n_u32);
	    eval 'sub vclzq_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vclzq_u8($__a));
	    }' unless defined(&vclzq_u8);
	    eval 'sub vclzq_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vclzq_u16($__a));
	    }' unless defined(&vclzq_u16);
	    eval 'sub vclzq_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vclzq_u32($__a));
	    }' unless defined(&vclzq_u32);
	    eval 'sub vaddvq_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vaddvq_u8($__a));
	    }' unless defined(&vaddvq_u8);
	    eval 'sub vaddvq_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vaddvq_u16($__a));
	    }' unless defined(&vaddvq_u16);
	    eval 'sub vaddvq_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vaddvq_u32($__a));
	    }' unless defined(&vaddvq_u32);
	    eval 'sub vrev32q_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vrev32q_u8($__a));
	    }' unless defined(&vrev32q_u8);
	    eval 'sub vrev32q_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vrev32q_u16($__a));
	    }' unless defined(&vrev32q_u16);
	    eval 'sub vmovltq_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vmovltq_u8($__a));
	    }' unless defined(&vmovltq_u8);
	    eval 'sub vmovltq_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vmovltq_u16($__a));
	    }' unless defined(&vmovltq_u16);
	    eval 'sub vmovlbq_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vmovlbq_u8($__a));
	    }' unless defined(&vmovlbq_u8);
	    eval 'sub vmovlbq_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vmovlbq_u16($__a));
	    }' unless defined(&vmovlbq_u16);
	    eval 'sub vmvnq_n_u16 {
	        my( $__imm) = @_;
    		eval q( &__arm_vmvnq_n_u16( $__imm));
	    }' unless defined(&vmvnq_n_u16);
	    eval 'sub vmvnq_n_u32 {
	        my( $__imm) = @_;
    		eval q( &__arm_vmvnq_n_u32( $__imm));
	    }' unless defined(&vmvnq_n_u32);
	    eval 'sub vrev16q_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vrev16q_u8($__a));
	    }' unless defined(&vrev16q_u8);
	    eval 'sub vaddlvq_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vaddlvq_u32($__a));
	    }' unless defined(&vaddlvq_u32);
	    eval 'sub vcvtq_u16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtq_u16_f16($__a));
	    }' unless defined(&vcvtq_u16_f16);
	    eval 'sub vcvtq_u32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtq_u32_f32($__a));
	    }' unless defined(&vcvtq_u32_f32);
	    eval 'sub vcvtpq_u16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtpq_u16_f16($__a));
	    }' unless defined(&vcvtpq_u16_f16);
	    eval 'sub vcvtpq_u32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtpq_u32_f32($__a));
	    }' unless defined(&vcvtpq_u32_f32);
	    eval 'sub vcvtnq_u16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtnq_u16_f16($__a));
	    }' unless defined(&vcvtnq_u16_f16);
	    eval 'sub vcvtnq_u32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtnq_u32_f32($__a));
	    }' unless defined(&vcvtnq_u32_f32);
	    eval 'sub vcvtmq_u16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtmq_u16_f16($__a));
	    }' unless defined(&vcvtmq_u16_f16);
	    eval 'sub vcvtmq_u32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtmq_u32_f32($__a));
	    }' unless defined(&vcvtmq_u32_f32);
	    eval 'sub vcvtaq_u16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtaq_u16_f16($__a));
	    }' unless defined(&vcvtaq_u16_f16);
	    eval 'sub vcvtaq_u32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vcvtaq_u32_f32($__a));
	    }' unless defined(&vcvtaq_u32_f32);
	    eval 'sub vctp16q {
	        my($__a) = @_;
    		eval q( &__arm_vctp16q($__a));
	    }' unless defined(&vctp16q);
	    eval 'sub vctp32q {
	        my($__a) = @_;
    		eval q( &__arm_vctp32q($__a));
	    }' unless defined(&vctp32q);
	    eval 'sub vctp64q {
	        my($__a) = @_;
    		eval q( &__arm_vctp64q($__a));
	    }' unless defined(&vctp64q);
	    eval 'sub vctp8q {
	        my($__a) = @_;
    		eval q( &__arm_vctp8q($__a));
	    }' unless defined(&vctp8q);
	    eval 'sub vpnot {
	        my($__a) = @_;
    		eval q( &__arm_vpnot($__a));
	    }' unless defined(&vpnot);
	    eval 'sub vsubq_n_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_n_f16($__a, $__b));
	    }' unless defined(&vsubq_n_f16);
	    eval 'sub vsubq_n_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_n_f32($__a, $__b));
	    }' unless defined(&vsubq_n_f32);
	    eval 'sub vbrsrq_n_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbrsrq_n_f16($__a, $__b));
	    }' unless defined(&vbrsrq_n_f16);
	    eval 'sub vbrsrq_n_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbrsrq_n_f32($__a, $__b));
	    }' unless defined(&vbrsrq_n_f32);
	    eval 'sub vcvtq_n_f16_s16 {
	        my($__a,  $__imm6) = @_;
    		eval q( &__arm_vcvtq_n_f16_s16($__a, $__imm6));
	    }' unless defined(&vcvtq_n_f16_s16);
	    eval 'sub vcvtq_n_f32_s32 {
	        my($__a,  $__imm6) = @_;
    		eval q( &__arm_vcvtq_n_f32_s32($__a, $__imm6));
	    }' unless defined(&vcvtq_n_f32_s32);
	    eval 'sub vcvtq_n_f16_u16 {
	        my($__a,  $__imm6) = @_;
    		eval q( &__arm_vcvtq_n_f16_u16($__a, $__imm6));
	    }' unless defined(&vcvtq_n_f16_u16);
	    eval 'sub vcvtq_n_f32_u32 {
	        my($__a,  $__imm6) = @_;
    		eval q( &__arm_vcvtq_n_f32_u32($__a, $__imm6));
	    }' unless defined(&vcvtq_n_f32_u32);
	    eval 'sub vcreateq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcreateq_f16($__a, $__b));
	    }' unless defined(&vcreateq_f16);
	    eval 'sub vcreateq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcreateq_f32($__a, $__b));
	    }' unless defined(&vcreateq_f32);
	    eval 'sub vcvtq_n_s16_f16 {
	        my($__a,  $__imm6) = @_;
    		eval q( &__arm_vcvtq_n_s16_f16($__a, $__imm6));
	    }' unless defined(&vcvtq_n_s16_f16);
	    eval 'sub vcvtq_n_s32_f32 {
	        my($__a,  $__imm6) = @_;
    		eval q( &__arm_vcvtq_n_s32_f32($__a, $__imm6));
	    }' unless defined(&vcvtq_n_s32_f32);
	    eval 'sub vcvtq_n_u16_f16 {
	        my($__a,  $__imm6) = @_;
    		eval q( &__arm_vcvtq_n_u16_f16($__a, $__imm6));
	    }' unless defined(&vcvtq_n_u16_f16);
	    eval 'sub vcvtq_n_u32_f32 {
	        my($__a,  $__imm6) = @_;
    		eval q( &__arm_vcvtq_n_u32_f32($__a, $__imm6));
	    }' unless defined(&vcvtq_n_u32_f32);
	    eval 'sub vcreateq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcreateq_u8($__a, $__b));
	    }' unless defined(&vcreateq_u8);
	    eval 'sub vcreateq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcreateq_u16($__a, $__b));
	    }' unless defined(&vcreateq_u16);
	    eval 'sub vcreateq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcreateq_u32($__a, $__b));
	    }' unless defined(&vcreateq_u32);
	    eval 'sub vcreateq_u64 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcreateq_u64($__a, $__b));
	    }' unless defined(&vcreateq_u64);
	    eval 'sub vcreateq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcreateq_s8($__a, $__b));
	    }' unless defined(&vcreateq_s8);
	    eval 'sub vcreateq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcreateq_s16($__a, $__b));
	    }' unless defined(&vcreateq_s16);
	    eval 'sub vcreateq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcreateq_s32($__a, $__b));
	    }' unless defined(&vcreateq_s32);
	    eval 'sub vcreateq_s64 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcreateq_s64($__a, $__b));
	    }' unless defined(&vcreateq_s64);
	    eval 'sub vshrq_n_s8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshrq_n_s8($__a, $__imm));
	    }' unless defined(&vshrq_n_s8);
	    eval 'sub vshrq_n_s16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshrq_n_s16($__a, $__imm));
	    }' unless defined(&vshrq_n_s16);
	    eval 'sub vshrq_n_s32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshrq_n_s32($__a, $__imm));
	    }' unless defined(&vshrq_n_s32);
	    eval 'sub vshrq_n_u8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshrq_n_u8($__a, $__imm));
	    }' unless defined(&vshrq_n_u8);
	    eval 'sub vshrq_n_u16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshrq_n_u16($__a, $__imm));
	    }' unless defined(&vshrq_n_u16);
	    eval 'sub vshrq_n_u32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshrq_n_u32($__a, $__imm));
	    }' unless defined(&vshrq_n_u32);
	    eval 'sub vaddlvq_p_s32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vaddlvq_p_s32($__a, $__p));
	    }' unless defined(&vaddlvq_p_s32);
	    eval 'sub vaddlvq_p_u32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vaddlvq_p_u32($__a, $__p));
	    }' unless defined(&vaddlvq_p_u32);
	    eval 'sub vcmpneq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_s8($__a, $__b));
	    }' unless defined(&vcmpneq_s8);
	    eval 'sub vcmpneq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_s16($__a, $__b));
	    }' unless defined(&vcmpneq_s16);
	    eval 'sub vcmpneq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_s32($__a, $__b));
	    }' unless defined(&vcmpneq_s32);
	    eval 'sub vcmpneq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_u8($__a, $__b));
	    }' unless defined(&vcmpneq_u8);
	    eval 'sub vcmpneq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_u16($__a, $__b));
	    }' unless defined(&vcmpneq_u16);
	    eval 'sub vcmpneq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_u32($__a, $__b));
	    }' unless defined(&vcmpneq_u32);
	    eval 'sub vshlq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_s8($__a, $__b));
	    }' unless defined(&vshlq_s8);
	    eval 'sub vshlq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_s16($__a, $__b));
	    }' unless defined(&vshlq_s16);
	    eval 'sub vshlq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_s32($__a, $__b));
	    }' unless defined(&vshlq_s32);
	    eval 'sub vshlq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_u8($__a, $__b));
	    }' unless defined(&vshlq_u8);
	    eval 'sub vshlq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_u16($__a, $__b));
	    }' unless defined(&vshlq_u16);
	    eval 'sub vshlq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_u32($__a, $__b));
	    }' unless defined(&vshlq_u32);
	    eval 'sub vsubq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_u8($__a, $__b));
	    }' unless defined(&vsubq_u8);
	    eval 'sub vsubq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_n_u8($__a, $__b));
	    }' unless defined(&vsubq_n_u8);
	    eval 'sub vrmulhq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmulhq_u8($__a, $__b));
	    }' unless defined(&vrmulhq_u8);
	    eval 'sub vrhaddq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrhaddq_u8($__a, $__b));
	    }' unless defined(&vrhaddq_u8);
	    eval 'sub vqsubq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_u8($__a, $__b));
	    }' unless defined(&vqsubq_u8);
	    eval 'sub vqsubq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_n_u8($__a, $__b));
	    }' unless defined(&vqsubq_n_u8);
	    eval 'sub vqaddq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_u8($__a, $__b));
	    }' unless defined(&vqaddq_u8);
	    eval 'sub vqaddq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_n_u8($__a, $__b));
	    }' unless defined(&vqaddq_n_u8);
	    eval 'sub vorrq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vorrq_u8($__a, $__b));
	    }' unless defined(&vorrq_u8);
	    eval 'sub vornq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vornq_u8($__a, $__b));
	    }' unless defined(&vornq_u8);
	    eval 'sub vmulq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_u8($__a, $__b));
	    }' unless defined(&vmulq_u8);
	    eval 'sub vmulq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_n_u8($__a, $__b));
	    }' unless defined(&vmulq_n_u8);
	    eval 'sub vmulltq_int_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulltq_int_u8($__a, $__b));
	    }' unless defined(&vmulltq_int_u8);
	    eval 'sub vmullbq_int_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmullbq_int_u8($__a, $__b));
	    }' unless defined(&vmullbq_int_u8);
	    eval 'sub vmulhq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulhq_u8($__a, $__b));
	    }' unless defined(&vmulhq_u8);
	    eval 'sub vmladavq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavq_u8($__a, $__b));
	    }' unless defined(&vmladavq_u8);
	    eval 'sub vminvq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminvq_u8($__a, $__b));
	    }' unless defined(&vminvq_u8);
	    eval 'sub vminq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminq_u8($__a, $__b));
	    }' unless defined(&vminq_u8);
	    eval 'sub vmaxvq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxvq_u8($__a, $__b));
	    }' unless defined(&vmaxvq_u8);
	    eval 'sub vmaxq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxq_u8($__a, $__b));
	    }' unless defined(&vmaxq_u8);
	    eval 'sub vhsubq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_u8($__a, $__b));
	    }' unless defined(&vhsubq_u8);
	    eval 'sub vhsubq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_n_u8($__a, $__b));
	    }' unless defined(&vhsubq_n_u8);
	    eval 'sub vhaddq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_u8($__a, $__b));
	    }' unless defined(&vhaddq_u8);
	    eval 'sub vhaddq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_n_u8($__a, $__b));
	    }' unless defined(&vhaddq_n_u8);
	    eval 'sub veorq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_veorq_u8($__a, $__b));
	    }' unless defined(&veorq_u8);
	    eval 'sub vcmpneq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_n_u8($__a, $__b));
	    }' unless defined(&vcmpneq_n_u8);
	    eval 'sub vcmphiq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmphiq_u8($__a, $__b));
	    }' unless defined(&vcmphiq_u8);
	    eval 'sub vcmphiq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmphiq_n_u8($__a, $__b));
	    }' unless defined(&vcmphiq_n_u8);
	    eval 'sub vcmpeqq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_u8($__a, $__b));
	    }' unless defined(&vcmpeqq_u8);
	    eval 'sub vcmpeqq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_n_u8($__a, $__b));
	    }' unless defined(&vcmpeqq_n_u8);
	    eval 'sub vcmpcsq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpcsq_u8($__a, $__b));
	    }' unless defined(&vcmpcsq_u8);
	    eval 'sub vcmpcsq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpcsq_n_u8($__a, $__b));
	    }' unless defined(&vcmpcsq_n_u8);
	    eval 'sub vcaddq_rot90_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot90_u8($__a, $__b));
	    }' unless defined(&vcaddq_rot90_u8);
	    eval 'sub vcaddq_rot270_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot270_u8($__a, $__b));
	    }' unless defined(&vcaddq_rot270_u8);
	    eval 'sub vbicq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbicq_u8($__a, $__b));
	    }' unless defined(&vbicq_u8);
	    eval 'sub vandq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vandq_u8($__a, $__b));
	    }' unless defined(&vandq_u8);
	    eval 'sub vaddvq_p_u8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vaddvq_p_u8($__a, $__p));
	    }' unless defined(&vaddvq_p_u8);
	    eval 'sub vaddvaq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddvaq_u8($__a, $__b));
	    }' unless defined(&vaddvaq_u8);
	    eval 'sub vaddq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_n_u8($__a, $__b));
	    }' unless defined(&vaddq_n_u8);
	    eval 'sub vabdq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vabdq_u8($__a, $__b));
	    }' unless defined(&vabdq_u8);
	    eval 'sub vshlq_r_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_r_u8($__a, $__b));
	    }' unless defined(&vshlq_r_u8);
	    eval 'sub vrshlq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_u8($__a, $__b));
	    }' unless defined(&vrshlq_u8);
	    eval 'sub vrshlq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_n_u8($__a, $__b));
	    }' unless defined(&vrshlq_n_u8);
	    eval 'sub vqshlq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_u8($__a, $__b));
	    }' unless defined(&vqshlq_u8);
	    eval 'sub vqshlq_r_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_r_u8($__a, $__b));
	    }' unless defined(&vqshlq_r_u8);
	    eval 'sub vqrshlq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_u8($__a, $__b));
	    }' unless defined(&vqrshlq_u8);
	    eval 'sub vqrshlq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_n_u8($__a, $__b));
	    }' unless defined(&vqrshlq_n_u8);
	    eval 'sub vminavq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminavq_s8($__a, $__b));
	    }' unless defined(&vminavq_s8);
	    eval 'sub vminaq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminaq_s8($__a, $__b));
	    }' unless defined(&vminaq_s8);
	    eval 'sub vmaxavq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxavq_s8($__a, $__b));
	    }' unless defined(&vmaxavq_s8);
	    eval 'sub vmaxaq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxaq_s8($__a, $__b));
	    }' unless defined(&vmaxaq_s8);
	    eval 'sub vbrsrq_n_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbrsrq_n_u8($__a, $__b));
	    }' unless defined(&vbrsrq_n_u8);
	    eval 'sub vshlq_n_u8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshlq_n_u8($__a, $__imm));
	    }' unless defined(&vshlq_n_u8);
	    eval 'sub vrshrq_n_u8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vrshrq_n_u8($__a, $__imm));
	    }' unless defined(&vrshrq_n_u8);
	    eval 'sub vqshlq_n_u8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vqshlq_n_u8($__a, $__imm));
	    }' unless defined(&vqshlq_n_u8);
	    eval 'sub vcmpneq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_n_s8($__a, $__b));
	    }' unless defined(&vcmpneq_n_s8);
	    eval 'sub vcmpltq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq_s8($__a, $__b));
	    }' unless defined(&vcmpltq_s8);
	    eval 'sub vcmpltq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq_n_s8($__a, $__b));
	    }' unless defined(&vcmpltq_n_s8);
	    eval 'sub vcmpleq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq_s8($__a, $__b));
	    }' unless defined(&vcmpleq_s8);
	    eval 'sub vcmpleq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq_n_s8($__a, $__b));
	    }' unless defined(&vcmpleq_n_s8);
	    eval 'sub vcmpgtq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq_s8($__a, $__b));
	    }' unless defined(&vcmpgtq_s8);
	    eval 'sub vcmpgtq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq_n_s8($__a, $__b));
	    }' unless defined(&vcmpgtq_n_s8);
	    eval 'sub vcmpgeq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq_s8($__a, $__b));
	    }' unless defined(&vcmpgeq_s8);
	    eval 'sub vcmpgeq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq_n_s8($__a, $__b));
	    }' unless defined(&vcmpgeq_n_s8);
	    eval 'sub vcmpeqq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_s8($__a, $__b));
	    }' unless defined(&vcmpeqq_s8);
	    eval 'sub vcmpeqq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_n_s8($__a, $__b));
	    }' unless defined(&vcmpeqq_n_s8);
	    eval 'sub vqshluq_n_s8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vqshluq_n_s8($__a, $__imm));
	    }' unless defined(&vqshluq_n_s8);
	    eval 'sub vaddvq_p_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vaddvq_p_s8($__a, $__p));
	    }' unless defined(&vaddvq_p_s8);
	    eval 'sub vsubq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_s8($__a, $__b));
	    }' unless defined(&vsubq_s8);
	    eval 'sub vsubq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_n_s8($__a, $__b));
	    }' unless defined(&vsubq_n_s8);
	    eval 'sub vshlq_r_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_r_s8($__a, $__b));
	    }' unless defined(&vshlq_r_s8);
	    eval 'sub vrshlq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_s8($__a, $__b));
	    }' unless defined(&vrshlq_s8);
	    eval 'sub vrshlq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_n_s8($__a, $__b));
	    }' unless defined(&vrshlq_n_s8);
	    eval 'sub vrmulhq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmulhq_s8($__a, $__b));
	    }' unless defined(&vrmulhq_s8);
	    eval 'sub vrhaddq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrhaddq_s8($__a, $__b));
	    }' unless defined(&vrhaddq_s8);
	    eval 'sub vqsubq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_s8($__a, $__b));
	    }' unless defined(&vqsubq_s8);
	    eval 'sub vqsubq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_n_s8($__a, $__b));
	    }' unless defined(&vqsubq_n_s8);
	    eval 'sub vqshlq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_s8($__a, $__b));
	    }' unless defined(&vqshlq_s8);
	    eval 'sub vqshlq_r_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_r_s8($__a, $__b));
	    }' unless defined(&vqshlq_r_s8);
	    eval 'sub vqrshlq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_s8($__a, $__b));
	    }' unless defined(&vqrshlq_s8);
	    eval 'sub vqrshlq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_n_s8($__a, $__b));
	    }' unless defined(&vqrshlq_n_s8);
	    eval 'sub vqrdmulhq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrdmulhq_s8($__a, $__b));
	    }' unless defined(&vqrdmulhq_s8);
	    eval 'sub vqrdmulhq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrdmulhq_n_s8($__a, $__b));
	    }' unless defined(&vqrdmulhq_n_s8);
	    eval 'sub vqdmulhq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulhq_s8($__a, $__b));
	    }' unless defined(&vqdmulhq_s8);
	    eval 'sub vqdmulhq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulhq_n_s8($__a, $__b));
	    }' unless defined(&vqdmulhq_n_s8);
	    eval 'sub vqaddq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_s8($__a, $__b));
	    }' unless defined(&vqaddq_s8);
	    eval 'sub vqaddq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_n_s8($__a, $__b));
	    }' unless defined(&vqaddq_n_s8);
	    eval 'sub vorrq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vorrq_s8($__a, $__b));
	    }' unless defined(&vorrq_s8);
	    eval 'sub vornq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vornq_s8($__a, $__b));
	    }' unless defined(&vornq_s8);
	    eval 'sub vmulq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_s8($__a, $__b));
	    }' unless defined(&vmulq_s8);
	    eval 'sub vmulq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_n_s8($__a, $__b));
	    }' unless defined(&vmulq_n_s8);
	    eval 'sub vmulltq_int_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulltq_int_s8($__a, $__b));
	    }' unless defined(&vmulltq_int_s8);
	    eval 'sub vmullbq_int_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmullbq_int_s8($__a, $__b));
	    }' unless defined(&vmullbq_int_s8);
	    eval 'sub vmulhq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulhq_s8($__a, $__b));
	    }' unless defined(&vmulhq_s8);
	    eval 'sub vmlsdavxq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsdavxq_s8($__a, $__b));
	    }' unless defined(&vmlsdavxq_s8);
	    eval 'sub vmlsdavq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsdavq_s8($__a, $__b));
	    }' unless defined(&vmlsdavq_s8);
	    eval 'sub vmladavxq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavxq_s8($__a, $__b));
	    }' unless defined(&vmladavxq_s8);
	    eval 'sub vmladavq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavq_s8($__a, $__b));
	    }' unless defined(&vmladavq_s8);
	    eval 'sub vminvq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminvq_s8($__a, $__b));
	    }' unless defined(&vminvq_s8);
	    eval 'sub vminq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminq_s8($__a, $__b));
	    }' unless defined(&vminq_s8);
	    eval 'sub vmaxvq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxvq_s8($__a, $__b));
	    }' unless defined(&vmaxvq_s8);
	    eval 'sub vmaxq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxq_s8($__a, $__b));
	    }' unless defined(&vmaxq_s8);
	    eval 'sub vhsubq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_s8($__a, $__b));
	    }' unless defined(&vhsubq_s8);
	    eval 'sub vhsubq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_n_s8($__a, $__b));
	    }' unless defined(&vhsubq_n_s8);
	    eval 'sub vhcaddq_rot90_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhcaddq_rot90_s8($__a, $__b));
	    }' unless defined(&vhcaddq_rot90_s8);
	    eval 'sub vhcaddq_rot270_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhcaddq_rot270_s8($__a, $__b));
	    }' unless defined(&vhcaddq_rot270_s8);
	    eval 'sub vhaddq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_s8($__a, $__b));
	    }' unless defined(&vhaddq_s8);
	    eval 'sub vhaddq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_n_s8($__a, $__b));
	    }' unless defined(&vhaddq_n_s8);
	    eval 'sub veorq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_veorq_s8($__a, $__b));
	    }' unless defined(&veorq_s8);
	    eval 'sub vcaddq_rot90_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot90_s8($__a, $__b));
	    }' unless defined(&vcaddq_rot90_s8);
	    eval 'sub vcaddq_rot270_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot270_s8($__a, $__b));
	    }' unless defined(&vcaddq_rot270_s8);
	    eval 'sub vbrsrq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbrsrq_n_s8($__a, $__b));
	    }' unless defined(&vbrsrq_n_s8);
	    eval 'sub vbicq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbicq_s8($__a, $__b));
	    }' unless defined(&vbicq_s8);
	    eval 'sub vandq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vandq_s8($__a, $__b));
	    }' unless defined(&vandq_s8);
	    eval 'sub vaddvaq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddvaq_s8($__a, $__b));
	    }' unless defined(&vaddvaq_s8);
	    eval 'sub vaddq_n_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_n_s8($__a, $__b));
	    }' unless defined(&vaddq_n_s8);
	    eval 'sub vabdq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vabdq_s8($__a, $__b));
	    }' unless defined(&vabdq_s8);
	    eval 'sub vshlq_n_s8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshlq_n_s8($__a, $__imm));
	    }' unless defined(&vshlq_n_s8);
	    eval 'sub vrshrq_n_s8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vrshrq_n_s8($__a, $__imm));
	    }' unless defined(&vrshrq_n_s8);
	    eval 'sub vqshlq_n_s8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vqshlq_n_s8($__a, $__imm));
	    }' unless defined(&vqshlq_n_s8);
	    eval 'sub vsubq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_u16($__a, $__b));
	    }' unless defined(&vsubq_u16);
	    eval 'sub vsubq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_n_u16($__a, $__b));
	    }' unless defined(&vsubq_n_u16);
	    eval 'sub vrmulhq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmulhq_u16($__a, $__b));
	    }' unless defined(&vrmulhq_u16);
	    eval 'sub vrhaddq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrhaddq_u16($__a, $__b));
	    }' unless defined(&vrhaddq_u16);
	    eval 'sub vqsubq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_u16($__a, $__b));
	    }' unless defined(&vqsubq_u16);
	    eval 'sub vqsubq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_n_u16($__a, $__b));
	    }' unless defined(&vqsubq_n_u16);
	    eval 'sub vqaddq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_u16($__a, $__b));
	    }' unless defined(&vqaddq_u16);
	    eval 'sub vqaddq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_n_u16($__a, $__b));
	    }' unless defined(&vqaddq_n_u16);
	    eval 'sub vorrq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vorrq_u16($__a, $__b));
	    }' unless defined(&vorrq_u16);
	    eval 'sub vornq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vornq_u16($__a, $__b));
	    }' unless defined(&vornq_u16);
	    eval 'sub vmulq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_u16($__a, $__b));
	    }' unless defined(&vmulq_u16);
	    eval 'sub vmulq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_n_u16($__a, $__b));
	    }' unless defined(&vmulq_n_u16);
	    eval 'sub vmulltq_int_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulltq_int_u16($__a, $__b));
	    }' unless defined(&vmulltq_int_u16);
	    eval 'sub vmullbq_int_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmullbq_int_u16($__a, $__b));
	    }' unless defined(&vmullbq_int_u16);
	    eval 'sub vmulhq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulhq_u16($__a, $__b));
	    }' unless defined(&vmulhq_u16);
	    eval 'sub vmladavq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavq_u16($__a, $__b));
	    }' unless defined(&vmladavq_u16);
	    eval 'sub vminvq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminvq_u16($__a, $__b));
	    }' unless defined(&vminvq_u16);
	    eval 'sub vminq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminq_u16($__a, $__b));
	    }' unless defined(&vminq_u16);
	    eval 'sub vmaxvq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxvq_u16($__a, $__b));
	    }' unless defined(&vmaxvq_u16);
	    eval 'sub vmaxq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxq_u16($__a, $__b));
	    }' unless defined(&vmaxq_u16);
	    eval 'sub vhsubq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_u16($__a, $__b));
	    }' unless defined(&vhsubq_u16);
	    eval 'sub vhsubq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_n_u16($__a, $__b));
	    }' unless defined(&vhsubq_n_u16);
	    eval 'sub vhaddq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_u16($__a, $__b));
	    }' unless defined(&vhaddq_u16);
	    eval 'sub vhaddq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_n_u16($__a, $__b));
	    }' unless defined(&vhaddq_n_u16);
	    eval 'sub veorq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_veorq_u16($__a, $__b));
	    }' unless defined(&veorq_u16);
	    eval 'sub vcmpneq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_n_u16($__a, $__b));
	    }' unless defined(&vcmpneq_n_u16);
	    eval 'sub vcmphiq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmphiq_u16($__a, $__b));
	    }' unless defined(&vcmphiq_u16);
	    eval 'sub vcmphiq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmphiq_n_u16($__a, $__b));
	    }' unless defined(&vcmphiq_n_u16);
	    eval 'sub vcmpeqq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_u16($__a, $__b));
	    }' unless defined(&vcmpeqq_u16);
	    eval 'sub vcmpeqq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_n_u16($__a, $__b));
	    }' unless defined(&vcmpeqq_n_u16);
	    eval 'sub vcmpcsq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpcsq_u16($__a, $__b));
	    }' unless defined(&vcmpcsq_u16);
	    eval 'sub vcmpcsq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpcsq_n_u16($__a, $__b));
	    }' unless defined(&vcmpcsq_n_u16);
	    eval 'sub vcaddq_rot90_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot90_u16($__a, $__b));
	    }' unless defined(&vcaddq_rot90_u16);
	    eval 'sub vcaddq_rot270_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot270_u16($__a, $__b));
	    }' unless defined(&vcaddq_rot270_u16);
	    eval 'sub vbicq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbicq_u16($__a, $__b));
	    }' unless defined(&vbicq_u16);
	    eval 'sub vandq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vandq_u16($__a, $__b));
	    }' unless defined(&vandq_u16);
	    eval 'sub vaddvq_p_u16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vaddvq_p_u16($__a, $__p));
	    }' unless defined(&vaddvq_p_u16);
	    eval 'sub vaddvaq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddvaq_u16($__a, $__b));
	    }' unless defined(&vaddvaq_u16);
	    eval 'sub vaddq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_n_u16($__a, $__b));
	    }' unless defined(&vaddq_n_u16);
	    eval 'sub vabdq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vabdq_u16($__a, $__b));
	    }' unless defined(&vabdq_u16);
	    eval 'sub vshlq_r_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_r_u16($__a, $__b));
	    }' unless defined(&vshlq_r_u16);
	    eval 'sub vrshlq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_u16($__a, $__b));
	    }' unless defined(&vrshlq_u16);
	    eval 'sub vrshlq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_n_u16($__a, $__b));
	    }' unless defined(&vrshlq_n_u16);
	    eval 'sub vqshlq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_u16($__a, $__b));
	    }' unless defined(&vqshlq_u16);
	    eval 'sub vqshlq_r_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_r_u16($__a, $__b));
	    }' unless defined(&vqshlq_r_u16);
	    eval 'sub vqrshlq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_u16($__a, $__b));
	    }' unless defined(&vqrshlq_u16);
	    eval 'sub vqrshlq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_n_u16($__a, $__b));
	    }' unless defined(&vqrshlq_n_u16);
	    eval 'sub vminavq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminavq_s16($__a, $__b));
	    }' unless defined(&vminavq_s16);
	    eval 'sub vminaq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminaq_s16($__a, $__b));
	    }' unless defined(&vminaq_s16);
	    eval 'sub vmaxavq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxavq_s16($__a, $__b));
	    }' unless defined(&vmaxavq_s16);
	    eval 'sub vmaxaq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxaq_s16($__a, $__b));
	    }' unless defined(&vmaxaq_s16);
	    eval 'sub vbrsrq_n_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbrsrq_n_u16($__a, $__b));
	    }' unless defined(&vbrsrq_n_u16);
	    eval 'sub vshlq_n_u16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshlq_n_u16($__a, $__imm));
	    }' unless defined(&vshlq_n_u16);
	    eval 'sub vrshrq_n_u16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vrshrq_n_u16($__a, $__imm));
	    }' unless defined(&vrshrq_n_u16);
	    eval 'sub vqshlq_n_u16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vqshlq_n_u16($__a, $__imm));
	    }' unless defined(&vqshlq_n_u16);
	    eval 'sub vcmpneq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_n_s16($__a, $__b));
	    }' unless defined(&vcmpneq_n_s16);
	    eval 'sub vcmpltq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq_s16($__a, $__b));
	    }' unless defined(&vcmpltq_s16);
	    eval 'sub vcmpltq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq_n_s16($__a, $__b));
	    }' unless defined(&vcmpltq_n_s16);
	    eval 'sub vcmpleq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq_s16($__a, $__b));
	    }' unless defined(&vcmpleq_s16);
	    eval 'sub vcmpleq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq_n_s16($__a, $__b));
	    }' unless defined(&vcmpleq_n_s16);
	    eval 'sub vcmpgtq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq_s16($__a, $__b));
	    }' unless defined(&vcmpgtq_s16);
	    eval 'sub vcmpgtq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq_n_s16($__a, $__b));
	    }' unless defined(&vcmpgtq_n_s16);
	    eval 'sub vcmpgeq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq_s16($__a, $__b));
	    }' unless defined(&vcmpgeq_s16);
	    eval 'sub vcmpgeq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq_n_s16($__a, $__b));
	    }' unless defined(&vcmpgeq_n_s16);
	    eval 'sub vcmpeqq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_s16($__a, $__b));
	    }' unless defined(&vcmpeqq_s16);
	    eval 'sub vcmpeqq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_n_s16($__a, $__b));
	    }' unless defined(&vcmpeqq_n_s16);
	    eval 'sub vqshluq_n_s16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vqshluq_n_s16($__a, $__imm));
	    }' unless defined(&vqshluq_n_s16);
	    eval 'sub vaddvq_p_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vaddvq_p_s16($__a, $__p));
	    }' unless defined(&vaddvq_p_s16);
	    eval 'sub vsubq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_s16($__a, $__b));
	    }' unless defined(&vsubq_s16);
	    eval 'sub vsubq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_n_s16($__a, $__b));
	    }' unless defined(&vsubq_n_s16);
	    eval 'sub vshlq_r_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_r_s16($__a, $__b));
	    }' unless defined(&vshlq_r_s16);
	    eval 'sub vrshlq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_s16($__a, $__b));
	    }' unless defined(&vrshlq_s16);
	    eval 'sub vrshlq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_n_s16($__a, $__b));
	    }' unless defined(&vrshlq_n_s16);
	    eval 'sub vrmulhq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmulhq_s16($__a, $__b));
	    }' unless defined(&vrmulhq_s16);
	    eval 'sub vrhaddq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrhaddq_s16($__a, $__b));
	    }' unless defined(&vrhaddq_s16);
	    eval 'sub vqsubq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_s16($__a, $__b));
	    }' unless defined(&vqsubq_s16);
	    eval 'sub vqsubq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_n_s16($__a, $__b));
	    }' unless defined(&vqsubq_n_s16);
	    eval 'sub vqshlq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_s16($__a, $__b));
	    }' unless defined(&vqshlq_s16);
	    eval 'sub vqshlq_r_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_r_s16($__a, $__b));
	    }' unless defined(&vqshlq_r_s16);
	    eval 'sub vqrshlq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_s16($__a, $__b));
	    }' unless defined(&vqrshlq_s16);
	    eval 'sub vqrshlq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_n_s16($__a, $__b));
	    }' unless defined(&vqrshlq_n_s16);
	    eval 'sub vqrdmulhq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrdmulhq_s16($__a, $__b));
	    }' unless defined(&vqrdmulhq_s16);
	    eval 'sub vqrdmulhq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrdmulhq_n_s16($__a, $__b));
	    }' unless defined(&vqrdmulhq_n_s16);
	    eval 'sub vqdmulhq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulhq_s16($__a, $__b));
	    }' unless defined(&vqdmulhq_s16);
	    eval 'sub vqdmulhq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulhq_n_s16($__a, $__b));
	    }' unless defined(&vqdmulhq_n_s16);
	    eval 'sub vqaddq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_s16($__a, $__b));
	    }' unless defined(&vqaddq_s16);
	    eval 'sub vqaddq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_n_s16($__a, $__b));
	    }' unless defined(&vqaddq_n_s16);
	    eval 'sub vorrq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vorrq_s16($__a, $__b));
	    }' unless defined(&vorrq_s16);
	    eval 'sub vornq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vornq_s16($__a, $__b));
	    }' unless defined(&vornq_s16);
	    eval 'sub vmulq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_s16($__a, $__b));
	    }' unless defined(&vmulq_s16);
	    eval 'sub vmulq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_n_s16($__a, $__b));
	    }' unless defined(&vmulq_n_s16);
	    eval 'sub vmulltq_int_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulltq_int_s16($__a, $__b));
	    }' unless defined(&vmulltq_int_s16);
	    eval 'sub vmullbq_int_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmullbq_int_s16($__a, $__b));
	    }' unless defined(&vmullbq_int_s16);
	    eval 'sub vmulhq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulhq_s16($__a, $__b));
	    }' unless defined(&vmulhq_s16);
	    eval 'sub vmlsdavxq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsdavxq_s16($__a, $__b));
	    }' unless defined(&vmlsdavxq_s16);
	    eval 'sub vmlsdavq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsdavq_s16($__a, $__b));
	    }' unless defined(&vmlsdavq_s16);
	    eval 'sub vmladavxq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavxq_s16($__a, $__b));
	    }' unless defined(&vmladavxq_s16);
	    eval 'sub vmladavq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavq_s16($__a, $__b));
	    }' unless defined(&vmladavq_s16);
	    eval 'sub vminvq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminvq_s16($__a, $__b));
	    }' unless defined(&vminvq_s16);
	    eval 'sub vminq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminq_s16($__a, $__b));
	    }' unless defined(&vminq_s16);
	    eval 'sub vmaxvq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxvq_s16($__a, $__b));
	    }' unless defined(&vmaxvq_s16);
	    eval 'sub vmaxq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxq_s16($__a, $__b));
	    }' unless defined(&vmaxq_s16);
	    eval 'sub vhsubq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_s16($__a, $__b));
	    }' unless defined(&vhsubq_s16);
	    eval 'sub vhsubq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_n_s16($__a, $__b));
	    }' unless defined(&vhsubq_n_s16);
	    eval 'sub vhcaddq_rot90_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhcaddq_rot90_s16($__a, $__b));
	    }' unless defined(&vhcaddq_rot90_s16);
	    eval 'sub vhcaddq_rot270_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhcaddq_rot270_s16($__a, $__b));
	    }' unless defined(&vhcaddq_rot270_s16);
	    eval 'sub vhaddq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_s16($__a, $__b));
	    }' unless defined(&vhaddq_s16);
	    eval 'sub vhaddq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_n_s16($__a, $__b));
	    }' unless defined(&vhaddq_n_s16);
	    eval 'sub veorq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_veorq_s16($__a, $__b));
	    }' unless defined(&veorq_s16);
	    eval 'sub vcaddq_rot90_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot90_s16($__a, $__b));
	    }' unless defined(&vcaddq_rot90_s16);
	    eval 'sub vcaddq_rot270_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot270_s16($__a, $__b));
	    }' unless defined(&vcaddq_rot270_s16);
	    eval 'sub vbrsrq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbrsrq_n_s16($__a, $__b));
	    }' unless defined(&vbrsrq_n_s16);
	    eval 'sub vbicq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbicq_s16($__a, $__b));
	    }' unless defined(&vbicq_s16);
	    eval 'sub vandq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vandq_s16($__a, $__b));
	    }' unless defined(&vandq_s16);
	    eval 'sub vaddvaq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddvaq_s16($__a, $__b));
	    }' unless defined(&vaddvaq_s16);
	    eval 'sub vaddq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_n_s16($__a, $__b));
	    }' unless defined(&vaddq_n_s16);
	    eval 'sub vabdq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vabdq_s16($__a, $__b));
	    }' unless defined(&vabdq_s16);
	    eval 'sub vshlq_n_s16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshlq_n_s16($__a, $__imm));
	    }' unless defined(&vshlq_n_s16);
	    eval 'sub vrshrq_n_s16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vrshrq_n_s16($__a, $__imm));
	    }' unless defined(&vrshrq_n_s16);
	    eval 'sub vqshlq_n_s16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vqshlq_n_s16($__a, $__imm));
	    }' unless defined(&vqshlq_n_s16);
	    eval 'sub vsubq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_u32($__a, $__b));
	    }' unless defined(&vsubq_u32);
	    eval 'sub vsubq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_n_u32($__a, $__b));
	    }' unless defined(&vsubq_n_u32);
	    eval 'sub vrmulhq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmulhq_u32($__a, $__b));
	    }' unless defined(&vrmulhq_u32);
	    eval 'sub vrhaddq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrhaddq_u32($__a, $__b));
	    }' unless defined(&vrhaddq_u32);
	    eval 'sub vqsubq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_u32($__a, $__b));
	    }' unless defined(&vqsubq_u32);
	    eval 'sub vqsubq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_n_u32($__a, $__b));
	    }' unless defined(&vqsubq_n_u32);
	    eval 'sub vqaddq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_u32($__a, $__b));
	    }' unless defined(&vqaddq_u32);
	    eval 'sub vqaddq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_n_u32($__a, $__b));
	    }' unless defined(&vqaddq_n_u32);
	    eval 'sub vorrq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vorrq_u32($__a, $__b));
	    }' unless defined(&vorrq_u32);
	    eval 'sub vornq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vornq_u32($__a, $__b));
	    }' unless defined(&vornq_u32);
	    eval 'sub vmulq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_u32($__a, $__b));
	    }' unless defined(&vmulq_u32);
	    eval 'sub vmulq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_n_u32($__a, $__b));
	    }' unless defined(&vmulq_n_u32);
	    eval 'sub vmulltq_int_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulltq_int_u32($__a, $__b));
	    }' unless defined(&vmulltq_int_u32);
	    eval 'sub vmullbq_int_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmullbq_int_u32($__a, $__b));
	    }' unless defined(&vmullbq_int_u32);
	    eval 'sub vmulhq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulhq_u32($__a, $__b));
	    }' unless defined(&vmulhq_u32);
	    eval 'sub vmladavq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavq_u32($__a, $__b));
	    }' unless defined(&vmladavq_u32);
	    eval 'sub vminvq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminvq_u32($__a, $__b));
	    }' unless defined(&vminvq_u32);
	    eval 'sub vminq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminq_u32($__a, $__b));
	    }' unless defined(&vminq_u32);
	    eval 'sub vmaxvq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxvq_u32($__a, $__b));
	    }' unless defined(&vmaxvq_u32);
	    eval 'sub vmaxq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxq_u32($__a, $__b));
	    }' unless defined(&vmaxq_u32);
	    eval 'sub vhsubq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_u32($__a, $__b));
	    }' unless defined(&vhsubq_u32);
	    eval 'sub vhsubq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_n_u32($__a, $__b));
	    }' unless defined(&vhsubq_n_u32);
	    eval 'sub vhaddq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_u32($__a, $__b));
	    }' unless defined(&vhaddq_u32);
	    eval 'sub vhaddq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_n_u32($__a, $__b));
	    }' unless defined(&vhaddq_n_u32);
	    eval 'sub veorq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_veorq_u32($__a, $__b));
	    }' unless defined(&veorq_u32);
	    eval 'sub vcmpneq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_n_u32($__a, $__b));
	    }' unless defined(&vcmpneq_n_u32);
	    eval 'sub vcmphiq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmphiq_u32($__a, $__b));
	    }' unless defined(&vcmphiq_u32);
	    eval 'sub vcmphiq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmphiq_n_u32($__a, $__b));
	    }' unless defined(&vcmphiq_n_u32);
	    eval 'sub vcmpeqq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_u32($__a, $__b));
	    }' unless defined(&vcmpeqq_u32);
	    eval 'sub vcmpeqq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_n_u32($__a, $__b));
	    }' unless defined(&vcmpeqq_n_u32);
	    eval 'sub vcmpcsq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpcsq_u32($__a, $__b));
	    }' unless defined(&vcmpcsq_u32);
	    eval 'sub vcmpcsq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpcsq_n_u32($__a, $__b));
	    }' unless defined(&vcmpcsq_n_u32);
	    eval 'sub vcaddq_rot90_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot90_u32($__a, $__b));
	    }' unless defined(&vcaddq_rot90_u32);
	    eval 'sub vcaddq_rot270_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot270_u32($__a, $__b));
	    }' unless defined(&vcaddq_rot270_u32);
	    eval 'sub vbicq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbicq_u32($__a, $__b));
	    }' unless defined(&vbicq_u32);
	    eval 'sub vandq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vandq_u32($__a, $__b));
	    }' unless defined(&vandq_u32);
	    eval 'sub vaddvq_p_u32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vaddvq_p_u32($__a, $__p));
	    }' unless defined(&vaddvq_p_u32);
	    eval 'sub vaddvaq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddvaq_u32($__a, $__b));
	    }' unless defined(&vaddvaq_u32);
	    eval 'sub vaddq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_n_u32($__a, $__b));
	    }' unless defined(&vaddq_n_u32);
	    eval 'sub vabdq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vabdq_u32($__a, $__b));
	    }' unless defined(&vabdq_u32);
	    eval 'sub vshlq_r_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_r_u32($__a, $__b));
	    }' unless defined(&vshlq_r_u32);
	    eval 'sub vrshlq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_u32($__a, $__b));
	    }' unless defined(&vrshlq_u32);
	    eval 'sub vrshlq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_n_u32($__a, $__b));
	    }' unless defined(&vrshlq_n_u32);
	    eval 'sub vqshlq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_u32($__a, $__b));
	    }' unless defined(&vqshlq_u32);
	    eval 'sub vqshlq_r_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_r_u32($__a, $__b));
	    }' unless defined(&vqshlq_r_u32);
	    eval 'sub vqrshlq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_u32($__a, $__b));
	    }' unless defined(&vqrshlq_u32);
	    eval 'sub vqrshlq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_n_u32($__a, $__b));
	    }' unless defined(&vqrshlq_n_u32);
	    eval 'sub vminavq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminavq_s32($__a, $__b));
	    }' unless defined(&vminavq_s32);
	    eval 'sub vminaq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminaq_s32($__a, $__b));
	    }' unless defined(&vminaq_s32);
	    eval 'sub vmaxavq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxavq_s32($__a, $__b));
	    }' unless defined(&vmaxavq_s32);
	    eval 'sub vmaxaq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxaq_s32($__a, $__b));
	    }' unless defined(&vmaxaq_s32);
	    eval 'sub vbrsrq_n_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbrsrq_n_u32($__a, $__b));
	    }' unless defined(&vbrsrq_n_u32);
	    eval 'sub vshlq_n_u32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshlq_n_u32($__a, $__imm));
	    }' unless defined(&vshlq_n_u32);
	    eval 'sub vrshrq_n_u32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vrshrq_n_u32($__a, $__imm));
	    }' unless defined(&vrshrq_n_u32);
	    eval 'sub vqshlq_n_u32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vqshlq_n_u32($__a, $__imm));
	    }' unless defined(&vqshlq_n_u32);
	    eval 'sub vcmpneq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_n_s32($__a, $__b));
	    }' unless defined(&vcmpneq_n_s32);
	    eval 'sub vcmpltq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq_s32($__a, $__b));
	    }' unless defined(&vcmpltq_s32);
	    eval 'sub vcmpltq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq_n_s32($__a, $__b));
	    }' unless defined(&vcmpltq_n_s32);
	    eval 'sub vcmpleq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq_s32($__a, $__b));
	    }' unless defined(&vcmpleq_s32);
	    eval 'sub vcmpleq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq_n_s32($__a, $__b));
	    }' unless defined(&vcmpleq_n_s32);
	    eval 'sub vcmpgtq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq_s32($__a, $__b));
	    }' unless defined(&vcmpgtq_s32);
	    eval 'sub vcmpgtq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq_n_s32($__a, $__b));
	    }' unless defined(&vcmpgtq_n_s32);
	    eval 'sub vcmpgeq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq_s32($__a, $__b));
	    }' unless defined(&vcmpgeq_s32);
	    eval 'sub vcmpgeq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq_n_s32($__a, $__b));
	    }' unless defined(&vcmpgeq_n_s32);
	    eval 'sub vcmpeqq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_s32($__a, $__b));
	    }' unless defined(&vcmpeqq_s32);
	    eval 'sub vcmpeqq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_n_s32($__a, $__b));
	    }' unless defined(&vcmpeqq_n_s32);
	    eval 'sub vqshluq_n_s32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vqshluq_n_s32($__a, $__imm));
	    }' unless defined(&vqshluq_n_s32);
	    eval 'sub vaddvq_p_s32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vaddvq_p_s32($__a, $__p));
	    }' unless defined(&vaddvq_p_s32);
	    eval 'sub vsubq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_s32($__a, $__b));
	    }' unless defined(&vsubq_s32);
	    eval 'sub vsubq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_n_s32($__a, $__b));
	    }' unless defined(&vsubq_n_s32);
	    eval 'sub vshlq_r_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vshlq_r_s32($__a, $__b));
	    }' unless defined(&vshlq_r_s32);
	    eval 'sub vrshlq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_s32($__a, $__b));
	    }' unless defined(&vrshlq_s32);
	    eval 'sub vrshlq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrshlq_n_s32($__a, $__b));
	    }' unless defined(&vrshlq_n_s32);
	    eval 'sub vrmulhq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmulhq_s32($__a, $__b));
	    }' unless defined(&vrmulhq_s32);
	    eval 'sub vrhaddq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrhaddq_s32($__a, $__b));
	    }' unless defined(&vrhaddq_s32);
	    eval 'sub vqsubq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_s32($__a, $__b));
	    }' unless defined(&vqsubq_s32);
	    eval 'sub vqsubq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqsubq_n_s32($__a, $__b));
	    }' unless defined(&vqsubq_n_s32);
	    eval 'sub vqshlq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_s32($__a, $__b));
	    }' unless defined(&vqshlq_s32);
	    eval 'sub vqshlq_r_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqshlq_r_s32($__a, $__b));
	    }' unless defined(&vqshlq_r_s32);
	    eval 'sub vqrshlq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_s32($__a, $__b));
	    }' unless defined(&vqrshlq_s32);
	    eval 'sub vqrshlq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrshlq_n_s32($__a, $__b));
	    }' unless defined(&vqrshlq_n_s32);
	    eval 'sub vqrdmulhq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrdmulhq_s32($__a, $__b));
	    }' unless defined(&vqrdmulhq_s32);
	    eval 'sub vqrdmulhq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqrdmulhq_n_s32($__a, $__b));
	    }' unless defined(&vqrdmulhq_n_s32);
	    eval 'sub vqdmulhq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulhq_s32($__a, $__b));
	    }' unless defined(&vqdmulhq_s32);
	    eval 'sub vqdmulhq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulhq_n_s32($__a, $__b));
	    }' unless defined(&vqdmulhq_n_s32);
	    eval 'sub vqaddq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_s32($__a, $__b));
	    }' unless defined(&vqaddq_s32);
	    eval 'sub vqaddq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqaddq_n_s32($__a, $__b));
	    }' unless defined(&vqaddq_n_s32);
	    eval 'sub vorrq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vorrq_s32($__a, $__b));
	    }' unless defined(&vorrq_s32);
	    eval 'sub vornq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vornq_s32($__a, $__b));
	    }' unless defined(&vornq_s32);
	    eval 'sub vmulq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_s32($__a, $__b));
	    }' unless defined(&vmulq_s32);
	    eval 'sub vmulq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_n_s32($__a, $__b));
	    }' unless defined(&vmulq_n_s32);
	    eval 'sub vmulltq_int_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulltq_int_s32($__a, $__b));
	    }' unless defined(&vmulltq_int_s32);
	    eval 'sub vmullbq_int_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmullbq_int_s32($__a, $__b));
	    }' unless defined(&vmullbq_int_s32);
	    eval 'sub vmulhq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulhq_s32($__a, $__b));
	    }' unless defined(&vmulhq_s32);
	    eval 'sub vmlsdavxq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsdavxq_s32($__a, $__b));
	    }' unless defined(&vmlsdavxq_s32);
	    eval 'sub vmlsdavq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsdavq_s32($__a, $__b));
	    }' unless defined(&vmlsdavq_s32);
	    eval 'sub vmladavxq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavxq_s32($__a, $__b));
	    }' unless defined(&vmladavxq_s32);
	    eval 'sub vmladavq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmladavq_s32($__a, $__b));
	    }' unless defined(&vmladavq_s32);
	    eval 'sub vminvq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminvq_s32($__a, $__b));
	    }' unless defined(&vminvq_s32);
	    eval 'sub vminq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminq_s32($__a, $__b));
	    }' unless defined(&vminq_s32);
	    eval 'sub vmaxvq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxvq_s32($__a, $__b));
	    }' unless defined(&vmaxvq_s32);
	    eval 'sub vmaxq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxq_s32($__a, $__b));
	    }' unless defined(&vmaxq_s32);
	    eval 'sub vhsubq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_s32($__a, $__b));
	    }' unless defined(&vhsubq_s32);
	    eval 'sub vhsubq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhsubq_n_s32($__a, $__b));
	    }' unless defined(&vhsubq_n_s32);
	    eval 'sub vhcaddq_rot90_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhcaddq_rot90_s32($__a, $__b));
	    }' unless defined(&vhcaddq_rot90_s32);
	    eval 'sub vhcaddq_rot270_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhcaddq_rot270_s32($__a, $__b));
	    }' unless defined(&vhcaddq_rot270_s32);
	    eval 'sub vhaddq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_s32($__a, $__b));
	    }' unless defined(&vhaddq_s32);
	    eval 'sub vhaddq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vhaddq_n_s32($__a, $__b));
	    }' unless defined(&vhaddq_n_s32);
	    eval 'sub veorq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_veorq_s32($__a, $__b));
	    }' unless defined(&veorq_s32);
	    eval 'sub vcaddq_rot90_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot90_s32($__a, $__b));
	    }' unless defined(&vcaddq_rot90_s32);
	    eval 'sub vcaddq_rot270_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot270_s32($__a, $__b));
	    }' unless defined(&vcaddq_rot270_s32);
	    eval 'sub vbrsrq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbrsrq_n_s32($__a, $__b));
	    }' unless defined(&vbrsrq_n_s32);
	    eval 'sub vbicq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbicq_s32($__a, $__b));
	    }' unless defined(&vbicq_s32);
	    eval 'sub vandq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vandq_s32($__a, $__b));
	    }' unless defined(&vandq_s32);
	    eval 'sub vaddvaq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddvaq_s32($__a, $__b));
	    }' unless defined(&vaddvaq_s32);
	    eval 'sub vaddq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_n_s32($__a, $__b));
	    }' unless defined(&vaddq_n_s32);
	    eval 'sub vabdq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vabdq_s32($__a, $__b));
	    }' unless defined(&vabdq_s32);
	    eval 'sub vshlq_n_s32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshlq_n_s32($__a, $__imm));
	    }' unless defined(&vshlq_n_s32);
	    eval 'sub vrshrq_n_s32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vrshrq_n_s32($__a, $__imm));
	    }' unless defined(&vrshrq_n_s32);
	    eval 'sub vqshlq_n_s32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vqshlq_n_s32($__a, $__imm));
	    }' unless defined(&vqshlq_n_s32);
	    eval 'sub vqmovntq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovntq_u16($__a, $__b));
	    }' unless defined(&vqmovntq_u16);
	    eval 'sub vqmovnbq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovnbq_u16($__a, $__b));
	    }' unless defined(&vqmovnbq_u16);
	    eval 'sub vmulltq_poly_p8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulltq_poly_p8($__a, $__b));
	    }' unless defined(&vmulltq_poly_p8);
	    eval 'sub vmullbq_poly_p8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmullbq_poly_p8($__a, $__b));
	    }' unless defined(&vmullbq_poly_p8);
	    eval 'sub vmovntq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmovntq_u16($__a, $__b));
	    }' unless defined(&vmovntq_u16);
	    eval 'sub vmovnbq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmovnbq_u16($__a, $__b));
	    }' unless defined(&vmovnbq_u16);
	    eval 'sub vmlaldavq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlaldavq_u16($__a, $__b));
	    }' unless defined(&vmlaldavq_u16);
	    eval 'sub vqmovuntq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovuntq_s16($__a, $__b));
	    }' unless defined(&vqmovuntq_s16);
	    eval 'sub vqmovunbq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovunbq_s16($__a, $__b));
	    }' unless defined(&vqmovunbq_s16);
	    eval 'sub vshlltq_n_u8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshlltq_n_u8($__a, $__imm));
	    }' unless defined(&vshlltq_n_u8);
	    eval 'sub vshllbq_n_u8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshllbq_n_u8($__a, $__imm));
	    }' unless defined(&vshllbq_n_u8);
	    eval 'sub vorrq_n_u16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vorrq_n_u16($__a, $__imm));
	    }' unless defined(&vorrq_n_u16);
	    eval 'sub vbicq_n_u16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vbicq_n_u16($__a, $__imm));
	    }' unless defined(&vbicq_n_u16);
	    eval 'sub vcmpneq_n_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_n_f16($__a, $__b));
	    }' unless defined(&vcmpneq_n_f16);
	    eval 'sub vcmpneq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_f16($__a, $__b));
	    }' unless defined(&vcmpneq_f16);
	    eval 'sub vcmpltq_n_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq_n_f16($__a, $__b));
	    }' unless defined(&vcmpltq_n_f16);
	    eval 'sub vcmpltq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq_f16($__a, $__b));
	    }' unless defined(&vcmpltq_f16);
	    eval 'sub vcmpleq_n_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq_n_f16($__a, $__b));
	    }' unless defined(&vcmpleq_n_f16);
	    eval 'sub vcmpleq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq_f16($__a, $__b));
	    }' unless defined(&vcmpleq_f16);
	    eval 'sub vcmpgtq_n_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq_n_f16($__a, $__b));
	    }' unless defined(&vcmpgtq_n_f16);
	    eval 'sub vcmpgtq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq_f16($__a, $__b));
	    }' unless defined(&vcmpgtq_f16);
	    eval 'sub vcmpgeq_n_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq_n_f16($__a, $__b));
	    }' unless defined(&vcmpgeq_n_f16);
	    eval 'sub vcmpgeq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq_f16($__a, $__b));
	    }' unless defined(&vcmpgeq_f16);
	    eval 'sub vcmpeqq_n_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_n_f16($__a, $__b));
	    }' unless defined(&vcmpeqq_n_f16);
	    eval 'sub vcmpeqq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_f16($__a, $__b));
	    }' unless defined(&vcmpeqq_f16);
	    eval 'sub vsubq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_f16($__a, $__b));
	    }' unless defined(&vsubq_f16);
	    eval 'sub vqmovntq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovntq_s16($__a, $__b));
	    }' unless defined(&vqmovntq_s16);
	    eval 'sub vqmovnbq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovnbq_s16($__a, $__b));
	    }' unless defined(&vqmovnbq_s16);
	    eval 'sub vqdmulltq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulltq_s16($__a, $__b));
	    }' unless defined(&vqdmulltq_s16);
	    eval 'sub vqdmulltq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulltq_n_s16($__a, $__b));
	    }' unless defined(&vqdmulltq_n_s16);
	    eval 'sub vqdmullbq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmullbq_s16($__a, $__b));
	    }' unless defined(&vqdmullbq_s16);
	    eval 'sub vqdmullbq_n_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmullbq_n_s16($__a, $__b));
	    }' unless defined(&vqdmullbq_n_s16);
	    eval 'sub vorrq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vorrq_f16($__a, $__b));
	    }' unless defined(&vorrq_f16);
	    eval 'sub vornq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vornq_f16($__a, $__b));
	    }' unless defined(&vornq_f16);
	    eval 'sub vmulq_n_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_n_f16($__a, $__b));
	    }' unless defined(&vmulq_n_f16);
	    eval 'sub vmulq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_f16($__a, $__b));
	    }' unless defined(&vmulq_f16);
	    eval 'sub vmovntq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmovntq_s16($__a, $__b));
	    }' unless defined(&vmovntq_s16);
	    eval 'sub vmovnbq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmovnbq_s16($__a, $__b));
	    }' unless defined(&vmovnbq_s16);
	    eval 'sub vmlsldavxq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsldavxq_s16($__a, $__b));
	    }' unless defined(&vmlsldavxq_s16);
	    eval 'sub vmlsldavq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsldavq_s16($__a, $__b));
	    }' unless defined(&vmlsldavq_s16);
	    eval 'sub vmlaldavxq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlaldavxq_s16($__a, $__b));
	    }' unless defined(&vmlaldavxq_s16);
	    eval 'sub vmlaldavq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlaldavq_s16($__a, $__b));
	    }' unless defined(&vmlaldavq_s16);
	    eval 'sub vminnmvq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmvq_f16($__a, $__b));
	    }' unless defined(&vminnmvq_f16);
	    eval 'sub vminnmq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmq_f16($__a, $__b));
	    }' unless defined(&vminnmq_f16);
	    eval 'sub vminnmavq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmavq_f16($__a, $__b));
	    }' unless defined(&vminnmavq_f16);
	    eval 'sub vminnmaq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmaq_f16($__a, $__b));
	    }' unless defined(&vminnmaq_f16);
	    eval 'sub vmaxnmvq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmvq_f16($__a, $__b));
	    }' unless defined(&vmaxnmvq_f16);
	    eval 'sub vmaxnmq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmq_f16($__a, $__b));
	    }' unless defined(&vmaxnmq_f16);
	    eval 'sub vmaxnmavq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmavq_f16($__a, $__b));
	    }' unless defined(&vmaxnmavq_f16);
	    eval 'sub vmaxnmaq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmaq_f16($__a, $__b));
	    }' unless defined(&vmaxnmaq_f16);
	    eval 'sub veorq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_veorq_f16($__a, $__b));
	    }' unless defined(&veorq_f16);
	    eval 'sub vcmulq_rot90_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_rot90_f16($__a, $__b));
	    }' unless defined(&vcmulq_rot90_f16);
	    eval 'sub vcmulq_rot270_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_rot270_f16($__a, $__b));
	    }' unless defined(&vcmulq_rot270_f16);
	    eval 'sub vcmulq_rot180_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_rot180_f16($__a, $__b));
	    }' unless defined(&vcmulq_rot180_f16);
	    eval 'sub vcmulq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_f16($__a, $__b));
	    }' unless defined(&vcmulq_f16);
	    eval 'sub vcaddq_rot90_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot90_f16($__a, $__b));
	    }' unless defined(&vcaddq_rot90_f16);
	    eval 'sub vcaddq_rot270_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot270_f16($__a, $__b));
	    }' unless defined(&vcaddq_rot270_f16);
	    eval 'sub vbicq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbicq_f16($__a, $__b));
	    }' unless defined(&vbicq_f16);
	    eval 'sub vandq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vandq_f16($__a, $__b));
	    }' unless defined(&vandq_f16);
	    eval 'sub vaddq_n_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_n_f16($__a, $__b));
	    }' unless defined(&vaddq_n_f16);
	    eval 'sub vabdq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vabdq_f16($__a, $__b));
	    }' unless defined(&vabdq_f16);
	    eval 'sub vshlltq_n_s8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshlltq_n_s8($__a, $__imm));
	    }' unless defined(&vshlltq_n_s8);
	    eval 'sub vshllbq_n_s8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshllbq_n_s8($__a, $__imm));
	    }' unless defined(&vshllbq_n_s8);
	    eval 'sub vorrq_n_s16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vorrq_n_s16($__a, $__imm));
	    }' unless defined(&vorrq_n_s16);
	    eval 'sub vbicq_n_s16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vbicq_n_s16($__a, $__imm));
	    }' unless defined(&vbicq_n_s16);
	    eval 'sub vqmovntq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovntq_u32($__a, $__b));
	    }' unless defined(&vqmovntq_u32);
	    eval 'sub vqmovnbq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovnbq_u32($__a, $__b));
	    }' unless defined(&vqmovnbq_u32);
	    eval 'sub vmulltq_poly_p16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulltq_poly_p16($__a, $__b));
	    }' unless defined(&vmulltq_poly_p16);
	    eval 'sub vmullbq_poly_p16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmullbq_poly_p16($__a, $__b));
	    }' unless defined(&vmullbq_poly_p16);
	    eval 'sub vmovntq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmovntq_u32($__a, $__b));
	    }' unless defined(&vmovntq_u32);
	    eval 'sub vmovnbq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmovnbq_u32($__a, $__b));
	    }' unless defined(&vmovnbq_u32);
	    eval 'sub vmlaldavq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlaldavq_u32($__a, $__b));
	    }' unless defined(&vmlaldavq_u32);
	    eval 'sub vqmovuntq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovuntq_s32($__a, $__b));
	    }' unless defined(&vqmovuntq_s32);
	    eval 'sub vqmovunbq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovunbq_s32($__a, $__b));
	    }' unless defined(&vqmovunbq_s32);
	    eval 'sub vshlltq_n_u16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshlltq_n_u16($__a, $__imm));
	    }' unless defined(&vshlltq_n_u16);
	    eval 'sub vshllbq_n_u16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshllbq_n_u16($__a, $__imm));
	    }' unless defined(&vshllbq_n_u16);
	    eval 'sub vorrq_n_u32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vorrq_n_u32($__a, $__imm));
	    }' unless defined(&vorrq_n_u32);
	    eval 'sub vbicq_n_u32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vbicq_n_u32($__a, $__imm));
	    }' unless defined(&vbicq_n_u32);
	    eval 'sub vcmpneq_n_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_n_f32($__a, $__b));
	    }' unless defined(&vcmpneq_n_f32);
	    eval 'sub vcmpneq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpneq_f32($__a, $__b));
	    }' unless defined(&vcmpneq_f32);
	    eval 'sub vcmpltq_n_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq_n_f32($__a, $__b));
	    }' unless defined(&vcmpltq_n_f32);
	    eval 'sub vcmpltq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpltq_f32($__a, $__b));
	    }' unless defined(&vcmpltq_f32);
	    eval 'sub vcmpleq_n_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq_n_f32($__a, $__b));
	    }' unless defined(&vcmpleq_n_f32);
	    eval 'sub vcmpleq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpleq_f32($__a, $__b));
	    }' unless defined(&vcmpleq_f32);
	    eval 'sub vcmpgtq_n_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq_n_f32($__a, $__b));
	    }' unless defined(&vcmpgtq_n_f32);
	    eval 'sub vcmpgtq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgtq_f32($__a, $__b));
	    }' unless defined(&vcmpgtq_f32);
	    eval 'sub vcmpgeq_n_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq_n_f32($__a, $__b));
	    }' unless defined(&vcmpgeq_n_f32);
	    eval 'sub vcmpgeq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpgeq_f32($__a, $__b));
	    }' unless defined(&vcmpgeq_f32);
	    eval 'sub vcmpeqq_n_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_n_f32($__a, $__b));
	    }' unless defined(&vcmpeqq_n_f32);
	    eval 'sub vcmpeqq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmpeqq_f32($__a, $__b));
	    }' unless defined(&vcmpeqq_f32);
	    eval 'sub vsubq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vsubq_f32($__a, $__b));
	    }' unless defined(&vsubq_f32);
	    eval 'sub vqmovntq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovntq_s32($__a, $__b));
	    }' unless defined(&vqmovntq_s32);
	    eval 'sub vqmovnbq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqmovnbq_s32($__a, $__b));
	    }' unless defined(&vqmovnbq_s32);
	    eval 'sub vqdmulltq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulltq_s32($__a, $__b));
	    }' unless defined(&vqdmulltq_s32);
	    eval 'sub vqdmulltq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmulltq_n_s32($__a, $__b));
	    }' unless defined(&vqdmulltq_n_s32);
	    eval 'sub vqdmullbq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmullbq_s32($__a, $__b));
	    }' unless defined(&vqdmullbq_s32);
	    eval 'sub vqdmullbq_n_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vqdmullbq_n_s32($__a, $__b));
	    }' unless defined(&vqdmullbq_n_s32);
	    eval 'sub vorrq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vorrq_f32($__a, $__b));
	    }' unless defined(&vorrq_f32);
	    eval 'sub vornq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vornq_f32($__a, $__b));
	    }' unless defined(&vornq_f32);
	    eval 'sub vmulq_n_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_n_f32($__a, $__b));
	    }' unless defined(&vmulq_n_f32);
	    eval 'sub vmulq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmulq_f32($__a, $__b));
	    }' unless defined(&vmulq_f32);
	    eval 'sub vmovntq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmovntq_s32($__a, $__b));
	    }' unless defined(&vmovntq_s32);
	    eval 'sub vmovnbq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmovnbq_s32($__a, $__b));
	    }' unless defined(&vmovnbq_s32);
	    eval 'sub vmlsldavxq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsldavxq_s32($__a, $__b));
	    }' unless defined(&vmlsldavxq_s32);
	    eval 'sub vmlsldavq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlsldavq_s32($__a, $__b));
	    }' unless defined(&vmlsldavq_s32);
	    eval 'sub vmlaldavxq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlaldavxq_s32($__a, $__b));
	    }' unless defined(&vmlaldavxq_s32);
	    eval 'sub vmlaldavq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmlaldavq_s32($__a, $__b));
	    }' unless defined(&vmlaldavq_s32);
	    eval 'sub vminnmvq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmvq_f32($__a, $__b));
	    }' unless defined(&vminnmvq_f32);
	    eval 'sub vminnmq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmq_f32($__a, $__b));
	    }' unless defined(&vminnmq_f32);
	    eval 'sub vminnmavq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmavq_f32($__a, $__b));
	    }' unless defined(&vminnmavq_f32);
	    eval 'sub vminnmaq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vminnmaq_f32($__a, $__b));
	    }' unless defined(&vminnmaq_f32);
	    eval 'sub vmaxnmvq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmvq_f32($__a, $__b));
	    }' unless defined(&vmaxnmvq_f32);
	    eval 'sub vmaxnmq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmq_f32($__a, $__b));
	    }' unless defined(&vmaxnmq_f32);
	    eval 'sub vmaxnmavq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmavq_f32($__a, $__b));
	    }' unless defined(&vmaxnmavq_f32);
	    eval 'sub vmaxnmaq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vmaxnmaq_f32($__a, $__b));
	    }' unless defined(&vmaxnmaq_f32);
	    eval 'sub veorq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_veorq_f32($__a, $__b));
	    }' unless defined(&veorq_f32);
	    eval 'sub vcmulq_rot90_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_rot90_f32($__a, $__b));
	    }' unless defined(&vcmulq_rot90_f32);
	    eval 'sub vcmulq_rot270_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_rot270_f32($__a, $__b));
	    }' unless defined(&vcmulq_rot270_f32);
	    eval 'sub vcmulq_rot180_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_rot180_f32($__a, $__b));
	    }' unless defined(&vcmulq_rot180_f32);
	    eval 'sub vcmulq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcmulq_f32($__a, $__b));
	    }' unless defined(&vcmulq_f32);
	    eval 'sub vcaddq_rot90_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot90_f32($__a, $__b));
	    }' unless defined(&vcaddq_rot90_f32);
	    eval 'sub vcaddq_rot270_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcaddq_rot270_f32($__a, $__b));
	    }' unless defined(&vcaddq_rot270_f32);
	    eval 'sub vbicq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vbicq_f32($__a, $__b));
	    }' unless defined(&vbicq_f32);
	    eval 'sub vandq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vandq_f32($__a, $__b));
	    }' unless defined(&vandq_f32);
	    eval 'sub vaddq_n_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_n_f32($__a, $__b));
	    }' unless defined(&vaddq_n_f32);
	    eval 'sub vabdq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vabdq_f32($__a, $__b));
	    }' unless defined(&vabdq_f32);
	    eval 'sub vshlltq_n_s16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshlltq_n_s16($__a, $__imm));
	    }' unless defined(&vshlltq_n_s16);
	    eval 'sub vshllbq_n_s16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vshllbq_n_s16($__a, $__imm));
	    }' unless defined(&vshllbq_n_s16);
	    eval 'sub vorrq_n_s32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vorrq_n_s32($__a, $__imm));
	    }' unless defined(&vorrq_n_s32);
	    eval 'sub vbicq_n_s32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vbicq_n_s32($__a, $__imm));
	    }' unless defined(&vbicq_n_s32);
	    eval 'sub vrmlaldavhq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmlaldavhq_u32($__a, $__b));
	    }' unless defined(&vrmlaldavhq_u32);
	    eval 'sub vctp8q_m {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vctp8q_m($__a, $__p));
	    }' unless defined(&vctp8q_m);
	    eval 'sub vctp64q_m {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vctp64q_m($__a, $__p));
	    }' unless defined(&vctp64q_m);
	    eval 'sub vctp32q_m {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vctp32q_m($__a, $__p));
	    }' unless defined(&vctp32q_m);
	    eval 'sub vctp16q_m {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vctp16q_m($__a, $__p));
	    }' unless defined(&vctp16q_m);
	    eval 'sub vaddlvaq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddlvaq_u32($__a, $__b));
	    }' unless defined(&vaddlvaq_u32);
	    eval 'sub vrmlsldavhxq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmlsldavhxq_s32($__a, $__b));
	    }' unless defined(&vrmlsldavhxq_s32);
	    eval 'sub vrmlsldavhq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmlsldavhq_s32($__a, $__b));
	    }' unless defined(&vrmlsldavhq_s32);
	    eval 'sub vrmlaldavhxq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmlaldavhxq_s32($__a, $__b));
	    }' unless defined(&vrmlaldavhxq_s32);
	    eval 'sub vrmlaldavhq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vrmlaldavhq_s32($__a, $__b));
	    }' unless defined(&vrmlaldavhq_s32);
	    eval 'sub vcvttq_f16_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcvttq_f16_f32($__a, $__b));
	    }' unless defined(&vcvttq_f16_f32);
	    eval 'sub vcvtbq_f16_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vcvtbq_f16_f32($__a, $__b));
	    }' unless defined(&vcvtbq_f16_f32);
	    eval 'sub vaddlvaq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddlvaq_s32($__a, $__b));
	    }' unless defined(&vaddlvaq_s32);
	    eval 'sub vabavq_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vabavq_s8($__a, $__b, $__c));
	    }' unless defined(&vabavq_s8);
	    eval 'sub vabavq_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vabavq_s16($__a, $__b, $__c));
	    }' unless defined(&vabavq_s16);
	    eval 'sub vabavq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vabavq_s32($__a, $__b, $__c));
	    }' unless defined(&vabavq_s32);
	    eval 'sub vbicq_m_n_s16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vbicq_m_n_s16($__a, $__imm, $__p));
	    }' unless defined(&vbicq_m_n_s16);
	    eval 'sub vbicq_m_n_s32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vbicq_m_n_s32($__a, $__imm, $__p));
	    }' unless defined(&vbicq_m_n_s32);
	    eval 'sub vbicq_m_n_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vbicq_m_n_u16($__a, $__imm, $__p));
	    }' unless defined(&vbicq_m_n_u16);
	    eval 'sub vbicq_m_n_u32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vbicq_m_n_u32($__a, $__imm, $__p));
	    }' unless defined(&vbicq_m_n_u32);
	    eval 'sub vcmpeqq_m_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_f16);
	    eval 'sub vcmpeqq_m_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_f32);
	    eval 'sub vcvtaq_m_s16_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtaq_m_s16_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtaq_m_s16_f16);
	    eval 'sub vcvtaq_m_u16_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtaq_m_u16_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtaq_m_u16_f16);
	    eval 'sub vcvtaq_m_s32_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtaq_m_s32_f32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtaq_m_s32_f32);
	    eval 'sub vcvtaq_m_u32_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtaq_m_u32_f32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtaq_m_u32_f32);
	    eval 'sub vcvtq_m_f16_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtq_m_f16_s16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtq_m_f16_s16);
	    eval 'sub vcvtq_m_f16_u16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtq_m_f16_u16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtq_m_f16_u16);
	    eval 'sub vcvtq_m_f32_s32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtq_m_f32_s32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtq_m_f32_s32);
	    eval 'sub vcvtq_m_f32_u32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtq_m_f32_u32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtq_m_f32_u32);
	    eval 'sub vqrshrnbq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshrnbq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vqrshrnbq_n_s16);
	    eval 'sub vqrshrnbq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshrnbq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vqrshrnbq_n_u16);
	    eval 'sub vqrshrnbq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshrnbq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vqrshrnbq_n_s32);
	    eval 'sub vqrshrnbq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshrnbq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vqrshrnbq_n_u32);
	    eval 'sub vqrshrunbq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshrunbq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vqrshrunbq_n_s16);
	    eval 'sub vqrshrunbq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshrunbq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vqrshrunbq_n_s32);
	    eval 'sub vrmlaldavhaq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vrmlaldavhaq_s32($__a, $__b, $__c));
	    }' unless defined(&vrmlaldavhaq_s32);
	    eval 'sub vrmlaldavhaq_u32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vrmlaldavhaq_u32($__a, $__b, $__c));
	    }' unless defined(&vrmlaldavhaq_u32);
	    eval 'sub vshlcq_s8 {
	        my($__a,  $__b,  $__imm) = @_;
    		eval q( &__arm_vshlcq_s8($__a, $__b, $__imm));
	    }' unless defined(&vshlcq_s8);
	    eval 'sub vshlcq_u8 {
	        my($__a,  $__b,  $__imm) = @_;
    		eval q( &__arm_vshlcq_u8($__a, $__b, $__imm));
	    }' unless defined(&vshlcq_u8);
	    eval 'sub vshlcq_s16 {
	        my($__a,  $__b,  $__imm) = @_;
    		eval q( &__arm_vshlcq_s16($__a, $__b, $__imm));
	    }' unless defined(&vshlcq_s16);
	    eval 'sub vshlcq_u16 {
	        my($__a,  $__b,  $__imm) = @_;
    		eval q( &__arm_vshlcq_u16($__a, $__b, $__imm));
	    }' unless defined(&vshlcq_u16);
	    eval 'sub vshlcq_s32 {
	        my($__a,  $__b,  $__imm) = @_;
    		eval q( &__arm_vshlcq_s32($__a, $__b, $__imm));
	    }' unless defined(&vshlcq_s32);
	    eval 'sub vshlcq_u32 {
	        my($__a,  $__b,  $__imm) = @_;
    		eval q( &__arm_vshlcq_u32($__a, $__b, $__imm));
	    }' unless defined(&vshlcq_u32);
	    eval 'sub vabavq_u8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vabavq_u8($__a, $__b, $__c));
	    }' unless defined(&vabavq_u8);
	    eval 'sub vabavq_u16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vabavq_u16($__a, $__b, $__c));
	    }' unless defined(&vabavq_u16);
	    eval 'sub vabavq_u32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vabavq_u32($__a, $__b, $__c));
	    }' unless defined(&vabavq_u32);
	    eval 'sub vpselq_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq_u8($__a, $__b, $__p));
	    }' unless defined(&vpselq_u8);
	    eval 'sub vpselq_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq_s8($__a, $__b, $__p));
	    }' unless defined(&vpselq_s8);
	    eval 'sub vrev64q_m_u8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev64q_m_u8($__inactive, $__a, $__p));
	    }' unless defined(&vrev64q_m_u8);
	    eval 'sub vmvnq_m_u8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmvnq_m_u8($__inactive, $__a, $__p));
	    }' unless defined(&vmvnq_m_u8);
	    eval 'sub vmlasq_n_u8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlasq_n_u8($__a, $__b, $__c));
	    }' unless defined(&vmlasq_n_u8);
	    eval 'sub vmlaq_n_u8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaq_n_u8($__a, $__b, $__c));
	    }' unless defined(&vmlaq_n_u8);
	    eval 'sub vmladavq_p_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavq_p_u8($__a, $__b, $__p));
	    }' unless defined(&vmladavq_p_u8);
	    eval 'sub vmladavaq_u8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaq_u8($__a, $__b, $__c));
	    }' unless defined(&vmladavaq_u8);
	    eval 'sub vminvq_p_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminvq_p_u8($__a, $__b, $__p));
	    }' unless defined(&vminvq_p_u8);
	    eval 'sub vmaxvq_p_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxvq_p_u8($__a, $__b, $__p));
	    }' unless defined(&vmaxvq_p_u8);
	    eval 'sub vdupq_m_n_u8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vdupq_m_n_u8($__inactive, $__a, $__p));
	    }' unless defined(&vdupq_m_n_u8);
	    eval 'sub vcmpneq_m_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_u8($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_u8);
	    eval 'sub vcmpneq_m_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_n_u8($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_n_u8);
	    eval 'sub vcmphiq_m_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmphiq_m_u8($__a, $__b, $__p));
	    }' unless defined(&vcmphiq_m_u8);
	    eval 'sub vcmphiq_m_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmphiq_m_n_u8($__a, $__b, $__p));
	    }' unless defined(&vcmphiq_m_n_u8);
	    eval 'sub vcmpeqq_m_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_u8($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_u8);
	    eval 'sub vcmpeqq_m_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_n_u8($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_n_u8);
	    eval 'sub vcmpcsq_m_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpcsq_m_u8($__a, $__b, $__p));
	    }' unless defined(&vcmpcsq_m_u8);
	    eval 'sub vcmpcsq_m_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpcsq_m_n_u8($__a, $__b, $__p));
	    }' unless defined(&vcmpcsq_m_n_u8);
	    eval 'sub vclzq_m_u8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclzq_m_u8($__inactive, $__a, $__p));
	    }' unless defined(&vclzq_m_u8);
	    eval 'sub vaddvaq_p_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddvaq_p_u8($__a, $__b, $__p));
	    }' unless defined(&vaddvaq_p_u8);
	    eval 'sub vsriq_n_u8 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsriq_n_u8($__a, $__b, $__imm));
	    }' unless defined(&vsriq_n_u8);
	    eval 'sub vsliq_n_u8 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsliq_n_u8($__a, $__b, $__imm));
	    }' unless defined(&vsliq_n_u8);
	    eval 'sub vshlq_m_r_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_r_u8($__a, $__b, $__p));
	    }' unless defined(&vshlq_m_r_u8);
	    eval 'sub vrshlq_m_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_n_u8($__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_n_u8);
	    eval 'sub vqshlq_m_r_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_r_u8($__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_r_u8);
	    eval 'sub vqrshlq_m_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_n_u8($__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_n_u8);
	    eval 'sub vminavq_p_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminavq_p_s8($__a, $__b, $__p));
	    }' unless defined(&vminavq_p_s8);
	    eval 'sub vminaq_m_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminaq_m_s8($__a, $__b, $__p));
	    }' unless defined(&vminaq_m_s8);
	    eval 'sub vmaxavq_p_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxavq_p_s8($__a, $__b, $__p));
	    }' unless defined(&vmaxavq_p_s8);
	    eval 'sub vmaxaq_m_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxaq_m_s8($__a, $__b, $__p));
	    }' unless defined(&vmaxaq_m_s8);
	    eval 'sub vcmpneq_m_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_s8);
	    eval 'sub vcmpneq_m_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_n_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_n_s8);
	    eval 'sub vcmpltq_m_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m_s8);
	    eval 'sub vcmpltq_m_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m_n_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m_n_s8);
	    eval 'sub vcmpleq_m_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m_s8);
	    eval 'sub vcmpleq_m_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m_n_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m_n_s8);
	    eval 'sub vcmpgtq_m_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m_s8);
	    eval 'sub vcmpgtq_m_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m_n_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m_n_s8);
	    eval 'sub vcmpgeq_m_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m_s8);
	    eval 'sub vcmpgeq_m_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m_n_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m_n_s8);
	    eval 'sub vcmpeqq_m_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_s8);
	    eval 'sub vcmpeqq_m_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_n_s8($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_n_s8);
	    eval 'sub vshlq_m_r_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_r_s8($__a, $__b, $__p));
	    }' unless defined(&vshlq_m_r_s8);
	    eval 'sub vrshlq_m_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_n_s8($__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_n_s8);
	    eval 'sub vrev64q_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev64q_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vrev64q_m_s8);
	    eval 'sub vqshlq_m_r_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_r_s8($__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_r_s8);
	    eval 'sub vqrshlq_m_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_n_s8($__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_n_s8);
	    eval 'sub vqnegq_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vqnegq_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vqnegq_m_s8);
	    eval 'sub vqabsq_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vqabsq_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vqabsq_m_s8);
	    eval 'sub vnegq_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vnegq_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vnegq_m_s8);
	    eval 'sub vmvnq_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmvnq_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vmvnq_m_s8);
	    eval 'sub vmlsdavxq_p_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsdavxq_p_s8($__a, $__b, $__p));
	    }' unless defined(&vmlsdavxq_p_s8);
	    eval 'sub vmlsdavq_p_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsdavq_p_s8($__a, $__b, $__p));
	    }' unless defined(&vmlsdavq_p_s8);
	    eval 'sub vmladavxq_p_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavxq_p_s8($__a, $__b, $__p));
	    }' unless defined(&vmladavxq_p_s8);
	    eval 'sub vmladavq_p_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavq_p_s8($__a, $__b, $__p));
	    }' unless defined(&vmladavq_p_s8);
	    eval 'sub vminvq_p_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminvq_p_s8($__a, $__b, $__p));
	    }' unless defined(&vminvq_p_s8);
	    eval 'sub vmaxvq_p_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxvq_p_s8($__a, $__b, $__p));
	    }' unless defined(&vmaxvq_p_s8);
	    eval 'sub vdupq_m_n_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vdupq_m_n_s8($__inactive, $__a, $__p));
	    }' unless defined(&vdupq_m_n_s8);
	    eval 'sub vclzq_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclzq_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vclzq_m_s8);
	    eval 'sub vclsq_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclsq_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vclsq_m_s8);
	    eval 'sub vaddvaq_p_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddvaq_p_s8($__a, $__b, $__p));
	    }' unless defined(&vaddvaq_p_s8);
	    eval 'sub vabsq_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vabsq_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vabsq_m_s8);
	    eval 'sub vqrdmlsdhxq_s8 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmlsdhxq_s8($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmlsdhxq_s8);
	    eval 'sub vqrdmlsdhq_s8 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmlsdhq_s8($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmlsdhq_s8);
	    eval 'sub vqrdmlashq_n_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqrdmlashq_n_s8($__a, $__b, $__c));
	    }' unless defined(&vqrdmlashq_n_s8);
	    eval 'sub vqrdmlahq_n_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqrdmlahq_n_s8($__a, $__b, $__c));
	    }' unless defined(&vqrdmlahq_n_s8);
	    eval 'sub vqrdmladhxq_s8 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmladhxq_s8($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmladhxq_s8);
	    eval 'sub vqrdmladhq_s8 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmladhq_s8($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmladhq_s8);
	    eval 'sub vqdmlsdhxq_s8 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmlsdhxq_s8($__inactive, $__a, $__b));
	    }' unless defined(&vqdmlsdhxq_s8);
	    eval 'sub vqdmlsdhq_s8 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmlsdhq_s8($__inactive, $__a, $__b));
	    }' unless defined(&vqdmlsdhq_s8);
	    eval 'sub vqdmlahq_n_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqdmlahq_n_s8($__a, $__b, $__c));
	    }' unless defined(&vqdmlahq_n_s8);
	    eval 'sub vqdmlashq_n_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqdmlashq_n_s8($__a, $__b, $__c));
	    }' unless defined(&vqdmlashq_n_s8);
	    eval 'sub vqdmladhxq_s8 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmladhxq_s8($__inactive, $__a, $__b));
	    }' unless defined(&vqdmladhxq_s8);
	    eval 'sub vqdmladhq_s8 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmladhq_s8($__inactive, $__a, $__b));
	    }' unless defined(&vqdmladhq_s8);
	    eval 'sub vmlsdavaxq_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsdavaxq_s8($__a, $__b, $__c));
	    }' unless defined(&vmlsdavaxq_s8);
	    eval 'sub vmlsdavaq_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsdavaq_s8($__a, $__b, $__c));
	    }' unless defined(&vmlsdavaq_s8);
	    eval 'sub vmlasq_n_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlasq_n_s8($__a, $__b, $__c));
	    }' unless defined(&vmlasq_n_s8);
	    eval 'sub vmlaq_n_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaq_n_s8($__a, $__b, $__c));
	    }' unless defined(&vmlaq_n_s8);
	    eval 'sub vmladavaxq_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaxq_s8($__a, $__b, $__c));
	    }' unless defined(&vmladavaxq_s8);
	    eval 'sub vmladavaq_s8 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaq_s8($__a, $__b, $__c));
	    }' unless defined(&vmladavaq_s8);
	    eval 'sub vsriq_n_s8 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsriq_n_s8($__a, $__b, $__imm));
	    }' unless defined(&vsriq_n_s8);
	    eval 'sub vsliq_n_s8 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsliq_n_s8($__a, $__b, $__imm));
	    }' unless defined(&vsliq_n_s8);
	    eval 'sub vpselq_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq_u16($__a, $__b, $__p));
	    }' unless defined(&vpselq_u16);
	    eval 'sub vpselq_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq_s16($__a, $__b, $__p));
	    }' unless defined(&vpselq_s16);
	    eval 'sub vrev64q_m_u16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev64q_m_u16($__inactive, $__a, $__p));
	    }' unless defined(&vrev64q_m_u16);
	    eval 'sub vmvnq_m_u16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmvnq_m_u16($__inactive, $__a, $__p));
	    }' unless defined(&vmvnq_m_u16);
	    eval 'sub vmlasq_n_u16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlasq_n_u16($__a, $__b, $__c));
	    }' unless defined(&vmlasq_n_u16);
	    eval 'sub vmlaq_n_u16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaq_n_u16($__a, $__b, $__c));
	    }' unless defined(&vmlaq_n_u16);
	    eval 'sub vmladavq_p_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavq_p_u16($__a, $__b, $__p));
	    }' unless defined(&vmladavq_p_u16);
	    eval 'sub vmladavaq_u16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaq_u16($__a, $__b, $__c));
	    }' unless defined(&vmladavaq_u16);
	    eval 'sub vminvq_p_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminvq_p_u16($__a, $__b, $__p));
	    }' unless defined(&vminvq_p_u16);
	    eval 'sub vmaxvq_p_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxvq_p_u16($__a, $__b, $__p));
	    }' unless defined(&vmaxvq_p_u16);
	    eval 'sub vdupq_m_n_u16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vdupq_m_n_u16($__inactive, $__a, $__p));
	    }' unless defined(&vdupq_m_n_u16);
	    eval 'sub vcmpneq_m_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_u16($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_u16);
	    eval 'sub vcmpneq_m_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_n_u16($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_n_u16);
	    eval 'sub vcmphiq_m_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmphiq_m_u16($__a, $__b, $__p));
	    }' unless defined(&vcmphiq_m_u16);
	    eval 'sub vcmphiq_m_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmphiq_m_n_u16($__a, $__b, $__p));
	    }' unless defined(&vcmphiq_m_n_u16);
	    eval 'sub vcmpeqq_m_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_u16($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_u16);
	    eval 'sub vcmpeqq_m_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_n_u16($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_n_u16);
	    eval 'sub vcmpcsq_m_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpcsq_m_u16($__a, $__b, $__p));
	    }' unless defined(&vcmpcsq_m_u16);
	    eval 'sub vcmpcsq_m_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpcsq_m_n_u16($__a, $__b, $__p));
	    }' unless defined(&vcmpcsq_m_n_u16);
	    eval 'sub vclzq_m_u16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclzq_m_u16($__inactive, $__a, $__p));
	    }' unless defined(&vclzq_m_u16);
	    eval 'sub vaddvaq_p_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddvaq_p_u16($__a, $__b, $__p));
	    }' unless defined(&vaddvaq_p_u16);
	    eval 'sub vsriq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsriq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vsriq_n_u16);
	    eval 'sub vsliq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsliq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vsliq_n_u16);
	    eval 'sub vshlq_m_r_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_r_u16($__a, $__b, $__p));
	    }' unless defined(&vshlq_m_r_u16);
	    eval 'sub vrshlq_m_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_n_u16($__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_n_u16);
	    eval 'sub vqshlq_m_r_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_r_u16($__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_r_u16);
	    eval 'sub vqrshlq_m_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_n_u16($__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_n_u16);
	    eval 'sub vminavq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminavq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vminavq_p_s16);
	    eval 'sub vminaq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminaq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vminaq_m_s16);
	    eval 'sub vmaxavq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxavq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vmaxavq_p_s16);
	    eval 'sub vmaxaq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxaq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vmaxaq_m_s16);
	    eval 'sub vcmpneq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_s16);
	    eval 'sub vcmpneq_m_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_n_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_n_s16);
	    eval 'sub vcmpltq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m_s16);
	    eval 'sub vcmpltq_m_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m_n_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m_n_s16);
	    eval 'sub vcmpleq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m_s16);
	    eval 'sub vcmpleq_m_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m_n_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m_n_s16);
	    eval 'sub vcmpgtq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m_s16);
	    eval 'sub vcmpgtq_m_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m_n_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m_n_s16);
	    eval 'sub vcmpgeq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m_s16);
	    eval 'sub vcmpgeq_m_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m_n_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m_n_s16);
	    eval 'sub vcmpeqq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_s16);
	    eval 'sub vcmpeqq_m_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_n_s16($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_n_s16);
	    eval 'sub vshlq_m_r_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_r_s16($__a, $__b, $__p));
	    }' unless defined(&vshlq_m_r_s16);
	    eval 'sub vrshlq_m_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_n_s16($__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_n_s16);
	    eval 'sub vrev64q_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev64q_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vrev64q_m_s16);
	    eval 'sub vqshlq_m_r_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_r_s16($__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_r_s16);
	    eval 'sub vqrshlq_m_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_n_s16($__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_n_s16);
	    eval 'sub vqnegq_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vqnegq_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vqnegq_m_s16);
	    eval 'sub vqabsq_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vqabsq_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vqabsq_m_s16);
	    eval 'sub vnegq_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vnegq_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vnegq_m_s16);
	    eval 'sub vmvnq_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmvnq_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vmvnq_m_s16);
	    eval 'sub vmlsdavxq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsdavxq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vmlsdavxq_p_s16);
	    eval 'sub vmlsdavq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsdavq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vmlsdavq_p_s16);
	    eval 'sub vmladavxq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavxq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vmladavxq_p_s16);
	    eval 'sub vmladavq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vmladavq_p_s16);
	    eval 'sub vminvq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminvq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vminvq_p_s16);
	    eval 'sub vmaxvq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxvq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vmaxvq_p_s16);
	    eval 'sub vdupq_m_n_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vdupq_m_n_s16($__inactive, $__a, $__p));
	    }' unless defined(&vdupq_m_n_s16);
	    eval 'sub vclzq_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclzq_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vclzq_m_s16);
	    eval 'sub vclsq_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclsq_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vclsq_m_s16);
	    eval 'sub vaddvaq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddvaq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vaddvaq_p_s16);
	    eval 'sub vabsq_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vabsq_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vabsq_m_s16);
	    eval 'sub vqrdmlsdhxq_s16 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmlsdhxq_s16($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmlsdhxq_s16);
	    eval 'sub vqrdmlsdhq_s16 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmlsdhq_s16($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmlsdhq_s16);
	    eval 'sub vqrdmlashq_n_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqrdmlashq_n_s16($__a, $__b, $__c));
	    }' unless defined(&vqrdmlashq_n_s16);
	    eval 'sub vqrdmlahq_n_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqrdmlahq_n_s16($__a, $__b, $__c));
	    }' unless defined(&vqrdmlahq_n_s16);
	    eval 'sub vqrdmladhxq_s16 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmladhxq_s16($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmladhxq_s16);
	    eval 'sub vqrdmladhq_s16 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmladhq_s16($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmladhq_s16);
	    eval 'sub vqdmlsdhxq_s16 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmlsdhxq_s16($__inactive, $__a, $__b));
	    }' unless defined(&vqdmlsdhxq_s16);
	    eval 'sub vqdmlsdhq_s16 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmlsdhq_s16($__inactive, $__a, $__b));
	    }' unless defined(&vqdmlsdhq_s16);
	    eval 'sub vqdmlashq_n_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqdmlashq_n_s16($__a, $__b, $__c));
	    }' unless defined(&vqdmlashq_n_s16);
	    eval 'sub vqdmlahq_n_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqdmlahq_n_s16($__a, $__b, $__c));
	    }' unless defined(&vqdmlahq_n_s16);
	    eval 'sub vqdmladhxq_s16 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmladhxq_s16($__inactive, $__a, $__b));
	    }' unless defined(&vqdmladhxq_s16);
	    eval 'sub vqdmladhq_s16 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmladhq_s16($__inactive, $__a, $__b));
	    }' unless defined(&vqdmladhq_s16);
	    eval 'sub vmlsdavaxq_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsdavaxq_s16($__a, $__b, $__c));
	    }' unless defined(&vmlsdavaxq_s16);
	    eval 'sub vmlsdavaq_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsdavaq_s16($__a, $__b, $__c));
	    }' unless defined(&vmlsdavaq_s16);
	    eval 'sub vmlasq_n_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlasq_n_s16($__a, $__b, $__c));
	    }' unless defined(&vmlasq_n_s16);
	    eval 'sub vmlaq_n_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaq_n_s16($__a, $__b, $__c));
	    }' unless defined(&vmlaq_n_s16);
	    eval 'sub vmladavaxq_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaxq_s16($__a, $__b, $__c));
	    }' unless defined(&vmladavaxq_s16);
	    eval 'sub vmladavaq_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaq_s16($__a, $__b, $__c));
	    }' unless defined(&vmladavaq_s16);
	    eval 'sub vsriq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsriq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vsriq_n_s16);
	    eval 'sub vsliq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsliq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vsliq_n_s16);
	    eval 'sub vpselq_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq_u32($__a, $__b, $__p));
	    }' unless defined(&vpselq_u32);
	    eval 'sub vpselq_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq_s32($__a, $__b, $__p));
	    }' unless defined(&vpselq_s32);
	    eval 'sub vrev64q_m_u32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev64q_m_u32($__inactive, $__a, $__p));
	    }' unless defined(&vrev64q_m_u32);
	    eval 'sub vmvnq_m_u32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmvnq_m_u32($__inactive, $__a, $__p));
	    }' unless defined(&vmvnq_m_u32);
	    eval 'sub vmlasq_n_u32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlasq_n_u32($__a, $__b, $__c));
	    }' unless defined(&vmlasq_n_u32);
	    eval 'sub vmlaq_n_u32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaq_n_u32($__a, $__b, $__c));
	    }' unless defined(&vmlaq_n_u32);
	    eval 'sub vmladavq_p_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavq_p_u32($__a, $__b, $__p));
	    }' unless defined(&vmladavq_p_u32);
	    eval 'sub vmladavaq_u32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaq_u32($__a, $__b, $__c));
	    }' unless defined(&vmladavaq_u32);
	    eval 'sub vminvq_p_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminvq_p_u32($__a, $__b, $__p));
	    }' unless defined(&vminvq_p_u32);
	    eval 'sub vmaxvq_p_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxvq_p_u32($__a, $__b, $__p));
	    }' unless defined(&vmaxvq_p_u32);
	    eval 'sub vdupq_m_n_u32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vdupq_m_n_u32($__inactive, $__a, $__p));
	    }' unless defined(&vdupq_m_n_u32);
	    eval 'sub vcmpneq_m_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_u32($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_u32);
	    eval 'sub vcmpneq_m_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_n_u32($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_n_u32);
	    eval 'sub vcmphiq_m_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmphiq_m_u32($__a, $__b, $__p));
	    }' unless defined(&vcmphiq_m_u32);
	    eval 'sub vcmphiq_m_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmphiq_m_n_u32($__a, $__b, $__p));
	    }' unless defined(&vcmphiq_m_n_u32);
	    eval 'sub vcmpeqq_m_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_u32($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_u32);
	    eval 'sub vcmpeqq_m_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_n_u32($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_n_u32);
	    eval 'sub vcmpcsq_m_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpcsq_m_u32($__a, $__b, $__p));
	    }' unless defined(&vcmpcsq_m_u32);
	    eval 'sub vcmpcsq_m_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpcsq_m_n_u32($__a, $__b, $__p));
	    }' unless defined(&vcmpcsq_m_n_u32);
	    eval 'sub vclzq_m_u32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclzq_m_u32($__inactive, $__a, $__p));
	    }' unless defined(&vclzq_m_u32);
	    eval 'sub vaddvaq_p_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddvaq_p_u32($__a, $__b, $__p));
	    }' unless defined(&vaddvaq_p_u32);
	    eval 'sub vsriq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsriq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vsriq_n_u32);
	    eval 'sub vsliq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsliq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vsliq_n_u32);
	    eval 'sub vshlq_m_r_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_r_u32($__a, $__b, $__p));
	    }' unless defined(&vshlq_m_r_u32);
	    eval 'sub vrshlq_m_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_n_u32($__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_n_u32);
	    eval 'sub vqshlq_m_r_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_r_u32($__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_r_u32);
	    eval 'sub vqrshlq_m_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_n_u32($__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_n_u32);
	    eval 'sub vminavq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminavq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vminavq_p_s32);
	    eval 'sub vminaq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminaq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vminaq_m_s32);
	    eval 'sub vmaxavq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxavq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vmaxavq_p_s32);
	    eval 'sub vmaxaq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxaq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vmaxaq_m_s32);
	    eval 'sub vcmpneq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_s32);
	    eval 'sub vcmpneq_m_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_n_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_n_s32);
	    eval 'sub vcmpltq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m_s32);
	    eval 'sub vcmpltq_m_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m_n_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m_n_s32);
	    eval 'sub vcmpleq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m_s32);
	    eval 'sub vcmpleq_m_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m_n_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m_n_s32);
	    eval 'sub vcmpgtq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m_s32);
	    eval 'sub vcmpgtq_m_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m_n_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m_n_s32);
	    eval 'sub vcmpgeq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m_s32);
	    eval 'sub vcmpgeq_m_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m_n_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m_n_s32);
	    eval 'sub vcmpeqq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_s32);
	    eval 'sub vcmpeqq_m_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_n_s32($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_n_s32);
	    eval 'sub vshlq_m_r_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_r_s32($__a, $__b, $__p));
	    }' unless defined(&vshlq_m_r_s32);
	    eval 'sub vrshlq_m_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_n_s32($__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_n_s32);
	    eval 'sub vrev64q_m_s32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev64q_m_s32($__inactive, $__a, $__p));
	    }' unless defined(&vrev64q_m_s32);
	    eval 'sub vqshlq_m_r_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_r_s32($__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_r_s32);
	    eval 'sub vqrshlq_m_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_n_s32($__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_n_s32);
	    eval 'sub vqnegq_m_s32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vqnegq_m_s32($__inactive, $__a, $__p));
	    }' unless defined(&vqnegq_m_s32);
	    eval 'sub vqabsq_m_s32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vqabsq_m_s32($__inactive, $__a, $__p));
	    }' unless defined(&vqabsq_m_s32);
	    eval 'sub vnegq_m_s32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vnegq_m_s32($__inactive, $__a, $__p));
	    }' unless defined(&vnegq_m_s32);
	    eval 'sub vmvnq_m_s32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmvnq_m_s32($__inactive, $__a, $__p));
	    }' unless defined(&vmvnq_m_s32);
	    eval 'sub vmlsdavxq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsdavxq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vmlsdavxq_p_s32);
	    eval 'sub vmlsdavq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsdavq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vmlsdavq_p_s32);
	    eval 'sub vmladavxq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavxq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vmladavxq_p_s32);
	    eval 'sub vmladavq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmladavq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vmladavq_p_s32);
	    eval 'sub vminvq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminvq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vminvq_p_s32);
	    eval 'sub vmaxvq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxvq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vmaxvq_p_s32);
	    eval 'sub vdupq_m_n_s32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vdupq_m_n_s32($__inactive, $__a, $__p));
	    }' unless defined(&vdupq_m_n_s32);
	    eval 'sub vclzq_m_s32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclzq_m_s32($__inactive, $__a, $__p));
	    }' unless defined(&vclzq_m_s32);
	    eval 'sub vclsq_m_s32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vclsq_m_s32($__inactive, $__a, $__p));
	    }' unless defined(&vclsq_m_s32);
	    eval 'sub vaddvaq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddvaq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vaddvaq_p_s32);
	    eval 'sub vabsq_m_s32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vabsq_m_s32($__inactive, $__a, $__p));
	    }' unless defined(&vabsq_m_s32);
	    eval 'sub vqrdmlsdhxq_s32 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmlsdhxq_s32($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmlsdhxq_s32);
	    eval 'sub vqrdmlsdhq_s32 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmlsdhq_s32($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmlsdhq_s32);
	    eval 'sub vqrdmlashq_n_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqrdmlashq_n_s32($__a, $__b, $__c));
	    }' unless defined(&vqrdmlashq_n_s32);
	    eval 'sub vqrdmlahq_n_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqrdmlahq_n_s32($__a, $__b, $__c));
	    }' unless defined(&vqrdmlahq_n_s32);
	    eval 'sub vqrdmladhxq_s32 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmladhxq_s32($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmladhxq_s32);
	    eval 'sub vqrdmladhq_s32 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqrdmladhq_s32($__inactive, $__a, $__b));
	    }' unless defined(&vqrdmladhq_s32);
	    eval 'sub vqdmlsdhxq_s32 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmlsdhxq_s32($__inactive, $__a, $__b));
	    }' unless defined(&vqdmlsdhxq_s32);
	    eval 'sub vqdmlsdhq_s32 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmlsdhq_s32($__inactive, $__a, $__b));
	    }' unless defined(&vqdmlsdhq_s32);
	    eval 'sub vqdmlashq_n_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqdmlashq_n_s32($__a, $__b, $__c));
	    }' unless defined(&vqdmlashq_n_s32);
	    eval 'sub vqdmlahq_n_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vqdmlahq_n_s32($__a, $__b, $__c));
	    }' unless defined(&vqdmlahq_n_s32);
	    eval 'sub vqdmladhxq_s32 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmladhxq_s32($__inactive, $__a, $__b));
	    }' unless defined(&vqdmladhxq_s32);
	    eval 'sub vqdmladhq_s32 {
	        my($__inactive, $__a, $__b) = @_;
    		eval q( &__arm_vqdmladhq_s32($__inactive, $__a, $__b));
	    }' unless defined(&vqdmladhq_s32);
	    eval 'sub vmlsdavaxq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsdavaxq_s32($__a, $__b, $__c));
	    }' unless defined(&vmlsdavaxq_s32);
	    eval 'sub vmlsdavaq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsdavaq_s32($__a, $__b, $__c));
	    }' unless defined(&vmlsdavaq_s32);
	    eval 'sub vmlasq_n_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlasq_n_s32($__a, $__b, $__c));
	    }' unless defined(&vmlasq_n_s32);
	    eval 'sub vmlaq_n_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaq_n_s32($__a, $__b, $__c));
	    }' unless defined(&vmlaq_n_s32);
	    eval 'sub vmladavaxq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaxq_s32($__a, $__b, $__c));
	    }' unless defined(&vmladavaxq_s32);
	    eval 'sub vmladavaq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmladavaq_s32($__a, $__b, $__c));
	    }' unless defined(&vmladavaq_s32);
	    eval 'sub vsriq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsriq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vsriq_n_s32);
	    eval 'sub vsliq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vsliq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vsliq_n_s32);
	    eval 'sub vpselq_u64 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq_u64($__a, $__b, $__p));
	    }' unless defined(&vpselq_u64);
	    eval 'sub vpselq_s64 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq_s64($__a, $__b, $__p));
	    }' unless defined(&vpselq_s64);
	    eval 'sub vrmlaldavhaxq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vrmlaldavhaxq_s32($__a, $__b, $__c));
	    }' unless defined(&vrmlaldavhaxq_s32);
	    eval 'sub vrmlsldavhaq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vrmlsldavhaq_s32($__a, $__b, $__c));
	    }' unless defined(&vrmlsldavhaq_s32);
	    eval 'sub vrmlsldavhaxq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vrmlsldavhaxq_s32($__a, $__b, $__c));
	    }' unless defined(&vrmlsldavhaxq_s32);
	    eval 'sub vaddlvaq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddlvaq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vaddlvaq_p_s32);
	    eval 'sub vcvtbq_m_f16_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcvtbq_m_f16_f32($__a, $__b, $__p));
	    }' unless defined(&vcvtbq_m_f16_f32);
	    eval 'sub vcvtbq_m_f32_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtbq_m_f32_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtbq_m_f32_f16);
	    eval 'sub vcvttq_m_f16_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcvttq_m_f16_f32($__a, $__b, $__p));
	    }' unless defined(&vcvttq_m_f16_f32);
	    eval 'sub vcvttq_m_f32_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvttq_m_f32_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvttq_m_f32_f16);
	    eval 'sub vrev16q_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev16q_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vrev16q_m_s8);
	    eval 'sub vrev32q_m_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev32q_m_f16($__inactive, $__a, $__p));
	    }' unless defined(&vrev32q_m_f16);
	    eval 'sub vrmlaldavhq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmlaldavhq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vrmlaldavhq_p_s32);
	    eval 'sub vrmlaldavhxq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmlaldavhxq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vrmlaldavhxq_p_s32);
	    eval 'sub vrmlsldavhq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmlsldavhq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vrmlsldavhq_p_s32);
	    eval 'sub vrmlsldavhxq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmlsldavhxq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vrmlsldavhxq_p_s32);
	    eval 'sub vaddlvaq_p_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddlvaq_p_u32($__a, $__b, $__p));
	    }' unless defined(&vaddlvaq_p_u32);
	    eval 'sub vrev16q_m_u8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev16q_m_u8($__inactive, $__a, $__p));
	    }' unless defined(&vrev16q_m_u8);
	    eval 'sub vrmlaldavhq_p_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmlaldavhq_p_u32($__a, $__b, $__p));
	    }' unless defined(&vrmlaldavhq_p_u32);
	    eval 'sub vmvnq_m_n_s16 {
	        my($__inactive,  $__imm, $__p) = @_;
    		eval q( &__arm_vmvnq_m_n_s16($__inactive, $__imm, $__p));
	    }' unless defined(&vmvnq_m_n_s16);
	    eval 'sub vorrq_m_n_s16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vorrq_m_n_s16($__a, $__imm, $__p));
	    }' unless defined(&vorrq_m_n_s16);
	    eval 'sub vqrshrntq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshrntq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vqrshrntq_n_s16);
	    eval 'sub vqshrnbq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshrnbq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vqshrnbq_n_s16);
	    eval 'sub vqshrntq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshrntq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vqshrntq_n_s16);
	    eval 'sub vrshrnbq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vrshrnbq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vrshrnbq_n_s16);
	    eval 'sub vrshrntq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vrshrntq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vrshrntq_n_s16);
	    eval 'sub vshrnbq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vshrnbq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vshrnbq_n_s16);
	    eval 'sub vshrntq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vshrntq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vshrntq_n_s16);
	    eval 'sub vcmlaq_f16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_f16($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_f16);
	    eval 'sub vcmlaq_rot180_f16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_rot180_f16($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_rot180_f16);
	    eval 'sub vcmlaq_rot270_f16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_rot270_f16($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_rot270_f16);
	    eval 'sub vcmlaq_rot90_f16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_rot90_f16($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_rot90_f16);
	    eval 'sub vfmaq_f16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmaq_f16($__a, $__b, $__c));
	    }' unless defined(&vfmaq_f16);
	    eval 'sub vfmaq_n_f16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmaq_n_f16($__a, $__b, $__c));
	    }' unless defined(&vfmaq_n_f16);
	    eval 'sub vfmasq_n_f16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmasq_n_f16($__a, $__b, $__c));
	    }' unless defined(&vfmasq_n_f16);
	    eval 'sub vfmsq_f16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmsq_f16($__a, $__b, $__c));
	    }' unless defined(&vfmsq_f16);
	    eval 'sub vmlaldavaq_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaldavaq_s16($__a, $__b, $__c));
	    }' unless defined(&vmlaldavaq_s16);
	    eval 'sub vmlaldavaxq_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaldavaxq_s16($__a, $__b, $__c));
	    }' unless defined(&vmlaldavaxq_s16);
	    eval 'sub vmlsldavaq_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsldavaq_s16($__a, $__b, $__c));
	    }' unless defined(&vmlsldavaq_s16);
	    eval 'sub vmlsldavaxq_s16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsldavaxq_s16($__a, $__b, $__c));
	    }' unless defined(&vmlsldavaxq_s16);
	    eval 'sub vabsq_m_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vabsq_m_f16($__inactive, $__a, $__p));
	    }' unless defined(&vabsq_m_f16);
	    eval 'sub vcvtmq_m_s16_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtmq_m_s16_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtmq_m_s16_f16);
	    eval 'sub vcvtnq_m_s16_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtnq_m_s16_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtnq_m_s16_f16);
	    eval 'sub vcvtpq_m_s16_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtpq_m_s16_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtpq_m_s16_f16);
	    eval 'sub vcvtq_m_s16_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtq_m_s16_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtq_m_s16_f16);
	    eval 'sub vdupq_m_n_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vdupq_m_n_f16($__inactive, $__a, $__p));
	    }' unless defined(&vdupq_m_n_f16);
	    eval 'sub vmaxnmaq_m_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmaq_m_f16($__a, $__b, $__p));
	    }' unless defined(&vmaxnmaq_m_f16);
	    eval 'sub vmaxnmavq_p_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmavq_p_f16($__a, $__b, $__p));
	    }' unless defined(&vmaxnmavq_p_f16);
	    eval 'sub vmaxnmvq_p_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmvq_p_f16($__a, $__b, $__p));
	    }' unless defined(&vmaxnmvq_p_f16);
	    eval 'sub vminnmaq_m_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmaq_m_f16($__a, $__b, $__p));
	    }' unless defined(&vminnmaq_m_f16);
	    eval 'sub vminnmavq_p_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmavq_p_f16($__a, $__b, $__p));
	    }' unless defined(&vminnmavq_p_f16);
	    eval 'sub vminnmvq_p_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmvq_p_f16($__a, $__b, $__p));
	    }' unless defined(&vminnmvq_p_f16);
	    eval 'sub vmlaldavq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlaldavq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vmlaldavq_p_s16);
	    eval 'sub vmlaldavxq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlaldavxq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vmlaldavxq_p_s16);
	    eval 'sub vmlsldavq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsldavq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vmlsldavq_p_s16);
	    eval 'sub vmlsldavxq_p_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsldavxq_p_s16($__a, $__b, $__p));
	    }' unless defined(&vmlsldavxq_p_s16);
	    eval 'sub vmovlbq_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmovlbq_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vmovlbq_m_s8);
	    eval 'sub vmovltq_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmovltq_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vmovltq_m_s8);
	    eval 'sub vmovnbq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmovnbq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vmovnbq_m_s16);
	    eval 'sub vmovntq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmovntq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vmovntq_m_s16);
	    eval 'sub vnegq_m_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vnegq_m_f16($__inactive, $__a, $__p));
	    }' unless defined(&vnegq_m_f16);
	    eval 'sub vpselq_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq_f16($__a, $__b, $__p));
	    }' unless defined(&vpselq_f16);
	    eval 'sub vqmovnbq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovnbq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vqmovnbq_m_s16);
	    eval 'sub vqmovntq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovntq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vqmovntq_m_s16);
	    eval 'sub vrev32q_m_s8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev32q_m_s8($__inactive, $__a, $__p));
	    }' unless defined(&vrev32q_m_s8);
	    eval 'sub vrev64q_m_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev64q_m_f16($__inactive, $__a, $__p));
	    }' unless defined(&vrev64q_m_f16);
	    eval 'sub vrndaq_m_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndaq_m_f16($__inactive, $__a, $__p));
	    }' unless defined(&vrndaq_m_f16);
	    eval 'sub vrndmq_m_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndmq_m_f16($__inactive, $__a, $__p));
	    }' unless defined(&vrndmq_m_f16);
	    eval 'sub vrndnq_m_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndnq_m_f16($__inactive, $__a, $__p));
	    }' unless defined(&vrndnq_m_f16);
	    eval 'sub vrndpq_m_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndpq_m_f16($__inactive, $__a, $__p));
	    }' unless defined(&vrndpq_m_f16);
	    eval 'sub vrndq_m_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndq_m_f16($__inactive, $__a, $__p));
	    }' unless defined(&vrndq_m_f16);
	    eval 'sub vrndxq_m_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndxq_m_f16($__inactive, $__a, $__p));
	    }' unless defined(&vrndxq_m_f16);
	    eval 'sub vcmpeqq_m_n_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_n_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_n_f16);
	    eval 'sub vcmpgeq_m_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m_f16);
	    eval 'sub vcmpgeq_m_n_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m_n_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m_n_f16);
	    eval 'sub vcmpgtq_m_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m_f16);
	    eval 'sub vcmpgtq_m_n_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m_n_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m_n_f16);
	    eval 'sub vcmpleq_m_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m_f16);
	    eval 'sub vcmpleq_m_n_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m_n_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m_n_f16);
	    eval 'sub vcmpltq_m_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m_f16);
	    eval 'sub vcmpltq_m_n_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m_n_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m_n_f16);
	    eval 'sub vcmpneq_m_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_f16);
	    eval 'sub vcmpneq_m_n_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_n_f16($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_n_f16);
	    eval 'sub vmvnq_m_n_u16 {
	        my($__inactive,  $__imm, $__p) = @_;
    		eval q( &__arm_vmvnq_m_n_u16($__inactive, $__imm, $__p));
	    }' unless defined(&vmvnq_m_n_u16);
	    eval 'sub vorrq_m_n_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vorrq_m_n_u16($__a, $__imm, $__p));
	    }' unless defined(&vorrq_m_n_u16);
	    eval 'sub vqrshruntq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshruntq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vqrshruntq_n_s16);
	    eval 'sub vqshrunbq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshrunbq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vqshrunbq_n_s16);
	    eval 'sub vqshruntq_n_s16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshruntq_n_s16($__a, $__b, $__imm));
	    }' unless defined(&vqshruntq_n_s16);
	    eval 'sub vcvtmq_m_u16_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtmq_m_u16_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtmq_m_u16_f16);
	    eval 'sub vcvtnq_m_u16_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtnq_m_u16_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtnq_m_u16_f16);
	    eval 'sub vcvtpq_m_u16_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtpq_m_u16_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtpq_m_u16_f16);
	    eval 'sub vcvtq_m_u16_f16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtq_m_u16_f16($__inactive, $__a, $__p));
	    }' unless defined(&vcvtq_m_u16_f16);
	    eval 'sub vqmovunbq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovunbq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vqmovunbq_m_s16);
	    eval 'sub vqmovuntq_m_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovuntq_m_s16($__a, $__b, $__p));
	    }' unless defined(&vqmovuntq_m_s16);
	    eval 'sub vqrshrntq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshrntq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vqrshrntq_n_u16);
	    eval 'sub vqshrnbq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshrnbq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vqshrnbq_n_u16);
	    eval 'sub vqshrntq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshrntq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vqshrntq_n_u16);
	    eval 'sub vrshrnbq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vrshrnbq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vrshrnbq_n_u16);
	    eval 'sub vrshrntq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vrshrntq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vrshrntq_n_u16);
	    eval 'sub vshrnbq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vshrnbq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vshrnbq_n_u16);
	    eval 'sub vshrntq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vshrntq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vshrntq_n_u16);
	    eval 'sub vmlaldavaq_u16 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaldavaq_u16($__a, $__b, $__c));
	    }' unless defined(&vmlaldavaq_u16);
	    eval 'sub vmlaldavq_p_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlaldavq_p_u16($__a, $__b, $__p));
	    }' unless defined(&vmlaldavq_p_u16);
	    eval 'sub vmovlbq_m_u8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmovlbq_m_u8($__inactive, $__a, $__p));
	    }' unless defined(&vmovlbq_m_u8);
	    eval 'sub vmovltq_m_u8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmovltq_m_u8($__inactive, $__a, $__p));
	    }' unless defined(&vmovltq_m_u8);
	    eval 'sub vmovnbq_m_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmovnbq_m_u16($__a, $__b, $__p));
	    }' unless defined(&vmovnbq_m_u16);
	    eval 'sub vmovntq_m_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmovntq_m_u16($__a, $__b, $__p));
	    }' unless defined(&vmovntq_m_u16);
	    eval 'sub vqmovnbq_m_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovnbq_m_u16($__a, $__b, $__p));
	    }' unless defined(&vqmovnbq_m_u16);
	    eval 'sub vqmovntq_m_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovntq_m_u16($__a, $__b, $__p));
	    }' unless defined(&vqmovntq_m_u16);
	    eval 'sub vrev32q_m_u8 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev32q_m_u8($__inactive, $__a, $__p));
	    }' unless defined(&vrev32q_m_u8);
	    eval 'sub vmvnq_m_n_s32 {
	        my($__inactive,  $__imm, $__p) = @_;
    		eval q( &__arm_vmvnq_m_n_s32($__inactive, $__imm, $__p));
	    }' unless defined(&vmvnq_m_n_s32);
	    eval 'sub vorrq_m_n_s32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vorrq_m_n_s32($__a, $__imm, $__p));
	    }' unless defined(&vorrq_m_n_s32);
	    eval 'sub vqrshrntq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshrntq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vqrshrntq_n_s32);
	    eval 'sub vqshrnbq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshrnbq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vqshrnbq_n_s32);
	    eval 'sub vqshrntq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshrntq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vqshrntq_n_s32);
	    eval 'sub vrshrnbq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vrshrnbq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vrshrnbq_n_s32);
	    eval 'sub vrshrntq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vrshrntq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vrshrntq_n_s32);
	    eval 'sub vshrnbq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vshrnbq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vshrnbq_n_s32);
	    eval 'sub vshrntq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vshrntq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vshrntq_n_s32);
	    eval 'sub vcmlaq_f32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_f32($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_f32);
	    eval 'sub vcmlaq_rot180_f32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_rot180_f32($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_rot180_f32);
	    eval 'sub vcmlaq_rot270_f32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_rot270_f32($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_rot270_f32);
	    eval 'sub vcmlaq_rot90_f32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vcmlaq_rot90_f32($__a, $__b, $__c));
	    }' unless defined(&vcmlaq_rot90_f32);
	    eval 'sub vfmaq_f32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmaq_f32($__a, $__b, $__c));
	    }' unless defined(&vfmaq_f32);
	    eval 'sub vfmaq_n_f32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmaq_n_f32($__a, $__b, $__c));
	    }' unless defined(&vfmaq_n_f32);
	    eval 'sub vfmasq_n_f32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmasq_n_f32($__a, $__b, $__c));
	    }' unless defined(&vfmasq_n_f32);
	    eval 'sub vfmsq_f32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vfmsq_f32($__a, $__b, $__c));
	    }' unless defined(&vfmsq_f32);
	    eval 'sub vmlaldavaq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaldavaq_s32($__a, $__b, $__c));
	    }' unless defined(&vmlaldavaq_s32);
	    eval 'sub vmlaldavaxq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaldavaxq_s32($__a, $__b, $__c));
	    }' unless defined(&vmlaldavaxq_s32);
	    eval 'sub vmlsldavaq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsldavaq_s32($__a, $__b, $__c));
	    }' unless defined(&vmlsldavaq_s32);
	    eval 'sub vmlsldavaxq_s32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlsldavaxq_s32($__a, $__b, $__c));
	    }' unless defined(&vmlsldavaxq_s32);
	    eval 'sub vabsq_m_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vabsq_m_f32($__inactive, $__a, $__p));
	    }' unless defined(&vabsq_m_f32);
	    eval 'sub vcvtmq_m_s32_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtmq_m_s32_f32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtmq_m_s32_f32);
	    eval 'sub vcvtnq_m_s32_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtnq_m_s32_f32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtnq_m_s32_f32);
	    eval 'sub vcvtpq_m_s32_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtpq_m_s32_f32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtpq_m_s32_f32);
	    eval 'sub vcvtq_m_s32_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtq_m_s32_f32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtq_m_s32_f32);
	    eval 'sub vdupq_m_n_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vdupq_m_n_f32($__inactive, $__a, $__p));
	    }' unless defined(&vdupq_m_n_f32);
	    eval 'sub vmaxnmaq_m_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmaq_m_f32($__a, $__b, $__p));
	    }' unless defined(&vmaxnmaq_m_f32);
	    eval 'sub vmaxnmavq_p_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmavq_p_f32($__a, $__b, $__p));
	    }' unless defined(&vmaxnmavq_p_f32);
	    eval 'sub vmaxnmvq_p_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmvq_p_f32($__a, $__b, $__p));
	    }' unless defined(&vmaxnmvq_p_f32);
	    eval 'sub vminnmaq_m_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmaq_m_f32($__a, $__b, $__p));
	    }' unless defined(&vminnmaq_m_f32);
	    eval 'sub vminnmavq_p_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmavq_p_f32($__a, $__b, $__p));
	    }' unless defined(&vminnmavq_p_f32);
	    eval 'sub vminnmvq_p_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmvq_p_f32($__a, $__b, $__p));
	    }' unless defined(&vminnmvq_p_f32);
	    eval 'sub vmlaldavq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlaldavq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vmlaldavq_p_s32);
	    eval 'sub vmlaldavxq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlaldavxq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vmlaldavxq_p_s32);
	    eval 'sub vmlsldavq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsldavq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vmlsldavq_p_s32);
	    eval 'sub vmlsldavxq_p_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlsldavxq_p_s32($__a, $__b, $__p));
	    }' unless defined(&vmlsldavxq_p_s32);
	    eval 'sub vmovlbq_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmovlbq_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vmovlbq_m_s16);
	    eval 'sub vmovltq_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmovltq_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vmovltq_m_s16);
	    eval 'sub vmovnbq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmovnbq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vmovnbq_m_s32);
	    eval 'sub vmovntq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmovntq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vmovntq_m_s32);
	    eval 'sub vnegq_m_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vnegq_m_f32($__inactive, $__a, $__p));
	    }' unless defined(&vnegq_m_f32);
	    eval 'sub vpselq_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vpselq_f32($__a, $__b, $__p));
	    }' unless defined(&vpselq_f32);
	    eval 'sub vqmovnbq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovnbq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vqmovnbq_m_s32);
	    eval 'sub vqmovntq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovntq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vqmovntq_m_s32);
	    eval 'sub vrev32q_m_s16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev32q_m_s16($__inactive, $__a, $__p));
	    }' unless defined(&vrev32q_m_s16);
	    eval 'sub vrev64q_m_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev64q_m_f32($__inactive, $__a, $__p));
	    }' unless defined(&vrev64q_m_f32);
	    eval 'sub vrndaq_m_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndaq_m_f32($__inactive, $__a, $__p));
	    }' unless defined(&vrndaq_m_f32);
	    eval 'sub vrndmq_m_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndmq_m_f32($__inactive, $__a, $__p));
	    }' unless defined(&vrndmq_m_f32);
	    eval 'sub vrndnq_m_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndnq_m_f32($__inactive, $__a, $__p));
	    }' unless defined(&vrndnq_m_f32);
	    eval 'sub vrndpq_m_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndpq_m_f32($__inactive, $__a, $__p));
	    }' unless defined(&vrndpq_m_f32);
	    eval 'sub vrndq_m_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndq_m_f32($__inactive, $__a, $__p));
	    }' unless defined(&vrndq_m_f32);
	    eval 'sub vrndxq_m_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrndxq_m_f32($__inactive, $__a, $__p));
	    }' unless defined(&vrndxq_m_f32);
	    eval 'sub vcmpeqq_m_n_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpeqq_m_n_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpeqq_m_n_f32);
	    eval 'sub vcmpgeq_m_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m_f32);
	    eval 'sub vcmpgeq_m_n_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgeq_m_n_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpgeq_m_n_f32);
	    eval 'sub vcmpgtq_m_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m_f32);
	    eval 'sub vcmpgtq_m_n_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpgtq_m_n_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpgtq_m_n_f32);
	    eval 'sub vcmpleq_m_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m_f32);
	    eval 'sub vcmpleq_m_n_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpleq_m_n_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpleq_m_n_f32);
	    eval 'sub vcmpltq_m_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m_f32);
	    eval 'sub vcmpltq_m_n_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpltq_m_n_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpltq_m_n_f32);
	    eval 'sub vcmpneq_m_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_f32);
	    eval 'sub vcmpneq_m_n_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmpneq_m_n_f32($__a, $__b, $__p));
	    }' unless defined(&vcmpneq_m_n_f32);
	    eval 'sub vmvnq_m_n_u32 {
	        my($__inactive,  $__imm, $__p) = @_;
    		eval q( &__arm_vmvnq_m_n_u32($__inactive, $__imm, $__p));
	    }' unless defined(&vmvnq_m_n_u32);
	    eval 'sub vorrq_m_n_u32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vorrq_m_n_u32($__a, $__imm, $__p));
	    }' unless defined(&vorrq_m_n_u32);
	    eval 'sub vqrshruntq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshruntq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vqrshruntq_n_s32);
	    eval 'sub vqshrunbq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshrunbq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vqshrunbq_n_s32);
	    eval 'sub vqshruntq_n_s32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshruntq_n_s32($__a, $__b, $__imm));
	    }' unless defined(&vqshruntq_n_s32);
	    eval 'sub vcvtmq_m_u32_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtmq_m_u32_f32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtmq_m_u32_f32);
	    eval 'sub vcvtnq_m_u32_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtnq_m_u32_f32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtnq_m_u32_f32);
	    eval 'sub vcvtpq_m_u32_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtpq_m_u32_f32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtpq_m_u32_f32);
	    eval 'sub vcvtq_m_u32_f32 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vcvtq_m_u32_f32($__inactive, $__a, $__p));
	    }' unless defined(&vcvtq_m_u32_f32);
	    eval 'sub vqmovunbq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovunbq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vqmovunbq_m_s32);
	    eval 'sub vqmovuntq_m_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovuntq_m_s32($__a, $__b, $__p));
	    }' unless defined(&vqmovuntq_m_s32);
	    eval 'sub vqrshrntq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqrshrntq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vqrshrntq_n_u32);
	    eval 'sub vqshrnbq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshrnbq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vqshrnbq_n_u32);
	    eval 'sub vqshrntq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vqshrntq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vqshrntq_n_u32);
	    eval 'sub vrshrnbq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vrshrnbq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vrshrnbq_n_u32);
	    eval 'sub vrshrntq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vrshrntq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vrshrntq_n_u32);
	    eval 'sub vshrnbq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vshrnbq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vshrnbq_n_u32);
	    eval 'sub vshrntq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vshrntq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vshrntq_n_u32);
	    eval 'sub vmlaldavaq_u32 {
	        my($__a, $__b, $__c) = @_;
    		eval q( &__arm_vmlaldavaq_u32($__a, $__b, $__c));
	    }' unless defined(&vmlaldavaq_u32);
	    eval 'sub vmlaldavq_p_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmlaldavq_p_u32($__a, $__b, $__p));
	    }' unless defined(&vmlaldavq_p_u32);
	    eval 'sub vmovlbq_m_u16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmovlbq_m_u16($__inactive, $__a, $__p));
	    }' unless defined(&vmovlbq_m_u16);
	    eval 'sub vmovltq_m_u16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vmovltq_m_u16($__inactive, $__a, $__p));
	    }' unless defined(&vmovltq_m_u16);
	    eval 'sub vmovnbq_m_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmovnbq_m_u32($__a, $__b, $__p));
	    }' unless defined(&vmovnbq_m_u32);
	    eval 'sub vmovntq_m_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmovntq_m_u32($__a, $__b, $__p));
	    }' unless defined(&vmovntq_m_u32);
	    eval 'sub vqmovnbq_m_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovnbq_m_u32($__a, $__b, $__p));
	    }' unless defined(&vqmovnbq_m_u32);
	    eval 'sub vqmovntq_m_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vqmovntq_m_u32($__a, $__b, $__p));
	    }' unless defined(&vqmovntq_m_u32);
	    eval 'sub vrev32q_m_u16 {
	        my($__inactive, $__a, $__p) = @_;
    		eval q( &__arm_vrev32q_m_u16($__inactive, $__a, $__p));
	    }' unless defined(&vrev32q_m_u16);
	    eval 'sub vsriq_m_n_s8 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsriq_m_n_s8($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsriq_m_n_s8);
	    eval 'sub vsubq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_s8);
	    eval 'sub vcvtq_m_n_f16_u16 {
	        my($__inactive, $__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_m_n_f16_u16($__inactive, $__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_m_n_f16_u16);
	    eval 'sub vqshluq_m_n_s8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshluq_m_n_s8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshluq_m_n_s8);
	    eval 'sub vabavq_p_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vabavq_p_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vabavq_p_s8);
	    eval 'sub vsriq_m_n_u8 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsriq_m_n_u8($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsriq_m_n_u8);
	    eval 'sub vshlq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vshlq_m_u8);
	    eval 'sub vsubq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_u8);
	    eval 'sub vabavq_p_u8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vabavq_p_u8($__a, $__b, $__c, $__p));
	    }' unless defined(&vabavq_p_u8);
	    eval 'sub vshlq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vshlq_m_s8);
	    eval 'sub vcvtq_m_n_f16_s16 {
	        my($__inactive, $__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_m_n_f16_s16($__inactive, $__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_m_n_f16_s16);
	    eval 'sub vsriq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsriq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsriq_m_n_s16);
	    eval 'sub vsubq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_s16);
	    eval 'sub vcvtq_m_n_f32_u32 {
	        my($__inactive, $__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_m_n_f32_u32($__inactive, $__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_m_n_f32_u32);
	    eval 'sub vqshluq_m_n_s16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshluq_m_n_s16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshluq_m_n_s16);
	    eval 'sub vabavq_p_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vabavq_p_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vabavq_p_s16);
	    eval 'sub vsriq_m_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsriq_m_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsriq_m_n_u16);
	    eval 'sub vshlq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vshlq_m_u16);
	    eval 'sub vsubq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_u16);
	    eval 'sub vabavq_p_u16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vabavq_p_u16($__a, $__b, $__c, $__p));
	    }' unless defined(&vabavq_p_u16);
	    eval 'sub vshlq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vshlq_m_s16);
	    eval 'sub vcvtq_m_n_f32_s32 {
	        my($__inactive, $__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_m_n_f32_s32($__inactive, $__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_m_n_f32_s32);
	    eval 'sub vsriq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsriq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsriq_m_n_s32);
	    eval 'sub vsubq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_s32);
	    eval 'sub vqshluq_m_n_s32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshluq_m_n_s32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshluq_m_n_s32);
	    eval 'sub vabavq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vabavq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vabavq_p_s32);
	    eval 'sub vsriq_m_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsriq_m_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsriq_m_n_u32);
	    eval 'sub vshlq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vshlq_m_u32);
	    eval 'sub vsubq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_u32);
	    eval 'sub vabavq_p_u32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vabavq_p_u32($__a, $__b, $__c, $__p));
	    }' unless defined(&vabavq_p_u32);
	    eval 'sub vshlq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vshlq_m_s32);
	    eval 'sub vabdq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vabdq_m_s8);
	    eval 'sub vabdq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vabdq_m_s32);
	    eval 'sub vabdq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vabdq_m_s16);
	    eval 'sub vabdq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vabdq_m_u8);
	    eval 'sub vabdq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vabdq_m_u32);
	    eval 'sub vabdq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vabdq_m_u16);
	    eval 'sub vaddq_m_n_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_n_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_n_s8);
	    eval 'sub vaddq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_n_s32);
	    eval 'sub vaddq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_n_s16);
	    eval 'sub vaddq_m_n_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_n_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_n_u8);
	    eval 'sub vaddq_m_n_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_n_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_n_u32);
	    eval 'sub vaddq_m_n_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_n_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_n_u16);
	    eval 'sub vaddq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_s8);
	    eval 'sub vaddq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_s32);
	    eval 'sub vaddq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_s16);
	    eval 'sub vaddq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_u8);
	    eval 'sub vaddq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_u32);
	    eval 'sub vaddq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_u16);
	    eval 'sub vandq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vandq_m_s8);
	    eval 'sub vandq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vandq_m_s32);
	    eval 'sub vandq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vandq_m_s16);
	    eval 'sub vandq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vandq_m_u8);
	    eval 'sub vandq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vandq_m_u32);
	    eval 'sub vandq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vandq_m_u16);
	    eval 'sub vbicq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbicq_m_s8);
	    eval 'sub vbicq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbicq_m_s32);
	    eval 'sub vbicq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbicq_m_s16);
	    eval 'sub vbicq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbicq_m_u8);
	    eval 'sub vbicq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbicq_m_u32);
	    eval 'sub vbicq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbicq_m_u16);
	    eval 'sub vbrsrq_m_n_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_m_n_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbrsrq_m_n_s8);
	    eval 'sub vbrsrq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbrsrq_m_n_s32);
	    eval 'sub vbrsrq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbrsrq_m_n_s16);
	    eval 'sub vbrsrq_m_n_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_m_n_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbrsrq_m_n_u8);
	    eval 'sub vbrsrq_m_n_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_m_n_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbrsrq_m_n_u32);
	    eval 'sub vbrsrq_m_n_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_m_n_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbrsrq_m_n_u16);
	    eval 'sub vcaddq_rot270_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_m_s8);
	    eval 'sub vcaddq_rot270_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_m_s32);
	    eval 'sub vcaddq_rot270_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_m_s16);
	    eval 'sub vcaddq_rot270_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_m_u8);
	    eval 'sub vcaddq_rot270_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_m_u32);
	    eval 'sub vcaddq_rot270_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_m_u16);
	    eval 'sub vcaddq_rot90_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_m_s8);
	    eval 'sub vcaddq_rot90_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_m_s32);
	    eval 'sub vcaddq_rot90_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_m_s16);
	    eval 'sub vcaddq_rot90_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_m_u8);
	    eval 'sub vcaddq_rot90_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_m_u32);
	    eval 'sub vcaddq_rot90_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_m_u16);
	    eval 'sub veorq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&veorq_m_s8);
	    eval 'sub veorq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&veorq_m_s32);
	    eval 'sub veorq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&veorq_m_s16);
	    eval 'sub veorq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&veorq_m_u8);
	    eval 'sub veorq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&veorq_m_u32);
	    eval 'sub veorq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&veorq_m_u16);
	    eval 'sub vhaddq_m_n_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_n_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_n_s8);
	    eval 'sub vhaddq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_n_s32);
	    eval 'sub vhaddq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_n_s16);
	    eval 'sub vhaddq_m_n_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_n_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_n_u8);
	    eval 'sub vhaddq_m_n_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_n_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_n_u32);
	    eval 'sub vhaddq_m_n_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_n_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_n_u16);
	    eval 'sub vhaddq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_s8);
	    eval 'sub vhaddq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_s32);
	    eval 'sub vhaddq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_s16);
	    eval 'sub vhaddq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_u8);
	    eval 'sub vhaddq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_u32);
	    eval 'sub vhaddq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhaddq_m_u16);
	    eval 'sub vhcaddq_rot270_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot270_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot270_m_s8);
	    eval 'sub vhcaddq_rot270_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot270_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot270_m_s32);
	    eval 'sub vhcaddq_rot270_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot270_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot270_m_s16);
	    eval 'sub vhcaddq_rot90_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot90_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot90_m_s8);
	    eval 'sub vhcaddq_rot90_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot90_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot90_m_s32);
	    eval 'sub vhcaddq_rot90_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot90_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot90_m_s16);
	    eval 'sub vhsubq_m_n_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_n_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_n_s8);
	    eval 'sub vhsubq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_n_s32);
	    eval 'sub vhsubq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_n_s16);
	    eval 'sub vhsubq_m_n_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_n_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_n_u8);
	    eval 'sub vhsubq_m_n_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_n_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_n_u32);
	    eval 'sub vhsubq_m_n_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_n_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_n_u16);
	    eval 'sub vhsubq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_s8);
	    eval 'sub vhsubq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_s32);
	    eval 'sub vhsubq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_s16);
	    eval 'sub vhsubq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_u8);
	    eval 'sub vhsubq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_u32);
	    eval 'sub vhsubq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vhsubq_m_u16);
	    eval 'sub vmaxq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmaxq_m_s8);
	    eval 'sub vmaxq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmaxq_m_s32);
	    eval 'sub vmaxq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmaxq_m_s16);
	    eval 'sub vmaxq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmaxq_m_u8);
	    eval 'sub vmaxq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmaxq_m_u32);
	    eval 'sub vmaxq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmaxq_m_u16);
	    eval 'sub vminq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vminq_m_s8);
	    eval 'sub vminq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vminq_m_s32);
	    eval 'sub vminq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vminq_m_s16);
	    eval 'sub vminq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vminq_m_u8);
	    eval 'sub vminq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vminq_m_u32);
	    eval 'sub vminq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vminq_m_u16);
	    eval 'sub vmladavaq_p_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaq_p_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaq_p_s8);
	    eval 'sub vmladavaq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaq_p_s32);
	    eval 'sub vmladavaq_p_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaq_p_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaq_p_s16);
	    eval 'sub vmladavaq_p_u8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaq_p_u8($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaq_p_u8);
	    eval 'sub vmladavaq_p_u32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaq_p_u32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaq_p_u32);
	    eval 'sub vmladavaq_p_u16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaq_p_u16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaq_p_u16);
	    eval 'sub vmladavaxq_p_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaxq_p_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaxq_p_s8);
	    eval 'sub vmladavaxq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaxq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaxq_p_s32);
	    eval 'sub vmladavaxq_p_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmladavaxq_p_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmladavaxq_p_s16);
	    eval 'sub vmlaq_m_n_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaq_m_n_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaq_m_n_s8);
	    eval 'sub vmlaq_m_n_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaq_m_n_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaq_m_n_s32);
	    eval 'sub vmlaq_m_n_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaq_m_n_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaq_m_n_s16);
	    eval 'sub vmlaq_m_n_u8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaq_m_n_u8($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaq_m_n_u8);
	    eval 'sub vmlaq_m_n_u32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaq_m_n_u32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaq_m_n_u32);
	    eval 'sub vmlaq_m_n_u16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaq_m_n_u16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaq_m_n_u16);
	    eval 'sub vmlasq_m_n_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlasq_m_n_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlasq_m_n_s8);
	    eval 'sub vmlasq_m_n_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlasq_m_n_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlasq_m_n_s32);
	    eval 'sub vmlasq_m_n_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlasq_m_n_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlasq_m_n_s16);
	    eval 'sub vmlasq_m_n_u8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlasq_m_n_u8($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlasq_m_n_u8);
	    eval 'sub vmlasq_m_n_u32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlasq_m_n_u32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlasq_m_n_u32);
	    eval 'sub vmlasq_m_n_u16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlasq_m_n_u16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlasq_m_n_u16);
	    eval 'sub vmlsdavaq_p_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsdavaq_p_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsdavaq_p_s8);
	    eval 'sub vmlsdavaq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsdavaq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsdavaq_p_s32);
	    eval 'sub vmlsdavaq_p_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsdavaq_p_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsdavaq_p_s16);
	    eval 'sub vmlsdavaxq_p_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsdavaxq_p_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsdavaxq_p_s8);
	    eval 'sub vmlsdavaxq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsdavaxq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsdavaxq_p_s32);
	    eval 'sub vmlsdavaxq_p_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsdavaxq_p_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsdavaxq_p_s16);
	    eval 'sub vmulhq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulhq_m_s8);
	    eval 'sub vmulhq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulhq_m_s32);
	    eval 'sub vmulhq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulhq_m_s16);
	    eval 'sub vmulhq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulhq_m_u8);
	    eval 'sub vmulhq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulhq_m_u32);
	    eval 'sub vmulhq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulhq_m_u16);
	    eval 'sub vmullbq_int_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_m_s8);
	    eval 'sub vmullbq_int_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_m_s32);
	    eval 'sub vmullbq_int_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_m_s16);
	    eval 'sub vmullbq_int_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_m_u8);
	    eval 'sub vmullbq_int_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_m_u32);
	    eval 'sub vmullbq_int_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_m_u16);
	    eval 'sub vmulltq_int_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_m_s8);
	    eval 'sub vmulltq_int_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_m_s32);
	    eval 'sub vmulltq_int_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_m_s16);
	    eval 'sub vmulltq_int_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_m_u8);
	    eval 'sub vmulltq_int_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_m_u32);
	    eval 'sub vmulltq_int_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_m_u16);
	    eval 'sub vmulq_m_n_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_n_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_n_s8);
	    eval 'sub vmulq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_n_s32);
	    eval 'sub vmulq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_n_s16);
	    eval 'sub vmulq_m_n_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_n_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_n_u8);
	    eval 'sub vmulq_m_n_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_n_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_n_u32);
	    eval 'sub vmulq_m_n_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_n_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_n_u16);
	    eval 'sub vmulq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_s8);
	    eval 'sub vmulq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_s32);
	    eval 'sub vmulq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_s16);
	    eval 'sub vmulq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_u8);
	    eval 'sub vmulq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_u32);
	    eval 'sub vmulq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_u16);
	    eval 'sub vornq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vornq_m_s8);
	    eval 'sub vornq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vornq_m_s32);
	    eval 'sub vornq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vornq_m_s16);
	    eval 'sub vornq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vornq_m_u8);
	    eval 'sub vornq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vornq_m_u32);
	    eval 'sub vornq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vornq_m_u16);
	    eval 'sub vorrq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vorrq_m_s8);
	    eval 'sub vorrq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vorrq_m_s32);
	    eval 'sub vorrq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vorrq_m_s16);
	    eval 'sub vorrq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vorrq_m_u8);
	    eval 'sub vorrq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vorrq_m_u32);
	    eval 'sub vorrq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vorrq_m_u16);
	    eval 'sub vqaddq_m_n_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_n_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_n_s8);
	    eval 'sub vqaddq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_n_s32);
	    eval 'sub vqaddq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_n_s16);
	    eval 'sub vqaddq_m_n_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_n_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_n_u8);
	    eval 'sub vqaddq_m_n_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_n_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_n_u32);
	    eval 'sub vqaddq_m_n_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_n_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_n_u16);
	    eval 'sub vqaddq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_s8);
	    eval 'sub vqaddq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_s32);
	    eval 'sub vqaddq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_s16);
	    eval 'sub vqaddq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_u8);
	    eval 'sub vqaddq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_u32);
	    eval 'sub vqaddq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqaddq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqaddq_m_u16);
	    eval 'sub vqdmladhq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmladhq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmladhq_m_s8);
	    eval 'sub vqdmladhq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmladhq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmladhq_m_s32);
	    eval 'sub vqdmladhq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmladhq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmladhq_m_s16);
	    eval 'sub vqdmladhxq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmladhxq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmladhxq_m_s8);
	    eval 'sub vqdmladhxq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmladhxq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmladhxq_m_s32);
	    eval 'sub vqdmladhxq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmladhxq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmladhxq_m_s16);
	    eval 'sub vqdmlashq_m_n_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqdmlashq_m_n_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vqdmlashq_m_n_s8);
	    eval 'sub vqdmlashq_m_n_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqdmlashq_m_n_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vqdmlashq_m_n_s32);
	    eval 'sub vqdmlashq_m_n_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqdmlashq_m_n_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vqdmlashq_m_n_s16);
	    eval 'sub vqdmlahq_m_n_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqdmlahq_m_n_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vqdmlahq_m_n_s8);
	    eval 'sub vqdmlahq_m_n_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqdmlahq_m_n_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vqdmlahq_m_n_s32);
	    eval 'sub vqdmlahq_m_n_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqdmlahq_m_n_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vqdmlahq_m_n_s16);
	    eval 'sub vqdmlsdhq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmlsdhq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmlsdhq_m_s8);
	    eval 'sub vqdmlsdhq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmlsdhq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmlsdhq_m_s32);
	    eval 'sub vqdmlsdhq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmlsdhq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmlsdhq_m_s16);
	    eval 'sub vqdmlsdhxq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmlsdhxq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmlsdhxq_m_s8);
	    eval 'sub vqdmlsdhxq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmlsdhxq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmlsdhxq_m_s32);
	    eval 'sub vqdmlsdhxq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmlsdhxq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmlsdhxq_m_s16);
	    eval 'sub vqdmulhq_m_n_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulhq_m_n_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulhq_m_n_s8);
	    eval 'sub vqdmulhq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulhq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulhq_m_n_s32);
	    eval 'sub vqdmulhq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulhq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulhq_m_n_s16);
	    eval 'sub vqdmulhq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulhq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulhq_m_s8);
	    eval 'sub vqdmulhq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulhq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulhq_m_s32);
	    eval 'sub vqdmulhq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulhq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulhq_m_s16);
	    eval 'sub vqrdmladhq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmladhq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmladhq_m_s8);
	    eval 'sub vqrdmladhq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmladhq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmladhq_m_s32);
	    eval 'sub vqrdmladhq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmladhq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmladhq_m_s16);
	    eval 'sub vqrdmladhxq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmladhxq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmladhxq_m_s8);
	    eval 'sub vqrdmladhxq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmladhxq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmladhxq_m_s32);
	    eval 'sub vqrdmladhxq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmladhxq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmladhxq_m_s16);
	    eval 'sub vqrdmlahq_m_n_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqrdmlahq_m_n_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vqrdmlahq_m_n_s8);
	    eval 'sub vqrdmlahq_m_n_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqrdmlahq_m_n_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vqrdmlahq_m_n_s32);
	    eval 'sub vqrdmlahq_m_n_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqrdmlahq_m_n_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vqrdmlahq_m_n_s16);
	    eval 'sub vqrdmlashq_m_n_s8 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqrdmlashq_m_n_s8($__a, $__b, $__c, $__p));
	    }' unless defined(&vqrdmlashq_m_n_s8);
	    eval 'sub vqrdmlashq_m_n_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqrdmlashq_m_n_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vqrdmlashq_m_n_s32);
	    eval 'sub vqrdmlashq_m_n_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vqrdmlashq_m_n_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vqrdmlashq_m_n_s16);
	    eval 'sub vqrdmlsdhq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmlsdhq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmlsdhq_m_s8);
	    eval 'sub vqrdmlsdhq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmlsdhq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmlsdhq_m_s32);
	    eval 'sub vqrdmlsdhq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmlsdhq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmlsdhq_m_s16);
	    eval 'sub vqrdmlsdhxq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmlsdhxq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmlsdhxq_m_s8);
	    eval 'sub vqrdmlsdhxq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmlsdhxq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmlsdhxq_m_s32);
	    eval 'sub vqrdmlsdhxq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmlsdhxq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmlsdhxq_m_s16);
	    eval 'sub vqrdmulhq_m_n_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmulhq_m_n_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmulhq_m_n_s8);
	    eval 'sub vqrdmulhq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmulhq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmulhq_m_n_s32);
	    eval 'sub vqrdmulhq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmulhq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmulhq_m_n_s16);
	    eval 'sub vqrdmulhq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmulhq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmulhq_m_s8);
	    eval 'sub vqrdmulhq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmulhq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmulhq_m_s32);
	    eval 'sub vqrdmulhq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrdmulhq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrdmulhq_m_s16);
	    eval 'sub vqrshlq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_s8);
	    eval 'sub vqrshlq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_s32);
	    eval 'sub vqrshlq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_s16);
	    eval 'sub vqrshlq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_u8);
	    eval 'sub vqrshlq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_u32);
	    eval 'sub vqrshlq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqrshlq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqrshlq_m_u16);
	    eval 'sub vqshlq_m_n_s8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshlq_m_n_s8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshlq_m_n_s8);
	    eval 'sub vqshlq_m_n_s32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshlq_m_n_s32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshlq_m_n_s32);
	    eval 'sub vqshlq_m_n_s16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshlq_m_n_s16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshlq_m_n_s16);
	    eval 'sub vqshlq_m_n_u8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshlq_m_n_u8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshlq_m_n_u8);
	    eval 'sub vqshlq_m_n_u32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshlq_m_n_u32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshlq_m_n_u32);
	    eval 'sub vqshlq_m_n_u16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshlq_m_n_u16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vqshlq_m_n_u16);
	    eval 'sub vqshlq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_s8);
	    eval 'sub vqshlq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_s32);
	    eval 'sub vqshlq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_s16);
	    eval 'sub vqshlq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_u8);
	    eval 'sub vqshlq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_u32);
	    eval 'sub vqshlq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqshlq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqshlq_m_u16);
	    eval 'sub vqsubq_m_n_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_n_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_n_s8);
	    eval 'sub vqsubq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_n_s32);
	    eval 'sub vqsubq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_n_s16);
	    eval 'sub vqsubq_m_n_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_n_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_n_u8);
	    eval 'sub vqsubq_m_n_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_n_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_n_u32);
	    eval 'sub vqsubq_m_n_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_n_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_n_u16);
	    eval 'sub vqsubq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_s8);
	    eval 'sub vqsubq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_s32);
	    eval 'sub vqsubq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_s16);
	    eval 'sub vqsubq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_u8);
	    eval 'sub vqsubq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_u32);
	    eval 'sub vqsubq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqsubq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqsubq_m_u16);
	    eval 'sub vrhaddq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrhaddq_m_s8);
	    eval 'sub vrhaddq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrhaddq_m_s32);
	    eval 'sub vrhaddq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrhaddq_m_s16);
	    eval 'sub vrhaddq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrhaddq_m_u8);
	    eval 'sub vrhaddq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrhaddq_m_u32);
	    eval 'sub vrhaddq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrhaddq_m_u16);
	    eval 'sub vrmulhq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrmulhq_m_s8);
	    eval 'sub vrmulhq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrmulhq_m_s32);
	    eval 'sub vrmulhq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrmulhq_m_s16);
	    eval 'sub vrmulhq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrmulhq_m_u8);
	    eval 'sub vrmulhq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrmulhq_m_u32);
	    eval 'sub vrmulhq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrmulhq_m_u16);
	    eval 'sub vrshlq_m_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_s8);
	    eval 'sub vrshlq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_s32);
	    eval 'sub vrshlq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_s16);
	    eval 'sub vrshlq_m_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_u8);
	    eval 'sub vrshlq_m_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_u32);
	    eval 'sub vrshlq_m_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_m_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vrshlq_m_u16);
	    eval 'sub vrshrq_m_n_s8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_m_n_s8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vrshrq_m_n_s8);
	    eval 'sub vrshrq_m_n_s32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_m_n_s32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vrshrq_m_n_s32);
	    eval 'sub vrshrq_m_n_s16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_m_n_s16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vrshrq_m_n_s16);
	    eval 'sub vrshrq_m_n_u8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_m_n_u8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vrshrq_m_n_u8);
	    eval 'sub vrshrq_m_n_u32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_m_n_u32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vrshrq_m_n_u32);
	    eval 'sub vrshrq_m_n_u16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_m_n_u16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vrshrq_m_n_u16);
	    eval 'sub vshlq_m_n_s8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_m_n_s8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlq_m_n_s8);
	    eval 'sub vshlq_m_n_s32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_m_n_s32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlq_m_n_s32);
	    eval 'sub vshlq_m_n_s16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_m_n_s16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlq_m_n_s16);
	    eval 'sub vshlq_m_n_u8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_m_n_u8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlq_m_n_u8);
	    eval 'sub vshlq_m_n_u32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_m_n_u32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlq_m_n_u32);
	    eval 'sub vshlq_m_n_u16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_m_n_u16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlq_m_n_u16);
	    eval 'sub vshrq_m_n_s8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_m_n_s8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshrq_m_n_s8);
	    eval 'sub vshrq_m_n_s32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_m_n_s32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshrq_m_n_s32);
	    eval 'sub vshrq_m_n_s16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_m_n_s16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshrq_m_n_s16);
	    eval 'sub vshrq_m_n_u8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_m_n_u8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshrq_m_n_u8);
	    eval 'sub vshrq_m_n_u32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_m_n_u32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshrq_m_n_u32);
	    eval 'sub vshrq_m_n_u16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_m_n_u16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshrq_m_n_u16);
	    eval 'sub vsliq_m_n_s8 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsliq_m_n_s8($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsliq_m_n_s8);
	    eval 'sub vsliq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsliq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsliq_m_n_s32);
	    eval 'sub vsliq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsliq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsliq_m_n_s16);
	    eval 'sub vsliq_m_n_u8 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsliq_m_n_u8($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsliq_m_n_u8);
	    eval 'sub vsliq_m_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsliq_m_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsliq_m_n_u32);
	    eval 'sub vsliq_m_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vsliq_m_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vsliq_m_n_u16);
	    eval 'sub vsubq_m_n_s8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_n_s8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_n_s8);
	    eval 'sub vsubq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_n_s32);
	    eval 'sub vsubq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_n_s16);
	    eval 'sub vsubq_m_n_u8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_n_u8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_n_u8);
	    eval 'sub vsubq_m_n_u32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_n_u32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_n_u32);
	    eval 'sub vsubq_m_n_u16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_n_u16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_n_u16);
	    eval 'sub vmlaldavaq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaldavaq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaldavaq_p_s32);
	    eval 'sub vmlaldavaq_p_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaldavaq_p_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaldavaq_p_s16);
	    eval 'sub vmlaldavaq_p_u32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaldavaq_p_u32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaldavaq_p_u32);
	    eval 'sub vmlaldavaq_p_u16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaldavaq_p_u16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaldavaq_p_u16);
	    eval 'sub vmlaldavaxq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaldavaxq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaldavaxq_p_s32);
	    eval 'sub vmlaldavaxq_p_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlaldavaxq_p_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlaldavaxq_p_s16);
	    eval 'sub vmlsldavaq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsldavaq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsldavaq_p_s32);
	    eval 'sub vmlsldavaq_p_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsldavaq_p_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsldavaq_p_s16);
	    eval 'sub vmlsldavaxq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsldavaxq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsldavaxq_p_s32);
	    eval 'sub vmlsldavaxq_p_s16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vmlsldavaxq_p_s16($__a, $__b, $__c, $__p));
	    }' unless defined(&vmlsldavaxq_p_s16);
	    eval 'sub vmullbq_poly_m_p8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_poly_m_p8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmullbq_poly_m_p8);
	    eval 'sub vmullbq_poly_m_p16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_poly_m_p16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmullbq_poly_m_p16);
	    eval 'sub vmulltq_poly_m_p8 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_poly_m_p8($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulltq_poly_m_p8);
	    eval 'sub vmulltq_poly_m_p16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_poly_m_p16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulltq_poly_m_p16);
	    eval 'sub vqdmullbq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmullbq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmullbq_m_n_s32);
	    eval 'sub vqdmullbq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmullbq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmullbq_m_n_s16);
	    eval 'sub vqdmullbq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmullbq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmullbq_m_s32);
	    eval 'sub vqdmullbq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmullbq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmullbq_m_s16);
	    eval 'sub vqdmulltq_m_n_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulltq_m_n_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulltq_m_n_s32);
	    eval 'sub vqdmulltq_m_n_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulltq_m_n_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulltq_m_n_s16);
	    eval 'sub vqdmulltq_m_s32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulltq_m_s32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulltq_m_s32);
	    eval 'sub vqdmulltq_m_s16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vqdmulltq_m_s16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vqdmulltq_m_s16);
	    eval 'sub vqrshrnbq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrnbq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrnbq_m_n_s32);
	    eval 'sub vqrshrnbq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrnbq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrnbq_m_n_s16);
	    eval 'sub vqrshrnbq_m_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrnbq_m_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrnbq_m_n_u32);
	    eval 'sub vqrshrnbq_m_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrnbq_m_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrnbq_m_n_u16);
	    eval 'sub vqrshrntq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrntq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrntq_m_n_s32);
	    eval 'sub vqrshrntq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrntq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrntq_m_n_s16);
	    eval 'sub vqrshrntq_m_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrntq_m_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrntq_m_n_u32);
	    eval 'sub vqrshrntq_m_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrntq_m_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrntq_m_n_u16);
	    eval 'sub vqrshrunbq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrunbq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrunbq_m_n_s32);
	    eval 'sub vqrshrunbq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshrunbq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshrunbq_m_n_s16);
	    eval 'sub vqrshruntq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshruntq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshruntq_m_n_s32);
	    eval 'sub vqrshruntq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqrshruntq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqrshruntq_m_n_s16);
	    eval 'sub vqshrnbq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshrnbq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrnbq_m_n_s32);
	    eval 'sub vqshrnbq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshrnbq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrnbq_m_n_s16);
	    eval 'sub vqshrnbq_m_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshrnbq_m_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrnbq_m_n_u32);
	    eval 'sub vqshrnbq_m_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshrnbq_m_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrnbq_m_n_u16);
	    eval 'sub vqshrntq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshrntq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrntq_m_n_s32);
	    eval 'sub vqshrntq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshrntq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrntq_m_n_s16);
	    eval 'sub vqshrntq_m_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshrntq_m_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrntq_m_n_u32);
	    eval 'sub vqshrntq_m_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshrntq_m_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrntq_m_n_u16);
	    eval 'sub vqshrunbq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshrunbq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrunbq_m_n_s32);
	    eval 'sub vqshrunbq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshrunbq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshrunbq_m_n_s16);
	    eval 'sub vqshruntq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshruntq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshruntq_m_n_s32);
	    eval 'sub vqshruntq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vqshruntq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vqshruntq_m_n_s16);
	    eval 'sub vrmlaldavhaq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vrmlaldavhaq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vrmlaldavhaq_p_s32);
	    eval 'sub vrmlaldavhaq_p_u32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vrmlaldavhaq_p_u32($__a, $__b, $__c, $__p));
	    }' unless defined(&vrmlaldavhaq_p_u32);
	    eval 'sub vrmlaldavhaxq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vrmlaldavhaxq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vrmlaldavhaxq_p_s32);
	    eval 'sub vrmlsldavhaq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vrmlsldavhaq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vrmlsldavhaq_p_s32);
	    eval 'sub vrmlsldavhaxq_p_s32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vrmlsldavhaxq_p_s32($__a, $__b, $__c, $__p));
	    }' unless defined(&vrmlsldavhaxq_p_s32);
	    eval 'sub vrshrnbq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrnbq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vrshrnbq_m_n_s32);
	    eval 'sub vrshrnbq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrnbq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vrshrnbq_m_n_s16);
	    eval 'sub vrshrnbq_m_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrnbq_m_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vrshrnbq_m_n_u32);
	    eval 'sub vrshrnbq_m_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrnbq_m_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vrshrnbq_m_n_u16);
	    eval 'sub vrshrntq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrntq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vrshrntq_m_n_s32);
	    eval 'sub vrshrntq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrntq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vrshrntq_m_n_s16);
	    eval 'sub vrshrntq_m_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrntq_m_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vrshrntq_m_n_u32);
	    eval 'sub vrshrntq_m_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrntq_m_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vrshrntq_m_n_u16);
	    eval 'sub vshllbq_m_n_s8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshllbq_m_n_s8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshllbq_m_n_s8);
	    eval 'sub vshllbq_m_n_s16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshllbq_m_n_s16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshllbq_m_n_s16);
	    eval 'sub vshllbq_m_n_u8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshllbq_m_n_u8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshllbq_m_n_u8);
	    eval 'sub vshllbq_m_n_u16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshllbq_m_n_u16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshllbq_m_n_u16);
	    eval 'sub vshlltq_m_n_s8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlltq_m_n_s8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlltq_m_n_s8);
	    eval 'sub vshlltq_m_n_s16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlltq_m_n_s16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlltq_m_n_s16);
	    eval 'sub vshlltq_m_n_u8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlltq_m_n_u8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlltq_m_n_u8);
	    eval 'sub vshlltq_m_n_u16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlltq_m_n_u16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vshlltq_m_n_u16);
	    eval 'sub vshrnbq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrnbq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshrnbq_m_n_s32);
	    eval 'sub vshrnbq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrnbq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshrnbq_m_n_s16);
	    eval 'sub vshrnbq_m_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrnbq_m_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshrnbq_m_n_u32);
	    eval 'sub vshrnbq_m_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrnbq_m_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshrnbq_m_n_u16);
	    eval 'sub vshrntq_m_n_s32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrntq_m_n_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshrntq_m_n_s32);
	    eval 'sub vshrntq_m_n_s16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrntq_m_n_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshrntq_m_n_s16);
	    eval 'sub vshrntq_m_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrntq_m_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshrntq_m_n_u32);
	    eval 'sub vshrntq_m_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrntq_m_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshrntq_m_n_u16);
	    eval 'sub vabdq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vabdq_m_f32);
	    eval 'sub vabdq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vabdq_m_f16);
	    eval 'sub vaddq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_f32);
	    eval 'sub vaddq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_f16);
	    eval 'sub vaddq_m_n_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_n_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_n_f32);
	    eval 'sub vaddq_m_n_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_m_n_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vaddq_m_n_f16);
	    eval 'sub vandq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vandq_m_f32);
	    eval 'sub vandq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vandq_m_f16);
	    eval 'sub vbicq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbicq_m_f32);
	    eval 'sub vbicq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbicq_m_f16);
	    eval 'sub vbrsrq_m_n_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_m_n_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbrsrq_m_n_f32);
	    eval 'sub vbrsrq_m_n_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_m_n_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vbrsrq_m_n_f16);
	    eval 'sub vcaddq_rot270_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_m_f32);
	    eval 'sub vcaddq_rot270_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_m_f16);
	    eval 'sub vcaddq_rot90_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_m_f32);
	    eval 'sub vcaddq_rot90_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_m_f16);
	    eval 'sub vcmlaq_m_f32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_m_f32($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_m_f32);
	    eval 'sub vcmlaq_m_f16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_m_f16($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_m_f16);
	    eval 'sub vcmlaq_rot180_m_f32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_rot180_m_f32($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_rot180_m_f32);
	    eval 'sub vcmlaq_rot180_m_f16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_rot180_m_f16($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_rot180_m_f16);
	    eval 'sub vcmlaq_rot270_m_f32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_rot270_m_f32($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_rot270_m_f32);
	    eval 'sub vcmlaq_rot270_m_f16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_rot270_m_f16($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_rot270_m_f16);
	    eval 'sub vcmlaq_rot90_m_f32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_rot90_m_f32($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_rot90_m_f32);
	    eval 'sub vcmlaq_rot90_m_f16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vcmlaq_rot90_m_f16($__a, $__b, $__c, $__p));
	    }' unless defined(&vcmlaq_rot90_m_f16);
	    eval 'sub vcmulq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_m_f32);
	    eval 'sub vcmulq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_m_f16);
	    eval 'sub vcmulq_rot180_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot180_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot180_m_f32);
	    eval 'sub vcmulq_rot180_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot180_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot180_m_f16);
	    eval 'sub vcmulq_rot270_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot270_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot270_m_f32);
	    eval 'sub vcmulq_rot270_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot270_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot270_m_f16);
	    eval 'sub vcmulq_rot90_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot90_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot90_m_f32);
	    eval 'sub vcmulq_rot90_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot90_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot90_m_f16);
	    eval 'sub vcvtq_m_n_s32_f32 {
	        my($__inactive, $__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_m_n_s32_f32($__inactive, $__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_m_n_s32_f32);
	    eval 'sub vcvtq_m_n_s16_f16 {
	        my($__inactive, $__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_m_n_s16_f16($__inactive, $__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_m_n_s16_f16);
	    eval 'sub vcvtq_m_n_u32_f32 {
	        my($__inactive, $__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_m_n_u32_f32($__inactive, $__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_m_n_u32_f32);
	    eval 'sub vcvtq_m_n_u16_f16 {
	        my($__inactive, $__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_m_n_u16_f16($__inactive, $__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_m_n_u16_f16);
	    eval 'sub veorq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&veorq_m_f32);
	    eval 'sub veorq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&veorq_m_f16);
	    eval 'sub vfmaq_m_f32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmaq_m_f32($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmaq_m_f32);
	    eval 'sub vfmaq_m_f16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmaq_m_f16($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmaq_m_f16);
	    eval 'sub vfmaq_m_n_f32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmaq_m_n_f32($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmaq_m_n_f32);
	    eval 'sub vfmaq_m_n_f16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmaq_m_n_f16($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmaq_m_n_f16);
	    eval 'sub vfmasq_m_n_f32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmasq_m_n_f32($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmasq_m_n_f32);
	    eval 'sub vfmasq_m_n_f16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmasq_m_n_f16($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmasq_m_n_f16);
	    eval 'sub vfmsq_m_f32 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmsq_m_f32($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmsq_m_f32);
	    eval 'sub vfmsq_m_f16 {
	        my($__a, $__b, $__c, $__p) = @_;
    		eval q( &__arm_vfmsq_m_f16($__a, $__b, $__c, $__p));
	    }' unless defined(&vfmsq_m_f16);
	    eval 'sub vmaxnmq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmaxnmq_m_f32);
	    eval 'sub vmaxnmq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmaxnmq_m_f16);
	    eval 'sub vminnmq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vminnmq_m_f32);
	    eval 'sub vminnmq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vminnmq_m_f16);
	    eval 'sub vmulq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_f32);
	    eval 'sub vmulq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_f16);
	    eval 'sub vmulq_m_n_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_n_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_n_f32);
	    eval 'sub vmulq_m_n_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_m_n_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vmulq_m_n_f16);
	    eval 'sub vornq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vornq_m_f32);
	    eval 'sub vornq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vornq_m_f16);
	    eval 'sub vorrq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vorrq_m_f32);
	    eval 'sub vorrq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vorrq_m_f16);
	    eval 'sub vsubq_m_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_f32);
	    eval 'sub vsubq_m_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_f16);
	    eval 'sub vsubq_m_n_f32 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_n_f32($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_n_f32);
	    eval 'sub vsubq_m_n_f16 {
	        my($__inactive, $__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_m_n_f16($__inactive, $__a, $__b, $__p));
	    }' unless defined(&vsubq_m_n_f16);
	    eval 'sub vstrbq_s8 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vstrbq_s8( $__addr, $__value));
	    }' unless defined(&vstrbq_s8);
	    eval 'sub vstrbq_u8 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vstrbq_u8( $__addr, $__value));
	    }' unless defined(&vstrbq_u8);
	    eval 'sub vstrbq_u16 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vstrbq_u16( $__addr, $__value));
	    }' unless defined(&vstrbq_u16);
	    eval 'sub vstrbq_scatter_offset_s8 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_s8( $__base, $__offset, $__value));
	    }' unless defined(&vstrbq_scatter_offset_s8);
	    eval 'sub vstrbq_scatter_offset_u8 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_u8( $__base, $__offset, $__value));
	    }' unless defined(&vstrbq_scatter_offset_u8);
	    eval 'sub vstrbq_scatter_offset_u16 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_u16( $__base, $__offset, $__value));
	    }' unless defined(&vstrbq_scatter_offset_u16);
	    eval 'sub vstrbq_s16 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vstrbq_s16( $__addr, $__value));
	    }' unless defined(&vstrbq_s16);
	    eval 'sub vstrbq_u32 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vstrbq_u32( $__addr, $__value));
	    }' unless defined(&vstrbq_u32);
	    eval 'sub vstrbq_scatter_offset_s16 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_s16( $__base, $__offset, $__value));
	    }' unless defined(&vstrbq_scatter_offset_s16);
	    eval 'sub vstrbq_scatter_offset_u32 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_u32( $__base, $__offset, $__value));
	    }' unless defined(&vstrbq_scatter_offset_u32);
	    eval 'sub vstrbq_s32 {
	        my( $__addr, $__value) = @_;
    		eval q( &__arm_vstrbq_s32( $__addr, $__value));
	    }' unless defined(&vstrbq_s32);
	    eval 'sub vstrbq_scatter_offset_s32 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_s32( $__base, $__offset, $__value));
	    }' unless defined(&vstrbq_scatter_offset_s32);
	    eval 'sub vstrwq_scatter_base_s32 {
	        my($__addr,  $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_base_s32($__addr, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_base_s32);
	    eval 'sub vstrwq_scatter_base_u32 {
	        my($__addr,  $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_base_u32($__addr, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_base_u32);
	    eval 'sub vldrbq_gather_offset_u8 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrbq_gather_offset_u8($__base, $__offset));
	    }' unless defined(&vldrbq_gather_offset_u8);
	    eval 'sub vldrbq_gather_offset_s8 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrbq_gather_offset_s8($__base, $__offset));
	    }' unless defined(&vldrbq_gather_offset_s8);
	    eval 'sub vldrbq_s8 {
	        my($__base) = @_;
    		eval q( &__arm_vldrbq_s8($__base));
	    }' unless defined(&vldrbq_s8);
	    eval 'sub vldrbq_u8 {
	        my($__base) = @_;
    		eval q( &__arm_vldrbq_u8($__base));
	    }' unless defined(&vldrbq_u8);
	    eval 'sub vldrbq_gather_offset_u16 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrbq_gather_offset_u16($__base, $__offset));
	    }' unless defined(&vldrbq_gather_offset_u16);
	    eval 'sub vldrbq_gather_offset_s16 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrbq_gather_offset_s16($__base, $__offset));
	    }' unless defined(&vldrbq_gather_offset_s16);
	    eval 'sub vldrbq_s16 {
	        my($__base) = @_;
    		eval q( &__arm_vldrbq_s16($__base));
	    }' unless defined(&vldrbq_s16);
	    eval 'sub vldrbq_u16 {
	        my($__base) = @_;
    		eval q( &__arm_vldrbq_u16($__base));
	    }' unless defined(&vldrbq_u16);
	    eval 'sub vldrbq_gather_offset_u32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrbq_gather_offset_u32($__base, $__offset));
	    }' unless defined(&vldrbq_gather_offset_u32);
	    eval 'sub vldrbq_gather_offset_s32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrbq_gather_offset_s32($__base, $__offset));
	    }' unless defined(&vldrbq_gather_offset_s32);
	    eval 'sub vldrbq_s32 {
	        my($__base) = @_;
    		eval q( &__arm_vldrbq_s32($__base));
	    }' unless defined(&vldrbq_s32);
	    eval 'sub vldrbq_u32 {
	        my($__base) = @_;
    		eval q( &__arm_vldrbq_u32($__base));
	    }' unless defined(&vldrbq_u32);
	    eval 'sub vldrwq_gather_base_s32 {
	        my($__addr,  $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_base_s32($__addr, $__offset));
	    }' unless defined(&vldrwq_gather_base_s32);
	    eval 'sub vldrwq_gather_base_u32 {
	        my($__addr,  $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_base_u32($__addr, $__offset));
	    }' unless defined(&vldrwq_gather_base_u32);
	    eval 'sub vstrbq_p_s8 {
	        my( $__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_p_s8( $__addr, $__value, $__p));
	    }' unless defined(&vstrbq_p_s8);
	    eval 'sub vstrbq_p_s32 {
	        my( $__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_p_s32( $__addr, $__value, $__p));
	    }' unless defined(&vstrbq_p_s32);
	    eval 'sub vstrbq_p_s16 {
	        my( $__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_p_s16( $__addr, $__value, $__p));
	    }' unless defined(&vstrbq_p_s16);
	    eval 'sub vstrbq_p_u8 {
	        my( $__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_p_u8( $__addr, $__value, $__p));
	    }' unless defined(&vstrbq_p_u8);
	    eval 'sub vstrbq_p_u32 {
	        my( $__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_p_u32( $__addr, $__value, $__p));
	    }' unless defined(&vstrbq_p_u32);
	    eval 'sub vstrbq_p_u16 {
	        my( $__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_p_u16( $__addr, $__value, $__p));
	    }' unless defined(&vstrbq_p_u16);
	    eval 'sub vstrbq_scatter_offset_p_s8 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_p_s8( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrbq_scatter_offset_p_s8);
	    eval 'sub vstrbq_scatter_offset_p_s32 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_p_s32( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrbq_scatter_offset_p_s32);
	    eval 'sub vstrbq_scatter_offset_p_s16 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_p_s16( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrbq_scatter_offset_p_s16);
	    eval 'sub vstrbq_scatter_offset_p_u8 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_p_u8( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrbq_scatter_offset_p_u8);
	    eval 'sub vstrbq_scatter_offset_p_u32 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_p_u32( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrbq_scatter_offset_p_u32);
	    eval 'sub vstrbq_scatter_offset_p_u16 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrbq_scatter_offset_p_u16( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrbq_scatter_offset_p_u16);
	    eval 'sub vstrwq_scatter_base_p_s32 {
	        my($__addr,  $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_base_p_s32($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_base_p_s32);
	    eval 'sub vstrwq_scatter_base_p_u32 {
	        my($__addr,  $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_base_p_u32($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_base_p_u32);
	    eval 'sub vldrbq_gather_offset_z_s16 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrbq_gather_offset_z_s16($__base, $__offset, $__p));
	    }' unless defined(&vldrbq_gather_offset_z_s16);
	    eval 'sub vldrbq_gather_offset_z_u8 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrbq_gather_offset_z_u8($__base, $__offset, $__p));
	    }' unless defined(&vldrbq_gather_offset_z_u8);
	    eval 'sub vldrbq_gather_offset_z_s32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrbq_gather_offset_z_s32($__base, $__offset, $__p));
	    }' unless defined(&vldrbq_gather_offset_z_s32);
	    eval 'sub vldrbq_gather_offset_z_u16 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrbq_gather_offset_z_u16($__base, $__offset, $__p));
	    }' unless defined(&vldrbq_gather_offset_z_u16);
	    eval 'sub vldrbq_gather_offset_z_u32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrbq_gather_offset_z_u32($__base, $__offset, $__p));
	    }' unless defined(&vldrbq_gather_offset_z_u32);
	    eval 'sub vldrbq_gather_offset_z_s8 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrbq_gather_offset_z_s8($__base, $__offset, $__p));
	    }' unless defined(&vldrbq_gather_offset_z_s8);
	    eval 'sub vldrbq_z_s16 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrbq_z_s16($__base, $__p));
	    }' unless defined(&vldrbq_z_s16);
	    eval 'sub vldrbq_z_u8 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrbq_z_u8($__base, $__p));
	    }' unless defined(&vldrbq_z_u8);
	    eval 'sub vldrbq_z_s8 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrbq_z_s8($__base, $__p));
	    }' unless defined(&vldrbq_z_s8);
	    eval 'sub vldrbq_z_s32 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrbq_z_s32($__base, $__p));
	    }' unless defined(&vldrbq_z_s32);
	    eval 'sub vldrbq_z_u16 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrbq_z_u16($__base, $__p));
	    }' unless defined(&vldrbq_z_u16);
	    eval 'sub vldrbq_z_u32 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrbq_z_u32($__base, $__p));
	    }' unless defined(&vldrbq_z_u32);
	    eval 'sub vldrwq_gather_base_z_u32 {
	        my($__addr,  $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_base_z_u32($__addr, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_base_z_u32);
	    eval 'sub vldrwq_gather_base_z_s32 {
	        my($__addr,  $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_base_z_s32($__addr, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_base_z_s32);
	    eval 'sub vld1q_s8 {
	        my($__base) = @_;
    		eval q( &__arm_vld1q_s8($__base));
	    }' unless defined(&vld1q_s8);
	    eval 'sub vld1q_s32 {
	        my($__base) = @_;
    		eval q( &__arm_vld1q_s32($__base));
	    }' unless defined(&vld1q_s32);
	    eval 'sub vld1q_s16 {
	        my($__base) = @_;
    		eval q( &__arm_vld1q_s16($__base));
	    }' unless defined(&vld1q_s16);
	    eval 'sub vld1q_u8 {
	        my($__base) = @_;
    		eval q( &__arm_vld1q_u8($__base));
	    }' unless defined(&vld1q_u8);
	    eval 'sub vld1q_u32 {
	        my($__base) = @_;
    		eval q( &__arm_vld1q_u32($__base));
	    }' unless defined(&vld1q_u32);
	    eval 'sub vld1q_u16 {
	        my($__base) = @_;
    		eval q( &__arm_vld1q_u16($__base));
	    }' unless defined(&vld1q_u16);
	    eval 'sub vldrhq_gather_offset_s32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_offset_s32($__base, $__offset));
	    }' unless defined(&vldrhq_gather_offset_s32);
	    eval 'sub vldrhq_gather_offset_s16 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_offset_s16($__base, $__offset));
	    }' unless defined(&vldrhq_gather_offset_s16);
	    eval 'sub vldrhq_gather_offset_u32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_offset_u32($__base, $__offset));
	    }' unless defined(&vldrhq_gather_offset_u32);
	    eval 'sub vldrhq_gather_offset_u16 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_offset_u16($__base, $__offset));
	    }' unless defined(&vldrhq_gather_offset_u16);
	    eval 'sub vldrhq_gather_offset_z_s32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_offset_z_s32($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_offset_z_s32);
	    eval 'sub vldrhq_gather_offset_z_s16 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_offset_z_s16($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_offset_z_s16);
	    eval 'sub vldrhq_gather_offset_z_u32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_offset_z_u32($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_offset_z_u32);
	    eval 'sub vldrhq_gather_offset_z_u16 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_offset_z_u16($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_offset_z_u16);
	    eval 'sub vldrhq_gather_shifted_offset_s32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_s32($__base, $__offset));
	    }' unless defined(&vldrhq_gather_shifted_offset_s32);
	    eval 'sub vldrhq_gather_shifted_offset_s16 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_s16($__base, $__offset));
	    }' unless defined(&vldrhq_gather_shifted_offset_s16);
	    eval 'sub vldrhq_gather_shifted_offset_u32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_u32($__base, $__offset));
	    }' unless defined(&vldrhq_gather_shifted_offset_u32);
	    eval 'sub vldrhq_gather_shifted_offset_u16 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_u16($__base, $__offset));
	    }' unless defined(&vldrhq_gather_shifted_offset_u16);
	    eval 'sub vldrhq_gather_shifted_offset_z_s32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_z_s32($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_shifted_offset_z_s32);
	    eval 'sub vldrhq_gather_shifted_offset_z_s16 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_z_s16($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_shifted_offset_z_s16);
	    eval 'sub vldrhq_gather_shifted_offset_z_u32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_z_u32($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_shifted_offset_z_u32);
	    eval 'sub vldrhq_gather_shifted_offset_z_u16 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_z_u16($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_shifted_offset_z_u16);
	    eval 'sub vldrhq_s32 {
	        my($__base) = @_;
    		eval q( &__arm_vldrhq_s32($__base));
	    }' unless defined(&vldrhq_s32);
	    eval 'sub vldrhq_s16 {
	        my($__base) = @_;
    		eval q( &__arm_vldrhq_s16($__base));
	    }' unless defined(&vldrhq_s16);
	    eval 'sub vldrhq_u32 {
	        my($__base) = @_;
    		eval q( &__arm_vldrhq_u32($__base));
	    }' unless defined(&vldrhq_u32);
	    eval 'sub vldrhq_u16 {
	        my($__base) = @_;
    		eval q( &__arm_vldrhq_u16($__base));
	    }' unless defined(&vldrhq_u16);
	    eval 'sub vldrhq_z_s32 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrhq_z_s32($__base, $__p));
	    }' unless defined(&vldrhq_z_s32);
	    eval 'sub vldrhq_z_s16 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrhq_z_s16($__base, $__p));
	    }' unless defined(&vldrhq_z_s16);
	    eval 'sub vldrhq_z_u32 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrhq_z_u32($__base, $__p));
	    }' unless defined(&vldrhq_z_u32);
	    eval 'sub vldrhq_z_u16 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrhq_z_u16($__base, $__p));
	    }' unless defined(&vldrhq_z_u16);
	    eval 'sub vldrwq_s32 {
	        my($__base) = @_;
    		eval q( &__arm_vldrwq_s32($__base));
	    }' unless defined(&vldrwq_s32);
	    eval 'sub vldrwq_u32 {
	        my($__base) = @_;
    		eval q( &__arm_vldrwq_u32($__base));
	    }' unless defined(&vldrwq_u32);
	    eval 'sub vldrwq_z_s32 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrwq_z_s32($__base, $__p));
	    }' unless defined(&vldrwq_z_s32);
	    eval 'sub vldrwq_z_u32 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrwq_z_u32($__base, $__p));
	    }' unless defined(&vldrwq_z_u32);
	    eval 'sub vld1q_f32 {
	        my($__base) = @_;
    		eval q( &__arm_vld1q_f32($__base));
	    }' unless defined(&vld1q_f32);
	    eval 'sub vld1q_f16 {
	        my($__base) = @_;
    		eval q( &__arm_vld1q_f16($__base));
	    }' unless defined(&vld1q_f16);
	    eval 'sub vldrhq_f16 {
	        my($__base) = @_;
    		eval q( &__arm_vldrhq_f16($__base));
	    }' unless defined(&vldrhq_f16);
	    eval 'sub vldrhq_z_f16 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrhq_z_f16($__base, $__p));
	    }' unless defined(&vldrhq_z_f16);
	    eval 'sub vldrwq_f32 {
	        my($__base) = @_;
    		eval q( &__arm_vldrwq_f32($__base));
	    }' unless defined(&vldrwq_f32);
	    eval 'sub vldrwq_z_f32 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vldrwq_z_f32($__base, $__p));
	    }' unless defined(&vldrwq_z_f32);
	    eval 'sub vldrdq_gather_base_s64 {
	        my($__addr,  $__offset) = @_;
    		eval q( &__arm_vldrdq_gather_base_s64($__addr, $__offset));
	    }' unless defined(&vldrdq_gather_base_s64);
	    eval 'sub vldrdq_gather_base_u64 {
	        my($__addr,  $__offset) = @_;
    		eval q( &__arm_vldrdq_gather_base_u64($__addr, $__offset));
	    }' unless defined(&vldrdq_gather_base_u64);
	    eval 'sub vldrdq_gather_base_z_s64 {
	        my($__addr,  $__offset, $__p) = @_;
    		eval q( &__arm_vldrdq_gather_base_z_s64($__addr, $__offset, $__p));
	    }' unless defined(&vldrdq_gather_base_z_s64);
	    eval 'sub vldrdq_gather_base_z_u64 {
	        my($__addr,  $__offset, $__p) = @_;
    		eval q( &__arm_vldrdq_gather_base_z_u64($__addr, $__offset, $__p));
	    }' unless defined(&vldrdq_gather_base_z_u64);
	    eval 'sub vldrdq_gather_offset_s64 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrdq_gather_offset_s64($__base, $__offset));
	    }' unless defined(&vldrdq_gather_offset_s64);
	    eval 'sub vldrdq_gather_offset_u64 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrdq_gather_offset_u64($__base, $__offset));
	    }' unless defined(&vldrdq_gather_offset_u64);
	    eval 'sub vldrdq_gather_offset_z_s64 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrdq_gather_offset_z_s64($__base, $__offset, $__p));
	    }' unless defined(&vldrdq_gather_offset_z_s64);
	    eval 'sub vldrdq_gather_offset_z_u64 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrdq_gather_offset_z_u64($__base, $__offset, $__p));
	    }' unless defined(&vldrdq_gather_offset_z_u64);
	    eval 'sub vldrdq_gather_shifted_offset_s64 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrdq_gather_shifted_offset_s64($__base, $__offset));
	    }' unless defined(&vldrdq_gather_shifted_offset_s64);
	    eval 'sub vldrdq_gather_shifted_offset_u64 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrdq_gather_shifted_offset_u64($__base, $__offset));
	    }' unless defined(&vldrdq_gather_shifted_offset_u64);
	    eval 'sub vldrdq_gather_shifted_offset_z_s64 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrdq_gather_shifted_offset_z_s64($__base, $__offset, $__p));
	    }' unless defined(&vldrdq_gather_shifted_offset_z_s64);
	    eval 'sub vldrdq_gather_shifted_offset_z_u64 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrdq_gather_shifted_offset_z_u64($__base, $__offset, $__p));
	    }' unless defined(&vldrdq_gather_shifted_offset_z_u64);
	    eval 'sub vldrhq_gather_offset_f16 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_offset_f16($__base, $__offset));
	    }' unless defined(&vldrhq_gather_offset_f16);
	    eval 'sub vldrhq_gather_offset_z_f16 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_offset_z_f16($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_offset_z_f16);
	    eval 'sub vldrhq_gather_shifted_offset_f16 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_f16($__base, $__offset));
	    }' unless defined(&vldrhq_gather_shifted_offset_f16);
	    eval 'sub vldrhq_gather_shifted_offset_z_f16 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrhq_gather_shifted_offset_z_f16($__base, $__offset, $__p));
	    }' unless defined(&vldrhq_gather_shifted_offset_z_f16);
	    eval 'sub vldrwq_gather_base_f32 {
	        my($__addr,  $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_base_f32($__addr, $__offset));
	    }' unless defined(&vldrwq_gather_base_f32);
	    eval 'sub vldrwq_gather_base_z_f32 {
	        my($__addr,  $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_base_z_f32($__addr, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_base_z_f32);
	    eval 'sub vldrwq_gather_offset_f32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_offset_f32($__base, $__offset));
	    }' unless defined(&vldrwq_gather_offset_f32);
	    eval 'sub vldrwq_gather_offset_s32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_offset_s32($__base, $__offset));
	    }' unless defined(&vldrwq_gather_offset_s32);
	    eval 'sub vldrwq_gather_offset_u32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_offset_u32($__base, $__offset));
	    }' unless defined(&vldrwq_gather_offset_u32);
	    eval 'sub vldrwq_gather_offset_z_f32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_offset_z_f32($__base, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_offset_z_f32);
	    eval 'sub vldrwq_gather_offset_z_s32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_offset_z_s32($__base, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_offset_z_s32);
	    eval 'sub vldrwq_gather_offset_z_u32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_offset_z_u32($__base, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_offset_z_u32);
	    eval 'sub vldrwq_gather_shifted_offset_f32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_shifted_offset_f32($__base, $__offset));
	    }' unless defined(&vldrwq_gather_shifted_offset_f32);
	    eval 'sub vldrwq_gather_shifted_offset_s32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_shifted_offset_s32($__base, $__offset));
	    }' unless defined(&vldrwq_gather_shifted_offset_s32);
	    eval 'sub vldrwq_gather_shifted_offset_u32 {
	        my($__base, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_shifted_offset_u32($__base, $__offset));
	    }' unless defined(&vldrwq_gather_shifted_offset_u32);
	    eval 'sub vldrwq_gather_shifted_offset_z_f32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_shifted_offset_z_f32($__base, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_shifted_offset_z_f32);
	    eval 'sub vldrwq_gather_shifted_offset_z_s32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_shifted_offset_z_s32($__base, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_shifted_offset_z_s32);
	    eval 'sub vldrwq_gather_shifted_offset_z_u32 {
	        my($__base, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_shifted_offset_z_u32($__base, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_shifted_offset_z_u32);
	    eval 'sub vst1q_f32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst1q_f32($__addr, $__value));
	    }' unless defined(&vst1q_f32);
	    eval 'sub vst1q_f16 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst1q_f16($__addr, $__value));
	    }' unless defined(&vst1q_f16);
	    eval 'sub vst1q_s8 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst1q_s8($__addr, $__value));
	    }' unless defined(&vst1q_s8);
	    eval 'sub vst1q_s32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst1q_s32($__addr, $__value));
	    }' unless defined(&vst1q_s32);
	    eval 'sub vst1q_s16 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst1q_s16($__addr, $__value));
	    }' unless defined(&vst1q_s16);
	    eval 'sub vst1q_u8 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst1q_u8($__addr, $__value));
	    }' unless defined(&vst1q_u8);
	    eval 'sub vst1q_u32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst1q_u32($__addr, $__value));
	    }' unless defined(&vst1q_u32);
	    eval 'sub vst1q_u16 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst1q_u16($__addr, $__value));
	    }' unless defined(&vst1q_u16);
	    eval 'sub vstrhq_f16 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrhq_f16($__addr, $__value));
	    }' unless defined(&vstrhq_f16);
	    eval 'sub vstrhq_scatter_offset_s32 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_s32( $__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_offset_s32);
	    eval 'sub vstrhq_scatter_offset_s16 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_s16( $__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_offset_s16);
	    eval 'sub vstrhq_scatter_offset_u32 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_u32( $__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_offset_u32);
	    eval 'sub vstrhq_scatter_offset_u16 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_u16( $__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_offset_u16);
	    eval 'sub vstrhq_scatter_offset_p_s32 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_p_s32( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_offset_p_s32);
	    eval 'sub vstrhq_scatter_offset_p_s16 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_p_s16( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_offset_p_s16);
	    eval 'sub vstrhq_scatter_offset_p_u32 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_p_u32( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_offset_p_u32);
	    eval 'sub vstrhq_scatter_offset_p_u16 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_p_u16( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_offset_p_u16);
	    eval 'sub vstrhq_scatter_shifted_offset_s32 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_s32( $__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_shifted_offset_s32);
	    eval 'sub vstrhq_scatter_shifted_offset_s16 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_s16( $__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_shifted_offset_s16);
	    eval 'sub vstrhq_scatter_shifted_offset_u32 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_u32( $__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_shifted_offset_u32);
	    eval 'sub vstrhq_scatter_shifted_offset_u16 {
	        my( $__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_u16( $__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_shifted_offset_u16);
	    eval 'sub vstrhq_scatter_shifted_offset_p_s32 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_p_s32( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_shifted_offset_p_s32);
	    eval 'sub vstrhq_scatter_shifted_offset_p_s16 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_p_s16( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_shifted_offset_p_s16);
	    eval 'sub vstrhq_scatter_shifted_offset_p_u32 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_p_u32( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_shifted_offset_p_u32);
	    eval 'sub vstrhq_scatter_shifted_offset_p_u16 {
	        my( $__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_p_u16( $__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_shifted_offset_p_u16);
	    eval 'sub vstrhq_s32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrhq_s32($__addr, $__value));
	    }' unless defined(&vstrhq_s32);
	    eval 'sub vstrhq_s16 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrhq_s16($__addr, $__value));
	    }' unless defined(&vstrhq_s16);
	    eval 'sub vstrhq_u32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrhq_u32($__addr, $__value));
	    }' unless defined(&vstrhq_u32);
	    eval 'sub vstrhq_u16 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrhq_u16($__addr, $__value));
	    }' unless defined(&vstrhq_u16);
	    eval 'sub vstrhq_p_f16 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_p_f16($__addr, $__value, $__p));
	    }' unless defined(&vstrhq_p_f16);
	    eval 'sub vstrhq_p_s32 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_p_s32($__addr, $__value, $__p));
	    }' unless defined(&vstrhq_p_s32);
	    eval 'sub vstrhq_p_s16 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_p_s16($__addr, $__value, $__p));
	    }' unless defined(&vstrhq_p_s16);
	    eval 'sub vstrhq_p_u32 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_p_u32($__addr, $__value, $__p));
	    }' unless defined(&vstrhq_p_u32);
	    eval 'sub vstrhq_p_u16 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_p_u16($__addr, $__value, $__p));
	    }' unless defined(&vstrhq_p_u16);
	    eval 'sub vstrwq_f32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrwq_f32($__addr, $__value));
	    }' unless defined(&vstrwq_f32);
	    eval 'sub vstrwq_s32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrwq_s32($__addr, $__value));
	    }' unless defined(&vstrwq_s32);
	    eval 'sub vstrwq_u32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vstrwq_u32($__addr, $__value));
	    }' unless defined(&vstrwq_u32);
	    eval 'sub vstrwq_p_f32 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_p_f32($__addr, $__value, $__p));
	    }' unless defined(&vstrwq_p_f32);
	    eval 'sub vstrwq_p_s32 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_p_s32($__addr, $__value, $__p));
	    }' unless defined(&vstrwq_p_s32);
	    eval 'sub vstrwq_p_u32 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_p_u32($__addr, $__value, $__p));
	    }' unless defined(&vstrwq_p_u32);
	    eval 'sub vstrdq_scatter_base_p_s64 {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_base_p_s64($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_base_p_s64);
	    eval 'sub vstrdq_scatter_base_p_u64 {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_base_p_u64($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_base_p_u64);
	    eval 'sub vstrdq_scatter_base_s64 {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_base_s64($__addr, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_base_s64);
	    eval 'sub vstrdq_scatter_base_u64 {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_base_u64($__addr, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_base_u64);
	    eval 'sub vstrdq_scatter_offset_p_s64 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_offset_p_s64($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_offset_p_s64);
	    eval 'sub vstrdq_scatter_offset_p_u64 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_offset_p_u64($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_offset_p_u64);
	    eval 'sub vstrdq_scatter_offset_s64 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_offset_s64($__base, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_offset_s64);
	    eval 'sub vstrdq_scatter_offset_u64 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_offset_u64($__base, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_offset_u64);
	    eval 'sub vstrdq_scatter_shifted_offset_p_s64 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_shifted_offset_p_s64($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_shifted_offset_p_s64);
	    eval 'sub vstrdq_scatter_shifted_offset_p_u64 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_shifted_offset_p_u64($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_shifted_offset_p_u64);
	    eval 'sub vstrdq_scatter_shifted_offset_s64 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_shifted_offset_s64($__base, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_shifted_offset_s64);
	    eval 'sub vstrdq_scatter_shifted_offset_u64 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_shifted_offset_u64($__base, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_shifted_offset_u64);
	    eval 'sub vstrhq_scatter_offset_f16 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_f16($__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_offset_f16);
	    eval 'sub vstrhq_scatter_offset_p_f16 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_offset_p_f16($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_offset_p_f16);
	    eval 'sub vstrhq_scatter_shifted_offset_f16 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_f16($__base, $__offset, $__value));
	    }' unless defined(&vstrhq_scatter_shifted_offset_f16);
	    eval 'sub vstrhq_scatter_shifted_offset_p_f16 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrhq_scatter_shifted_offset_p_f16($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrhq_scatter_shifted_offset_p_f16);
	    eval 'sub vstrwq_scatter_base_f32 {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_base_f32($__addr, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_base_f32);
	    eval 'sub vstrwq_scatter_base_p_f32 {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_base_p_f32($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_base_p_f32);
	    eval 'sub vstrwq_scatter_offset_f32 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_offset_f32($__base, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_offset_f32);
	    eval 'sub vstrwq_scatter_offset_p_f32 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_offset_p_f32($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_offset_p_f32);
	    eval 'sub vstrwq_scatter_offset_p_s32 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_offset_p_s32($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_offset_p_s32);
	    eval 'sub vstrwq_scatter_offset_p_u32 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_offset_p_u32($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_offset_p_u32);
	    eval 'sub vstrwq_scatter_offset_s32 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_offset_s32($__base, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_offset_s32);
	    eval 'sub vstrwq_scatter_offset_u32 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_offset_u32($__base, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_offset_u32);
	    eval 'sub vstrwq_scatter_shifted_offset_f32 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_shifted_offset_f32($__base, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_shifted_offset_f32);
	    eval 'sub vstrwq_scatter_shifted_offset_p_f32 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_shifted_offset_p_f32($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_shifted_offset_p_f32);
	    eval 'sub vstrwq_scatter_shifted_offset_p_s32 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_shifted_offset_p_s32($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_shifted_offset_p_s32);
	    eval 'sub vstrwq_scatter_shifted_offset_p_u32 {
	        my($__base, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_shifted_offset_p_u32($__base, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_shifted_offset_p_u32);
	    eval 'sub vstrwq_scatter_shifted_offset_s32 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_shifted_offset_s32($__base, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_shifted_offset_s32);
	    eval 'sub vstrwq_scatter_shifted_offset_u32 {
	        my($__base, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_shifted_offset_u32($__base, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_shifted_offset_u32);
	    eval 'sub vaddq_s8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_s8($__a, $__b));
	    }' unless defined(&vaddq_s8);
	    eval 'sub vaddq_s16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_s16($__a, $__b));
	    }' unless defined(&vaddq_s16);
	    eval 'sub vaddq_s32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_s32($__a, $__b));
	    }' unless defined(&vaddq_s32);
	    eval 'sub vaddq_u8 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_u8($__a, $__b));
	    }' unless defined(&vaddq_u8);
	    eval 'sub vaddq_u16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_u16($__a, $__b));
	    }' unless defined(&vaddq_u16);
	    eval 'sub vaddq_u32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_u32($__a, $__b));
	    }' unless defined(&vaddq_u32);
	    eval 'sub vaddq_f16 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_f16($__a, $__b));
	    }' unless defined(&vaddq_f16);
	    eval 'sub vaddq_f32 {
	        my($__a, $__b) = @_;
    		eval q( &__arm_vaddq_f32($__a, $__b));
	    }' unless defined(&vaddq_f32);
	    eval 'sub vreinterpretq_s16_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s16_s32($__a));
	    }' unless defined(&vreinterpretq_s16_s32);
	    eval 'sub vreinterpretq_s16_s64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s16_s64($__a));
	    }' unless defined(&vreinterpretq_s16_s64);
	    eval 'sub vreinterpretq_s16_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s16_s8($__a));
	    }' unless defined(&vreinterpretq_s16_s8);
	    eval 'sub vreinterpretq_s16_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s16_u16($__a));
	    }' unless defined(&vreinterpretq_s16_u16);
	    eval 'sub vreinterpretq_s16_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s16_u32($__a));
	    }' unless defined(&vreinterpretq_s16_u32);
	    eval 'sub vreinterpretq_s16_u64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s16_u64($__a));
	    }' unless defined(&vreinterpretq_s16_u64);
	    eval 'sub vreinterpretq_s16_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s16_u8($__a));
	    }' unless defined(&vreinterpretq_s16_u8);
	    eval 'sub vreinterpretq_s32_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s32_s16($__a));
	    }' unless defined(&vreinterpretq_s32_s16);
	    eval 'sub vreinterpretq_s32_s64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s32_s64($__a));
	    }' unless defined(&vreinterpretq_s32_s64);
	    eval 'sub vreinterpretq_s32_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s32_s8($__a));
	    }' unless defined(&vreinterpretq_s32_s8);
	    eval 'sub vreinterpretq_s32_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s32_u16($__a));
	    }' unless defined(&vreinterpretq_s32_u16);
	    eval 'sub vreinterpretq_s32_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s32_u32($__a));
	    }' unless defined(&vreinterpretq_s32_u32);
	    eval 'sub vreinterpretq_s32_u64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s32_u64($__a));
	    }' unless defined(&vreinterpretq_s32_u64);
	    eval 'sub vreinterpretq_s32_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s32_u8($__a));
	    }' unless defined(&vreinterpretq_s32_u8);
	    eval 'sub vreinterpretq_s64_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s64_s16($__a));
	    }' unless defined(&vreinterpretq_s64_s16);
	    eval 'sub vreinterpretq_s64_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s64_s32($__a));
	    }' unless defined(&vreinterpretq_s64_s32);
	    eval 'sub vreinterpretq_s64_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s64_s8($__a));
	    }' unless defined(&vreinterpretq_s64_s8);
	    eval 'sub vreinterpretq_s64_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s64_u16($__a));
	    }' unless defined(&vreinterpretq_s64_u16);
	    eval 'sub vreinterpretq_s64_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s64_u32($__a));
	    }' unless defined(&vreinterpretq_s64_u32);
	    eval 'sub vreinterpretq_s64_u64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s64_u64($__a));
	    }' unless defined(&vreinterpretq_s64_u64);
	    eval 'sub vreinterpretq_s64_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s64_u8($__a));
	    }' unless defined(&vreinterpretq_s64_u8);
	    eval 'sub vreinterpretq_s8_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s8_s16($__a));
	    }' unless defined(&vreinterpretq_s8_s16);
	    eval 'sub vreinterpretq_s8_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s8_s32($__a));
	    }' unless defined(&vreinterpretq_s8_s32);
	    eval 'sub vreinterpretq_s8_s64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s8_s64($__a));
	    }' unless defined(&vreinterpretq_s8_s64);
	    eval 'sub vreinterpretq_s8_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s8_u16($__a));
	    }' unless defined(&vreinterpretq_s8_u16);
	    eval 'sub vreinterpretq_s8_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s8_u32($__a));
	    }' unless defined(&vreinterpretq_s8_u32);
	    eval 'sub vreinterpretq_s8_u64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s8_u64($__a));
	    }' unless defined(&vreinterpretq_s8_u64);
	    eval 'sub vreinterpretq_s8_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s8_u8($__a));
	    }' unless defined(&vreinterpretq_s8_u8);
	    eval 'sub vreinterpretq_u16_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u16_s16($__a));
	    }' unless defined(&vreinterpretq_u16_s16);
	    eval 'sub vreinterpretq_u16_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u16_s32($__a));
	    }' unless defined(&vreinterpretq_u16_s32);
	    eval 'sub vreinterpretq_u16_s64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u16_s64($__a));
	    }' unless defined(&vreinterpretq_u16_s64);
	    eval 'sub vreinterpretq_u16_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u16_s8($__a));
	    }' unless defined(&vreinterpretq_u16_s8);
	    eval 'sub vreinterpretq_u16_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u16_u32($__a));
	    }' unless defined(&vreinterpretq_u16_u32);
	    eval 'sub vreinterpretq_u16_u64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u16_u64($__a));
	    }' unless defined(&vreinterpretq_u16_u64);
	    eval 'sub vreinterpretq_u16_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u16_u8($__a));
	    }' unless defined(&vreinterpretq_u16_u8);
	    eval 'sub vreinterpretq_u32_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u32_s16($__a));
	    }' unless defined(&vreinterpretq_u32_s16);
	    eval 'sub vreinterpretq_u32_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u32_s32($__a));
	    }' unless defined(&vreinterpretq_u32_s32);
	    eval 'sub vreinterpretq_u32_s64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u32_s64($__a));
	    }' unless defined(&vreinterpretq_u32_s64);
	    eval 'sub vreinterpretq_u32_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u32_s8($__a));
	    }' unless defined(&vreinterpretq_u32_s8);
	    eval 'sub vreinterpretq_u32_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u32_u16($__a));
	    }' unless defined(&vreinterpretq_u32_u16);
	    eval 'sub vreinterpretq_u32_u64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u32_u64($__a));
	    }' unless defined(&vreinterpretq_u32_u64);
	    eval 'sub vreinterpretq_u32_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u32_u8($__a));
	    }' unless defined(&vreinterpretq_u32_u8);
	    eval 'sub vreinterpretq_u64_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u64_s16($__a));
	    }' unless defined(&vreinterpretq_u64_s16);
	    eval 'sub vreinterpretq_u64_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u64_s32($__a));
	    }' unless defined(&vreinterpretq_u64_s32);
	    eval 'sub vreinterpretq_u64_s64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u64_s64($__a));
	    }' unless defined(&vreinterpretq_u64_s64);
	    eval 'sub vreinterpretq_u64_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u64_s8($__a));
	    }' unless defined(&vreinterpretq_u64_s8);
	    eval 'sub vreinterpretq_u64_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u64_u16($__a));
	    }' unless defined(&vreinterpretq_u64_u16);
	    eval 'sub vreinterpretq_u64_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u64_u32($__a));
	    }' unless defined(&vreinterpretq_u64_u32);
	    eval 'sub vreinterpretq_u64_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u64_u8($__a));
	    }' unless defined(&vreinterpretq_u64_u8);
	    eval 'sub vreinterpretq_u8_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u8_s16($__a));
	    }' unless defined(&vreinterpretq_u8_s16);
	    eval 'sub vreinterpretq_u8_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u8_s32($__a));
	    }' unless defined(&vreinterpretq_u8_s32);
	    eval 'sub vreinterpretq_u8_s64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u8_s64($__a));
	    }' unless defined(&vreinterpretq_u8_s64);
	    eval 'sub vreinterpretq_u8_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u8_s8($__a));
	    }' unless defined(&vreinterpretq_u8_s8);
	    eval 'sub vreinterpretq_u8_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u8_u16($__a));
	    }' unless defined(&vreinterpretq_u8_u16);
	    eval 'sub vreinterpretq_u8_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u8_u32($__a));
	    }' unless defined(&vreinterpretq_u8_u32);
	    eval 'sub vreinterpretq_u8_u64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u8_u64($__a));
	    }' unless defined(&vreinterpretq_u8_u64);
	    eval 'sub vreinterpretq_s32_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s32_f16($__a));
	    }' unless defined(&vreinterpretq_s32_f16);
	    eval 'sub vreinterpretq_s32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s32_f32($__a));
	    }' unless defined(&vreinterpretq_s32_f32);
	    eval 'sub vreinterpretq_u16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u16_f16($__a));
	    }' unless defined(&vreinterpretq_u16_f16);
	    eval 'sub vreinterpretq_u16_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u16_f32($__a));
	    }' unless defined(&vreinterpretq_u16_f32);
	    eval 'sub vreinterpretq_u32_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u32_f16($__a));
	    }' unless defined(&vreinterpretq_u32_f16);
	    eval 'sub vreinterpretq_u32_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u32_f32($__a));
	    }' unless defined(&vreinterpretq_u32_f32);
	    eval 'sub vreinterpretq_u64_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u64_f16($__a));
	    }' unless defined(&vreinterpretq_u64_f16);
	    eval 'sub vreinterpretq_u64_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u64_f32($__a));
	    }' unless defined(&vreinterpretq_u64_f32);
	    eval 'sub vreinterpretq_u8_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u8_f16($__a));
	    }' unless defined(&vreinterpretq_u8_f16);
	    eval 'sub vreinterpretq_u8_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_u8_f32($__a));
	    }' unless defined(&vreinterpretq_u8_f32);
	    eval 'sub vreinterpretq_f16_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f16_f32($__a));
	    }' unless defined(&vreinterpretq_f16_f32);
	    eval 'sub vreinterpretq_f16_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f16_s16($__a));
	    }' unless defined(&vreinterpretq_f16_s16);
	    eval 'sub vreinterpretq_f16_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f16_s32($__a));
	    }' unless defined(&vreinterpretq_f16_s32);
	    eval 'sub vreinterpretq_f16_s64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f16_s64($__a));
	    }' unless defined(&vreinterpretq_f16_s64);
	    eval 'sub vreinterpretq_f16_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f16_s8($__a));
	    }' unless defined(&vreinterpretq_f16_s8);
	    eval 'sub vreinterpretq_f16_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f16_u16($__a));
	    }' unless defined(&vreinterpretq_f16_u16);
	    eval 'sub vreinterpretq_f16_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f16_u32($__a));
	    }' unless defined(&vreinterpretq_f16_u32);
	    eval 'sub vreinterpretq_f16_u64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f16_u64($__a));
	    }' unless defined(&vreinterpretq_f16_u64);
	    eval 'sub vreinterpretq_f16_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f16_u8($__a));
	    }' unless defined(&vreinterpretq_f16_u8);
	    eval 'sub vreinterpretq_f32_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f32_f16($__a));
	    }' unless defined(&vreinterpretq_f32_f16);
	    eval 'sub vreinterpretq_f32_s16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f32_s16($__a));
	    }' unless defined(&vreinterpretq_f32_s16);
	    eval 'sub vreinterpretq_f32_s32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f32_s32($__a));
	    }' unless defined(&vreinterpretq_f32_s32);
	    eval 'sub vreinterpretq_f32_s64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f32_s64($__a));
	    }' unless defined(&vreinterpretq_f32_s64);
	    eval 'sub vreinterpretq_f32_s8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f32_s8($__a));
	    }' unless defined(&vreinterpretq_f32_s8);
	    eval 'sub vreinterpretq_f32_u16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f32_u16($__a));
	    }' unless defined(&vreinterpretq_f32_u16);
	    eval 'sub vreinterpretq_f32_u32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f32_u32($__a));
	    }' unless defined(&vreinterpretq_f32_u32);
	    eval 'sub vreinterpretq_f32_u64 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f32_u64($__a));
	    }' unless defined(&vreinterpretq_f32_u64);
	    eval 'sub vreinterpretq_f32_u8 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_f32_u8($__a));
	    }' unless defined(&vreinterpretq_f32_u8);
	    eval 'sub vreinterpretq_s16_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s16_f16($__a));
	    }' unless defined(&vreinterpretq_s16_f16);
	    eval 'sub vreinterpretq_s16_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s16_f32($__a));
	    }' unless defined(&vreinterpretq_s16_f32);
	    eval 'sub vreinterpretq_s64_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s64_f16($__a));
	    }' unless defined(&vreinterpretq_s64_f16);
	    eval 'sub vreinterpretq_s64_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s64_f32($__a));
	    }' unless defined(&vreinterpretq_s64_f32);
	    eval 'sub vreinterpretq_s8_f16 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s8_f16($__a));
	    }' unless defined(&vreinterpretq_s8_f16);
	    eval 'sub vreinterpretq_s8_f32 {
	        my($__a) = @_;
    		eval q( &__arm_vreinterpretq_s8_f32($__a));
	    }' unless defined(&vreinterpretq_s8_f32);
	    eval 'sub vuninitializedq_u8 {
	        my($void) = @_;
    		eval q( &__arm_vuninitializedq_u8($void));
	    }' unless defined(&vuninitializedq_u8);
	    eval 'sub vuninitializedq_u16 {
	        my($void) = @_;
    		eval q( &__arm_vuninitializedq_u16($void));
	    }' unless defined(&vuninitializedq_u16);
	    eval 'sub vuninitializedq_u32 {
	        my($void) = @_;
    		eval q( &__arm_vuninitializedq_u32($void));
	    }' unless defined(&vuninitializedq_u32);
	    eval 'sub vuninitializedq_u64 {
	        my($void) = @_;
    		eval q( &__arm_vuninitializedq_u64($void));
	    }' unless defined(&vuninitializedq_u64);
	    eval 'sub vuninitializedq_s8 {
	        my($void) = @_;
    		eval q( &__arm_vuninitializedq_s8($void));
	    }' unless defined(&vuninitializedq_s8);
	    eval 'sub vuninitializedq_s16 {
	        my($void) = @_;
    		eval q( &__arm_vuninitializedq_s16($void));
	    }' unless defined(&vuninitializedq_s16);
	    eval 'sub vuninitializedq_s32 {
	        my($void) = @_;
    		eval q( &__arm_vuninitializedq_s32($void));
	    }' unless defined(&vuninitializedq_s32);
	    eval 'sub vuninitializedq_s64 {
	        my($void) = @_;
    		eval q( &__arm_vuninitializedq_s64($void));
	    }' unless defined(&vuninitializedq_s64);
	    eval 'sub vuninitializedq_f16 {
	        my($void) = @_;
    		eval q( &__arm_vuninitializedq_f16($void));
	    }' unless defined(&vuninitializedq_f16);
	    eval 'sub vuninitializedq_f32 {
	        my($void) = @_;
    		eval q( &__arm_vuninitializedq_f32($void));
	    }' unless defined(&vuninitializedq_f32);
	    eval 'sub vddupq_m_n_u8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_m_n_u8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vddupq_m_n_u8);
	    eval 'sub vddupq_m_n_u32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_m_n_u32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vddupq_m_n_u32);
	    eval 'sub vddupq_m_n_u16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_m_n_u16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vddupq_m_n_u16);
	    eval 'sub vddupq_m_wb_u8 {
	        my($__inactive,  $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_m_wb_u8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vddupq_m_wb_u8);
	    eval 'sub vddupq_m_wb_u16 {
	        my($__inactive,  $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_m_wb_u16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vddupq_m_wb_u16);
	    eval 'sub vddupq_m_wb_u32 {
	        my($__inactive,  $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_m_wb_u32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vddupq_m_wb_u32);
	    eval 'sub vddupq_n_u8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vddupq_n_u8($__a, $__imm));
	    }' unless defined(&vddupq_n_u8);
	    eval 'sub vddupq_n_u32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vddupq_n_u32($__a, $__imm));
	    }' unless defined(&vddupq_n_u32);
	    eval 'sub vddupq_n_u16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vddupq_n_u16($__a, $__imm));
	    }' unless defined(&vddupq_n_u16);
	    eval 'sub vddupq_wb_u8 {
	        my( $__a,  $__imm) = @_;
    		eval q( &__arm_vddupq_wb_u8( $__a, $__imm));
	    }' unless defined(&vddupq_wb_u8);
	    eval 'sub vddupq_wb_u16 {
	        my( $__a,  $__imm) = @_;
    		eval q( &__arm_vddupq_wb_u16( $__a, $__imm));
	    }' unless defined(&vddupq_wb_u16);
	    eval 'sub vddupq_wb_u32 {
	        my( $__a,  $__imm) = @_;
    		eval q( &__arm_vddupq_wb_u32( $__a, $__imm));
	    }' unless defined(&vddupq_wb_u32);
	    eval 'sub vdwdupq_m_n_u8 {
	        my($__inactive, $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_m_n_u8($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_m_n_u8);
	    eval 'sub vdwdupq_m_n_u32 {
	        my($__inactive, $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_m_n_u32($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_m_n_u32);
	    eval 'sub vdwdupq_m_n_u16 {
	        my($__inactive, $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_m_n_u16($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_m_n_u16);
	    eval 'sub vdwdupq_m_wb_u8 {
	        my($__inactive,  $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_m_wb_u8($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_m_wb_u8);
	    eval 'sub vdwdupq_m_wb_u32 {
	        my($__inactive,  $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_m_wb_u32($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_m_wb_u32);
	    eval 'sub vdwdupq_m_wb_u16 {
	        my($__inactive,  $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_m_wb_u16($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_m_wb_u16);
	    eval 'sub vdwdupq_n_u8 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vdwdupq_n_u8($__a, $__b, $__imm));
	    }' unless defined(&vdwdupq_n_u8);
	    eval 'sub vdwdupq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vdwdupq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&vdwdupq_n_u32);
	    eval 'sub vdwdupq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vdwdupq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&vdwdupq_n_u16);
	    eval 'sub vdwdupq_wb_u8 {
	        my( $__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vdwdupq_wb_u8( $__a, $__b, $__imm));
	    }' unless defined(&vdwdupq_wb_u8);
	    eval 'sub vdwdupq_wb_u32 {
	        my( $__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vdwdupq_wb_u32( $__a, $__b, $__imm));
	    }' unless defined(&vdwdupq_wb_u32);
	    eval 'sub vdwdupq_wb_u16 {
	        my( $__a, $__b,  $__imm) = @_;
    		eval q( &__arm_vdwdupq_wb_u16( $__a, $__b, $__imm));
	    }' unless defined(&vdwdupq_wb_u16);
	    eval 'sub vidupq_m_n_u8 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_m_n_u8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vidupq_m_n_u8);
	    eval 'sub vidupq_m_n_u32 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_m_n_u32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vidupq_m_n_u32);
	    eval 'sub vidupq_m_n_u16 {
	        my($__inactive, $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_m_n_u16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vidupq_m_n_u16);
	    eval 'sub vidupq_m_wb_u8 {
	        my($__inactive,  $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_m_wb_u8($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vidupq_m_wb_u8);
	    eval 'sub vidupq_m_wb_u16 {
	        my($__inactive,  $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_m_wb_u16($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vidupq_m_wb_u16);
	    eval 'sub vidupq_m_wb_u32 {
	        my($__inactive,  $__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_m_wb_u32($__inactive, $__a, $__imm, $__p));
	    }' unless defined(&vidupq_m_wb_u32);
	    eval 'sub vidupq_n_u8 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vidupq_n_u8($__a, $__imm));
	    }' unless defined(&vidupq_n_u8);
	    eval 'sub vidupq_n_u32 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vidupq_n_u32($__a, $__imm));
	    }' unless defined(&vidupq_n_u32);
	    eval 'sub vidupq_n_u16 {
	        my($__a,  $__imm) = @_;
    		eval q( &__arm_vidupq_n_u16($__a, $__imm));
	    }' unless defined(&vidupq_n_u16);
	    eval 'sub vidupq_wb_u8 {
	        my( $__a,  $__imm) = @_;
    		eval q( &__arm_vidupq_wb_u8( $__a, $__imm));
	    }' unless defined(&vidupq_wb_u8);
	    eval 'sub vidupq_wb_u16 {
	        my( $__a,  $__imm) = @_;
    		eval q( &__arm_vidupq_wb_u16( $__a, $__imm));
	    }' unless defined(&vidupq_wb_u16);
	    eval 'sub vidupq_wb_u32 {
	        my( $__a,  $__imm) = @_;
    		eval q( &__arm_vidupq_wb_u32( $__a, $__imm));
	    }' unless defined(&vidupq_wb_u32);
	    eval 'sub viwdupq_m_n_u8 {
	        my($__inactive, $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_m_n_u8($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_m_n_u8);
	    eval 'sub viwdupq_m_n_u32 {
	        my($__inactive, $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_m_n_u32($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_m_n_u32);
	    eval 'sub viwdupq_m_n_u16 {
	        my($__inactive, $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_m_n_u16($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_m_n_u16);
	    eval 'sub viwdupq_m_wb_u8 {
	        my($__inactive,  $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_m_wb_u8($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_m_wb_u8);
	    eval 'sub viwdupq_m_wb_u32 {
	        my($__inactive,  $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_m_wb_u32($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_m_wb_u32);
	    eval 'sub viwdupq_m_wb_u16 {
	        my($__inactive,  $__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_m_wb_u16($__inactive, $__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_m_wb_u16);
	    eval 'sub viwdupq_n_u8 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_viwdupq_n_u8($__a, $__b, $__imm));
	    }' unless defined(&viwdupq_n_u8);
	    eval 'sub viwdupq_n_u32 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_viwdupq_n_u32($__a, $__b, $__imm));
	    }' unless defined(&viwdupq_n_u32);
	    eval 'sub viwdupq_n_u16 {
	        my($__a, $__b,  $__imm) = @_;
    		eval q( &__arm_viwdupq_n_u16($__a, $__b, $__imm));
	    }' unless defined(&viwdupq_n_u16);
	    eval 'sub viwdupq_wb_u8 {
	        my( $__a, $__b,  $__imm) = @_;
    		eval q( &__arm_viwdupq_wb_u8( $__a, $__b, $__imm));
	    }' unless defined(&viwdupq_wb_u8);
	    eval 'sub viwdupq_wb_u32 {
	        my( $__a, $__b,  $__imm) = @_;
    		eval q( &__arm_viwdupq_wb_u32( $__a, $__b, $__imm));
	    }' unless defined(&viwdupq_wb_u32);
	    eval 'sub viwdupq_wb_u16 {
	        my( $__a, $__b,  $__imm) = @_;
    		eval q( &__arm_viwdupq_wb_u16( $__a, $__b, $__imm));
	    }' unless defined(&viwdupq_wb_u16);
	    eval 'sub vldrdq_gather_base_wb_s64 {
	        my($__addr, $__offset) = @_;
    		eval q( &__arm_vldrdq_gather_base_wb_s64($__addr, $__offset));
	    }' unless defined(&vldrdq_gather_base_wb_s64);
	    eval 'sub vldrdq_gather_base_wb_u64 {
	        my($__addr, $__offset) = @_;
    		eval q( &__arm_vldrdq_gather_base_wb_u64($__addr, $__offset));
	    }' unless defined(&vldrdq_gather_base_wb_u64);
	    eval 'sub vldrdq_gather_base_wb_z_s64 {
	        my($__addr, $__offset, $__p) = @_;
    		eval q( &__arm_vldrdq_gather_base_wb_z_s64($__addr, $__offset, $__p));
	    }' unless defined(&vldrdq_gather_base_wb_z_s64);
	    eval 'sub vldrdq_gather_base_wb_z_u64 {
	        my($__addr, $__offset, $__p) = @_;
    		eval q( &__arm_vldrdq_gather_base_wb_z_u64($__addr, $__offset, $__p));
	    }' unless defined(&vldrdq_gather_base_wb_z_u64);
	    eval 'sub vldrwq_gather_base_wb_f32 {
	        my($__addr, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_base_wb_f32($__addr, $__offset));
	    }' unless defined(&vldrwq_gather_base_wb_f32);
	    eval 'sub vldrwq_gather_base_wb_s32 {
	        my($__addr, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_base_wb_s32($__addr, $__offset));
	    }' unless defined(&vldrwq_gather_base_wb_s32);
	    eval 'sub vldrwq_gather_base_wb_u32 {
	        my($__addr, $__offset) = @_;
    		eval q( &__arm_vldrwq_gather_base_wb_u32($__addr, $__offset));
	    }' unless defined(&vldrwq_gather_base_wb_u32);
	    eval 'sub vldrwq_gather_base_wb_z_f32 {
	        my($__addr, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_base_wb_z_f32($__addr, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_base_wb_z_f32);
	    eval 'sub vldrwq_gather_base_wb_z_s32 {
	        my($__addr, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_base_wb_z_s32($__addr, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_base_wb_z_s32);
	    eval 'sub vldrwq_gather_base_wb_z_u32 {
	        my($__addr, $__offset, $__p) = @_;
    		eval q( &__arm_vldrwq_gather_base_wb_z_u32($__addr, $__offset, $__p));
	    }' unless defined(&vldrwq_gather_base_wb_z_u32);
	    eval 'sub vstrdq_scatter_base_wb_p_s64 {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_base_wb_p_s64($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_base_wb_p_s64);
	    eval 'sub vstrdq_scatter_base_wb_p_u64 {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrdq_scatter_base_wb_p_u64($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrdq_scatter_base_wb_p_u64);
	    eval 'sub vstrdq_scatter_base_wb_s64 {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_base_wb_s64($__addr, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_base_wb_s64);
	    eval 'sub vstrdq_scatter_base_wb_u64 {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrdq_scatter_base_wb_u64($__addr, $__offset, $__value));
	    }' unless defined(&vstrdq_scatter_base_wb_u64);
	    eval 'sub vstrwq_scatter_base_wb_p_s32 {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_base_wb_p_s32($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_base_wb_p_s32);
	    eval 'sub vstrwq_scatter_base_wb_p_f32 {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_base_wb_p_f32($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_base_wb_p_f32);
	    eval 'sub vstrwq_scatter_base_wb_p_u32 {
	        my($__addr, $__offset, $__value, $__p) = @_;
    		eval q( &__arm_vstrwq_scatter_base_wb_p_u32($__addr, $__offset, $__value, $__p));
	    }' unless defined(&vstrwq_scatter_base_wb_p_u32);
	    eval 'sub vstrwq_scatter_base_wb_s32 {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_base_wb_s32($__addr, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_base_wb_s32);
	    eval 'sub vstrwq_scatter_base_wb_u32 {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_base_wb_u32($__addr, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_base_wb_u32);
	    eval 'sub vstrwq_scatter_base_wb_f32 {
	        my($__addr, $__offset, $__value) = @_;
    		eval q( &__arm_vstrwq_scatter_base_wb_f32($__addr, $__offset, $__value));
	    }' unless defined(&vstrwq_scatter_base_wb_f32);
	    eval 'sub vddupq_x_n_u8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_x_n_u8($__a, $__imm, $__p));
	    }' unless defined(&vddupq_x_n_u8);
	    eval 'sub vddupq_x_n_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_x_n_u16($__a, $__imm, $__p));
	    }' unless defined(&vddupq_x_n_u16);
	    eval 'sub vddupq_x_n_u32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_x_n_u32($__a, $__imm, $__p));
	    }' unless defined(&vddupq_x_n_u32);
	    eval 'sub vddupq_x_wb_u8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_x_wb_u8($__a, $__imm, $__p));
	    }' unless defined(&vddupq_x_wb_u8);
	    eval 'sub vddupq_x_wb_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_x_wb_u16($__a, $__imm, $__p));
	    }' unless defined(&vddupq_x_wb_u16);
	    eval 'sub vddupq_x_wb_u32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vddupq_x_wb_u32($__a, $__imm, $__p));
	    }' unless defined(&vddupq_x_wb_u32);
	    eval 'sub vdwdupq_x_n_u8 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_x_n_u8($__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_x_n_u8);
	    eval 'sub vdwdupq_x_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_x_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_x_n_u16);
	    eval 'sub vdwdupq_x_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_x_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_x_n_u32);
	    eval 'sub vdwdupq_x_wb_u8 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_x_wb_u8($__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_x_wb_u8);
	    eval 'sub vdwdupq_x_wb_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_x_wb_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_x_wb_u16);
	    eval 'sub vdwdupq_x_wb_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vdwdupq_x_wb_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vdwdupq_x_wb_u32);
	    eval 'sub vidupq_x_n_u8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_x_n_u8($__a, $__imm, $__p));
	    }' unless defined(&vidupq_x_n_u8);
	    eval 'sub vidupq_x_n_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_x_n_u16($__a, $__imm, $__p));
	    }' unless defined(&vidupq_x_n_u16);
	    eval 'sub vidupq_x_n_u32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_x_n_u32($__a, $__imm, $__p));
	    }' unless defined(&vidupq_x_n_u32);
	    eval 'sub vidupq_x_wb_u8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_x_wb_u8($__a, $__imm, $__p));
	    }' unless defined(&vidupq_x_wb_u8);
	    eval 'sub vidupq_x_wb_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_x_wb_u16($__a, $__imm, $__p));
	    }' unless defined(&vidupq_x_wb_u16);
	    eval 'sub vidupq_x_wb_u32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vidupq_x_wb_u32($__a, $__imm, $__p));
	    }' unless defined(&vidupq_x_wb_u32);
	    eval 'sub viwdupq_x_n_u8 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_x_n_u8($__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_x_n_u8);
	    eval 'sub viwdupq_x_n_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_x_n_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_x_n_u16);
	    eval 'sub viwdupq_x_n_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_x_n_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_x_n_u32);
	    eval 'sub viwdupq_x_wb_u8 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_x_wb_u8($__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_x_wb_u8);
	    eval 'sub viwdupq_x_wb_u16 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_x_wb_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_x_wb_u16);
	    eval 'sub viwdupq_x_wb_u32 {
	        my($__a, $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_viwdupq_x_wb_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&viwdupq_x_wb_u32);
	    eval 'sub vdupq_x_n_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vdupq_x_n_s8($__a, $__p));
	    }' unless defined(&vdupq_x_n_s8);
	    eval 'sub vdupq_x_n_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vdupq_x_n_s16($__a, $__p));
	    }' unless defined(&vdupq_x_n_s16);
	    eval 'sub vdupq_x_n_s32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vdupq_x_n_s32($__a, $__p));
	    }' unless defined(&vdupq_x_n_s32);
	    eval 'sub vdupq_x_n_u8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vdupq_x_n_u8($__a, $__p));
	    }' unless defined(&vdupq_x_n_u8);
	    eval 'sub vdupq_x_n_u16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vdupq_x_n_u16($__a, $__p));
	    }' unless defined(&vdupq_x_n_u16);
	    eval 'sub vdupq_x_n_u32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vdupq_x_n_u32($__a, $__p));
	    }' unless defined(&vdupq_x_n_u32);
	    eval 'sub vminq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vminq_x_s8);
	    eval 'sub vminq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vminq_x_s16);
	    eval 'sub vminq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vminq_x_s32);
	    eval 'sub vminq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vminq_x_u8);
	    eval 'sub vminq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vminq_x_u16);
	    eval 'sub vminq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vminq_x_u32);
	    eval 'sub vmaxq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vmaxq_x_s8);
	    eval 'sub vmaxq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vmaxq_x_s16);
	    eval 'sub vmaxq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vmaxq_x_s32);
	    eval 'sub vmaxq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vmaxq_x_u8);
	    eval 'sub vmaxq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vmaxq_x_u16);
	    eval 'sub vmaxq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vmaxq_x_u32);
	    eval 'sub vabdq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vabdq_x_s8);
	    eval 'sub vabdq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vabdq_x_s16);
	    eval 'sub vabdq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vabdq_x_s32);
	    eval 'sub vabdq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vabdq_x_u8);
	    eval 'sub vabdq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vabdq_x_u16);
	    eval 'sub vabdq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vabdq_x_u32);
	    eval 'sub vabsq_x_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vabsq_x_s8($__a, $__p));
	    }' unless defined(&vabsq_x_s8);
	    eval 'sub vabsq_x_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vabsq_x_s16($__a, $__p));
	    }' unless defined(&vabsq_x_s16);
	    eval 'sub vabsq_x_s32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vabsq_x_s32($__a, $__p));
	    }' unless defined(&vabsq_x_s32);
	    eval 'sub vaddq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_s8);
	    eval 'sub vaddq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_s16);
	    eval 'sub vaddq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_s32);
	    eval 'sub vaddq_x_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_n_s8($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_n_s8);
	    eval 'sub vaddq_x_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_n_s16($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_n_s16);
	    eval 'sub vaddq_x_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_n_s32($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_n_s32);
	    eval 'sub vaddq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_u8);
	    eval 'sub vaddq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_u16);
	    eval 'sub vaddq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_u32);
	    eval 'sub vaddq_x_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_n_u8($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_n_u8);
	    eval 'sub vaddq_x_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_n_u16($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_n_u16);
	    eval 'sub vaddq_x_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_n_u32($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_n_u32);
	    eval 'sub vclsq_x_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclsq_x_s8($__a, $__p));
	    }' unless defined(&vclsq_x_s8);
	    eval 'sub vclsq_x_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclsq_x_s16($__a, $__p));
	    }' unless defined(&vclsq_x_s16);
	    eval 'sub vclsq_x_s32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclsq_x_s32($__a, $__p));
	    }' unless defined(&vclsq_x_s32);
	    eval 'sub vclzq_x_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclzq_x_s8($__a, $__p));
	    }' unless defined(&vclzq_x_s8);
	    eval 'sub vclzq_x_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclzq_x_s16($__a, $__p));
	    }' unless defined(&vclzq_x_s16);
	    eval 'sub vclzq_x_s32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclzq_x_s32($__a, $__p));
	    }' unless defined(&vclzq_x_s32);
	    eval 'sub vclzq_x_u8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclzq_x_u8($__a, $__p));
	    }' unless defined(&vclzq_x_u8);
	    eval 'sub vclzq_x_u16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclzq_x_u16($__a, $__p));
	    }' unless defined(&vclzq_x_u16);
	    eval 'sub vclzq_x_u32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vclzq_x_u32($__a, $__p));
	    }' unless defined(&vclzq_x_u32);
	    eval 'sub vnegq_x_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vnegq_x_s8($__a, $__p));
	    }' unless defined(&vnegq_x_s8);
	    eval 'sub vnegq_x_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vnegq_x_s16($__a, $__p));
	    }' unless defined(&vnegq_x_s16);
	    eval 'sub vnegq_x_s32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vnegq_x_s32($__a, $__p));
	    }' unless defined(&vnegq_x_s32);
	    eval 'sub vmulhq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vmulhq_x_s8);
	    eval 'sub vmulhq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vmulhq_x_s16);
	    eval 'sub vmulhq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vmulhq_x_s32);
	    eval 'sub vmulhq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vmulhq_x_u8);
	    eval 'sub vmulhq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vmulhq_x_u16);
	    eval 'sub vmulhq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulhq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vmulhq_x_u32);
	    eval 'sub vmullbq_poly_x_p8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_poly_x_p8($__a, $__b, $__p));
	    }' unless defined(&vmullbq_poly_x_p8);
	    eval 'sub vmullbq_poly_x_p16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_poly_x_p16($__a, $__b, $__p));
	    }' unless defined(&vmullbq_poly_x_p16);
	    eval 'sub vmullbq_int_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_x_s8($__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_x_s8);
	    eval 'sub vmullbq_int_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_x_s16($__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_x_s16);
	    eval 'sub vmullbq_int_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_x_s32($__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_x_s32);
	    eval 'sub vmullbq_int_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_x_u8($__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_x_u8);
	    eval 'sub vmullbq_int_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_x_u16($__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_x_u16);
	    eval 'sub vmullbq_int_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmullbq_int_x_u32($__a, $__b, $__p));
	    }' unless defined(&vmullbq_int_x_u32);
	    eval 'sub vmulltq_poly_x_p8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_poly_x_p8($__a, $__b, $__p));
	    }' unless defined(&vmulltq_poly_x_p8);
	    eval 'sub vmulltq_poly_x_p16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_poly_x_p16($__a, $__b, $__p));
	    }' unless defined(&vmulltq_poly_x_p16);
	    eval 'sub vmulltq_int_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_x_s8($__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_x_s8);
	    eval 'sub vmulltq_int_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_x_s16($__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_x_s16);
	    eval 'sub vmulltq_int_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_x_s32($__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_x_s32);
	    eval 'sub vmulltq_int_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_x_u8($__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_x_u8);
	    eval 'sub vmulltq_int_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_x_u16($__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_x_u16);
	    eval 'sub vmulltq_int_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulltq_int_x_u32($__a, $__b, $__p));
	    }' unless defined(&vmulltq_int_x_u32);
	    eval 'sub vmulq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_s8);
	    eval 'sub vmulq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_s16);
	    eval 'sub vmulq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_s32);
	    eval 'sub vmulq_x_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_n_s8($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_n_s8);
	    eval 'sub vmulq_x_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_n_s16($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_n_s16);
	    eval 'sub vmulq_x_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_n_s32($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_n_s32);
	    eval 'sub vmulq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_u8);
	    eval 'sub vmulq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_u16);
	    eval 'sub vmulq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_u32);
	    eval 'sub vmulq_x_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_n_u8($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_n_u8);
	    eval 'sub vmulq_x_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_n_u16($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_n_u16);
	    eval 'sub vmulq_x_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_n_u32($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_n_u32);
	    eval 'sub vsubq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_s8);
	    eval 'sub vsubq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_s16);
	    eval 'sub vsubq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_s32);
	    eval 'sub vsubq_x_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_n_s8($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_n_s8);
	    eval 'sub vsubq_x_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_n_s16($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_n_s16);
	    eval 'sub vsubq_x_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_n_s32($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_n_s32);
	    eval 'sub vsubq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_u8);
	    eval 'sub vsubq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_u16);
	    eval 'sub vsubq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_u32);
	    eval 'sub vsubq_x_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_n_u8($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_n_u8);
	    eval 'sub vsubq_x_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_n_u16($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_n_u16);
	    eval 'sub vsubq_x_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_n_u32($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_n_u32);
	    eval 'sub vcaddq_rot90_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_x_s8($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_x_s8);
	    eval 'sub vcaddq_rot90_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_x_s16($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_x_s16);
	    eval 'sub vcaddq_rot90_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_x_s32($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_x_s32);
	    eval 'sub vcaddq_rot90_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_x_u8($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_x_u8);
	    eval 'sub vcaddq_rot90_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_x_u16($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_x_u16);
	    eval 'sub vcaddq_rot90_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_x_u32($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_x_u32);
	    eval 'sub vcaddq_rot270_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_x_s8($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_x_s8);
	    eval 'sub vcaddq_rot270_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_x_s16($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_x_s16);
	    eval 'sub vcaddq_rot270_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_x_s32($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_x_s32);
	    eval 'sub vcaddq_rot270_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_x_u8($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_x_u8);
	    eval 'sub vcaddq_rot270_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_x_u16($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_x_u16);
	    eval 'sub vcaddq_rot270_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_x_u32($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_x_u32);
	    eval 'sub vhaddq_x_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_n_s8($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_n_s8);
	    eval 'sub vhaddq_x_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_n_s16($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_n_s16);
	    eval 'sub vhaddq_x_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_n_s32($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_n_s32);
	    eval 'sub vhaddq_x_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_n_u8($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_n_u8);
	    eval 'sub vhaddq_x_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_n_u16($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_n_u16);
	    eval 'sub vhaddq_x_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_n_u32($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_n_u32);
	    eval 'sub vhaddq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_s8);
	    eval 'sub vhaddq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_s16);
	    eval 'sub vhaddq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_s32);
	    eval 'sub vhaddq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_u8);
	    eval 'sub vhaddq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_u16);
	    eval 'sub vhaddq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhaddq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vhaddq_x_u32);
	    eval 'sub vhcaddq_rot90_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot90_x_s8($__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot90_x_s8);
	    eval 'sub vhcaddq_rot90_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot90_x_s16($__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot90_x_s16);
	    eval 'sub vhcaddq_rot90_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot90_x_s32($__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot90_x_s32);
	    eval 'sub vhcaddq_rot270_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot270_x_s8($__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot270_x_s8);
	    eval 'sub vhcaddq_rot270_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot270_x_s16($__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot270_x_s16);
	    eval 'sub vhcaddq_rot270_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhcaddq_rot270_x_s32($__a, $__b, $__p));
	    }' unless defined(&vhcaddq_rot270_x_s32);
	    eval 'sub vhsubq_x_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_n_s8($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_n_s8);
	    eval 'sub vhsubq_x_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_n_s16($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_n_s16);
	    eval 'sub vhsubq_x_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_n_s32($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_n_s32);
	    eval 'sub vhsubq_x_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_n_u8($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_n_u8);
	    eval 'sub vhsubq_x_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_n_u16($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_n_u16);
	    eval 'sub vhsubq_x_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_n_u32($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_n_u32);
	    eval 'sub vhsubq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_s8);
	    eval 'sub vhsubq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_s16);
	    eval 'sub vhsubq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_s32);
	    eval 'sub vhsubq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_u8);
	    eval 'sub vhsubq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_u16);
	    eval 'sub vhsubq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vhsubq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vhsubq_x_u32);
	    eval 'sub vrhaddq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vrhaddq_x_s8);
	    eval 'sub vrhaddq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vrhaddq_x_s16);
	    eval 'sub vrhaddq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vrhaddq_x_s32);
	    eval 'sub vrhaddq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vrhaddq_x_u8);
	    eval 'sub vrhaddq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vrhaddq_x_u16);
	    eval 'sub vrhaddq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrhaddq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vrhaddq_x_u32);
	    eval 'sub vrmulhq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vrmulhq_x_s8);
	    eval 'sub vrmulhq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vrmulhq_x_s16);
	    eval 'sub vrmulhq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vrmulhq_x_s32);
	    eval 'sub vrmulhq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vrmulhq_x_u8);
	    eval 'sub vrmulhq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vrmulhq_x_u16);
	    eval 'sub vrmulhq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrmulhq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vrmulhq_x_u32);
	    eval 'sub vandq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vandq_x_s8);
	    eval 'sub vandq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vandq_x_s16);
	    eval 'sub vandq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vandq_x_s32);
	    eval 'sub vandq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vandq_x_u8);
	    eval 'sub vandq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vandq_x_u16);
	    eval 'sub vandq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vandq_x_u32);
	    eval 'sub vbicq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vbicq_x_s8);
	    eval 'sub vbicq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vbicq_x_s16);
	    eval 'sub vbicq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vbicq_x_s32);
	    eval 'sub vbicq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vbicq_x_u8);
	    eval 'sub vbicq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vbicq_x_u16);
	    eval 'sub vbicq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vbicq_x_u32);
	    eval 'sub vbrsrq_x_n_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_x_n_s8($__a, $__b, $__p));
	    }' unless defined(&vbrsrq_x_n_s8);
	    eval 'sub vbrsrq_x_n_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_x_n_s16($__a, $__b, $__p));
	    }' unless defined(&vbrsrq_x_n_s16);
	    eval 'sub vbrsrq_x_n_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_x_n_s32($__a, $__b, $__p));
	    }' unless defined(&vbrsrq_x_n_s32);
	    eval 'sub vbrsrq_x_n_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_x_n_u8($__a, $__b, $__p));
	    }' unless defined(&vbrsrq_x_n_u8);
	    eval 'sub vbrsrq_x_n_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_x_n_u16($__a, $__b, $__p));
	    }' unless defined(&vbrsrq_x_n_u16);
	    eval 'sub vbrsrq_x_n_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_x_n_u32($__a, $__b, $__p));
	    }' unless defined(&vbrsrq_x_n_u32);
	    eval 'sub veorq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_x_s8($__a, $__b, $__p));
	    }' unless defined(&veorq_x_s8);
	    eval 'sub veorq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_x_s16($__a, $__b, $__p));
	    }' unless defined(&veorq_x_s16);
	    eval 'sub veorq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_x_s32($__a, $__b, $__p));
	    }' unless defined(&veorq_x_s32);
	    eval 'sub veorq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_x_u8($__a, $__b, $__p));
	    }' unless defined(&veorq_x_u8);
	    eval 'sub veorq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_x_u16($__a, $__b, $__p));
	    }' unless defined(&veorq_x_u16);
	    eval 'sub veorq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_x_u32($__a, $__b, $__p));
	    }' unless defined(&veorq_x_u32);
	    eval 'sub vmovlbq_x_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmovlbq_x_s8($__a, $__p));
	    }' unless defined(&vmovlbq_x_s8);
	    eval 'sub vmovlbq_x_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmovlbq_x_s16($__a, $__p));
	    }' unless defined(&vmovlbq_x_s16);
	    eval 'sub vmovlbq_x_u8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmovlbq_x_u8($__a, $__p));
	    }' unless defined(&vmovlbq_x_u8);
	    eval 'sub vmovlbq_x_u16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmovlbq_x_u16($__a, $__p));
	    }' unless defined(&vmovlbq_x_u16);
	    eval 'sub vmovltq_x_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmovltq_x_s8($__a, $__p));
	    }' unless defined(&vmovltq_x_s8);
	    eval 'sub vmovltq_x_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmovltq_x_s16($__a, $__p));
	    }' unless defined(&vmovltq_x_s16);
	    eval 'sub vmovltq_x_u8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmovltq_x_u8($__a, $__p));
	    }' unless defined(&vmovltq_x_u8);
	    eval 'sub vmovltq_x_u16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmovltq_x_u16($__a, $__p));
	    }' unless defined(&vmovltq_x_u16);
	    eval 'sub vmvnq_x_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmvnq_x_s8($__a, $__p));
	    }' unless defined(&vmvnq_x_s8);
	    eval 'sub vmvnq_x_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmvnq_x_s16($__a, $__p));
	    }' unless defined(&vmvnq_x_s16);
	    eval 'sub vmvnq_x_s32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmvnq_x_s32($__a, $__p));
	    }' unless defined(&vmvnq_x_s32);
	    eval 'sub vmvnq_x_u8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmvnq_x_u8($__a, $__p));
	    }' unless defined(&vmvnq_x_u8);
	    eval 'sub vmvnq_x_u16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmvnq_x_u16($__a, $__p));
	    }' unless defined(&vmvnq_x_u16);
	    eval 'sub vmvnq_x_u32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vmvnq_x_u32($__a, $__p));
	    }' unless defined(&vmvnq_x_u32);
	    eval 'sub vmvnq_x_n_s16 {
	        my( $__imm, $__p) = @_;
    		eval q( &__arm_vmvnq_x_n_s16( $__imm, $__p));
	    }' unless defined(&vmvnq_x_n_s16);
	    eval 'sub vmvnq_x_n_s32 {
	        my( $__imm, $__p) = @_;
    		eval q( &__arm_vmvnq_x_n_s32( $__imm, $__p));
	    }' unless defined(&vmvnq_x_n_s32);
	    eval 'sub vmvnq_x_n_u16 {
	        my( $__imm, $__p) = @_;
    		eval q( &__arm_vmvnq_x_n_u16( $__imm, $__p));
	    }' unless defined(&vmvnq_x_n_u16);
	    eval 'sub vmvnq_x_n_u32 {
	        my( $__imm, $__p) = @_;
    		eval q( &__arm_vmvnq_x_n_u32( $__imm, $__p));
	    }' unless defined(&vmvnq_x_n_u32);
	    eval 'sub vornq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vornq_x_s8);
	    eval 'sub vornq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vornq_x_s16);
	    eval 'sub vornq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vornq_x_s32);
	    eval 'sub vornq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vornq_x_u8);
	    eval 'sub vornq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vornq_x_u16);
	    eval 'sub vornq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vornq_x_u32);
	    eval 'sub vorrq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vorrq_x_s8);
	    eval 'sub vorrq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vorrq_x_s16);
	    eval 'sub vorrq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vorrq_x_s32);
	    eval 'sub vorrq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vorrq_x_u8);
	    eval 'sub vorrq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vorrq_x_u16);
	    eval 'sub vorrq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vorrq_x_u32);
	    eval 'sub vrev16q_x_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev16q_x_s8($__a, $__p));
	    }' unless defined(&vrev16q_x_s8);
	    eval 'sub vrev16q_x_u8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev16q_x_u8($__a, $__p));
	    }' unless defined(&vrev16q_x_u8);
	    eval 'sub vrev32q_x_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev32q_x_s8($__a, $__p));
	    }' unless defined(&vrev32q_x_s8);
	    eval 'sub vrev32q_x_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev32q_x_s16($__a, $__p));
	    }' unless defined(&vrev32q_x_s16);
	    eval 'sub vrev32q_x_u8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev32q_x_u8($__a, $__p));
	    }' unless defined(&vrev32q_x_u8);
	    eval 'sub vrev32q_x_u16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev32q_x_u16($__a, $__p));
	    }' unless defined(&vrev32q_x_u16);
	    eval 'sub vrev64q_x_s8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev64q_x_s8($__a, $__p));
	    }' unless defined(&vrev64q_x_s8);
	    eval 'sub vrev64q_x_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev64q_x_s16($__a, $__p));
	    }' unless defined(&vrev64q_x_s16);
	    eval 'sub vrev64q_x_s32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev64q_x_s32($__a, $__p));
	    }' unless defined(&vrev64q_x_s32);
	    eval 'sub vrev64q_x_u8 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev64q_x_u8($__a, $__p));
	    }' unless defined(&vrev64q_x_u8);
	    eval 'sub vrev64q_x_u16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev64q_x_u16($__a, $__p));
	    }' unless defined(&vrev64q_x_u16);
	    eval 'sub vrev64q_x_u32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev64q_x_u32($__a, $__p));
	    }' unless defined(&vrev64q_x_u32);
	    eval 'sub vrshlq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vrshlq_x_s8);
	    eval 'sub vrshlq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vrshlq_x_s16);
	    eval 'sub vrshlq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vrshlq_x_s32);
	    eval 'sub vrshlq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vrshlq_x_u8);
	    eval 'sub vrshlq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vrshlq_x_u16);
	    eval 'sub vrshlq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vrshlq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vrshlq_x_u32);
	    eval 'sub vshllbq_x_n_s8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshllbq_x_n_s8($__a, $__imm, $__p));
	    }' unless defined(&vshllbq_x_n_s8);
	    eval 'sub vshllbq_x_n_s16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshllbq_x_n_s16($__a, $__imm, $__p));
	    }' unless defined(&vshllbq_x_n_s16);
	    eval 'sub vshllbq_x_n_u8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshllbq_x_n_u8($__a, $__imm, $__p));
	    }' unless defined(&vshllbq_x_n_u8);
	    eval 'sub vshllbq_x_n_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshllbq_x_n_u16($__a, $__imm, $__p));
	    }' unless defined(&vshllbq_x_n_u16);
	    eval 'sub vshlltq_x_n_s8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlltq_x_n_s8($__a, $__imm, $__p));
	    }' unless defined(&vshlltq_x_n_s8);
	    eval 'sub vshlltq_x_n_s16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlltq_x_n_s16($__a, $__imm, $__p));
	    }' unless defined(&vshlltq_x_n_s16);
	    eval 'sub vshlltq_x_n_u8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlltq_x_n_u8($__a, $__imm, $__p));
	    }' unless defined(&vshlltq_x_n_u8);
	    eval 'sub vshlltq_x_n_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlltq_x_n_u16($__a, $__imm, $__p));
	    }' unless defined(&vshlltq_x_n_u16);
	    eval 'sub vshlq_x_s8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_x_s8($__a, $__b, $__p));
	    }' unless defined(&vshlq_x_s8);
	    eval 'sub vshlq_x_s16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_x_s16($__a, $__b, $__p));
	    }' unless defined(&vshlq_x_s16);
	    eval 'sub vshlq_x_s32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_x_s32($__a, $__b, $__p));
	    }' unless defined(&vshlq_x_s32);
	    eval 'sub vshlq_x_u8 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_x_u8($__a, $__b, $__p));
	    }' unless defined(&vshlq_x_u8);
	    eval 'sub vshlq_x_u16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_x_u16($__a, $__b, $__p));
	    }' unless defined(&vshlq_x_u16);
	    eval 'sub vshlq_x_u32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vshlq_x_u32($__a, $__b, $__p));
	    }' unless defined(&vshlq_x_u32);
	    eval 'sub vshlq_x_n_s8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_x_n_s8($__a, $__imm, $__p));
	    }' unless defined(&vshlq_x_n_s8);
	    eval 'sub vshlq_x_n_s16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_x_n_s16($__a, $__imm, $__p));
	    }' unless defined(&vshlq_x_n_s16);
	    eval 'sub vshlq_x_n_s32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_x_n_s32($__a, $__imm, $__p));
	    }' unless defined(&vshlq_x_n_s32);
	    eval 'sub vshlq_x_n_u8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_x_n_u8($__a, $__imm, $__p));
	    }' unless defined(&vshlq_x_n_u8);
	    eval 'sub vshlq_x_n_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_x_n_u16($__a, $__imm, $__p));
	    }' unless defined(&vshlq_x_n_u16);
	    eval 'sub vshlq_x_n_u32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlq_x_n_u32($__a, $__imm, $__p));
	    }' unless defined(&vshlq_x_n_u32);
	    eval 'sub vrshrq_x_n_s8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_x_n_s8($__a, $__imm, $__p));
	    }' unless defined(&vrshrq_x_n_s8);
	    eval 'sub vrshrq_x_n_s16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_x_n_s16($__a, $__imm, $__p));
	    }' unless defined(&vrshrq_x_n_s16);
	    eval 'sub vrshrq_x_n_s32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_x_n_s32($__a, $__imm, $__p));
	    }' unless defined(&vrshrq_x_n_s32);
	    eval 'sub vrshrq_x_n_u8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_x_n_u8($__a, $__imm, $__p));
	    }' unless defined(&vrshrq_x_n_u8);
	    eval 'sub vrshrq_x_n_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_x_n_u16($__a, $__imm, $__p));
	    }' unless defined(&vrshrq_x_n_u16);
	    eval 'sub vrshrq_x_n_u32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vrshrq_x_n_u32($__a, $__imm, $__p));
	    }' unless defined(&vrshrq_x_n_u32);
	    eval 'sub vshrq_x_n_s8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_x_n_s8($__a, $__imm, $__p));
	    }' unless defined(&vshrq_x_n_s8);
	    eval 'sub vshrq_x_n_s16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_x_n_s16($__a, $__imm, $__p));
	    }' unless defined(&vshrq_x_n_s16);
	    eval 'sub vshrq_x_n_s32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_x_n_s32($__a, $__imm, $__p));
	    }' unless defined(&vshrq_x_n_s32);
	    eval 'sub vshrq_x_n_u8 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_x_n_u8($__a, $__imm, $__p));
	    }' unless defined(&vshrq_x_n_u8);
	    eval 'sub vshrq_x_n_u16 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_x_n_u16($__a, $__imm, $__p));
	    }' unless defined(&vshrq_x_n_u16);
	    eval 'sub vshrq_x_n_u32 {
	        my($__a,  $__imm, $__p) = @_;
    		eval q( &__arm_vshrq_x_n_u32($__a, $__imm, $__p));
	    }' unless defined(&vshrq_x_n_u32);
	    eval 'sub vdupq_x_n_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vdupq_x_n_f16($__a, $__p));
	    }' unless defined(&vdupq_x_n_f16);
	    eval 'sub vdupq_x_n_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vdupq_x_n_f32($__a, $__p));
	    }' unless defined(&vdupq_x_n_f32);
	    eval 'sub vminnmq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vminnmq_x_f16);
	    eval 'sub vminnmq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vminnmq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vminnmq_x_f32);
	    eval 'sub vmaxnmq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vmaxnmq_x_f16);
	    eval 'sub vmaxnmq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmaxnmq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vmaxnmq_x_f32);
	    eval 'sub vabdq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vabdq_x_f16);
	    eval 'sub vabdq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vabdq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vabdq_x_f32);
	    eval 'sub vabsq_x_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vabsq_x_f16($__a, $__p));
	    }' unless defined(&vabsq_x_f16);
	    eval 'sub vabsq_x_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vabsq_x_f32($__a, $__p));
	    }' unless defined(&vabsq_x_f32);
	    eval 'sub vaddq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_f16);
	    eval 'sub vaddq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_f32);
	    eval 'sub vaddq_x_n_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_n_f16($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_n_f16);
	    eval 'sub vaddq_x_n_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vaddq_x_n_f32($__a, $__b, $__p));
	    }' unless defined(&vaddq_x_n_f32);
	    eval 'sub vnegq_x_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vnegq_x_f16($__a, $__p));
	    }' unless defined(&vnegq_x_f16);
	    eval 'sub vnegq_x_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vnegq_x_f32($__a, $__p));
	    }' unless defined(&vnegq_x_f32);
	    eval 'sub vmulq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_f16);
	    eval 'sub vmulq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_f32);
	    eval 'sub vmulq_x_n_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_n_f16($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_n_f16);
	    eval 'sub vmulq_x_n_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vmulq_x_n_f32($__a, $__b, $__p));
	    }' unless defined(&vmulq_x_n_f32);
	    eval 'sub vsubq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_f16);
	    eval 'sub vsubq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_f32);
	    eval 'sub vsubq_x_n_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_n_f16($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_n_f16);
	    eval 'sub vsubq_x_n_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vsubq_x_n_f32($__a, $__b, $__p));
	    }' unless defined(&vsubq_x_n_f32);
	    eval 'sub vcaddq_rot90_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_x_f16($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_x_f16);
	    eval 'sub vcaddq_rot90_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot90_x_f32($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot90_x_f32);
	    eval 'sub vcaddq_rot270_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_x_f16($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_x_f16);
	    eval 'sub vcaddq_rot270_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcaddq_rot270_x_f32($__a, $__b, $__p));
	    }' unless defined(&vcaddq_rot270_x_f32);
	    eval 'sub vcmulq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vcmulq_x_f16);
	    eval 'sub vcmulq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vcmulq_x_f32);
	    eval 'sub vcmulq_rot90_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot90_x_f16($__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot90_x_f16);
	    eval 'sub vcmulq_rot90_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot90_x_f32($__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot90_x_f32);
	    eval 'sub vcmulq_rot180_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot180_x_f16($__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot180_x_f16);
	    eval 'sub vcmulq_rot180_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot180_x_f32($__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot180_x_f32);
	    eval 'sub vcmulq_rot270_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot270_x_f16($__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot270_x_f16);
	    eval 'sub vcmulq_rot270_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vcmulq_rot270_x_f32($__a, $__b, $__p));
	    }' unless defined(&vcmulq_rot270_x_f32);
	    eval 'sub vcvtaq_x_s16_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtaq_x_s16_f16($__a, $__p));
	    }' unless defined(&vcvtaq_x_s16_f16);
	    eval 'sub vcvtaq_x_s32_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtaq_x_s32_f32($__a, $__p));
	    }' unless defined(&vcvtaq_x_s32_f32);
	    eval 'sub vcvtaq_x_u16_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtaq_x_u16_f16($__a, $__p));
	    }' unless defined(&vcvtaq_x_u16_f16);
	    eval 'sub vcvtaq_x_u32_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtaq_x_u32_f32($__a, $__p));
	    }' unless defined(&vcvtaq_x_u32_f32);
	    eval 'sub vcvtnq_x_s16_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtnq_x_s16_f16($__a, $__p));
	    }' unless defined(&vcvtnq_x_s16_f16);
	    eval 'sub vcvtnq_x_s32_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtnq_x_s32_f32($__a, $__p));
	    }' unless defined(&vcvtnq_x_s32_f32);
	    eval 'sub vcvtnq_x_u16_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtnq_x_u16_f16($__a, $__p));
	    }' unless defined(&vcvtnq_x_u16_f16);
	    eval 'sub vcvtnq_x_u32_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtnq_x_u32_f32($__a, $__p));
	    }' unless defined(&vcvtnq_x_u32_f32);
	    eval 'sub vcvtpq_x_s16_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtpq_x_s16_f16($__a, $__p));
	    }' unless defined(&vcvtpq_x_s16_f16);
	    eval 'sub vcvtpq_x_s32_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtpq_x_s32_f32($__a, $__p));
	    }' unless defined(&vcvtpq_x_s32_f32);
	    eval 'sub vcvtpq_x_u16_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtpq_x_u16_f16($__a, $__p));
	    }' unless defined(&vcvtpq_x_u16_f16);
	    eval 'sub vcvtpq_x_u32_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtpq_x_u32_f32($__a, $__p));
	    }' unless defined(&vcvtpq_x_u32_f32);
	    eval 'sub vcvtmq_x_s16_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtmq_x_s16_f16($__a, $__p));
	    }' unless defined(&vcvtmq_x_s16_f16);
	    eval 'sub vcvtmq_x_s32_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtmq_x_s32_f32($__a, $__p));
	    }' unless defined(&vcvtmq_x_s32_f32);
	    eval 'sub vcvtmq_x_u16_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtmq_x_u16_f16($__a, $__p));
	    }' unless defined(&vcvtmq_x_u16_f16);
	    eval 'sub vcvtmq_x_u32_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtmq_x_u32_f32($__a, $__p));
	    }' unless defined(&vcvtmq_x_u32_f32);
	    eval 'sub vcvtbq_x_f32_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtbq_x_f32_f16($__a, $__p));
	    }' unless defined(&vcvtbq_x_f32_f16);
	    eval 'sub vcvttq_x_f32_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvttq_x_f32_f16($__a, $__p));
	    }' unless defined(&vcvttq_x_f32_f16);
	    eval 'sub vcvtq_x_f16_u16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtq_x_f16_u16($__a, $__p));
	    }' unless defined(&vcvtq_x_f16_u16);
	    eval 'sub vcvtq_x_f16_s16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtq_x_f16_s16($__a, $__p));
	    }' unless defined(&vcvtq_x_f16_s16);
	    eval 'sub vcvtq_x_f32_s32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtq_x_f32_s32($__a, $__p));
	    }' unless defined(&vcvtq_x_f32_s32);
	    eval 'sub vcvtq_x_f32_u32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtq_x_f32_u32($__a, $__p));
	    }' unless defined(&vcvtq_x_f32_u32);
	    eval 'sub vcvtq_x_n_f16_s16 {
	        my($__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_x_n_f16_s16($__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_x_n_f16_s16);
	    eval 'sub vcvtq_x_n_f16_u16 {
	        my($__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_x_n_f16_u16($__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_x_n_f16_u16);
	    eval 'sub vcvtq_x_n_f32_s32 {
	        my($__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_x_n_f32_s32($__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_x_n_f32_s32);
	    eval 'sub vcvtq_x_n_f32_u32 {
	        my($__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_x_n_f32_u32($__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_x_n_f32_u32);
	    eval 'sub vcvtq_x_s16_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtq_x_s16_f16($__a, $__p));
	    }' unless defined(&vcvtq_x_s16_f16);
	    eval 'sub vcvtq_x_s32_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtq_x_s32_f32($__a, $__p));
	    }' unless defined(&vcvtq_x_s32_f32);
	    eval 'sub vcvtq_x_u16_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtq_x_u16_f16($__a, $__p));
	    }' unless defined(&vcvtq_x_u16_f16);
	    eval 'sub vcvtq_x_u32_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vcvtq_x_u32_f32($__a, $__p));
	    }' unless defined(&vcvtq_x_u32_f32);
	    eval 'sub vcvtq_x_n_s16_f16 {
	        my($__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_x_n_s16_f16($__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_x_n_s16_f16);
	    eval 'sub vcvtq_x_n_s32_f32 {
	        my($__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_x_n_s32_f32($__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_x_n_s32_f32);
	    eval 'sub vcvtq_x_n_u16_f16 {
	        my($__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_x_n_u16_f16($__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_x_n_u16_f16);
	    eval 'sub vcvtq_x_n_u32_f32 {
	        my($__a,  $__imm6, $__p) = @_;
    		eval q( &__arm_vcvtq_x_n_u32_f32($__a, $__imm6, $__p));
	    }' unless defined(&vcvtq_x_n_u32_f32);
	    eval 'sub vrndq_x_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndq_x_f16($__a, $__p));
	    }' unless defined(&vrndq_x_f16);
	    eval 'sub vrndq_x_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndq_x_f32($__a, $__p));
	    }' unless defined(&vrndq_x_f32);
	    eval 'sub vrndnq_x_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndnq_x_f16($__a, $__p));
	    }' unless defined(&vrndnq_x_f16);
	    eval 'sub vrndnq_x_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndnq_x_f32($__a, $__p));
	    }' unless defined(&vrndnq_x_f32);
	    eval 'sub vrndmq_x_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndmq_x_f16($__a, $__p));
	    }' unless defined(&vrndmq_x_f16);
	    eval 'sub vrndmq_x_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndmq_x_f32($__a, $__p));
	    }' unless defined(&vrndmq_x_f32);
	    eval 'sub vrndpq_x_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndpq_x_f16($__a, $__p));
	    }' unless defined(&vrndpq_x_f16);
	    eval 'sub vrndpq_x_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndpq_x_f32($__a, $__p));
	    }' unless defined(&vrndpq_x_f32);
	    eval 'sub vrndaq_x_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndaq_x_f16($__a, $__p));
	    }' unless defined(&vrndaq_x_f16);
	    eval 'sub vrndaq_x_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndaq_x_f32($__a, $__p));
	    }' unless defined(&vrndaq_x_f32);
	    eval 'sub vrndxq_x_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndxq_x_f16($__a, $__p));
	    }' unless defined(&vrndxq_x_f16);
	    eval 'sub vrndxq_x_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrndxq_x_f32($__a, $__p));
	    }' unless defined(&vrndxq_x_f32);
	    eval 'sub vandq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vandq_x_f16);
	    eval 'sub vandq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vandq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vandq_x_f32);
	    eval 'sub vbicq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vbicq_x_f16);
	    eval 'sub vbicq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbicq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vbicq_x_f32);
	    eval 'sub vbrsrq_x_n_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_x_n_f16($__a, $__b, $__p));
	    }' unless defined(&vbrsrq_x_n_f16);
	    eval 'sub vbrsrq_x_n_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vbrsrq_x_n_f32($__a, $__b, $__p));
	    }' unless defined(&vbrsrq_x_n_f32);
	    eval 'sub veorq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_x_f16($__a, $__b, $__p));
	    }' unless defined(&veorq_x_f16);
	    eval 'sub veorq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_veorq_x_f32($__a, $__b, $__p));
	    }' unless defined(&veorq_x_f32);
	    eval 'sub vornq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vornq_x_f16);
	    eval 'sub vornq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vornq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vornq_x_f32);
	    eval 'sub vorrq_x_f16 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_x_f16($__a, $__b, $__p));
	    }' unless defined(&vorrq_x_f16);
	    eval 'sub vorrq_x_f32 {
	        my($__a, $__b, $__p) = @_;
    		eval q( &__arm_vorrq_x_f32($__a, $__b, $__p));
	    }' unless defined(&vorrq_x_f32);
	    eval 'sub vrev32q_x_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev32q_x_f16($__a, $__p));
	    }' unless defined(&vrev32q_x_f16);
	    eval 'sub vrev64q_x_f16 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev64q_x_f16($__a, $__p));
	    }' unless defined(&vrev64q_x_f16);
	    eval 'sub vrev64q_x_f32 {
	        my($__a, $__p) = @_;
    		eval q( &__arm_vrev64q_x_f32($__a, $__p));
	    }' unless defined(&vrev64q_x_f32);
	    eval 'sub vadciq_s32 {
	        my($__a, $__b,  $__carry_out) = @_;
    		eval q( &__arm_vadciq_s32($__a, $__b, $__carry_out));
	    }' unless defined(&vadciq_s32);
	    eval 'sub vadciq_u32 {
	        my($__a, $__b,  $__carry_out) = @_;
    		eval q( &__arm_vadciq_u32($__a, $__b, $__carry_out));
	    }' unless defined(&vadciq_u32);
	    eval 'sub vadciq_m_s32 {
	        my($__inactive, $__a, $__b,  $__carry_out, $__p) = @_;
    		eval q( &__arm_vadciq_m_s32($__inactive, $__a, $__b, $__carry_out, $__p));
	    }' unless defined(&vadciq_m_s32);
	    eval 'sub vadciq_m_u32 {
	        my($__inactive, $__a, $__b,  $__carry_out, $__p) = @_;
    		eval q( &__arm_vadciq_m_u32($__inactive, $__a, $__b, $__carry_out, $__p));
	    }' unless defined(&vadciq_m_u32);
	    eval 'sub vadcq_s32 {
	        my($__a, $__b,  $__carry) = @_;
    		eval q( &__arm_vadcq_s32($__a, $__b, $__carry));
	    }' unless defined(&vadcq_s32);
	    eval 'sub vadcq_u32 {
	        my($__a, $__b,  $__carry) = @_;
    		eval q( &__arm_vadcq_u32($__a, $__b, $__carry));
	    }' unless defined(&vadcq_u32);
	    eval 'sub vadcq_m_s32 {
	        my($__inactive, $__a, $__b,  $__carry, $__p) = @_;
    		eval q( &__arm_vadcq_m_s32($__inactive, $__a, $__b, $__carry, $__p));
	    }' unless defined(&vadcq_m_s32);
	    eval 'sub vadcq_m_u32 {
	        my($__inactive, $__a, $__b,  $__carry, $__p) = @_;
    		eval q( &__arm_vadcq_m_u32($__inactive, $__a, $__b, $__carry, $__p));
	    }' unless defined(&vadcq_m_u32);
	    eval 'sub vsbciq_s32 {
	        my($__a, $__b,  $__carry_out) = @_;
    		eval q( &__arm_vsbciq_s32($__a, $__b, $__carry_out));
	    }' unless defined(&vsbciq_s32);
	    eval 'sub vsbciq_u32 {
	        my($__a, $__b,  $__carry_out) = @_;
    		eval q( &__arm_vsbciq_u32($__a, $__b, $__carry_out));
	    }' unless defined(&vsbciq_u32);
	    eval 'sub vsbciq_m_s32 {
	        my($__inactive, $__a, $__b,  $__carry_out, $__p) = @_;
    		eval q( &__arm_vsbciq_m_s32($__inactive, $__a, $__b, $__carry_out, $__p));
	    }' unless defined(&vsbciq_m_s32);
	    eval 'sub vsbciq_m_u32 {
	        my($__inactive, $__a, $__b,  $__carry_out, $__p) = @_;
    		eval q( &__arm_vsbciq_m_u32($__inactive, $__a, $__b, $__carry_out, $__p));
	    }' unless defined(&vsbciq_m_u32);
	    eval 'sub vsbcq_s32 {
	        my($__a, $__b,  $__carry) = @_;
    		eval q( &__arm_vsbcq_s32($__a, $__b, $__carry));
	    }' unless defined(&vsbcq_s32);
	    eval 'sub vsbcq_u32 {
	        my($__a, $__b,  $__carry) = @_;
    		eval q( &__arm_vsbcq_u32($__a, $__b, $__carry));
	    }' unless defined(&vsbcq_u32);
	    eval 'sub vsbcq_m_s32 {
	        my($__inactive, $__a, $__b,  $__carry, $__p) = @_;
    		eval q( &__arm_vsbcq_m_s32($__inactive, $__a, $__b, $__carry, $__p));
	    }' unless defined(&vsbcq_m_s32);
	    eval 'sub vsbcq_m_u32 {
	        my($__inactive, $__a, $__b,  $__carry, $__p) = @_;
    		eval q( &__arm_vsbcq_m_u32($__inactive, $__a, $__b, $__carry, $__p));
	    }' unless defined(&vsbcq_m_u32);
	    eval 'sub vst1q_p_u8 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vst1q_p_u8($__addr, $__value, $__p));
	    }' unless defined(&vst1q_p_u8);
	    eval 'sub vst1q_p_s8 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vst1q_p_s8($__addr, $__value, $__p));
	    }' unless defined(&vst1q_p_s8);
	    eval 'sub vst2q_s8 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst2q_s8($__addr, $__value));
	    }' unless defined(&vst2q_s8);
	    eval 'sub vst2q_u8 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst2q_u8($__addr, $__value));
	    }' unless defined(&vst2q_u8);
	    eval 'sub vld1q_z_u8 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vld1q_z_u8($__base, $__p));
	    }' unless defined(&vld1q_z_u8);
	    eval 'sub vld1q_z_s8 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vld1q_z_s8($__base, $__p));
	    }' unless defined(&vld1q_z_s8);
	    eval 'sub vld2q_s8 {
	        my($__addr) = @_;
    		eval q( &__arm_vld2q_s8($__addr));
	    }' unless defined(&vld2q_s8);
	    eval 'sub vld2q_u8 {
	        my($__addr) = @_;
    		eval q( &__arm_vld2q_u8($__addr));
	    }' unless defined(&vld2q_u8);
	    eval 'sub vld4q_s8 {
	        my($__addr) = @_;
    		eval q( &__arm_vld4q_s8($__addr));
	    }' unless defined(&vld4q_s8);
	    eval 'sub vld4q_u8 {
	        my($__addr) = @_;
    		eval q( &__arm_vld4q_u8($__addr));
	    }' unless defined(&vld4q_u8);
	    eval 'sub vst1q_p_u16 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vst1q_p_u16($__addr, $__value, $__p));
	    }' unless defined(&vst1q_p_u16);
	    eval 'sub vst1q_p_s16 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vst1q_p_s16($__addr, $__value, $__p));
	    }' unless defined(&vst1q_p_s16);
	    eval 'sub vst2q_s16 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst2q_s16($__addr, $__value));
	    }' unless defined(&vst2q_s16);
	    eval 'sub vst2q_u16 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst2q_u16($__addr, $__value));
	    }' unless defined(&vst2q_u16);
	    eval 'sub vld1q_z_u16 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vld1q_z_u16($__base, $__p));
	    }' unless defined(&vld1q_z_u16);
	    eval 'sub vld1q_z_s16 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vld1q_z_s16($__base, $__p));
	    }' unless defined(&vld1q_z_s16);
	    eval 'sub vld2q_s16 {
	        my($__addr) = @_;
    		eval q( &__arm_vld2q_s16($__addr));
	    }' unless defined(&vld2q_s16);
	    eval 'sub vld2q_u16 {
	        my($__addr) = @_;
    		eval q( &__arm_vld2q_u16($__addr));
	    }' unless defined(&vld2q_u16);
	    eval 'sub vld4q_s16 {
	        my($__addr) = @_;
    		eval q( &__arm_vld4q_s16($__addr));
	    }' unless defined(&vld4q_s16);
	    eval 'sub vld4q_u16 {
	        my($__addr) = @_;
    		eval q( &__arm_vld4q_u16($__addr));
	    }' unless defined(&vld4q_u16);
	    eval 'sub vst1q_p_u32 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vst1q_p_u32($__addr, $__value, $__p));
	    }' unless defined(&vst1q_p_u32);
	    eval 'sub vst1q_p_s32 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vst1q_p_s32($__addr, $__value, $__p));
	    }' unless defined(&vst1q_p_s32);
	    eval 'sub vst2q_s32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst2q_s32($__addr, $__value));
	    }' unless defined(&vst2q_s32);
	    eval 'sub vst2q_u32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst2q_u32($__addr, $__value));
	    }' unless defined(&vst2q_u32);
	    eval 'sub vld1q_z_u32 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vld1q_z_u32($__base, $__p));
	    }' unless defined(&vld1q_z_u32);
	    eval 'sub vld1q_z_s32 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vld1q_z_s32($__base, $__p));
	    }' unless defined(&vld1q_z_s32);
	    eval 'sub vld2q_s32 {
	        my($__addr) = @_;
    		eval q( &__arm_vld2q_s32($__addr));
	    }' unless defined(&vld2q_s32);
	    eval 'sub vld2q_u32 {
	        my($__addr) = @_;
    		eval q( &__arm_vld2q_u32($__addr));
	    }' unless defined(&vld2q_u32);
	    eval 'sub vld4q_s32 {
	        my($__addr) = @_;
    		eval q( &__arm_vld4q_s32($__addr));
	    }' unless defined(&vld4q_s32);
	    eval 'sub vld4q_u32 {
	        my($__addr) = @_;
    		eval q( &__arm_vld4q_u32($__addr));
	    }' unless defined(&vld4q_u32);
	    eval 'sub vld4q_f16 {
	        my($__addr) = @_;
    		eval q( &__arm_vld4q_f16($__addr));
	    }' unless defined(&vld4q_f16);
	    eval 'sub vld2q_f16 {
	        my($__addr) = @_;
    		eval q( &__arm_vld2q_f16($__addr));
	    }' unless defined(&vld2q_f16);
	    eval 'sub vld1q_z_f16 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vld1q_z_f16($__base, $__p));
	    }' unless defined(&vld1q_z_f16);
	    eval 'sub vst2q_f16 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst2q_f16($__addr, $__value));
	    }' unless defined(&vst2q_f16);
	    eval 'sub vst1q_p_f16 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vst1q_p_f16($__addr, $__value, $__p));
	    }' unless defined(&vst1q_p_f16);
	    eval 'sub vld4q_f32 {
	        my($__addr) = @_;
    		eval q( &__arm_vld4q_f32($__addr));
	    }' unless defined(&vld4q_f32);
	    eval 'sub vld2q_f32 {
	        my($__addr) = @_;
    		eval q( &__arm_vld2q_f32($__addr));
	    }' unless defined(&vld2q_f32);
	    eval 'sub vld1q_z_f32 {
	        my($__base, $__p) = @_;
    		eval q( &__arm_vld1q_z_f32($__base, $__p));
	    }' unless defined(&vld1q_z_f32);
	    eval 'sub vst2q_f32 {
	        my($__addr, $__value) = @_;
    		eval q( &__arm_vst2q_f32($__addr, $__value));
	    }' unless defined(&vst2q_f32);
	    eval 'sub vst1q_p_f32 {
	        my($__addr, $__value, $__p) = @_;
    		eval q( &__arm_vst1q_p_f32($__addr, $__value, $__p));
	    }' unless defined(&vst1q_p_f32);
	    eval 'sub vsetq_lane_f16 {
	        my($__a, $__b,  $__idx) = @_;
    		eval q( &__arm_vsetq_lane_f16($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane_f16);
	    eval 'sub vsetq_lane_f32 {
	        my($__a, $__b,  $__idx) = @_;
    		eval q( &__arm_vsetq_lane_f32($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane_f32);
	    eval 'sub vsetq_lane_s16 {
	        my($__a, $__b,  $__idx) = @_;
    		eval q( &__arm_vsetq_lane_s16($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane_s16);
	    eval 'sub vsetq_lane_s32 {
	        my($__a, $__b,  $__idx) = @_;
    		eval q( &__arm_vsetq_lane_s32($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane_s32);
	    eval 'sub vsetq_lane_s8 {
	        my($__a, $__b,  $__idx) = @_;
    		eval q( &__arm_vsetq_lane_s8($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane_s8);
	    eval 'sub vsetq_lane_s64 {
	        my($__a, $__b,  $__idx) = @_;
    		eval q( &__arm_vsetq_lane_s64($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane_s64);
	    eval 'sub vsetq_lane_u8 {
	        my($__a, $__b,  $__idx) = @_;
    		eval q( &__arm_vsetq_lane_u8($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane_u8);
	    eval 'sub vsetq_lane_u16 {
	        my($__a, $__b,  $__idx) = @_;
    		eval q( &__arm_vsetq_lane_u16($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane_u16);
	    eval 'sub vsetq_lane_u32 {
	        my($__a, $__b,  $__idx) = @_;
    		eval q( &__arm_vsetq_lane_u32($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane_u32);
	    eval 'sub vsetq_lane_u64 {
	        my($__a, $__b,  $__idx) = @_;
    		eval q( &__arm_vsetq_lane_u64($__a, $__b, $__idx));
	    }' unless defined(&vsetq_lane_u64);
	    eval 'sub vgetq_lane_f16 {
	        my($__a,  $__idx) = @_;
    		eval q( &__arm_vgetq_lane_f16($__a, $__idx));
	    }' unless defined(&vgetq_lane_f16);
	    eval 'sub vgetq_lane_f32 {
	        my($__a,  $__idx) = @_;
    		eval q( &__arm_vgetq_lane_f32($__a, $__idx));
	    }' unless defined(&vgetq_lane_f32);
	    eval 'sub vgetq_lane_s16 {
	        my($__a,  $__idx) = @_;
    		eval q( &__arm_vgetq_lane_s16($__a, $__idx));
	    }' unless defined(&vgetq_lane_s16);
	    eval 'sub vgetq_lane_s32 {
	        my($__a,  $__idx) = @_;
    		eval q( &__arm_vgetq_lane_s32($__a, $__idx));
	    }' unless defined(&vgetq_lane_s32);
	    eval 'sub vgetq_lane_s8 {
	        my($__a,  $__idx) = @_;
    		eval q( &__arm_vgetq_lane_s8($__a, $__idx));
	    }' unless defined(&vgetq_lane_s8);
	    eval 'sub vgetq_lane_s64 {
	        my($__a,  $__idx) = @_;
    		eval q( &__arm_vgetq_lane_s64($__a, $__idx));
	    }' unless defined(&vgetq_lane_s64);
	    eval 'sub vgetq_lane_u8 {
	        my($__a,  $__idx) = @_;
    		eval q( &__arm_vgetq_lane_u8($__a, $__idx));
	    }' unless defined(&vgetq_lane_u8);
	    eval 'sub vgetq_lane_u16 {
	        my($__a,  $__idx) = @_;
    		eval q( &__arm_vgetq_lane_u16($__a, $__idx));
	    }' unless defined(&vgetq_lane_u16);
	    eval 'sub vgetq_lane_u32 {
	        my($__a,  $__idx) = @_;
    		eval q( &__arm_vgetq_lane_u32($__a, $__idx));
	    }' unless defined(&vgetq_lane_u32);
	    eval 'sub vgetq_lane_u64 {
	        my($__a,  $__idx) = @_;
    		eval q( &__arm_vgetq_lane_u64($__a, $__idx));
	    }' unless defined(&vgetq_lane_u64);
	    eval 'sub sqrshr {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_sqrshr($__p0, $__p1));
	    }' unless defined(&sqrshr);
	    eval 'sub sqrshrl {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_sqrshrl($__p0, $__p1));
	    }' unless defined(&sqrshrl);
	    eval 'sub sqrshrl_sat48 {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_sqrshrl_sat48($__p0, $__p1));
	    }' unless defined(&sqrshrl_sat48);
	    eval 'sub sqshl {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_sqshl($__p0, $__p1));
	    }' unless defined(&sqshl);
	    eval 'sub sqshll {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_sqshll($__p0, $__p1));
	    }' unless defined(&sqshll);
	    eval 'sub srshr {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_srshr($__p0, $__p1));
	    }' unless defined(&srshr);
	    eval 'sub srshrl {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_srshrl($__p0, $__p1));
	    }' unless defined(&srshrl);
	    eval 'sub uqrshl {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_uqrshl($__p0, $__p1));
	    }' unless defined(&uqrshl);
	    eval 'sub uqrshll {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_uqrshll($__p0, $__p1));
	    }' unless defined(&uqrshll);
	    eval 'sub uqrshll_sat48 {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_uqrshll_sat48($__p0, $__p1));
	    }' unless defined(&uqrshll_sat48);
	    eval 'sub uqshl {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_uqshl($__p0, $__p1));
	    }' unless defined(&uqshl);
	    eval 'sub uqshll {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_uqshll($__p0, $__p1));
	    }' unless defined(&uqshll);
	    eval 'sub urshr {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_urshr($__p0, $__p1));
	    }' unless defined(&urshr);
	    eval 'sub urshrl {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_urshrl($__p0, $__p1));
	    }' unless defined(&urshrl);
	    eval 'sub lsll {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_lsll($__p0, $__p1));
	    }' unless defined(&lsll);
	    eval 'sub asrl {
	        my($__p0, $__p1) = @_;
    		eval q( &__arm_asrl($__p0, $__p1));
	    }' unless defined(&asrl);
	    eval 'sub vshlcq_m_s8 {
	        my($__a,  $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlcq_m_s8($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshlcq_m_s8);
	    eval 'sub vshlcq_m_u8 {
	        my($__a,  $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlcq_m_u8($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshlcq_m_u8);
	    eval 'sub vshlcq_m_s16 {
	        my($__a,  $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlcq_m_s16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshlcq_m_s16);
	    eval 'sub vshlcq_m_u16 {
	        my($__a,  $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlcq_m_u16($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshlcq_m_u16);
	    eval 'sub vshlcq_m_s32 {
	        my($__a,  $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlcq_m_s32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshlcq_m_s32);
	    eval 'sub vshlcq_m_u32 {
	        my($__a,  $__b,  $__imm, $__p) = @_;
    		eval q( &__arm_vshlcq_m_u32($__a, $__b, $__imm, $__p));
	    }' unless defined(&vshlcq_m_u32);
	}
	eval 'sub __ARM_NUM_LANES {
	    my($__v) = @_;
    	    eval q(($sizeof{$__v} / $sizeof{$__v->[0]}));
	}' unless defined(&__ARM_NUM_LANES);
	if(defined(&__ARM_BIG_ENDIAN)) {
	    eval 'sub __ARM_LANEQ {
	        my($__vec, $__idx) = @_;
    		eval q(($__idx ^ ( &__ARM_NUM_LANES($__vec)/2- 1)));
	    }' unless defined(&__ARM_LANEQ);
	} else {
	    eval 'sub __ARM_LANEQ {
	        my($__vec, $__idx) = @_;
    		eval q($__idx);
	    }' unless defined(&__ARM_LANEQ);
	}
	eval 'sub __ARM_CHECK_LANEQ {
	    my($__vec, $__idx) = @_;
    	    eval q( &__builtin_arm_lane_check ( &__ARM_NUM_LANES($__vec),  &__ARM_LANEQ($__vec, $__idx)));
	}' unless defined(&__ARM_CHECK_LANEQ);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst4q_s8 ( &int8_t *  &__addr,  &int8x16x4_t  &__value) { \'union union\' {  &int8x16x4_t  &__i;  &__builtin_neon_xi  &__o; }  &__rv;  ($__rv->{__i}) =  &__value;  &__builtin_mve_vst4qv16qi (( &__builtin_neon_qi *)  &__addr,  ($__rv->{__o})); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst4q_s16 ( &int16_t *  &__addr,  &int16x8x4_t  &__value) { \'union union\' {  &int16x8x4_t  &__i;  &__builtin_neon_xi  &__o; }  &__rv;  ($__rv->{__i}) =  &__value;  &__builtin_mve_vst4qv8hi (( &__builtin_neon_hi *)  &__addr,  ($__rv->{__o})); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst4q_s32 ( &int32_t *  &__addr,  &int32x4x4_t  &__value) { \'union union\' {  &int32x4x4_t  &__i;  &__builtin_neon_xi  &__o; }  &__rv;  ($__rv->{__i}) =  &__value;  &__builtin_mve_vst4qv4si (( &__builtin_neon_si *)  &__addr,  ($__rv->{__o})); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst4q_u8 ( &uint8_t *  &__addr,  &uint8x16x4_t  &__value) { \'union union\' {  &uint8x16x4_t  &__i;  &__builtin_neon_xi  &__o; }  &__rv;  ($__rv->{__i}) =  &__value;  &__builtin_mve_vst4qv16qi (( &__builtin_neon_qi *)  &__addr,  ($__rv->{__o})); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst4q_u16 ( &uint16_t *  &__addr,  &uint16x8x4_t  &__value) { \'union union\' {  &uint16x8x4_t  &__i;  &__builtin_neon_xi  &__o; }  &__rv;  ($__rv->{__i}) =  &__value;  &__builtin_mve_vst4qv8hi (( &__builtin_neon_hi *)  &__addr,  ($__rv->{__o})); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst4q_u32 ( &uint32_t *  &__addr,  &uint32x4x4_t  &__value) { \'union union\' {  &uint32x4x4_t  &__i;  &__builtin_neon_xi  &__o; }  &__rv;  ($__rv->{__i}) =  &__value;  &__builtin_mve_vst4qv4si (( &__builtin_neon_si *)  &__addr,  ($__rv->{__o})); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_n_s8 ( &int8_t  &__a) {  &__builtin_mve_vdupq_n_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_n_s16 ( &int16_t  &__a) {  &__builtin_mve_vdupq_n_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_n_s32 ( &int32_t  &__a) {  &__builtin_mve_vdupq_n_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabsq_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vabsq_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabsq_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vabsq_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabsq_s32 ( &int32x4_t  &__a) {  &__builtin_mve_vabsq_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclsq_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vclsq_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclsq_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vclsq_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclsq_s32 ( &int32x4_t  &__a) {  &__builtin_mve_vclsq_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vclzq_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vclzq_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_s32 ( &int32x4_t  &__a) {  &__builtin_mve_vclzq_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vnegq_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vnegq_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vnegq_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vnegq_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vnegq_s32 ( &int32x4_t  &__a) {  &__builtin_mve_vnegq_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddlvq_s32 ( &int32x4_t  &__a) {  &__builtin_mve_vaddlvq_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vaddvq_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vaddvq_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_s32 ( &int32x4_t  &__a) {  &__builtin_mve_vaddvq_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovlbq_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vmovlbq_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovlbq_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vmovlbq_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovltq_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vmovltq_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovltq_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vmovltq_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vmvnq_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vmvnq_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_s32 ( &int32x4_t  &__a) {  &__builtin_mve_vmvnq_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_n_s16 ( &const  &int16_t  &__imm) {  &__builtin_mve_vmvnq_n_sv8hi ( &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_n_s32 ( &const  &int32_t  &__imm) {  &__builtin_mve_vmvnq_n_sv4si ( &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev16q_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vrev16q_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev32q_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vrev32q_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev32q_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vrev32q_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vrev64q_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vrev64q_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_s32 ( &int32x4_t  &__a) {  &__builtin_mve_vrev64q_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqabsq_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vqabsq_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqabsq_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vqabsq_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqabsq_s32 ( &int32x4_t  &__a) {  &__builtin_mve_vqabsq_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqnegq_s8 ( &int8x16_t  &__a) {  &__builtin_mve_vqnegq_sv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqnegq_s16 ( &int16x8_t  &__a) {  &__builtin_mve_vqnegq_sv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqnegq_s32 ( &int32x4_t  &__a) {  &__builtin_mve_vqnegq_sv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_u8 ( &uint8x16_t  &__a) {  &__builtin_mve_vrev64q_uv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_u16 ( &uint16x8_t  &__a) {  &__builtin_mve_vrev64q_uv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_u32 ( &uint32x4_t  &__a) {  &__builtin_mve_vrev64q_uv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_u8 ( &uint8x16_t  &__a) {  &__builtin_mve_vmvnq_uv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_u16 ( &uint16x8_t  &__a) {  &__builtin_mve_vmvnq_uv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_u32 ( &uint32x4_t  &__a) {  &__builtin_mve_vmvnq_uv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_n_u8 ( &uint8_t  &__a) {  &__builtin_mve_vdupq_n_uv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_n_u16 ( &uint16_t  &__a) {  &__builtin_mve_vdupq_n_uv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_n_u32 ( &uint32_t  &__a) {  &__builtin_mve_vdupq_n_uv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_u8 ( &uint8x16_t  &__a) {  &__builtin_mve_vclzq_uv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_u16 ( &uint16x8_t  &__a) {  &__builtin_mve_vclzq_uv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_u32 ( &uint32x4_t  &__a) {  &__builtin_mve_vclzq_uv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_u8 ( &uint8x16_t  &__a) {  &__builtin_mve_vaddvq_uv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_u16 ( &uint16x8_t  &__a) {  &__builtin_mve_vaddvq_uv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_u32 ( &uint32x4_t  &__a) {  &__builtin_mve_vaddvq_uv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev32q_u8 ( &uint8x16_t  &__a) {  &__builtin_mve_vrev32q_uv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev32q_u16 ( &uint16x8_t  &__a) {  &__builtin_mve_vrev32q_uv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovltq_u8 ( &uint8x16_t  &__a) {  &__builtin_mve_vmovltq_uv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovltq_u16 ( &uint16x8_t  &__a) {  &__builtin_mve_vmovltq_uv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovlbq_u8 ( &uint8x16_t  &__a) {  &__builtin_mve_vmovlbq_uv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovlbq_u16 ( &uint16x8_t  &__a) {  &__builtin_mve_vmovlbq_uv8hi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_n_u16 ( &const \'int\'  &__imm) {  &__builtin_mve_vmvnq_n_uv8hi ( &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_n_u32 ( &const \'int\'  &__imm) {  &__builtin_mve_vmvnq_n_uv4si ( &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev16q_u8 ( &uint8x16_t  &__a) {  &__builtin_mve_vrev16q_uv16qi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddlvq_u32 ( &uint32x4_t  &__a) {  &__builtin_mve_vaddlvq_uv4si ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vctp16q ( &uint32_t  &__a) {  &__builtin_mve_vctp16qhi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vctp32q ( &uint32_t  &__a) {  &__builtin_mve_vctp32qhi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vctp64q ( &uint32_t  &__a) {  &__builtin_mve_vctp64qhi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vctp8q ( &uint32_t  &__a) {  &__builtin_mve_vctp8qhi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vpnot ( &mve_pred16_t  &__a) {  &__builtin_mve_vpnothi ( &__a); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcreateq_u8 ( &uint64_t  &__a,  &uint64_t  &__b) {  &__builtin_mve_vcreateq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcreateq_u16 ( &uint64_t  &__a,  &uint64_t  &__b) {  &__builtin_mve_vcreateq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcreateq_u32 ( &uint64_t  &__a,  &uint64_t  &__b) {  &__builtin_mve_vcreateq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcreateq_u64 ( &uint64_t  &__a,  &uint64_t  &__b) {  &__builtin_mve_vcreateq_uv2di ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcreateq_s8 ( &uint64_t  &__a,  &uint64_t  &__b) {  &__builtin_mve_vcreateq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcreateq_s16 ( &uint64_t  &__a,  &uint64_t  &__b) {  &__builtin_mve_vcreateq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcreateq_s32 ( &uint64_t  &__a,  &uint64_t  &__b) {  &__builtin_mve_vcreateq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcreateq_s64 ( &uint64_t  &__a,  &uint64_t  &__b) {  &__builtin_mve_vcreateq_sv2di ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_n_s8 ( &int8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshrq_n_sv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshrq_n_sv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_n_s32 ( &int32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshrq_n_sv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_n_u8 ( &uint8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshrq_n_uv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_n_u16 ( &uint16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshrq_n_uv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_n_u32 ( &uint32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshrq_n_uv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddlvq_p_s32 ( &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddlvq_p_sv4si ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddlvq_p_u32 ( &uint32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddlvq_p_uv4si ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vcmpneq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vcmpneq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vcmpneq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vcmpneq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vcmpneq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vcmpneq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vshlq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vshlq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vshlq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_u8 ( &uint8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vshlq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_u16 ( &uint16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vshlq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_u32 ( &uint32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vshlq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vsubq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vsubq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vrmulhq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vrhaddq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vqsubq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vqsubq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vqaddq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vqaddq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vorrq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vornq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vmulq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vmulq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vmulltq_int_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vmullbq_int_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vmulhq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vmladavq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_u8 ( &uint8_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vminvq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vminq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_u8 ( &uint8_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vmaxvq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vmaxq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vhsubq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vhsubq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vhaddq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vhaddq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_veorq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vcmpneq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vcmphiq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vcmphiq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vcmpeqq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vcmpeqq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vcmpcsq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vcmpcsq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vcaddq_rot90_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vcaddq_rot270_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vbicq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vandq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_p_u8 ( &uint8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvq_p_uv16qi ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_u8 ( &uint32_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vaddvaq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b) {  &__builtin_mve_vaddq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vabdq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_r_u8 ( &uint8x16_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vshlq_r_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_u8 ( &uint8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vrshlq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_n_u8 ( &uint8x16_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vrshlq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_u8 ( &uint8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqshlq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_r_u8 ( &uint8x16_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqshlq_r_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_u8 ( &uint8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqrshlq_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_n_u8 ( &uint8x16_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqrshlq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminavq_s8 ( &uint8_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vminavq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminaq_s8 ( &uint8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vminaq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxavq_s8 ( &uint8_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmaxavq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxaq_s8 ( &uint8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmaxaq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_n_u8 ( &uint8x16_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vbrsrq_n_uv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_n_u8 ( &uint8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshlq_n_uv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_n_u8 ( &uint8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrq_n_uv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_n_u8 ( &uint8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vqshlq_n_uv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vcmpneq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vcmpltq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vcmpltq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vcmpleq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vcmpleq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vcmpgtq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vcmpgtq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vcmpgeq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vcmpgeq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vcmpeqq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vcmpeqq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshluq_n_s8 ( &int8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vqshluq_n_sv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_p_s8 ( &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvq_p_sv16qi ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vsubq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vsubq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_r_s8 ( &int8x16_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vshlq_r_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vrshlq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_n_s8 ( &int8x16_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vrshlq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vrmulhq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vrhaddq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqsubq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vqsubq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqshlq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_r_s8 ( &int8x16_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqshlq_r_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqrshlq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_n_s8 ( &int8x16_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqrshlq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqrdmulhq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vqrdmulhq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqdmulhq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vqdmulhq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqaddq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vqaddq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vorrq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vornq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmulq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vmulq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmulltq_int_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmullbq_int_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmulhq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavxq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmlsdavxq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmlsdavq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavxq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmladavxq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmladavq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_s8 ( &int8_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vminvq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vminq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_s8 ( &int8_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmaxvq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vmaxq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vhsubq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vhsubq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot90_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vhcaddq_rot90_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot270_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vhcaddq_rot270_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vhaddq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vhaddq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_veorq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vcaddq_rot90_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vcaddq_rot270_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_n_s8 ( &int8x16_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vbrsrq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vbicq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vandq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_s8 ( &int32_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vaddvaq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b) {  &__builtin_mve_vaddq_n_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vabdq_sv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_n_s8 ( &int8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshlq_n_sv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_n_s8 ( &int8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrq_n_sv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_n_s8 ( &int8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vqshlq_n_sv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vsubq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vsubq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vrmulhq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vrhaddq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vqsubq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vqsubq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vqaddq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vqaddq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vorrq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vornq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmulq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vmulq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmulltq_int_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmullbq_int_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmulhq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmladavq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_u16 ( &uint16_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vminvq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vminq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_u16 ( &uint16_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmaxvq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmaxq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vhsubq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vhsubq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vhaddq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vhaddq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_veorq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vcmpneq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vcmphiq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vcmphiq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vcmpeqq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vcmpeqq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vcmpcsq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vcmpcsq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vcaddq_rot90_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vcaddq_rot270_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vbicq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vandq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_p_u16 ( &uint16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvq_p_uv8hi ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_u16 ( &uint32_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vaddvaq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b) {  &__builtin_mve_vaddq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vabdq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_r_u16 ( &uint16x8_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vshlq_r_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_u16 ( &uint16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vrshlq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_n_u16 ( &uint16x8_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vrshlq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_u16 ( &uint16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqshlq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_r_u16 ( &uint16x8_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqshlq_r_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_u16 ( &uint16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqrshlq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_n_u16 ( &uint16x8_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqrshlq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminavq_s16 ( &uint16_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vminavq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminaq_s16 ( &uint16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vminaq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxavq_s16 ( &uint16_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmaxavq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxaq_s16 ( &uint16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmaxaq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_n_u16 ( &uint16x8_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vbrsrq_n_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_n_u16 ( &uint16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshlq_n_uv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_n_u16 ( &uint16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrq_n_uv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_n_u16 ( &uint16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vqshlq_n_uv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vcmpneq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vcmpltq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vcmpltq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vcmpleq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vcmpleq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vcmpgtq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vcmpgtq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vcmpgeq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vcmpgeq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vcmpeqq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vcmpeqq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshluq_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vqshluq_n_sv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_p_s16 ( &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvq_p_sv8hi ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vsubq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vsubq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_r_s16 ( &int16x8_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vshlq_r_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vrshlq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_n_s16 ( &int16x8_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vrshlq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vrmulhq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vrhaddq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqsubq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vqsubq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqshlq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_r_s16 ( &int16x8_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqshlq_r_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqrshlq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_n_s16 ( &int16x8_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqrshlq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqrdmulhq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vqrdmulhq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqdmulhq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vqdmulhq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqaddq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vqaddq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vorrq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vornq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmulq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vmulq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmulltq_int_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmullbq_int_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmulhq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavxq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmlsdavxq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmlsdavq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavxq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmladavxq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmladavq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_s16 ( &int16_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vminvq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vminq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_s16 ( &int16_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmaxvq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmaxq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vhsubq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vhsubq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot90_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vhcaddq_rot90_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot270_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vhcaddq_rot270_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vhaddq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vhaddq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_veorq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vcaddq_rot90_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vcaddq_rot270_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_n_s16 ( &int16x8_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vbrsrq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vbicq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vandq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_s16 ( &int32_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vaddvaq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vaddq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vabdq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshlq_n_sv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrq_n_sv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vqshlq_n_sv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vsubq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vsubq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vrmulhq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vrhaddq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vqsubq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vqsubq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vqaddq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vqaddq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vorrq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vornq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vmulq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vmulq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vmulltq_int_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vmullbq_int_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vmulhq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vmladavq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_u32 ( &uint32_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vminvq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vminq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_u32 ( &uint32_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vmaxvq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vmaxq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vhsubq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vhsubq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vhaddq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vhaddq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_veorq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vcmpneq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vcmphiq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vcmphiq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vcmpeqq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vcmpeqq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vcmpcsq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vcmpcsq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vcaddq_rot90_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vcaddq_rot270_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vbicq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vandq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_p_u32 ( &uint32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvq_p_uv4si ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_u32 ( &uint32_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vaddvaq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b) {  &__builtin_mve_vaddq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vabdq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_r_u32 ( &uint32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vshlq_r_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_u32 ( &uint32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vrshlq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_n_u32 ( &uint32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vrshlq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_u32 ( &uint32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqshlq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_r_u32 ( &uint32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqshlq_r_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_u32 ( &uint32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqrshlq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_n_u32 ( &uint32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqrshlq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminavq_s32 ( &uint32_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vminavq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminaq_s32 ( &uint32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vminaq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxavq_s32 ( &uint32_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmaxavq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxaq_s32 ( &uint32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmaxaq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_n_u32 ( &uint32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vbrsrq_n_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_n_u32 ( &uint32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshlq_n_uv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_n_u32 ( &uint32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrq_n_uv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_n_u32 ( &uint32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vqshlq_n_uv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vcmpneq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vcmpltq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vcmpltq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vcmpleq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vcmpleq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vcmpgtq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vcmpgtq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vcmpgeq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vcmpgeq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vcmpeqq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vcmpeqq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshluq_n_s32 ( &int32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vqshluq_n_sv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvq_p_s32 ( &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvq_p_sv4si ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vsubq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vsubq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_r_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vshlq_r_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vrshlq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vrshlq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vrmulhq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vrhaddq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqsubq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqsubq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqshlq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_r_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqshlq_r_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqrshlq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqrshlq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqrdmulhq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqrdmulhq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqdmulhq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqdmulhq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqaddq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqaddq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vorrq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vornq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmulq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vmulq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmulltq_int_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmullbq_int_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmulhq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavxq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmlsdavxq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmlsdavq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavxq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmladavxq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmladavq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_s32 ( &int32_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vminvq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vminq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_s32 ( &int32_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmaxvq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmaxq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vhsubq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vhsubq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot90_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vhcaddq_rot90_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot270_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vhcaddq_rot270_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vhaddq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vhaddq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_veorq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vcaddq_rot90_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vcaddq_rot270_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vbrsrq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vbicq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vandq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_s32 ( &int32_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vaddvaq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vaddq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vabdq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_n_s32 ( &int32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshlq_n_sv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_n_s32 ( &int32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrq_n_sv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_n_s32 ( &int32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vqshlq_n_sv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovntq_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vqmovntq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovnbq_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vqmovnbq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_poly_p8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vmulltq_poly_pv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_poly_p8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__builtin_mve_vmullbq_poly_pv16qi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovntq_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmovntq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovnbq_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmovnbq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmlaldavq_uv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovuntq_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqmovuntq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovunbq_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqmovunbq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlltq_n_u8 ( &uint8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshlltq_n_uv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshllbq_n_u8 ( &uint8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshllbq_n_uv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_n_u16 ( &uint16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vorrq_n_uv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_n_u16 ( &uint16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vbicq_n_uv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovntq_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqmovntq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovnbq_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqmovnbq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulltq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqdmulltq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulltq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vqdmulltq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmullbq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqdmullbq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmullbq_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b) {  &__builtin_mve_vqdmullbq_n_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovntq_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmovntq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovnbq_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmovnbq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavxq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmlsldavxq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmlsldavq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavxq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmlaldavxq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vmlaldavq_sv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlltq_n_s8 ( &int8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshlltq_n_sv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshllbq_n_s8 ( &int8x16_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshllbq_n_sv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vorrq_n_sv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vbicq_n_sv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovntq_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vqmovntq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovnbq_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vqmovnbq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_poly_p16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmulltq_poly_pv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_poly_p16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__builtin_mve_vmullbq_poly_pv8hi ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovntq_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vmovntq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovnbq_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vmovnbq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vmlaldavq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovuntq_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqmovuntq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovunbq_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqmovunbq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlltq_n_u16 ( &uint16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshlltq_n_uv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshllbq_n_u16 ( &uint16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshllbq_n_uv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_n_u32 ( &uint32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vorrq_n_uv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_n_u32 ( &uint32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vbicq_n_uv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovntq_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqmovntq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovnbq_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqmovnbq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulltq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqdmulltq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulltq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqdmulltq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmullbq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqdmullbq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmullbq_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b) {  &__builtin_mve_vqdmullbq_n_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovntq_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmovntq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovnbq_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmovnbq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavxq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmlsldavxq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmlsldavq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavxq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmlaldavxq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vmlaldavq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlltq_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshlltq_n_sv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshllbq_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vshllbq_n_sv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_n_s32 ( &int32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vorrq_n_sv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_n_s32 ( &int32x4_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vbicq_n_sv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vrmlaldavhq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vctp8q_m ( &uint32_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vctp8q_mhi ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vctp64q_m ( &uint32_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vctp64q_mhi ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vctp32q_m ( &uint32_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vctp32q_mhi ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vctp16q_m ( &uint32_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vctp16q_mhi ( &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddlvaq_u32 ( &uint64_t  &__a,  &uint32x4_t  &__b) {  &__builtin_mve_vaddlvaq_uv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlsldavhxq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vrmlsldavhxq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlsldavhq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vrmlsldavhq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhxq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vrmlaldavhxq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vrmlaldavhq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddlvaq_s32 ( &int64_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vaddlvaq_sv4si ( &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_s8 ( &uint32_t  &__a,  &int8x16_t  &__b,  &int8x16_t  &__c) {  &__builtin_mve_vabavq_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_s16 ( &uint32_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c) {  &__builtin_mve_vabavq_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_s32 ( &uint32_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vabavq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_u8 ( &uint32_t  &__a,  &uint8x16_t  &__b,  &uint8x16_t  &__c) {  &__builtin_mve_vabavq_uv16qi( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_u16 ( &uint32_t  &__a,  &uint16x8_t  &__b,  &uint16x8_t  &__c) {  &__builtin_mve_vabavq_uv8hi( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_u32 ( &uint32_t  &__a,  &uint32x4_t  &__b,  &uint32x4_t  &__c) {  &__builtin_mve_vabavq_uv4si( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_m_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vbicq_m_n_sv8hi ( &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_m_n_s32 ( &int32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vbicq_m_n_sv4si ( &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_m_n_u16 ( &uint16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vbicq_m_n_uv8hi ( &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_m_n_u32 ( &uint32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vbicq_m_n_uv4si ( &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrnbq_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshrnbq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrnbq_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshrnbq_n_uv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrnbq_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshrnbq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrnbq_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshrnbq_n_uv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrunbq_n_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshrunbq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrunbq_n_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshrunbq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhaq_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vrmlaldavhaq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhaq_u32 ( &uint64_t  &__a,  &uint32x4_t  &__b,  &uint32x4_t  &__c) {  &__builtin_mve_vrmlaldavhaq_uv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlcq_s8 ( &int8x16_t  &__a,  &uint32_t *  &__b,  &const \'int\'  &__imm) {  &int8x16_t  &__res =  &__builtin_mve_vshlcq_vec_sv16qi ( &__a, * &__b,  &__imm); * &__b =  &__builtin_mve_vshlcq_carry_sv16qi ( &__a, * &__b,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlcq_u8 ( &uint8x16_t  &__a,  &uint32_t *  &__b,  &const \'int\'  &__imm) {  &uint8x16_t  &__res =  &__builtin_mve_vshlcq_vec_uv16qi ( &__a, * &__b,  &__imm); * &__b =  &__builtin_mve_vshlcq_carry_uv16qi ( &__a, * &__b,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlcq_s16 ( &int16x8_t  &__a,  &uint32_t *  &__b,  &const \'int\'  &__imm) {  &int16x8_t  &__res =  &__builtin_mve_vshlcq_vec_sv8hi ( &__a, * &__b,  &__imm); * &__b =  &__builtin_mve_vshlcq_carry_sv8hi ( &__a, * &__b,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlcq_u16 ( &uint16x8_t  &__a,  &uint32_t *  &__b,  &const \'int\'  &__imm) {  &uint16x8_t  &__res =  &__builtin_mve_vshlcq_vec_uv8hi ( &__a, * &__b,  &__imm); * &__b =  &__builtin_mve_vshlcq_carry_uv8hi ( &__a, * &__b,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlcq_s32 ( &int32x4_t  &__a,  &uint32_t *  &__b,  &const \'int\'  &__imm) {  &int32x4_t  &__res =  &__builtin_mve_vshlcq_vec_sv4si ( &__a, * &__b,  &__imm); * &__b =  &__builtin_mve_vshlcq_carry_sv4si ( &__a, * &__b,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlcq_u32 ( &uint32x4_t  &__a,  &uint32_t *  &__b,  &const \'int\'  &__imm) {  &uint32x4_t  &__res =  &__builtin_mve_vshlcq_vec_uv4si ( &__a, * &__b,  &__imm); * &__b =  &__builtin_mve_vshlcq_carry_uv4si ( &__a, * &__b,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vpselq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vpselq_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vpselq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vpselq_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev64q_m_uv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmvnq_m_uv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_n_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &uint8_t  &__c) {  &__builtin_mve_vmlasq_n_uv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_n_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &uint8_t  &__c) {  &__builtin_mve_vmlaq_n_uv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_p_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavq_p_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_u8 ( &uint32_t  &__a,  &uint8x16_t  &__b,  &uint8x16_t  &__c) {  &__builtin_mve_vmladavaq_uv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_p_u8 ( &uint8_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminvq_p_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_p_u8 ( &uint8_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxvq_p_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_uv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_n_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_m_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmphiq_m_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_m_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmphiq_m_n_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_n_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_m_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpcsq_m_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_m_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpcsq_m_n_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_uv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_p_u8 ( &uint32_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvaq_p_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_n_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsriq_n_uv16qi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_n_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsliq_n_uv16qi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_r_u8 ( &uint8x16_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_r_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_n_u8 ( &uint8x16_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_n_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_r_u8 ( &uint8x16_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_r_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_n_u8 ( &uint8x16_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_n_uv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminavq_p_s8 ( &uint8_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminavq_p_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminaq_m_s8 ( &uint8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminaq_m_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxavq_p_s8 ( &uint8_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxavq_p_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxaq_m_s8 ( &uint8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxaq_m_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_n_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_m_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpltq_m_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_m_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpltq_m_n_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_m_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpleq_m_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_m_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpleq_m_n_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_m_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgtq_m_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_m_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgtq_m_n_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_m_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgeq_m_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_m_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgeq_m_n_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_n_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_r_s8 ( &int8x16_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_r_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_n_s8 ( &int8x16_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_n_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev64q_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_r_s8 ( &int8x16_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_r_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_n_s8 ( &int8x16_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_n_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqnegq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vqnegq_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqabsq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vqabsq_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vnegq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vnegq_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmvnq_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavxq_p_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavxq_p_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavq_p_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavq_p_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavxq_p_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavxq_p_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_p_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavq_p_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_p_s8 ( &int8_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminvq_p_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_p_s8 ( &int8_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxvq_p_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_m_n_s8 ( &int8x16_t  &__inactive,  &int8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclsq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclsq_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_p_s8 ( &int32_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvaq_p_sv16qi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabsq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vabsq_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhxq_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqrdmlsdhxq_sv16qi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhq_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqrdmlsdhq_sv16qi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlashq_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c) {  &__builtin_mve_vqrdmlashq_n_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlashq_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c) {  &__builtin_mve_vqdmlashq_n_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlahq_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c) {  &__builtin_mve_vqrdmlahq_n_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhxq_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqrdmladhxq_sv16qi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhq_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqrdmladhq_sv16qi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhxq_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqdmlsdhxq_sv16qi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhq_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqdmlsdhq_sv16qi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlahq_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c) {  &__builtin_mve_vqdmlahq_n_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhxq_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqdmladhxq_sv16qi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhq_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b) {  &__builtin_mve_vqdmladhq_sv16qi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaxq_s8 ( &int32_t  &__a,  &int8x16_t  &__b,  &int8x16_t  &__c) {  &__builtin_mve_vmlsdavaxq_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaq_s8 ( &int32_t  &__a,  &int8x16_t  &__b,  &int8x16_t  &__c) {  &__builtin_mve_vmlsdavaq_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c) {  &__builtin_mve_vmlasq_n_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c) {  &__builtin_mve_vmlaq_n_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaxq_s8 ( &int32_t  &__a,  &int8x16_t  &__b,  &int8x16_t  &__c) {  &__builtin_mve_vmladavaxq_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_s8 ( &int32_t  &__a,  &int8x16_t  &__b,  &int8x16_t  &__c) {  &__builtin_mve_vmladavaq_sv16qi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsriq_n_sv16qi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsliq_n_sv16qi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vpselq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vpselq_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vpselq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vpselq_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev64q_m_uv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmvnq_m_uv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_n_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &uint16_t  &__c) {  &__builtin_mve_vmlasq_n_uv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_n_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &uint16_t  &__c) {  &__builtin_mve_vmlaq_n_uv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_p_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavq_p_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_u16 ( &uint32_t  &__a,  &uint16x8_t  &__b,  &uint16x8_t  &__c) {  &__builtin_mve_vmladavaq_uv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_p_u16 ( &uint16_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminvq_p_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_p_u16 ( &uint16_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxvq_p_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_uv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_n_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_m_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmphiq_m_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_m_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmphiq_m_n_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_n_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_m_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpcsq_m_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_m_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpcsq_m_n_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_uv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_p_u16 ( &uint32_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvaq_p_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_n_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsriq_n_uv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_n_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsliq_n_uv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_r_u16 ( &uint16x8_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_r_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_n_u16 ( &uint16x8_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_n_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_r_u16 ( &uint16x8_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_r_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_n_u16 ( &uint16x8_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_n_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminavq_p_s16 ( &uint16_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminavq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminaq_m_s16 ( &uint16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminaq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxavq_p_s16 ( &uint16_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxavq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxaq_m_s16 ( &uint16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxaq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_n_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_m_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpltq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_m_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpltq_m_n_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_m_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpleq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_m_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpleq_m_n_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_m_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgtq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_m_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgtq_m_n_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_m_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgeq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_m_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgeq_m_n_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_n_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_r_s16 ( &int16x8_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_r_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_n_s16 ( &int16x8_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_n_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev64q_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_r_s16 ( &int16x8_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_r_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_n_s16 ( &int16x8_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_n_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqnegq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vqnegq_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqabsq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vqabsq_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vnegq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vnegq_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmvnq_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavxq_p_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavxq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavq_p_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavxq_p_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavxq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_p_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_p_s16 ( &int16_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminvq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_p_s16 ( &int16_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxvq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_m_n_s16 ( &int16x8_t  &__inactive,  &int16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclsq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclsq_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_p_s16 ( &int32_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvaq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabsq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vabsq_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhxq_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqrdmlsdhxq_sv8hi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhq_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqrdmlsdhq_sv8hi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlashq_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c) {  &__builtin_mve_vqrdmlashq_n_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlashq_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c) {  &__builtin_mve_vqdmlashq_n_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlahq_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c) {  &__builtin_mve_vqrdmlahq_n_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhxq_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqrdmladhxq_sv8hi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhq_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqrdmladhq_sv8hi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhxq_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqdmlsdhxq_sv8hi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhq_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqdmlsdhq_sv8hi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlahq_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c) {  &__builtin_mve_vqdmlahq_n_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhxq_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqdmladhxq_sv8hi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhq_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b) {  &__builtin_mve_vqdmladhq_sv8hi ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaxq_s16 ( &int32_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c) {  &__builtin_mve_vmlsdavaxq_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaq_s16 ( &int32_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c) {  &__builtin_mve_vmlsdavaq_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c) {  &__builtin_mve_vmlasq_n_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c) {  &__builtin_mve_vmlaq_n_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaxq_s16 ( &int32_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c) {  &__builtin_mve_vmladavaxq_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_s16 ( &int32_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c) {  &__builtin_mve_vmladavaq_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsriq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsliq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vpselq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vpselq_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vpselq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vpselq_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev64q_m_uv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmvnq_m_uv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_n_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &uint32_t  &__c) {  &__builtin_mve_vmlasq_n_uv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_n_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &uint32_t  &__c) {  &__builtin_mve_vmlaq_n_uv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_p_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavq_p_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_u32 ( &uint32_t  &__a,  &uint32x4_t  &__b,  &uint32x4_t  &__c) {  &__builtin_mve_vmladavaq_uv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_p_u32 ( &uint32_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminvq_p_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_p_u32 ( &uint32_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxvq_p_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_uv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_n_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_m_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmphiq_m_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmphiq_m_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmphiq_m_n_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_n_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_m_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpcsq_m_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpcsq_m_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpcsq_m_n_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_uv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_p_u32 ( &uint32_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvaq_p_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_n_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsriq_n_uv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_n_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsliq_n_uv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_r_u32 ( &uint32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_r_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_n_u32 ( &uint32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_n_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_r_u32 ( &uint32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_r_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_n_u32 ( &uint32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_n_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminavq_p_s32 ( &uint32_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminavq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminaq_m_s32 ( &uint32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminaq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxavq_p_s32 ( &uint32_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxavq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxaq_m_s32 ( &uint32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxaq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpneq_m_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpneq_m_n_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_m_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpltq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpltq_m_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpltq_m_n_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_m_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpleq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpleq_m_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpleq_m_n_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_m_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgtq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgtq_m_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgtq_m_n_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_m_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgeq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpgeq_m_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpgeq_m_n_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcmpeqq_m_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcmpeqq_m_n_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_r_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_r_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_n_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev64q_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev64q_m_sv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_r_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_r_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_n_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqnegq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vqnegq_m_sv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqabsq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vqabsq_m_sv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vnegq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vnegq_m_sv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmvnq_m_sv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavxq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavxq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavxq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavxq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminvq_p_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminvq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxvq_p_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxvq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_m_n_s32 ( &int32x4_t  &__inactive,  &int32_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_sv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_sv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclsq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclsq_m_sv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddvaq_p_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddvaq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabsq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vabsq_m_sv4si ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhxq_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqrdmlsdhxq_sv4si ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhq_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqrdmlsdhq_sv4si ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlashq_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c) {  &__builtin_mve_vqrdmlashq_n_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlashq_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c) {  &__builtin_mve_vqdmlashq_n_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlahq_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c) {  &__builtin_mve_vqrdmlahq_n_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhxq_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqrdmladhxq_sv4si ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhq_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqrdmladhq_sv4si ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhxq_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqdmlsdhxq_sv4si ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhq_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqdmlsdhq_sv4si ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlahq_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c) {  &__builtin_mve_vqdmlahq_n_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhxq_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqdmladhxq_sv4si ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhq_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b) {  &__builtin_mve_vqdmladhq_sv4si ( &__inactive,  &__a,  &__b); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaxq_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vmlsdavaxq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaq_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vmlsdavaq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c) {  &__builtin_mve_vmlasq_n_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c) {  &__builtin_mve_vmlaq_n_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaxq_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vmladavaxq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vmladavaq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsriq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vsliq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vpselq_u64 ( &uint64x2_t  &__a,  &uint64x2_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vpselq_uv2di ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vpselq_s64 ( &int64x2_t  &__a,  &int64x2_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vpselq_sv2di ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhaxq_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vrmlaldavhaxq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlsldavhaq_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vrmlsldavhaq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlsldavhaxq_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vrmlsldavhaxq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddlvaq_p_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddlvaq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev16q_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev16q_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmlaldavhq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhxq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmlaldavhxq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlsldavhq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmlsldavhq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlsldavhxq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmlsldavhxq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddlvaq_p_u32 ( &uint64_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddlvaq_p_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev16q_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev16q_m_uv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhq_p_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmlaldavhq_p_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_m_n_s16 ( &int16x8_t  &__inactive,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vmvnq_m_n_sv8hi ( &__inactive,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_m_n_s16 ( &int16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vorrq_m_n_sv8hi ( &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrntq_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshrntq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrnbq_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshrnbq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrntq_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshrntq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrnbq_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrnbq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrntq_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrntq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrnbq_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vshrnbq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrntq_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vshrntq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaq_s16 ( &int64_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c) {  &__builtin_mve_vmlaldavaq_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaxq_s16 ( &int64_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c) {  &__builtin_mve_vmlaldavaxq_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavaq_s16 ( &int64_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c) {  &__builtin_mve_vmlsldavaq_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavaxq_s16 ( &int64_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c) {  &__builtin_mve_vmlsldavaxq_sv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavq_p_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavxq_p_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavxq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavq_p_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsldavq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavxq_p_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsldavxq_p_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovlbq_m_s8 ( &int16x8_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovlbq_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovltq_m_s8 ( &int16x8_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovltq_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovnbq_m_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovnbq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovntq_m_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovntq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovnbq_m_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovnbq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovntq_m_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovntq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev32q_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev32q_m_sv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_m_n_u16 ( &uint16x8_t  &__inactive,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vmvnq_m_n_uv8hi ( &__inactive,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_m_n_u16 ( &uint16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vorrq_m_n_uv8hi ( &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshruntq_n_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshruntq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrunbq_n_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshrunbq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshruntq_n_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshruntq_n_sv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovunbq_m_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovunbq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovuntq_m_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovuntq_m_sv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrntq_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshrntq_n_uv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrnbq_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshrnbq_n_uv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrntq_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshrntq_n_uv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrnbq_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrnbq_n_uv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrntq_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrntq_n_uv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrnbq_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vshrnbq_n_uv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrntq_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vshrntq_n_uv8hi ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaq_u16 ( &uint64_t  &__a,  &uint16x8_t  &__b,  &uint16x8_t  &__c) {  &__builtin_mve_vmlaldavaq_uv8hi ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavq_p_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavq_p_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovlbq_m_u8 ( &uint16x8_t  &__inactive,  &uint8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovlbq_m_uv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovltq_m_u8 ( &uint16x8_t  &__inactive,  &uint8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovltq_m_uv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovnbq_m_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovnbq_m_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovntq_m_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovntq_m_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovnbq_m_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovnbq_m_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovntq_m_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovntq_m_uv8hi ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev32q_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev32q_m_uv16qi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_m_n_s32 ( &int32x4_t  &__inactive,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vmvnq_m_n_sv4si ( &__inactive,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_m_n_s32 ( &int32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vorrq_m_n_sv4si ( &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrntq_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshrntq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrnbq_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshrnbq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrntq_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshrntq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrnbq_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrnbq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrntq_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrntq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrnbq_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vshrnbq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrntq_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vshrntq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaq_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vmlaldavaq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaxq_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vmlaldavaxq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavaq_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vmlsldavaq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavaxq_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c) {  &__builtin_mve_vmlsldavaxq_sv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavxq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavxq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsldavq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavxq_p_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsldavxq_p_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovlbq_m_s16 ( &int32x4_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovlbq_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovltq_m_s16 ( &int32x4_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovltq_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovnbq_m_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovnbq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovntq_m_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovntq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovnbq_m_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovnbq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovntq_m_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovntq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev32q_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev32q_m_sv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmvnq_m_n_u32 ( &uint32x4_t  &__inactive,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vmvnq_m_n_uv4si ( &__inactive,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_m_n_u32 ( &uint32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vorrq_m_n_uv4si ( &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshruntq_n_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshruntq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrunbq_n_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshrunbq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshruntq_n_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshruntq_n_sv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovunbq_m_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovunbq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovuntq_m_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovuntq_m_sv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrntq_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqrshrntq_n_uv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrnbq_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshrnbq_n_uv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrntq_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vqshrntq_n_uv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrnbq_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrnbq_n_uv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrntq_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vrshrntq_n_uv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrnbq_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vshrnbq_n_uv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrntq_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm) {  &__builtin_mve_vshrntq_n_uv4si ( &__a,  &__b,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaq_u32 ( &uint64_t  &__a,  &uint32x4_t  &__b,  &uint32x4_t  &__c) {  &__builtin_mve_vmlaldavaq_uv4si ( &__a,  &__b,  &__c); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavq_p_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavq_p_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovlbq_m_u16 ( &uint32x4_t  &__inactive,  &uint16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovlbq_m_uv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovltq_m_u16 ( &uint32x4_t  &__inactive,  &uint16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovltq_m_uv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovnbq_m_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovnbq_m_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmovntq_m_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmovntq_m_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovnbq_m_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovnbq_m_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqmovntq_m_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqmovntq_m_uv4si ( &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrev32q_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vrev32q_m_uv8hi ( &__inactive,  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_m_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsriq_m_n_sv16qi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshluq_m_n_s8 ( &uint8x16_t  &__inactive,  &int8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshluq_m_n_sv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_p_s8 ( &uint32_t  &__a,  &int8x16_t  &__b,  &int8x16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vabavq_p_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_m_n_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsriq_m_n_uv16qi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_p_u8 ( &uint32_t  &__a,  &uint8x16_t  &__b,  &uint8x16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vabavq_p_uv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_m_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsriq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshluq_m_n_s16 ( &uint16x8_t  &__inactive,  &int16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshluq_m_n_sv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_p_s16 ( &uint32_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vabavq_p_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_m_n_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsriq_m_n_uv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_p_u16 ( &uint32_t  &__a,  &uint16x8_t  &__b,  &uint16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vabavq_p_uv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_m_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsriq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshluq_m_n_s32 ( &uint32x4_t  &__inactive,  &int32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshluq_m_n_sv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_p_s32 ( &uint32_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vabavq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsriq_m_n_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsriq_m_n_uv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabavq_p_u32 ( &uint32_t  &__a,  &uint32x4_t  &__b,  &uint32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vabavq_p_uv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a, \'int\'  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a, \'int\'  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a, \'int\'  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a, \'int\'  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a, \'int\'  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a, \'int\'  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vandq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vandq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vandq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vandq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vandq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vandq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbicq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbicq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbicq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbicq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbicq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbicq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbicq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbrsrq_m_n_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbrsrq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbrsrq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbrsrq_m_n_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbrsrq_m_n_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vbrsrq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vbrsrq_m_n_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_veorq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_veorq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_veorq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_veorq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_veorq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_veorq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_veorq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot270_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot270_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot270_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot270_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot270_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot270_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot90_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot90_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot90_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot90_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot90_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot90_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_p_s8 ( &int32_t  &__a,  &int8x16_t  &__b,  &int8x16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavaq_p_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_p_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavaq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_p_s16 ( &int32_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavaq_p_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_p_u8 ( &uint32_t  &__a,  &uint8x16_t  &__b,  &uint8x16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavaq_p_uv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_p_u32 ( &uint32_t  &__a,  &uint32x4_t  &__b,  &uint32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavaq_p_uv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaq_p_u16 ( &uint32_t  &__a,  &uint16x8_t  &__b,  &uint16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavaq_p_uv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaxq_p_s8 ( &int32_t  &__a,  &int8x16_t  &__b,  &int8x16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavaxq_p_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaxq_p_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavaxq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmladavaxq_p_s16 ( &int32_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmladavaxq_p_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_m_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaq_m_n_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_m_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaq_m_n_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_m_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaq_m_n_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_m_n_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &uint8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaq_m_n_uv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_m_n_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &uint32_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaq_m_n_uv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaq_m_n_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &uint16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaq_m_n_uv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_m_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlasq_m_n_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_m_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlasq_m_n_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_m_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlasq_m_n_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_m_n_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &uint8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlasq_m_n_uv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_m_n_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &uint32_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlasq_m_n_uv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlasq_m_n_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &uint16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlasq_m_n_uv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaq_p_s8 ( &int32_t  &__a,  &int8x16_t  &__b,  &int8x16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavaq_p_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaq_p_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavaq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaq_p_s16 ( &int32_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavaq_p_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaxq_p_s8 ( &int32_t  &__a,  &int8x16_t  &__b,  &int8x16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavaxq_p_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaxq_p_s32 ( &int32_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavaxq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsdavaxq_p_s16 ( &int32_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsdavaxq_p_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_m_s8 ( &int16x8_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_m_s32 ( &int64x2_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_m_s16 ( &int32x4_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_m_u8 ( &uint16x8_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_m_u32 ( &uint64x2_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_m_u16 ( &uint32x4_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_m_s8 ( &int16x8_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_m_s32 ( &int64x2_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_m_s16 ( &int32x4_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_m_u8 ( &uint16x8_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_m_u32 ( &uint64x2_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_m_u16 ( &uint32x4_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vornq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vornq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vornq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vornq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vornq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vornq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vornq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vorrq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vorrq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vorrq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vorrq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vorrq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vorrq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vorrq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_n_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_n_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_n_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_n_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqaddq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqaddq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmladhq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmladhq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmladhq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhxq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmladhxq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhxq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmladhxq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmladhxq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmladhxq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlahq_m_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlahq_m_n_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlahq_m_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlahq_m_n_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlahq_m_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlahq_m_n_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlsdhq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlsdhq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlsdhq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhxq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlsdhxq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhxq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlsdhxq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlsdhxq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlsdhxq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmulhq_m_n_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmulhq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmulhq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmulhq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmulhq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulhq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmulhq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmladhq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmladhq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmladhq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhxq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmladhxq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhxq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmladhxq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmladhxq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmladhxq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlahq_m_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlahq_m_n_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlahq_m_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlahq_m_n_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlahq_m_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlahq_m_n_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlashq_m_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlashq_m_n_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlashq_m_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlashq_m_n_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlashq_m_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlashq_m_n_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlashq_m_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &int8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlashq_m_n_sv16qi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlashq_m_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &int16_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlashq_m_n_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmlashq_m_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &int32_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmlashq_m_n_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlsdhq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlsdhq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlsdhq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhxq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlsdhxq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhxq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlsdhxq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmlsdhxq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmlsdhxq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmulhq_m_n_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmulhq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmulhq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmulhq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmulhq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrdmulhq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrdmulhq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshlq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshlq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_n_sv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_n_sv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_n_sv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_n_uv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_n_uv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_n_uv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshlq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshlq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_n_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_n_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_n_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_n_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqsubq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqsubq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshlq_m_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshlq_m_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrq_m_n_sv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrq_m_n_sv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrq_m_n_sv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrq_m_n_uv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrq_m_n_uv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrq_m_n_uv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_n_sv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_n_sv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_n_sv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_n_uv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_n_uv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlq_m_n_uv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrq_m_n_sv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrq_m_n_sv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrq_m_n_sv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrq_m_n_uv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrq_m_n_uv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrq_m_n_uv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_m_n_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsliq_m_n_sv16qi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_m_n_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsliq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_m_n_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsliq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_m_n_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsliq_m_n_uv16qi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_m_n_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsliq_m_n_uv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsliq_m_n_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vsliq_m_n_uv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_n_s8 ( &int8x16_t  &__inactive,  &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_sv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_n_s32 ( &int32x4_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_n_s16 ( &int16x8_t  &__inactive,  &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_uv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_uv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_uv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaq_p_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavaq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaq_p_s16 ( &int64_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavaq_p_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaq_p_u32 ( &uint64_t  &__a,  &uint32x4_t  &__b,  &uint32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavaq_p_uv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaq_p_u16 ( &uint64_t  &__a,  &uint16x8_t  &__b,  &uint16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavaq_p_uv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaxq_p_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavaxq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlaldavaxq_p_s16 ( &int64_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlaldavaxq_p_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavaq_p_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsldavaq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavaq_p_s16 ( &int64_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsldavaq_p_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavaxq_p_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsldavaxq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmlsldavaxq_p_s16 ( &int64_t  &__a,  &int16x8_t  &__b,  &int16x8_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vmlsldavaxq_p_sv8hi ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_poly_m_p8 ( &uint16x8_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_poly_m_pv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_poly_m_p16 ( &uint32x4_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_poly_m_pv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_poly_m_p8 ( &uint16x8_t  &__inactive,  &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_poly_m_pv16qi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_poly_m_p16 ( &uint32x4_t  &__inactive,  &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_poly_m_pv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmullbq_m_n_s32 ( &int64x2_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmullbq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmullbq_m_n_s16 ( &int32x4_t  &__inactive,  &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmullbq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmullbq_m_s32 ( &int64x2_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmullbq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmullbq_m_s16 ( &int32x4_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmullbq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulltq_m_n_s32 ( &int64x2_t  &__inactive,  &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmulltq_m_n_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulltq_m_n_s16 ( &int32x4_t  &__inactive,  &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmulltq_m_n_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulltq_m_s32 ( &int64x2_t  &__inactive,  &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmulltq_m_sv4si ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqdmulltq_m_s16 ( &int32x4_t  &__inactive,  &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vqdmulltq_m_sv8hi ( &__inactive,  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrnbq_m_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshrnbq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrnbq_m_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshrnbq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrnbq_m_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshrnbq_m_n_uv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrnbq_m_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshrnbq_m_n_uv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrntq_m_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshrntq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrntq_m_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshrntq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrntq_m_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshrntq_m_n_uv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrntq_m_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshrntq_m_n_uv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrunbq_m_n_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshrunbq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshrunbq_m_n_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshrunbq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshruntq_m_n_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshruntq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqrshruntq_m_n_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqrshruntq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrnbq_m_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshrnbq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrnbq_m_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshrnbq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrnbq_m_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshrnbq_m_n_uv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrnbq_m_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshrnbq_m_n_uv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrntq_m_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshrntq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrntq_m_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshrntq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrntq_m_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshrntq_m_n_uv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrntq_m_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshrntq_m_n_uv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrunbq_m_n_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshrunbq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshrunbq_m_n_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshrunbq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshruntq_m_n_s32 ( &uint16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshruntq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vqshruntq_m_n_s16 ( &uint8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vqshruntq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhaq_p_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmlaldavhaq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhaq_p_u32 ( &uint64_t  &__a,  &uint32x4_t  &__b,  &uint32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmlaldavhaq_p_uv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlaldavhaxq_p_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmlaldavhaxq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlsldavhaq_p_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmlsldavhaq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmlsldavhaxq_p_s32 ( &int64_t  &__a,  &int32x4_t  &__b,  &int32x4_t  &__c,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmlsldavhaxq_p_sv4si ( &__a,  &__b,  &__c,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrnbq_m_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrnbq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrnbq_m_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrnbq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrnbq_m_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrnbq_m_n_uv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrnbq_m_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrnbq_m_n_uv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrntq_m_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrntq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrntq_m_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrntq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrntq_m_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrntq_m_n_uv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrshrntq_m_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vrshrntq_m_n_uv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshllbq_m_n_s8 ( &int16x8_t  &__inactive,  &int8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshllbq_m_n_sv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshllbq_m_n_s16 ( &int32x4_t  &__inactive,  &int16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshllbq_m_n_sv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshllbq_m_n_u8 ( &uint16x8_t  &__inactive,  &uint8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshllbq_m_n_uv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshllbq_m_n_u16 ( &uint32x4_t  &__inactive,  &uint16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshllbq_m_n_uv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlltq_m_n_s8 ( &int16x8_t  &__inactive,  &int8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlltq_m_n_sv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlltq_m_n_s16 ( &int32x4_t  &__inactive,  &int16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlltq_m_n_sv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlltq_m_n_u8 ( &uint16x8_t  &__inactive,  &uint8x16_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlltq_m_n_uv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshlltq_m_n_u16 ( &uint32x4_t  &__inactive,  &uint16x8_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshlltq_m_n_uv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrnbq_m_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrnbq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrnbq_m_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrnbq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrnbq_m_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrnbq_m_n_uv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrnbq_m_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrnbq_m_n_uv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrntq_m_n_s32 ( &int16x8_t  &__a,  &int32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrntq_m_n_sv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrntq_m_n_s16 ( &int8x16_t  &__a,  &int16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrntq_m_n_sv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrntq_m_n_u32 ( &uint16x8_t  &__a,  &uint32x4_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrntq_m_n_uv4si ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vshrntq_m_n_u16 ( &uint8x16_t  &__a,  &uint16x8_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vshrntq_m_n_uv8hi ( &__a,  &__b,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_s8 ( &int8_t *  &__base,  &uint8x16_t  &__offset,  &int8x16_t  &__value) {  &__builtin_mve_vstrbq_scatter_offset_sv16qi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_s32 ( &int8_t *  &__base,  &uint32x4_t  &__offset,  &int32x4_t  &__value) {  &__builtin_mve_vstrbq_scatter_offset_sv4si (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_s16 ( &int8_t *  &__base,  &uint16x8_t  &__offset,  &int16x8_t  &__value) {  &__builtin_mve_vstrbq_scatter_offset_sv8hi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_u8 ( &uint8_t *  &__base,  &uint8x16_t  &__offset,  &uint8x16_t  &__value) {  &__builtin_mve_vstrbq_scatter_offset_uv16qi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_u32 ( &uint8_t *  &__base,  &uint32x4_t  &__offset,  &uint32x4_t  &__value) {  &__builtin_mve_vstrbq_scatter_offset_uv4si (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_u16 ( &uint8_t *  &__base,  &uint16x8_t  &__offset,  &uint16x8_t  &__value) {  &__builtin_mve_vstrbq_scatter_offset_uv8hi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_s8 ( &int8_t *  &__addr,  &int8x16_t  &__value) {  &__builtin_mve_vstrbq_sv16qi (( &__builtin_neon_qi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_s32 ( &int8_t *  &__addr,  &int32x4_t  &__value) {  &__builtin_mve_vstrbq_sv4si (( &__builtin_neon_qi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_s16 ( &int8_t *  &__addr,  &int16x8_t  &__value) {  &__builtin_mve_vstrbq_sv8hi (( &__builtin_neon_qi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_u8 ( &uint8_t *  &__addr,  &uint8x16_t  &__value) {  &__builtin_mve_vstrbq_uv16qi (( &__builtin_neon_qi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_u32 ( &uint8_t *  &__addr,  &uint32x4_t  &__value) {  &__builtin_mve_vstrbq_uv4si (( &__builtin_neon_qi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_u16 ( &uint8_t *  &__addr,  &uint16x8_t  &__value) {  &__builtin_mve_vstrbq_uv8hi (( &__builtin_neon_qi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_base_s32 ( &uint32x4_t  &__addr,  &const \'int\'  &__offset,  &int32x4_t  &__value) {  &__builtin_mve_vstrwq_scatter_base_sv4si ( &__addr,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_base_u32 ( &uint32x4_t  &__addr,  &const \'int\'  &__offset,  &uint32x4_t  &__value) {  &__builtin_mve_vstrwq_scatter_base_uv4si ( &__addr,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_u8 ( &uint8_t  &const *  &__base,  &uint8x16_t  &__offset) {  &__builtin_mve_vldrbq_gather_offset_uv16qi (( &__builtin_neon_qi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_s8 ( &int8_t  &const *  &__base,  &uint8x16_t  &__offset) {  &__builtin_mve_vldrbq_gather_offset_sv16qi (( &__builtin_neon_qi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_s8 ( &int8_t  &const *  &__base) {  &__builtin_mve_vldrbq_sv16qi (( &__builtin_neon_qi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_u8 ( &uint8_t  &const *  &__base) {  &__builtin_mve_vldrbq_uv16qi (( &__builtin_neon_qi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_u16 ( &uint8_t  &const *  &__base,  &uint16x8_t  &__offset) {  &__builtin_mve_vldrbq_gather_offset_uv8hi (( &__builtin_neon_qi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_s16 ( &int8_t  &const *  &__base,  &uint16x8_t  &__offset) {  &__builtin_mve_vldrbq_gather_offset_sv8hi (( &__builtin_neon_qi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_s16 ( &int8_t  &const *  &__base) {  &__builtin_mve_vldrbq_sv8hi (( &__builtin_neon_qi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_u16 ( &uint8_t  &const *  &__base) {  &__builtin_mve_vldrbq_uv8hi (( &__builtin_neon_qi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_u32 ( &uint8_t  &const *  &__base,  &uint32x4_t  &__offset) {  &__builtin_mve_vldrbq_gather_offset_uv4si (( &__builtin_neon_qi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_s32 ( &int8_t  &const *  &__base,  &uint32x4_t  &__offset) {  &__builtin_mve_vldrbq_gather_offset_sv4si (( &__builtin_neon_qi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_s32 ( &int8_t  &const *  &__base) {  &__builtin_mve_vldrbq_sv4si (( &__builtin_neon_qi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_u32 ( &uint8_t  &const *  &__base) {  &__builtin_mve_vldrbq_uv4si (( &__builtin_neon_qi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_base_s32 ( &uint32x4_t  &__addr,  &const \'int\'  &__offset) {  &__builtin_mve_vldrwq_gather_base_sv4si ( &__addr,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_base_u32 ( &uint32x4_t  &__addr,  &const \'int\'  &__offset) {  &__builtin_mve_vldrwq_gather_base_uv4si ( &__addr,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_p_s8 ( &int8_t *  &__addr,  &int8x16_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_p_sv16qi (( &__builtin_neon_qi *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_p_s32 ( &int8_t *  &__addr,  &int32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_p_sv4si (( &__builtin_neon_qi *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_p_s16 ( &int8_t *  &__addr,  &int16x8_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_p_sv8hi (( &__builtin_neon_qi *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_p_u8 ( &uint8_t *  &__addr,  &uint8x16_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_p_uv16qi (( &__builtin_neon_qi *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_p_u32 ( &uint8_t *  &__addr,  &uint32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_p_uv4si (( &__builtin_neon_qi *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_p_u16 ( &uint8_t *  &__addr,  &uint16x8_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_p_uv8hi (( &__builtin_neon_qi *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_p_s8 ( &int8_t *  &__base,  &uint8x16_t  &__offset,  &int8x16_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_scatter_offset_p_sv16qi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_p_s32 ( &int8_t *  &__base,  &uint32x4_t  &__offset,  &int32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_scatter_offset_p_sv4si (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_p_s16 ( &int8_t *  &__base,  &uint16x8_t  &__offset,  &int16x8_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_scatter_offset_p_sv8hi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_p_u8 ( &uint8_t *  &__base,  &uint8x16_t  &__offset,  &uint8x16_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_scatter_offset_p_uv16qi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_p_u32 ( &uint8_t *  &__base,  &uint32x4_t  &__offset,  &uint32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_scatter_offset_p_uv4si (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrbq_scatter_offset_p_u16 ( &uint8_t *  &__base,  &uint16x8_t  &__offset,  &uint16x8_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrbq_scatter_offset_p_uv8hi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_base_p_s32 ( &uint32x4_t  &__addr,  &const \'int\'  &__offset,  &int32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrwq_scatter_base_p_sv4si ( &__addr,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_base_p_u32 ( &uint32x4_t  &__addr,  &const \'int\'  &__offset,  &uint32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrwq_scatter_base_p_uv4si ( &__addr,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_z_s8 ( &int8_t  &const *  &__base,  &uint8x16_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_gather_offset_z_sv16qi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_z_s32 ( &int8_t  &const *  &__base,  &uint32x4_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_gather_offset_z_sv4si (( &__builtin_neon_qi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_z_s16 ( &int8_t  &const *  &__base,  &uint16x8_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_gather_offset_z_sv8hi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_z_u8 ( &uint8_t  &const *  &__base,  &uint8x16_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_gather_offset_z_uv16qi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_z_u32 ( &uint8_t  &const *  &__base,  &uint32x4_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_gather_offset_z_uv4si (( &__builtin_neon_qi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_gather_offset_z_u16 ( &uint8_t  &const *  &__base,  &uint16x8_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_gather_offset_z_uv8hi (( &__builtin_neon_qi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_z_s8 ( &int8_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_z_sv16qi (( &__builtin_neon_qi *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_z_s32 ( &int8_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_z_sv4si (( &__builtin_neon_qi *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_z_s16 ( &int8_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_z_sv8hi (( &__builtin_neon_qi *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_z_u8 ( &uint8_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_z_uv16qi (( &__builtin_neon_qi *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_z_u32 ( &uint8_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_z_uv4si (( &__builtin_neon_qi *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrbq_z_u16 ( &uint8_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrbq_z_uv8hi (( &__builtin_neon_qi *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_base_z_s32 ( &uint32x4_t  &__addr,  &const \'int\'  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrwq_gather_base_z_sv4si ( &__addr,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_base_z_u32 ( &uint32x4_t  &__addr,  &const \'int\'  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrwq_gather_base_z_uv4si ( &__addr,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vld1q_s8 ( &int8_t  &const *  &__base) {  &__builtin_mve_vld1q_sv16qi (( &__builtin_neon_qi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vld1q_s32 ( &int32_t  &const *  &__base) {  &__builtin_mve_vld1q_sv4si (( &__builtin_neon_si *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vld1q_s16 ( &int16_t  &const *  &__base) {  &__builtin_mve_vld1q_sv8hi (( &__builtin_neon_hi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vld1q_u8 ( &uint8_t  &const *  &__base) {  &__builtin_mve_vld1q_uv16qi (( &__builtin_neon_qi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vld1q_u32 ( &uint32_t  &const *  &__base) {  &__builtin_mve_vld1q_uv4si (( &__builtin_neon_si *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vld1q_u16 ( &uint16_t  &const *  &__base) {  &__builtin_mve_vld1q_uv8hi (( &__builtin_neon_hi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_offset_s32 ( &int16_t  &const *  &__base,  &uint32x4_t  &__offset) {  &__builtin_mve_vldrhq_gather_offset_sv4si (( &__builtin_neon_hi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_offset_s16 ( &int16_t  &const *  &__base,  &uint16x8_t  &__offset) {  &__builtin_mve_vldrhq_gather_offset_sv8hi (( &__builtin_neon_hi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_offset_u32 ( &uint16_t  &const *  &__base,  &uint32x4_t  &__offset) {  &__builtin_mve_vldrhq_gather_offset_uv4si (( &__builtin_neon_hi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_offset_u16 ( &uint16_t  &const *  &__base,  &uint16x8_t  &__offset) {  &__builtin_mve_vldrhq_gather_offset_uv8hi (( &__builtin_neon_hi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_offset_z_s32 ( &int16_t  &const *  &__base,  &uint32x4_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_gather_offset_z_sv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_offset_z_s16 ( &int16_t  &const *  &__base,  &uint16x8_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_gather_offset_z_sv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_offset_z_u32 ( &uint16_t  &const *  &__base,  &uint32x4_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_gather_offset_z_uv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_offset_z_u16 ( &uint16_t  &const *  &__base,  &uint16x8_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_gather_offset_z_uv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_shifted_offset_s32 ( &int16_t  &const *  &__base,  &uint32x4_t  &__offset) {  &__builtin_mve_vldrhq_gather_shifted_offset_sv4si (( &__builtin_neon_hi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_shifted_offset_s16 ( &int16_t  &const *  &__base,  &uint16x8_t  &__offset) {  &__builtin_mve_vldrhq_gather_shifted_offset_sv8hi (( &__builtin_neon_hi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_shifted_offset_u32 ( &uint16_t  &const *  &__base,  &uint32x4_t  &__offset) {  &__builtin_mve_vldrhq_gather_shifted_offset_uv4si (( &__builtin_neon_hi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_shifted_offset_u16 ( &uint16_t  &const *  &__base,  &uint16x8_t  &__offset) {  &__builtin_mve_vldrhq_gather_shifted_offset_uv8hi (( &__builtin_neon_hi *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_shifted_offset_z_s32 ( &int16_t  &const *  &__base,  &uint32x4_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_gather_shifted_offset_z_sv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_shifted_offset_z_s16 ( &int16_t  &const *  &__base,  &uint16x8_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_gather_shifted_offset_z_sv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_shifted_offset_z_u32 ( &uint16_t  &const *  &__base,  &uint32x4_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_gather_shifted_offset_z_uv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_gather_shifted_offset_z_u16 ( &uint16_t  &const *  &__base,  &uint16x8_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_gather_shifted_offset_z_uv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_s32 ( &int16_t  &const *  &__base) {  &__builtin_mve_vldrhq_sv4si (( &__builtin_neon_hi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_s16 ( &int16_t  &const *  &__base) {  &__builtin_mve_vldrhq_sv8hi (( &__builtin_neon_hi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_u32 ( &uint16_t  &const *  &__base) {  &__builtin_mve_vldrhq_uv4si (( &__builtin_neon_hi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_u16 ( &uint16_t  &const *  &__base) {  &__builtin_mve_vldrhq_uv8hi (( &__builtin_neon_hi *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_z_s32 ( &int16_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_z_sv4si (( &__builtin_neon_hi *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_z_s16 ( &int16_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_z_sv8hi (( &__builtin_neon_hi *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_z_u32 ( &uint16_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_z_uv4si (( &__builtin_neon_hi *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrhq_z_u16 ( &uint16_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrhq_z_uv8hi (( &__builtin_neon_hi *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_s32 ( &int32_t  &const *  &__base) {  &__builtin_mve_vldrwq_sv4si (( &__builtin_neon_si *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_u32 ( &uint32_t  &const *  &__base) {  &__builtin_mve_vldrwq_uv4si (( &__builtin_neon_si *)  &__base); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_z_s32 ( &int32_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrwq_z_sv4si (( &__builtin_neon_si *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_z_u32 ( &uint32_t  &const *  &__base,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrwq_z_uv4si (( &__builtin_neon_si *)  &__base,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_base_s64 ( &uint64x2_t  &__addr,  &const \'int\'  &__offset) {  &__builtin_mve_vldrdq_gather_base_sv2di ( &__addr,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_base_u64 ( &uint64x2_t  &__addr,  &const \'int\'  &__offset) {  &__builtin_mve_vldrdq_gather_base_uv2di ( &__addr,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_base_z_s64 ( &uint64x2_t  &__addr,  &const \'int\'  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrdq_gather_base_z_sv2di ( &__addr,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_base_z_u64 ( &uint64x2_t  &__addr,  &const \'int\'  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrdq_gather_base_z_uv2di ( &__addr,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_offset_s64 ( &int64_t  &const *  &__base,  &uint64x2_t  &__offset) {  &__builtin_mve_vldrdq_gather_offset_sv2di (( &__builtin_neon_di *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_offset_u64 ( &uint64_t  &const *  &__base,  &uint64x2_t  &__offset) {  &__builtin_mve_vldrdq_gather_offset_uv2di (( &__builtin_neon_di *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_offset_z_s64 ( &int64_t  &const *  &__base,  &uint64x2_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrdq_gather_offset_z_sv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_offset_z_u64 ( &uint64_t  &const *  &__base,  &uint64x2_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrdq_gather_offset_z_uv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_shifted_offset_s64 ( &int64_t  &const *  &__base,  &uint64x2_t  &__offset) {  &__builtin_mve_vldrdq_gather_shifted_offset_sv2di (( &__builtin_neon_di *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_shifted_offset_u64 ( &uint64_t  &const *  &__base,  &uint64x2_t  &__offset) {  &__builtin_mve_vldrdq_gather_shifted_offset_uv2di (( &__builtin_neon_di *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_shifted_offset_z_s64 ( &int64_t  &const *  &__base,  &uint64x2_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrdq_gather_shifted_offset_z_sv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_shifted_offset_z_u64 ( &uint64_t  &const *  &__base,  &uint64x2_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrdq_gather_shifted_offset_z_uv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_offset_s32 ( &int32_t  &const *  &__base,  &uint32x4_t  &__offset) {  &__builtin_mve_vldrwq_gather_offset_sv4si (( &__builtin_neon_si *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_offset_u32 ( &uint32_t  &const *  &__base,  &uint32x4_t  &__offset) {  &__builtin_mve_vldrwq_gather_offset_uv4si (( &__builtin_neon_si *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_offset_z_s32 ( &int32_t  &const *  &__base,  &uint32x4_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrwq_gather_offset_z_sv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_offset_z_u32 ( &uint32_t  &const *  &__base,  &uint32x4_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrwq_gather_offset_z_uv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_shifted_offset_s32 ( &int32_t  &const *  &__base,  &uint32x4_t  &__offset) {  &__builtin_mve_vldrwq_gather_shifted_offset_sv4si (( &__builtin_neon_si *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_shifted_offset_u32 ( &uint32_t  &const *  &__base,  &uint32x4_t  &__offset) {  &__builtin_mve_vldrwq_gather_shifted_offset_uv4si (( &__builtin_neon_si *)  &__base,  &__offset); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_shifted_offset_z_s32 ( &int32_t  &const *  &__base,  &uint32x4_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrwq_gather_shifted_offset_z_sv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_shifted_offset_z_u32 ( &uint32_t  &const *  &__base,  &uint32x4_t  &__offset,  &mve_pred16_t  &__p) {  &__builtin_mve_vldrwq_gather_shifted_offset_z_uv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst1q_s8 ( &int8_t *  &__addr,  &int8x16_t  &__value) {  &__builtin_mve_vst1q_sv16qi (( &__builtin_neon_qi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst1q_s32 ( &int32_t *  &__addr,  &int32x4_t  &__value) {  &__builtin_mve_vst1q_sv4si (( &__builtin_neon_si *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst1q_s16 ( &int16_t *  &__addr,  &int16x8_t  &__value) {  &__builtin_mve_vst1q_sv8hi (( &__builtin_neon_hi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst1q_u8 ( &uint8_t *  &__addr,  &uint8x16_t  &__value) {  &__builtin_mve_vst1q_uv16qi (( &__builtin_neon_qi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst1q_u32 ( &uint32_t *  &__addr,  &uint32x4_t  &__value) {  &__builtin_mve_vst1q_uv4si (( &__builtin_neon_si *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vst1q_u16 ( &uint16_t *  &__addr,  &uint16x8_t  &__value) {  &__builtin_mve_vst1q_uv8hi (( &__builtin_neon_hi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_offset_s32 ( &int16_t *  &__base,  &uint32x4_t  &__offset,  &int32x4_t  &__value) {  &__builtin_mve_vstrhq_scatter_offset_sv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_offset_s16 ( &int16_t *  &__base,  &uint16x8_t  &__offset,  &int16x8_t  &__value) {  &__builtin_mve_vstrhq_scatter_offset_sv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_offset_u32 ( &uint16_t *  &__base,  &uint32x4_t  &__offset,  &uint32x4_t  &__value) {  &__builtin_mve_vstrhq_scatter_offset_uv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_offset_u16 ( &uint16_t *  &__base,  &uint16x8_t  &__offset,  &uint16x8_t  &__value) {  &__builtin_mve_vstrhq_scatter_offset_uv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_offset_p_s32 ( &int16_t *  &__base,  &uint32x4_t  &__offset,  &int32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_scatter_offset_p_sv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_offset_p_s16 ( &int16_t *  &__base,  &uint16x8_t  &__offset,  &int16x8_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_scatter_offset_p_sv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_offset_p_u32 ( &uint16_t *  &__base,  &uint32x4_t  &__offset,  &uint32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_scatter_offset_p_uv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_offset_p_u16 ( &uint16_t *  &__base,  &uint16x8_t  &__offset,  &uint16x8_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_scatter_offset_p_uv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_shifted_offset_s32 ( &int16_t *  &__base,  &uint32x4_t  &__offset,  &int32x4_t  &__value) {  &__builtin_mve_vstrhq_scatter_shifted_offset_sv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_shifted_offset_s16 ( &int16_t *  &__base,  &uint16x8_t  &__offset,  &int16x8_t  &__value) {  &__builtin_mve_vstrhq_scatter_shifted_offset_sv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_shifted_offset_u32 ( &uint16_t *  &__base,  &uint32x4_t  &__offset,  &uint32x4_t  &__value) {  &__builtin_mve_vstrhq_scatter_shifted_offset_uv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_shifted_offset_u16 ( &uint16_t *  &__base,  &uint16x8_t  &__offset,  &uint16x8_t  &__value) {  &__builtin_mve_vstrhq_scatter_shifted_offset_uv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_shifted_offset_p_s32 ( &int16_t *  &__base,  &uint32x4_t  &__offset,  &int32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_scatter_shifted_offset_p_sv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_shifted_offset_p_s16 ( &int16_t *  &__base,  &uint16x8_t  &__offset,  &int16x8_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_scatter_shifted_offset_p_sv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_shifted_offset_p_u32 ( &uint16_t *  &__base,  &uint32x4_t  &__offset,  &uint32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_scatter_shifted_offset_p_uv4si (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_scatter_shifted_offset_p_u16 ( &uint16_t *  &__base,  &uint16x8_t  &__offset,  &uint16x8_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_scatter_shifted_offset_p_uv8hi (( &__builtin_neon_hi *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_s32 ( &int16_t *  &__addr,  &int32x4_t  &__value) {  &__builtin_mve_vstrhq_sv4si (( &__builtin_neon_hi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_s16 ( &int16_t *  &__addr,  &int16x8_t  &__value) {  &__builtin_mve_vstrhq_sv8hi (( &__builtin_neon_hi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_u32 ( &uint16_t *  &__addr,  &uint32x4_t  &__value) {  &__builtin_mve_vstrhq_uv4si (( &__builtin_neon_hi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_u16 ( &uint16_t *  &__addr,  &uint16x8_t  &__value) {  &__builtin_mve_vstrhq_uv8hi (( &__builtin_neon_hi *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_p_s32 ( &int16_t *  &__addr,  &int32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_p_sv4si (( &__builtin_neon_hi *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_p_s16 ( &int16_t *  &__addr,  &int16x8_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_p_sv8hi (( &__builtin_neon_hi *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_p_u32 ( &uint16_t *  &__addr,  &uint32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_p_uv4si (( &__builtin_neon_hi *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrhq_p_u16 ( &uint16_t *  &__addr,  &uint16x8_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrhq_p_uv8hi (( &__builtin_neon_hi *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_s32 ( &int32_t *  &__addr,  &int32x4_t  &__value) {  &__builtin_mve_vstrwq_sv4si (( &__builtin_neon_si *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_u32 ( &uint32_t *  &__addr,  &uint32x4_t  &__value) {  &__builtin_mve_vstrwq_uv4si (( &__builtin_neon_si *)  &__addr,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_p_s32 ( &int32_t *  &__addr,  &int32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrwq_p_sv4si (( &__builtin_neon_si *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_p_u32 ( &uint32_t *  &__addr,  &uint32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrwq_p_uv4si (( &__builtin_neon_si *)  &__addr,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_base_p_s64 ( &uint64x2_t  &__addr,  &const \'int\'  &__offset,  &int64x2_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrdq_scatter_base_p_sv2di ( &__addr,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_base_p_u64 ( &uint64x2_t  &__addr,  &const \'int\'  &__offset,  &uint64x2_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrdq_scatter_base_p_uv2di ( &__addr,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_base_s64 ( &uint64x2_t  &__addr,  &const \'int\'  &__offset,  &int64x2_t  &__value) {  &__builtin_mve_vstrdq_scatter_base_sv2di ( &__addr,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_base_u64 ( &uint64x2_t  &__addr,  &const \'int\'  &__offset,  &uint64x2_t  &__value) {  &__builtin_mve_vstrdq_scatter_base_uv2di ( &__addr,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_offset_p_s64 ( &int64_t *  &__base,  &uint64x2_t  &__offset,  &int64x2_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrdq_scatter_offset_p_sv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_offset_p_u64 ( &uint64_t *  &__base,  &uint64x2_t  &__offset,  &uint64x2_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrdq_scatter_offset_p_uv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_offset_s64 ( &int64_t *  &__base,  &uint64x2_t  &__offset,  &int64x2_t  &__value) {  &__builtin_mve_vstrdq_scatter_offset_sv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_offset_u64 ( &uint64_t *  &__base,  &uint64x2_t  &__offset,  &uint64x2_t  &__value) {  &__builtin_mve_vstrdq_scatter_offset_uv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_shifted_offset_p_s64 ( &int64_t *  &__base,  &uint64x2_t  &__offset,  &int64x2_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrdq_scatter_shifted_offset_p_sv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_shifted_offset_p_u64 ( &uint64_t *  &__base,  &uint64x2_t  &__offset,  &uint64x2_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrdq_scatter_shifted_offset_p_uv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_shifted_offset_s64 ( &int64_t *  &__base,  &uint64x2_t  &__offset,  &int64x2_t  &__value) {  &__builtin_mve_vstrdq_scatter_shifted_offset_sv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_shifted_offset_u64 ( &uint64_t *  &__base,  &uint64x2_t  &__offset,  &uint64x2_t  &__value) {  &__builtin_mve_vstrdq_scatter_shifted_offset_uv2di (( &__builtin_neon_di *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_offset_p_s32 ( &int32_t *  &__base,  &uint32x4_t  &__offset,  &int32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrwq_scatter_offset_p_sv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_offset_p_u32 ( &uint32_t *  &__base,  &uint32x4_t  &__offset,  &uint32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrwq_scatter_offset_p_uv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_offset_s32 ( &int32_t *  &__base,  &uint32x4_t  &__offset,  &int32x4_t  &__value) {  &__builtin_mve_vstrwq_scatter_offset_sv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_offset_u32 ( &uint32_t *  &__base,  &uint32x4_t  &__offset,  &uint32x4_t  &__value) {  &__builtin_mve_vstrwq_scatter_offset_uv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_shifted_offset_p_s32 ( &int32_t *  &__base,  &uint32x4_t  &__offset,  &int32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrwq_scatter_shifted_offset_p_sv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_shifted_offset_p_u32 ( &uint32_t *  &__base,  &uint32x4_t  &__offset,  &uint32x4_t  &__value,  &mve_pred16_t  &__p) {  &__builtin_mve_vstrwq_scatter_shifted_offset_p_uv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_shifted_offset_s32 ( &int32_t *  &__base,  &uint32x4_t  &__offset,  &int32x4_t  &__value) {  &__builtin_mve_vstrwq_scatter_shifted_offset_sv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_shifted_offset_u32 ( &uint32_t *  &__base,  &uint32x4_t  &__offset,  &uint32x4_t  &__value) {  &__builtin_mve_vstrwq_scatter_shifted_offset_uv4si (( &__builtin_neon_si *)  &__base,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b) {  &__a +  &__b; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b) {  &__a +  &__b; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b) {  &__a +  &__b; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b) {  &__a +  &__b; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b) {  &__a +  &__b; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b) {  &__a +  &__b; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vddupq_m_n_uv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vddupq_m_n_uv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vddupq_m_n_uv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_m_wb_u8 ( &uint8x16_t  &__inactive,  &uint32_t *  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint8x16_t  &__res =  &__builtin_mve_vddupq_m_n_uv16qi ( &__inactive, *  &__a,  &__imm,  &__p); * &__a -=  &__imm * 16;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_m_wb_u16 ( &uint16x8_t  &__inactive,  &uint32_t *  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint16x8_t  &__res =  &__builtin_mve_vddupq_m_n_uv8hi ( &__inactive, * &__a,  &__imm,  &__p); * &__a -=  &__imm * 8;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_m_wb_u32 ( &uint32x4_t  &__inactive,  &uint32_t *  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint32x4_t  &__res =  &__builtin_mve_vddupq_m_n_uv4si ( &__inactive, * &__a,  &__imm,  &__p); * &__a -=  &__imm * 4;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_n_u8 ( &uint32_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vddupq_n_uv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_n_u32 ( &uint32_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vddupq_n_uv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_n_u16 ( &uint32_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vddupq_n_uv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_vdwdupq_m_n_uv16qi ( &__inactive,  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_vdwdupq_m_n_uv4si ( &__inactive,  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_vdwdupq_m_n_uv8hi ( &__inactive,  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_m_wb_u8 ( &uint8x16_t  &__inactive,  &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint8x16_t  &__res =  &__builtin_mve_vdwdupq_m_n_uv16qi ( &__inactive, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_vdwdupq_m_wb_uv16qi ( &__inactive, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_m_wb_u32 ( &uint32x4_t  &__inactive,  &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint32x4_t  &__res =  &__builtin_mve_vdwdupq_m_n_uv4si ( &__inactive, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_vdwdupq_m_wb_uv4si ( &__inactive, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_m_wb_u16 ( &uint16x8_t  &__inactive,  &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint16x8_t  &__res =  &__builtin_mve_vdwdupq_m_n_uv8hi ( &__inactive, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_vdwdupq_m_wb_uv8hi ( &__inactive, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_n_u8 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_vdwdupq_n_uv16qi ( &__a,  &__c,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_n_u32 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_vdwdupq_n_uv4si ( &__a,  &__c,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_n_u16 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_vdwdupq_n_uv8hi ( &__a,  &__c,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_wb_u8 ( &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint8x16_t  &__res =  &__builtin_mve_vdwdupq_n_uv16qi (* &__a,  &__c,  &__imm); * &__a =  &__builtin_mve_vdwdupq_wb_uv16qi (* &__a,  &__c,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_wb_u32 ( &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint32x4_t  &__res =  &__builtin_mve_vdwdupq_n_uv4si (* &__a,  &__c,  &__imm); * &__a =  &__builtin_mve_vdwdupq_wb_uv4si (* &__a,  &__c,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_wb_u16 ( &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint16x8_t  &__res =  &__builtin_mve_vdwdupq_n_uv8hi (* &__a,  &__c,  &__imm); * &__a =  &__builtin_mve_vdwdupq_wb_uv8hi (* &__a,  &__c,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vidupq_m_n_uv16qi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vidupq_m_n_uv4si ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vidupq_m_n_uv8hi ( &__inactive,  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_n_u8 ( &uint32_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vidupq_n_uv16qi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_m_wb_u8 ( &uint8x16_t  &__inactive,  &uint32_t *  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint8x16_t  &__res =  &__builtin_mve_vidupq_m_n_uv16qi ( &__inactive, * &__a,  &__imm,  &__p); * &__a +=  &__imm * 16;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_m_wb_u16 ( &uint16x8_t  &__inactive,  &uint32_t *  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint16x8_t  &__res =  &__builtin_mve_vidupq_m_n_uv8hi ( &__inactive, * &__a,  &__imm,  &__p); * &__a +=  &__imm * 8;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_m_wb_u32 ( &uint32x4_t  &__inactive,  &uint32_t *  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint32x4_t  &__res =  &__builtin_mve_vidupq_m_n_uv4si ( &__inactive, * &__a,  &__imm,  &__p); * &__a +=  &__imm * 4;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_n_u32 ( &uint32_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vidupq_n_uv4si ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_n_u16 ( &uint32_t  &__a,  &const \'int\'  &__imm) {  &__builtin_mve_vidupq_n_uv8hi ( &__a,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_wb_u8 ( &uint32_t *  &__a,  &const \'int\'  &__imm) {  &uint8x16_t  &__res =  &__builtin_mve_vidupq_n_uv16qi (* &__a,  &__imm); * &__a +=  &__imm * 16;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_wb_u16 ( &uint32_t *  &__a,  &const \'int\'  &__imm) {  &uint16x8_t  &__res =  &__builtin_mve_vidupq_n_uv8hi (* &__a,  &__imm); * &__a +=  &__imm * 8;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_wb_u32 ( &uint32_t *  &__a,  &const \'int\'  &__imm) {  &uint32x4_t  &__res =  &__builtin_mve_vidupq_n_uv4si (* &__a,  &__imm); * &__a +=  &__imm * 4;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_wb_u8 ( &uint32_t *  &__a,  &const \'int\'  &__imm) {  &uint8x16_t  &__res =  &__builtin_mve_vddupq_n_uv16qi (* &__a,  &__imm); * &__a -=  &__imm * 16;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_wb_u16 ( &uint32_t *  &__a,  &const \'int\'  &__imm) {  &uint16x8_t  &__res =  &__builtin_mve_vddupq_n_uv8hi (* &__a,  &__imm); * &__a -=  &__imm * 8;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_wb_u32 ( &uint32_t *  &__a,  &const \'int\'  &__imm) {  &uint32x4_t  &__res =  &__builtin_mve_vddupq_n_uv4si (* &__a,  &__imm); * &__a -=  &__imm * 4;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_m_n_u8 ( &uint8x16_t  &__inactive,  &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_viwdupq_m_n_uv16qi ( &__inactive,  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_m_n_u32 ( &uint32x4_t  &__inactive,  &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_viwdupq_m_n_uv4si ( &__inactive,  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_m_n_u16 ( &uint16x8_t  &__inactive,  &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_viwdupq_m_n_uv8hi ( &__inactive,  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_m_wb_u8 ( &uint8x16_t  &__inactive,  &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint8x16_t  &__res =  &__builtin_mve_viwdupq_m_n_uv16qi ( &__inactive, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_viwdupq_m_wb_uv16qi ( &__inactive, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_m_wb_u32 ( &uint32x4_t  &__inactive,  &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint32x4_t  &__res =  &__builtin_mve_viwdupq_m_n_uv4si ( &__inactive, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_viwdupq_m_wb_uv4si ( &__inactive, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_m_wb_u16 ( &uint16x8_t  &__inactive,  &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint16x8_t  &__res =  &__builtin_mve_viwdupq_m_n_uv8hi ( &__inactive, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_viwdupq_m_wb_uv8hi ( &__inactive, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_n_u8 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_viwdupq_n_uv16qi ( &__a,  &__c,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_n_u32 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_viwdupq_n_uv4si ( &__a,  &__c,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_n_u16 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_viwdupq_n_uv8hi ( &__a,  &__c,  &__imm); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_wb_u8 ( &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint8x16_t  &__res =  &__builtin_mve_viwdupq_n_uv16qi (* &__a,  &__c,  &__imm); * &__a =  &__builtin_mve_viwdupq_wb_uv16qi (* &__a,  &__c,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_wb_u32 ( &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint32x4_t  &__res =  &__builtin_mve_viwdupq_n_uv4si (* &__a,  &__c,  &__imm); * &__a =  &__builtin_mve_viwdupq_wb_uv4si (* &__a,  &__c,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_wb_u16 ( &uint32_t *  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint16x8_t  &__res =  &__builtin_mve_viwdupq_n_uv8hi (* &__a,  &__c,  &__imm); * &__a =  &__builtin_mve_viwdupq_wb_uv8hi (* &__a,  &__c,  &__imm);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_base_wb_s64 ( &uint64x2_t *  &__addr,  &const \'int\'  &__offset) {  &int64x2_t  &result =  &__builtin_mve_vldrdq_gather_base_nowb_sv2di (* &__addr,  &__offset); * &__addr =  &__builtin_mve_vldrdq_gather_base_wb_sv2di (* &__addr,  &__offset);  &result; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_base_wb_u64 ( &uint64x2_t *  &__addr,  &const \'int\'  &__offset) {  &uint64x2_t  &result =  &__builtin_mve_vldrdq_gather_base_nowb_uv2di (* &__addr,  &__offset); * &__addr =  &__builtin_mve_vldrdq_gather_base_wb_uv2di (* &__addr,  &__offset);  &result; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_base_wb_z_s64 ( &uint64x2_t *  &__addr,  &const \'int\'  &__offset,  &mve_pred16_t  &__p) {  &int64x2_t  &result =  &__builtin_mve_vldrdq_gather_base_nowb_z_sv2di (* &__addr,  &__offset,  &__p); * &__addr =  &__builtin_mve_vldrdq_gather_base_wb_z_sv2di (* &__addr,  &__offset,  &__p);  &result; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrdq_gather_base_wb_z_u64 ( &uint64x2_t *  &__addr,  &const \'int\'  &__offset,  &mve_pred16_t  &__p) {  &uint64x2_t  &result =  &__builtin_mve_vldrdq_gather_base_nowb_z_uv2di (* &__addr,  &__offset,  &__p); * &__addr =  &__builtin_mve_vldrdq_gather_base_wb_z_uv2di (* &__addr,  &__offset,  &__p);  &result; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_base_wb_s32 ( &uint32x4_t *  &__addr,  &const \'int\'  &__offset) {  &int32x4_t  &result =  &__builtin_mve_vldrwq_gather_base_nowb_sv4si (* &__addr,  &__offset); * &__addr =  &__builtin_mve_vldrwq_gather_base_wb_sv4si (* &__addr,  &__offset);  &result; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_base_wb_u32 ( &uint32x4_t *  &__addr,  &const \'int\'  &__offset) {  &uint32x4_t  &result =  &__builtin_mve_vldrwq_gather_base_nowb_uv4si (* &__addr,  &__offset); * &__addr =  &__builtin_mve_vldrwq_gather_base_wb_uv4si (* &__addr,  &__offset);  &result; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_base_wb_z_s32 ( &uint32x4_t *  &__addr,  &const \'int\'  &__offset,  &mve_pred16_t  &__p) {  &int32x4_t  &result =  &__builtin_mve_vldrwq_gather_base_nowb_z_sv4si (* &__addr,  &__offset,  &__p); * &__addr =  &__builtin_mve_vldrwq_gather_base_wb_z_sv4si (* &__addr,  &__offset,  &__p);  &result; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vldrwq_gather_base_wb_z_u32 ( &uint32x4_t *  &__addr,  &const \'int\'  &__offset,  &mve_pred16_t  &__p) {  &uint32x4_t  &result =  &__builtin_mve_vldrwq_gather_base_nowb_z_uv4si (* &__addr,  &__offset,  &__p); * &__addr =  &__builtin_mve_vldrwq_gather_base_wb_z_uv4si (* &__addr,  &__offset,  &__p);  &result; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_base_wb_s64 ( &uint64x2_t *  &__addr,  &const \'int\'  &__offset,  &int64x2_t  &__value) { * &__addr =  &__builtin_mve_vstrdq_scatter_base_wb_sv2di (* &__addr,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_base_wb_u64 ( &uint64x2_t *  &__addr,  &const \'int\'  &__offset,  &uint64x2_t  &__value) { * &__addr =  &__builtin_mve_vstrdq_scatter_base_wb_uv2di (* &__addr,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_base_wb_p_s64 ( &uint64x2_t *  &__addr,  &const \'int\'  &__offset,  &int64x2_t  &__value,  &mve_pred16_t  &__p) { * &__addr =  &__builtin_mve_vstrdq_scatter_base_wb_p_sv2di (* &__addr,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrdq_scatter_base_wb_p_u64 ( &uint64x2_t *  &__addr,  &const \'int\'  &__offset,  &uint64x2_t  &__value,  &mve_pred16_t  &__p) { * &__addr =  &__builtin_mve_vstrdq_scatter_base_wb_p_uv2di (* &__addr,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_base_wb_p_s32 ( &uint32x4_t *  &__addr,  &const \'int\'  &__offset,  &int32x4_t  &__value,  &mve_pred16_t  &__p) { * &__addr =  &__builtin_mve_vstrwq_scatter_base_wb_p_sv4si (* &__addr,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_base_wb_p_u32 ( &uint32x4_t *  &__addr,  &const \'int\'  &__offset,  &uint32x4_t  &__value,  &mve_pred16_t  &__p) { * &__addr =  &__builtin_mve_vstrwq_scatter_base_wb_p_uv4si (* &__addr,  &__offset,  &__value,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_base_wb_s32 ( &uint32x4_t *  &__addr,  &const \'int\'  &__offset,  &int32x4_t  &__value) { * &__addr =  &__builtin_mve_vstrwq_scatter_base_wb_sv4si (* &__addr,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vstrwq_scatter_base_wb_u32 ( &uint32x4_t *  &__addr,  &const \'int\'  &__offset,  &uint32x4_t  &__value) { * &__addr =  &__builtin_mve_vstrwq_scatter_base_wb_uv4si (* &__addr,  &__offset,  &__value); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_x_n_u8 ( &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vddupq_m_n_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_x_n_u16 ( &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vddupq_m_n_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_x_n_u32 ( &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vddupq_m_n_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_x_wb_u8 ( &uint32_t * &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint8x16_t  &__arg1 =  &__arm_vuninitializedq_u8 ();  &uint8x16_t  &__res =  &__builtin_mve_vddupq_m_n_uv16qi ( &__arg1, *  &__a,  &__imm,  &__p); * &__a -=  &__imm * 16;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_x_wb_u16 ( &uint32_t * &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint16x8_t  &__arg1 =  &__arm_vuninitializedq_u16 ();  &uint16x8_t  &__res =  &__builtin_mve_vddupq_m_n_uv8hi ( &__arg1, * &__a,  &__imm,  &__p); * &__a -=  &__imm * 8;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vddupq_x_wb_u32 ( &uint32_t * &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint32x4_t  &__arg1 =  &__arm_vuninitializedq_u32 ();  &uint32x4_t  &__res =  &__builtin_mve_vddupq_m_n_uv4si ( &__arg1, * &__a,  &__imm,  &__p); * &__a -=  &__imm * 4;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_x_n_u8 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_vdwdupq_m_n_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_x_n_u16 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_vdwdupq_m_n_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_x_n_u32 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_vdwdupq_m_n_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_x_wb_u8 ( &uint32_t * &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint8x16_t  &__arg1 =  &__arm_vuninitializedq_u8 ();  &uint8x16_t  &__res =  &__builtin_mve_vdwdupq_m_n_uv16qi ( &__arg1, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_vdwdupq_m_wb_uv16qi ( &__arg1, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_x_wb_u16 ( &uint32_t * &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint16x8_t  &__arg1 =  &__arm_vuninitializedq_u16 ();  &uint16x8_t  &__res =  &__builtin_mve_vdwdupq_m_n_uv8hi ( &__arg1, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_vdwdupq_m_wb_uv8hi ( &__arg1, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdwdupq_x_wb_u32 ( &uint32_t * &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint32x4_t  &__arg1 =  &__arm_vuninitializedq_u32 ();  &uint32x4_t  &__res =  &__builtin_mve_vdwdupq_m_n_uv4si ( &__arg1, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_vdwdupq_m_wb_uv4si ( &__arg1, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_x_n_u8 ( &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vidupq_m_n_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_x_n_u16 ( &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vidupq_m_n_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_x_n_u32 ( &uint32_t  &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &__builtin_mve_vidupq_m_n_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_x_wb_u8 ( &uint32_t * &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint8x16_t  &__arg1 =  &__arm_vuninitializedq_u8 ();  &uint8x16_t  &__res =  &__builtin_mve_vidupq_m_n_uv16qi ( &__arg1, * &__a,  &__imm,  &__p); * &__a +=  &__imm * 16;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_x_wb_u16 ( &uint32_t * &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint16x8_t  &__arg1 =  &__arm_vuninitializedq_u16 ();  &uint16x8_t  &__res =  &__builtin_mve_vidupq_m_n_uv8hi ( &__arg1, * &__a,  &__imm,  &__p); * &__a +=  &__imm * 8;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vidupq_x_wb_u32 ( &uint32_t * &__a,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint32x4_t  &__arg1 =  &__arm_vuninitializedq_u32 ();  &uint32x4_t  &__res =  &__builtin_mve_vidupq_m_n_uv4si ( &__arg1, * &__a,  &__imm,  &__p); * &__a +=  &__imm * 4;  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_x_n_u8 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_viwdupq_m_n_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_x_n_u16 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_viwdupq_m_n_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_x_n_u32 ( &uint32_t  &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &__builtin_mve_viwdupq_m_n_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__c,  &__imm,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_x_wb_u8 ( &uint32_t * &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint8x16_t  &__arg1 =  &__arm_vuninitializedq_u8 ();  &uint8x16_t  &__res =  &__builtin_mve_viwdupq_m_n_uv16qi ( &__arg1, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_viwdupq_m_wb_uv16qi ( &__arg1, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_x_wb_u16 ( &uint32_t * &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint16x8_t  &__arg1 =  &__arm_vuninitializedq_u16 ();  &uint16x8_t  &__res =  &__builtin_mve_viwdupq_m_n_uv8hi ( &__arg1, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_viwdupq_m_wb_uv8hi ( &__arg1, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_viwdupq_x_wb_u32 ( &uint32_t * &__a,  &uint32_t  &__b,  &const \'int\'  &__imm,  &mve_pred16_t  &__p) {  &uint64_t  &__c = (( &uint64_t)  &__b) << 32;  &uint32x4_t  &__arg1 =  &__arm_vuninitializedq_u32 ();  &uint32x4_t  &__res =  &__builtin_mve_viwdupq_m_n_uv4si ( &__arg1, * &__a,  &__c,  &__imm,  &__p); * &__a =  &__builtin_mve_viwdupq_m_wb_uv4si ( &__arg1, * &__a,  &__c,  &__imm,  &__p);  &__res; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_x_n_s8 ( &int8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_x_n_s16 ( &int16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_x_n_s32 ( &int32_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_x_n_u8 ( &uint8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_x_n_u16 ( &uint16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vdupq_x_n_u32 ( &uint32_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vdupq_m_n_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vminq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vminq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmaxq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmaxq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabdq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vabdq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabsq_x_s8 ( &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vabsq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabsq_x_s16 ( &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vabsq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vabsq_x_s32 ( &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vabsq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vaddq_x_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vaddq_m_n_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclsq_x_s8 ( &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclsq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclsq_x_s16 ( &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclsq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclsq_x_s32 ( &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclsq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_x_s8 ( &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_x_s16 ( &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_x_s32 ( &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_x_u8 ( &uint8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_x_u16 ( &uint16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vclzq_x_u32 ( &uint32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vclzq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vnegq_x_s8 ( &int8x16_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vnegq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vnegq_x_s16 ( &int16x8_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vnegq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vnegq_x_s32 ( &int32x4_t  &__a,  &mve_pred16_t  &__p) {  &__builtin_mve_vnegq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulhq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulhq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_poly_x_p8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_poly_m_pv16qi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_poly_x_p16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_poly_m_pv8hi ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_sv16qi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_sv8hi ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_sv4si ( &__arm_vuninitializedq_s64 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_uv16qi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_uv8hi ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmullbq_int_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmullbq_int_m_uv4si ( &__arm_vuninitializedq_u64 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_poly_x_p8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_poly_m_pv16qi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_poly_x_p16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_poly_m_pv8hi ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_sv16qi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_sv8hi ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_sv4si ( &__arm_vuninitializedq_s64 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_uv16qi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_uv8hi ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulltq_int_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulltq_int_m_uv4si ( &__arm_vuninitializedq_u64 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vmulq_x_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vmulq_m_n_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vsubq_x_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vsubq_m_n_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot90_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot90_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vcaddq_rot270_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vcaddq_rot270_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_n_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhaddq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhaddq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot90_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot90_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot90_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot90_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot90_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot90_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot270_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot270_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot270_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot270_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhcaddq_rot270_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhcaddq_rot270_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_n_s8 ( &int8x16_t  &__a,  &int8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_n_s16 ( &int16x8_t  &__a,  &int16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_n_s32 ( &int32x4_t  &__a,  &int32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_n_u8 ( &uint8x16_t  &__a,  &uint8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_n_u16 ( &uint16x8_t  &__a,  &uint16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_n_u32 ( &uint32x4_t  &__a,  &uint32_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_n_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vhsubq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vhsubq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrhaddq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrhaddq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_x_u8 ( &uint8x16_t  &__a,  &uint8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_uv16qi ( &__arm_vuninitializedq_u8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_x_u16 ( &uint16x8_t  &__a,  &uint16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_uv8hi ( &__arm_vuninitializedq_u16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vrmulhq_x_u32 ( &uint32x4_t  &__a,  &uint32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vrmulhq_m_uv4si ( &__arm_vuninitializedq_u32 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_x_s8 ( &int8x16_t  &__a,  &int8x16_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vandq_m_sv16qi ( &__arm_vuninitializedq_s8 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_x_s16 ( &int16x8_t  &__a,  &int16x8_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vandq_m_sv8hi ( &__arm_vuninitializedq_s16 (),  &__a,  &__b,  &__p); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ () {
	    eval q((( &__always_inline__,  &__gnu_inline__,  &__artificial__))  &__arm_vandq_x_s32 ( &int32x4_t  &__a,  &int32x4_t  &__b,  &mve_pred16_t  &__p) {  &__builtin_mve_vandq_m_sv4si ( &__arm_vuninitializedq_s32 (),  &__a,  &__b,  