/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JList;
import javax.swing.JTree;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.history.ManualRequestEditorDialog;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;

public class PopupMenuResend
extends ExtensionPopupMenu {
    private ExtensionHistory extension = null;
    private JTree treeSite = null;
    private HttpSender httpSender = null;

    public PopupMenuResend() {
        this.initialize();
    }

    public PopupMenuResend(String string) {
        super(string);
    }

    private void initialize() {
        this.setText("Resend...");
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManualRequestEditorDialog manualRequestEditorDialog = PopupMenuResend.this.extension.getResendDialog();
                JList jList = PopupMenuResend.this.extension.getLogPanel().getListLog();
                HistoryReference historyReference = (HistoryReference)jList.getSelectedValue();
                HttpMessage httpMessage = null;
                try {
                    httpMessage = historyReference.getHttpMessage().cloneRequest();
                    manualRequestEditorDialog.setMessage(httpMessage);
                    manualRequestEditorDialog.setVisible(true);
                }
                catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                    httpMalformedHeaderException.printStackTrace();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        });
    }

    public boolean isEnableForComponent(Component component) {
        if (component.getName() != null && component.getName().equals("ListLog")) {
            try {
                JList jList = (JList)component;
                if (jList.getSelectedIndex() >= 0) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }
}

