/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.pager;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.hyperic.sigar.pager.PageControl;
import org.hyperic.sigar.pager.PageFetcher;
import org.hyperic.sigar.pager.PageList;

public class ListPageFetcher
extends PageFetcher {
    private List data;
    private int sortOrder;

    public ListPageFetcher(List data) {
        this.data = data;
        this.sortOrder = 0;
    }

    public PageList getPage(PageControl control) {
        int startIdx;
        PageList res = new PageList();
        if (this.data.size() == 0) {
            return new PageList();
        }
        this.ensureSortOrder(control);
        res.setTotalSize(this.data.size());
        int endIdx = control.getPagesize() == -1 ? this.data.size() : ListPageFetcher.clamp(startIdx + control.getPagesize(), startIdx, this.data.size());
        ListIterator i = this.data.listIterator(startIdx);
        for (int curIdx = startIdx = ListPageFetcher.clamp(control.getPageEntityIndex(), 0, this.data.size() - 1); i.hasNext() && curIdx < endIdx; ++curIdx) {
            res.add(i.next());
        }
        return res;
    }

    private void ensureSortOrder(PageControl control) {
        if (control.getSortorder() == this.sortOrder) {
            return;
        }
        this.sortOrder = control.getSortorder();
        if (this.sortOrder == 0) {
            return;
        }
        if (this.sortOrder == 1) {
            Collections.sort(this.data);
        } else if (this.sortOrder == 2) {
            Collections.sort(this.data, new DescSorter());
        } else {
            throw new IllegalStateException("Unknown control sorting type: " + this.sortOrder);
        }
    }

    private static int clamp(int val, int min, int max) {
        return (int)ListPageFetcher.clamp((long)val, (long)min, (long)max);
    }

    private static long clamp(long val, long min, long max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    private class DescSorter
    implements Comparator {
        private DescSorter() {
        }

        public int compare(Object o1, Object o2) {
            return -((Comparable)o1).compareTo((Comparable)o2);
        }

        public boolean equals(Object other) {
            return false;
        }
    }
}

