/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.mcast;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.io.XByteBuffer;

public class McastMember
implements Member,
Serializable {
    static final transient char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final transient String TCP_LISTEN_PORT = "tcpListenPort";
    public static final transient String TCP_LISTEN_HOST = "tcpListenHost";
    public static final transient String MEMBER_NAME = "memberName";
    public static final transient String MEMBER_DOMAIN = "memberDomain";
    protected String host;
    protected int port;
    private String name;
    private String domain;
    protected int msgCount = 0;
    protected long memberAliveTime = 0L;

    public McastMember(String name, String domain, String host, int port, long aliveTime) {
        this.host = host;
        this.port = port;
        this.name = name;
        this.domain = domain;
        this.memberAliveTime = aliveTime;
    }

    public HashMap getMemberProperties() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(TCP_LISTEN_HOST, this.host);
        map.put(TCP_LISTEN_PORT, String.valueOf(this.port));
        map.put(MEMBER_NAME, this.name);
        map.put(MEMBER_DOMAIN, this.domain);
        return map;
    }

    protected void inc() {
        ++this.msgCount;
    }

    protected byte[] getData(long startTime) throws Exception {
        byte[] named = this.getName().getBytes();
        byte[] domaind = this.getDomain().getBytes();
        byte[] addr = InetAddress.getByName(this.host).getAddress();
        byte[] data = new byte[12 + addr.length + 4 + named.length + 4 + domaind.length];
        long alive = System.currentTimeMillis() - startTime;
        System.arraycopy(XByteBuffer.toBytes(alive), 0, data, 0, 8);
        System.arraycopy(XByteBuffer.toBytes(this.port), 0, data, 8, 4);
        System.arraycopy(addr, 0, data, 12, addr.length);
        System.arraycopy(XByteBuffer.toBytes(named.length), 0, data, 16, 4);
        System.arraycopy(named, 0, data, 20, named.length);
        System.arraycopy(XByteBuffer.toBytes(domaind.length), 0, data, named.length + 20, 4);
        System.arraycopy(domaind, 0, data, named.length + 24, domaind.length);
        return data;
    }

    protected static McastMember getMember(byte[] data) {
        byte[] alived = new byte[8];
        System.arraycopy(data, 0, alived, 0, 8);
        byte[] portd = new byte[4];
        System.arraycopy(data, 8, portd, 0, 4);
        byte[] addr = new byte[4];
        System.arraycopy(data, 12, addr, 0, 4);
        byte[] nlend = new byte[4];
        System.arraycopy(data, 16, nlend, 0, 4);
        int nlen = XByteBuffer.toInt(nlend, 0);
        byte[] named = new byte[nlen];
        System.arraycopy(data, 20, named, 0, named.length);
        byte[] dlend = new byte[4];
        System.arraycopy(data, nlen + 20, dlend, 0, 4);
        int dlen = XByteBuffer.toInt(dlend, 0);
        byte[] domaind = new byte[dlen];
        System.arraycopy(data, nlen + 24, domaind, 0, domaind.length);
        return new McastMember(new String(named), new String(domaind), McastMember.addressToString(addr), XByteBuffer.toInt(portd, 0), XByteBuffer.toLong(alived, 0));
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public long getMemberAliveTime() {
        return this.memberAliveTime;
    }

    public void setMemberAliveTime(long time) {
        this.memberAliveTime = time;
    }

    public String toString() {
        return "org.apache.catalina.cluster.mcast.McastMember[" + this.name + "," + this.domain + "," + this.host + "," + this.port + ", alive=" + this.memberAliveTime + "]";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof McastMember) {
            return this.name.equals(((McastMember)o).getName());
        }
        return false;
    }

    private static final String addressToString(byte[] address) {
        int q;
        int r = 0;
        int charPos = 15;
        char[] buf = new char[15];
        int dot = 46;
        int i = address[3] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[2] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[1] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[0] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        return new String(buf, charPos, 15 - charPos);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setMsgCount(int msgCount) {
        this.msgCount = msgCount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

