/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import com.gokgs.shared.KGameSummary;
import com.gokgs.shared.KGameType;
import com.gokgs.shared.KRole;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.UIManager;
import org.igoweb.igoweb.client.swing.GameSummaryRenderer;
import org.igoweb.igoweb.client.swing.UserRenderer;
import org.igoweb.igoweb.shared.GameSummary;
import org.igoweb.igoweb.shared.IBundle;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.GuiUtil;

public class KGameSummaryRenderer
extends GameSummaryRenderer {
    @Override
    public Dimension getMinimumSize() {
        int w = this.tags == null ? 2 + this.fontH * 18 : 2 + this.fontH * 50;
        return this.currentGame != null && this.currentGame.getGameType() == KGameType.RENGO ? new Dimension(w, this.fontH * 2) : new Dimension(w, this.fontH);
    }

    @Override
    protected void paint(Graphics g, GameSummary<?> rawGame) {
        int ascent;
        KGameSummary game = (KGameSummary)rawGame;
        boolean isRengo = game != null && game.getGameType() == KGameType.RENGO;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int x = 2;
        int y2 = ascent = g.getFontMetrics().getAscent();
        if (isRengo) {
            y2 += this.fontH / 2;
        }
        int lgGap = UIManager.getInt("org.igoweb.fontH");
        int winMarkSize = (lgGap + 1) / 2;
        if (game.isInPlay()) {
            g.setFont(this.boldFont);
        } else if (!game.isFinished() && !game.getGameType().isEditable()) {
            g.setFont(this.italFont);
        } else {
            g.setFont(this.stdFont);
        }
        g.setColor(UIManager.getColor("Label.foreground"));
        g.drawString(Defs.getString(game.isPrivate() ? 2031923687 : -266865813 + game.getGameType().id), x, y2);
        x += lgGap;
        int userW = UserRenderer.getMinimumWidth(false);
        IBundle bundle = IBundle.get();
        if (game.getGameType() == KGameType.DEMONSTRATION) {
            g.drawString(((User)game.getPlayer(KRole.OWNER)).getNameAndRank(bundle), x += winMarkSize, ascent);
            x += userW * 2 + winMarkSize;
        } else if (game.getGameType() == KGameType.REVIEW) {
            g.drawString(GuiUtil.makeStringFit(Defs.getString(-669080763, new Object[]{((User)game.getPlayer(KRole.OWNER)).getNameAndRank(bundle), ((User)game.getPlayer(KRole.WHITE)).getNameAndRank(bundle), ((User)game.getPlayer(KRole.BLACK)).getNameAndRank(bundle)}), g, userW * 2 + winMarkSize), x += winMarkSize, ascent);
            x += userW * 2 + winMarkSize;
        } else if (game.getGameType() == KGameType.RENGO_REVIEW) {
            g.drawString(GuiUtil.makeStringFit(Defs.getString(696435397, new Object[]{((User)game.getPlayer(KRole.OWNER)).getNameAndRank(bundle), ((User)game.getPlayer(KRole.WHITE)).getNameAndRank(bundle), ((User)game.getPlayer(KRole.WHITE_2)).getNameAndRank(bundle), ((User)game.getPlayer(KRole.BLACK)).getNameAndRank(bundle), ((User)game.getPlayer(KRole.BLACK_2)).getNameAndRank(bundle)}), g, userW * 2 + winMarkSize), x += winMarkSize, ascent);
            x += userW * 2 + winMarkSize;
        } else {
            if (game.getWinner() == KRole.WHITE) {
                g.fillOval(x, y2 - ascent + (lgGap - winMarkSize) / 2, winMarkSize, winMarkSize);
            }
            g.drawString(((User)game.getPlayer(KRole.WHITE)).getNameAndRank(bundle), x += winMarkSize, ascent);
            if (isRengo) {
                g.drawString(((User)game.getPlayer(KRole.WHITE_2)).getNameAndRank(bundle), x, ascent + this.fontH);
            }
            x += userW;
            if (game.getWinner() == KRole.BLACK) {
                g.fillOval(x, y2 - ascent + (lgGap - winMarkSize) / 2, winMarkSize, winMarkSize);
            }
            g.drawString(((User)game.getPlayer(KRole.BLACK)).getNameAndRank(bundle), x += winMarkSize, ascent);
            if (isRengo) {
                g.drawString(((User)game.getPlayer(KRole.BLACK_2)).getNameAndRank(bundle), x, ascent + this.fontH);
            }
            x += userW;
        }
        Object[] args = new Object[]{game.getBoardSize(), game.getHandicap(), null};
        g.drawString(Defs.getString(-669080762, args), x, y2);
        g.drawString(Defs.getString(-903340706, game.getKomi()), x += 11 * lgGap / 2, y2);
        x += 4 * lgGap;
        if (game.isFinished() && game.getGameType() != KGameType.DEMONSTRATION && game.getGameType() != KGameType.REVIEW && game.getGameType() != KGameType.RENGO_REVIEW) {
            g.drawString(bundle.formatScore(game.getScore()), x, y2);
        }
        g.drawString(DateFormat.getDateTimeInstance(3, 2).format(new Date(game.id)), x + 4 * lgGap, y2);
        if (this.tags != null) {
            g.drawString((String)this.tags.get(game.id), x + 15 * lgGap, y2);
        }
    }
}

