/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import java.util.ArrayList;
import java.util.List;

public class SecurityGroupDescription {
    public String name;
    public String desc;
    public String owner;
    public List<IpPermission> perms = new ArrayList<IpPermission>();

    public SecurityGroupDescription(String name, String desc, String owner) {
        this.name = name;
        this.desc = desc;
        this.owner = owner;
    }

    public IpPermission addPermission(String protocol, int fromPort, int toPort) {
        IpPermission perm = new IpPermission(protocol, fromPort, toPort);
        this.perms.add(perm);
        return perm;
    }

    public String toString() {
        return "SecurityGroup[name=" + this.name + ", Desc=" + this.desc + ", own=" + this.owner + ", perms=" + this.perms + "]";
    }

    public class IpPermission {
        public String protocol;
        public int fromPort;
        public int toPort;
        public List<String> cidrIps = new ArrayList<String>();
        public List<String[]> uid_group_pairs = new ArrayList<String[]>();

        public IpPermission(String protocol, int fromPort, int toPort) {
            this.protocol = protocol;
            this.fromPort = fromPort;
            this.toPort = toPort;
        }

        public void addIpRange(String cidrIp) {
            this.cidrIps.add(cidrIp);
        }

        public void addUserGroupPair(String userId, String groupName) {
            this.uid_group_pairs.add(new String[]{userId, groupName});
        }

        public String toString() {
            ArrayList<String> uid_grp_str = new ArrayList<String>();
            for (String[] pair : this.uid_group_pairs) {
                uid_grp_str.add("(" + pair[0] + "," + pair[1] + ")");
            }
            return "[proto=" + this.protocol + ", portRng=(" + this.fromPort + ".." + this.toPort + "), cidrIps=" + this.cidrIps + ", uidgrp=" + uid_grp_str + "]";
        }
    }
}

