/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class SubQueryExpression
extends Expression {
    private final LogicalPlan query;
    private final ExpressionId id;

    public SubQueryExpression(Source source, LogicalPlan query) {
        this(source, query, null);
    }

    public SubQueryExpression(Source source, LogicalPlan query, ExpressionId id) {
        super(source, Collections.emptyList());
        this.query = query;
        this.id = id == null ? new ExpressionId() : id;
    }

    @Override
    public final Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    public LogicalPlan query() {
        return this.query;
    }

    public ExpressionId id() {
        return this.id;
    }

    @Override
    public boolean resolved() {
        return false;
    }

    public SubQueryExpression withQuery(LogicalPlan newQuery) {
        return Objects.equals(this.query, newQuery) ? this : this.clone(newQuery);
    }

    protected abstract SubQueryExpression clone(LogicalPlan var1);

    @Override
    public int hashCode() {
        return Objects.hash(this.query());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubQueryExpression other = (SubQueryExpression)obj;
        return Objects.equals(this.query(), other.query());
    }
}

