/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.gen.processor;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class ConstantProcessor
implements Processor {
    public static String NAME = "c";
    private final Object constant;
    private final boolean namedWriteable;
    private final Class<?> clazz;

    public ConstantProcessor(Object value) {
        this.constant = value;
        this.namedWriteable = value instanceof NamedWriteable;
        this.clazz = this.namedWriteable ? value.getClass() : null;
    }

    public ConstantProcessor(StreamInput in) throws IOException {
        this.namedWriteable = in.readBoolean();
        if (this.namedWriteable) {
            try {
                this.clazz = ConstantProcessor.class.getClassLoader().loadClass(in.readString());
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            this.constant = in.readNamedWriteable(this.clazz);
        } else {
            this.clazz = null;
            this.constant = in.readGenericValue();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.namedWriteable);
        if (this.namedWriteable) {
            out.writeString(this.constant.getClass().getName());
            out.writeNamedWriteable((NamedWriteable)this.constant);
        } else {
            out.writeGenericValue(this.constant);
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object process(Object input) {
        return this.constant;
    }

    public int hashCode() {
        return Objects.hashCode(this.constant);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantProcessor other = (ConstantProcessor)obj;
        return Objects.equals(this.constant, other.constant);
    }

    public String toString() {
        return "^" + this.constant;
    }
}

