/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.action.RollupJobCaps;
import org.joda.time.DateTimeZone;

public class RollupJobIdentifierUtils {
    static final Comparator<RollupJobCaps> COMPARATOR = RollupJobIdentifierUtils.getComparator();

    public static Set<RollupJobCaps> findBestJobs(AggregationBuilder source, Set<RollupJobCaps> jobCaps) {
        HashSet<RollupJobCaps> bestCaps = new HashSet<RollupJobCaps>();
        RollupJobIdentifierUtils.doFindBestJobs(source, new ArrayList<RollupJobCaps>(jobCaps), bestCaps);
        return bestCaps;
    }

    private static void doFindBestJobs(AggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        if (source.getWriteableName().equals("date_histogram")) {
            RollupJobIdentifierUtils.checkDateHisto((DateHistogramAggregationBuilder)source, jobCaps, bestCaps);
        } else if (source.getWriteableName().equals("histogram")) {
            RollupJobIdentifierUtils.checkHisto((HistogramAggregationBuilder)source, jobCaps, bestCaps);
        } else if (RollupField.SUPPORTED_METRICS.contains(source.getWriteableName())) {
            RollupJobIdentifierUtils.checkVSLeaf((ValuesSourceAggregationBuilder.LeafOnly)source, jobCaps, bestCaps);
        } else if (source.getWriteableName().equals("terms")) {
            RollupJobIdentifierUtils.checkTerms((TermsAggregationBuilder)source, jobCaps, bestCaps);
        } else {
            throw new IllegalArgumentException("Unable to translate aggregation tree into Rollup.  Aggregation [" + source.getName() + "] is of type [" + source.getClass().getSimpleName() + "] which is currently unsupported.");
        }
    }

    private static void checkDateHisto(DateHistogramAggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                String sourceTimeZone;
                if (!agg.get("agg").equals("date_histogram")) continue;
                DateHistogramInterval interval = new DateHistogramInterval((String)agg.get("interval"));
                String thisTimezone = (String)agg.get("time_zone");
                if (!thisTimezone.equalsIgnoreCase(sourceTimeZone = source.timeZone() == null ? DateTimeZone.UTC.toString() : source.timeZone().toString())) continue;
                if (source.dateHistogramInterval() != null) {
                    if (RollupJobIdentifierUtils.validateCalendarInterval(source.dateHistogramInterval(), interval)) {
                        localCaps.add(cap);
                        continue block0;
                    }
                    if (!RollupJobIdentifierUtils.validateFixedInterval(source.dateHistogramInterval(), interval)) continue block0;
                    localCaps.add(cap);
                    continue block0;
                }
                if (!RollupJobIdentifierUtils.validateFixedInterval(source.interval(), interval)) continue block0;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg on field [" + source.field() + "] which also satisfies all requirements of query.");
        }
        if (source.getSubAggregations().size() == 0) {
            bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
        } else {
            source.getSubAggregations().forEach(sub -> RollupJobIdentifierUtils.doFindBestJobs(sub, localCaps, bestCaps));
        }
    }

    private static boolean isCalendarInterval(DateHistogramInterval interval) {
        return DateHistogramAggregationBuilder.DATE_FIELD_UNITS.containsKey(interval.toString());
    }

    static boolean validateCalendarInterval(DateHistogramInterval requestInterval, DateHistogramInterval configInterval) {
        DateTimeUnit configUnit;
        long configOrder;
        if (!RollupJobIdentifierUtils.isCalendarInterval(requestInterval) || !RollupJobIdentifierUtils.isCalendarInterval(configInterval)) {
            return false;
        }
        DateTimeUnit requestUnit = (DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(requestInterval.toString());
        long requestOrder = requestUnit.field(DateTimeZone.UTC).getDurationField().getUnitMillis();
        return requestOrder >= (configOrder = (configUnit = (DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(configInterval.toString())).field(DateTimeZone.UTC).getDurationField().getUnitMillis());
    }

    static boolean validateFixedInterval(DateHistogramInterval requestInterval, DateHistogramInterval configInterval) {
        if (RollupJobIdentifierUtils.isCalendarInterval(requestInterval) || RollupJobIdentifierUtils.isCalendarInterval(configInterval)) {
            return false;
        }
        long configIntervalMillis = TimeValue.parseTimeValue((String)configInterval.toString(), (String)"date_histo.config.interval").getMillis();
        long requestIntervalMillis = TimeValue.parseTimeValue((String)requestInterval.toString(), (String)"date_histo.request.interval").getMillis();
        return requestIntervalMillis >= configIntervalMillis && requestIntervalMillis % configIntervalMillis == 0L;
    }

    static boolean validateFixedInterval(long requestInterval, DateHistogramInterval configInterval) {
        if (RollupJobIdentifierUtils.isCalendarInterval(configInterval)) {
            return false;
        }
        long configIntervalMillis = TimeValue.parseTimeValue((String)configInterval.toString(), (String)"date_histo.config.interval").getMillis();
        return requestInterval >= configIntervalMillis && requestInterval % configIntervalMillis == 0L;
    }

    private static void checkHisto(HistogramAggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                if (!agg.get("agg").equals("histogram")) continue;
                Long interval = (long)((Long)agg.get("interval"));
                if (!((double)interval.longValue() <= source.interval()) || source.interval() % (double)interval.longValue() != 0.0) continue block0;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg on field [" + source.field() + "] which also satisfies all requirements of query.");
        }
        if (source.getSubAggregations().size() == 0) {
            bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
        } else {
            source.getSubAggregations().forEach(sub -> RollupJobIdentifierUtils.doFindBestJobs(sub, localCaps, bestCaps));
        }
    }

    private static void checkTerms(TermsAggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                if (!agg.get("agg").equals("terms")) continue;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg on field [" + source.field() + "] which also satisfies all requirements of query.");
        }
        if (source.getSubAggregations().size() == 0) {
            bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
        } else {
            source.getSubAggregations().forEach(sub -> RollupJobIdentifierUtils.doFindBestJobs(sub, localCaps, bestCaps));
        }
    }

    private static void checkVSLeaf(ValuesSourceAggregationBuilder.LeafOnly source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                if (!agg.get("agg").equals(source.getWriteableName())) continue;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg with name [" + source.getName() + "] which also satisfies all requirements of query.");
        }
        bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
    }

    private static RollupJobCaps getTopEqualCaps(List<RollupJobCaps> caps) {
        assert (!caps.isEmpty());
        caps.sort(COMPARATOR);
        return caps.get(0);
    }

    private static Comparator<RollupJobCaps> getComparator() {
        return (o1, o2) -> {
            if (o1 == null) {
                throw new NullPointerException("RollupJobCap [o1] cannot be null");
            }
            if (o2 == null) {
                throw new NullPointerException("RollupJobCap [o2] cannot be null");
            }
            if (o1.equals(o2)) {
                return 0;
            }
            long thisTime = Long.MAX_VALUE;
            long thatTime = Long.MAX_VALUE;
            float thisHistoWeights = 0.0f;
            float thatHistoWeights = 0.0f;
            long counter = 0L;
            long thisTermsWeights = 0L;
            long thatTermsWeights = 0L;
            for (RollupJobCaps.RollupFieldCaps fieldCaps : o1.getFieldCaps().values()) {
                for (Map agg : fieldCaps.getAggs()) {
                    if (agg.get("agg").equals("date_histogram")) {
                        thisTime = RollupJobIdentifierUtils.getMillisFixedOrCalendar((String)agg.get("interval"));
                        continue;
                    }
                    if (agg.get("agg").equals("histogram")) {
                        thisHistoWeights += (float)((Long)agg.get("interval")).longValue();
                        ++counter;
                        continue;
                    }
                    if (!agg.get("agg").equals("terms")) continue;
                    ++thisTermsWeights;
                }
            }
            thisHistoWeights = counter == 0L ? 0.0f : thisHistoWeights / (float)counter;
            counter = 0L;
            for (RollupJobCaps.RollupFieldCaps fieldCaps : o2.getFieldCaps().values()) {
                for (Map agg : fieldCaps.getAggs()) {
                    if (agg.get("agg").equals("date_histogram")) {
                        thatTime = RollupJobIdentifierUtils.getMillisFixedOrCalendar((String)agg.get("interval"));
                        continue;
                    }
                    if (agg.get("agg").equals("histogram")) {
                        thatHistoWeights += (float)((Long)agg.get("interval")).longValue();
                        ++counter;
                        continue;
                    }
                    if (!agg.get("agg").equals("terms")) continue;
                    ++thatTermsWeights;
                }
            }
            thatHistoWeights = counter == 0L ? 0.0f : thatHistoWeights / (float)counter;
            int timeCompare = Long.compare(thisTime, thatTime);
            if (timeCompare != 0) {
                return -timeCompare;
            }
            int histoCompare = Float.compare(thisHistoWeights, thatHistoWeights);
            if (histoCompare != 0) {
                if (thisHistoWeights == 0.0f) {
                    return -1;
                }
                if (thatHistoWeights == 0.0f) {
                    return 1;
                }
                return -histoCompare;
            }
            return Long.compare(thisTermsWeights, thatTermsWeights);
        };
    }

    static long getMillisFixedOrCalendar(String value) {
        DateHistogramInterval interval = new DateHistogramInterval(value);
        if (RollupJobIdentifierUtils.isCalendarInterval(interval)) {
            DateTimeUnit intervalUnit = (DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(interval.toString());
            return intervalUnit.field(DateTimeZone.UTC).getDurationField().getUnitMillis();
        }
        return TimeValue.parseTimeValue((String)value, (String)"date_histo.comparator.interval").getMillis();
    }
}

