/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.bitmap;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.ContentChecker;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BitmapPreflight
implements ContentChecker {
    ZipFile zip;
    Report report;
    String path;
    String mimeType;

    BitmapPreflight(ZipFile zip, Report report, String path, String mimeType) {
        this.zip = zip;
        this.report = report;
        this.path = path;
        this.mimeType = mimeType;
    }

    private void checkHeader(byte[] header) {
        boolean passed = this.mimeType.equals("image/jpeg") ? header[0] == -1 && header[1] == -40 : (this.mimeType.equals("image/gif") ? header[0] == 71 && header[1] == 73 && header[2] == 70 && header[3] == 56 : (this.mimeType.equals("image/png") ? header[0] == -119 && header[1] == 80 && header[2] == 78 && header[3] == 71 : true));
        if (!passed) {
            this.report.error(null, 0, "The file " + this.path + " does not appear to be of type " + this.mimeType);
        }
    }

    public void runChecks() {
        ZipEntry imageEntry = this.zip.getEntry(this.path);
        if (imageEntry == null) {
            this.report.error(null, 0, "image file " + this.path + " is missing");
        } else {
            long entrySize = imageEntry.getSize();
            if (entrySize > 0xA00000L) {
                this.report.error(this.path, 0, "Image is too large. (Greater than 10MB)");
            }
            if (entrySize == 0L) {
                this.report.error(this.path, 0, "Image has no content.");
            }
            try {
                InputStream in = this.zip.getInputStream(imageEntry);
                byte[] header = new byte[4];
                if (in.read(header) != header.length) {
                    this.report.error(null, 0, "image file " + this.path + " is too short");
                } else {
                    this.checkHeader(header);
                }
                in.close();
            }
            catch (IOException e) {
                this.report.error(null, 0, "I/O error reading " + this.path);
            }
        }
    }
}

