/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.BinaryDatatype;
import org.relaxng.datatype.ValidationContext;

class Base64BinaryDatatype
extends BinaryDatatype {
    private static final byte[] weightTable = Base64BinaryDatatype.makeWeightTable();
    private static final byte INVALID = -1;
    private static final byte WHITESPACE = -2;
    private static final byte PADDING = -3;

    Base64BinaryDatatype() {
    }

    boolean lexicallyAllows(String str) {
        return Base64BinaryDatatype.byteCount(str) >= 0;
    }

    private static int byteCount(String str) {
        int nChars = 0;
        int nPadding = 0;
        int lastCharWeight = -1;
        int len = str.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0080') {
                return -1;
            }
            int w = weightTable[c];
            switch (w) {
                case -2: {
                    continue block9;
                }
                case -3: {
                    if (++nPadding <= 2) continue block9;
                    return -1;
                }
                case -1: {
                    return -1;
                }
                default: {
                    if (nPadding > 0) {
                        return -1;
                    }
                    lastCharWeight = w;
                    ++nChars;
                }
            }
        }
        if ((nChars + nPadding & 3) != 0) {
            return -1;
        }
        switch (nPadding) {
            case 1: {
                if ((lastCharWeight & 3) == 0) break;
                return -1;
            }
            case 2: {
                if ((lastCharWeight & 0xF) == 0) break;
                return -1;
            }
        }
        return (nChars + nPadding >> 2) * 3 - nPadding;
    }

    Object getValue(String str, ValidationContext vc) {
        int nBytes = Base64BinaryDatatype.byteCount(str);
        byte[] value = new byte[nBytes];
        int valueIndex = 0;
        int nBytesAccum = 0;
        int accum = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            byte w = weightTable[str.charAt(i)];
            if (w == -2) continue;
            accum <<= 6;
            if (w != -3) {
                accum |= w;
            }
            if (++nBytesAccum != 4) continue;
            for (int shift = 16; shift >= 0; shift -= 8) {
                if (valueIndex >= nBytes) continue;
                value[valueIndex++] = (byte)(accum >> shift & 0xFF);
            }
            nBytesAccum = 0;
            accum = 0;
        }
        return value;
    }

    private static byte[] makeWeightTable() {
        int i;
        byte[] w = new byte[128];
        int n = -1;
        for (i = 0; i < 128; ++i) {
            w[i] = n;
        }
        n = 0;
        i = 65;
        while (i <= 90) {
            w[i] = n;
            ++i;
            n = (byte)(n + 1);
        }
        i = 97;
        while (i <= 122) {
            w[i] = n;
            ++i;
            n = (byte)(n + 1);
        }
        i = 48;
        while (i <= 57) {
            w[i] = n;
            ++i;
            n = (byte)(n + 1);
        }
        int n2 = n;
        n = (byte)(n + 1);
        w[43] = n2;
        int n3 = n;
        n = (byte)(n + 1);
        w[47] = n3;
        w[10] = -2;
        w[13] = -2;
        w[9] = -2;
        w[32] = -2;
        w[61] = -3;
        return w;
    }
}

