/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.Transformation;

public class TransformationChain<R extends ConnectRecord<R>> {
    private final List<Transformation<R>> transformations;

    public TransformationChain(List<Transformation<R>> transformations) {
        this.transformations = transformations;
    }

    public R apply(R record) {
        Transformation<R> transformation;
        if (this.transformations.isEmpty()) {
            return record;
        }
        Iterator<Transformation<R>> iterator = this.transformations.iterator();
        while (iterator.hasNext() && (record = (transformation = iterator.next()).apply(record)) != null) {
        }
        return record;
    }

    public void close() {
        for (Transformation<R> transformation : this.transformations) {
            transformation.close();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformationChain that = (TransformationChain)o;
        return Objects.equals(this.transformations, that.transformations);
    }

    public int hashCode() {
        return Objects.hash(this.transformations);
    }

    public static <R extends ConnectRecord<R>> TransformationChain<R> noOp() {
        return new TransformationChain<R>(Collections.emptyList());
    }
}

