/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.FixedPortTestUtils$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001\u001d\u0011a\u0003\u0016:b]N\f7\r^5p]N\u0014u.\u001e8dKR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003\u001b)\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013%Q#\u0001\nqe>$WoY3s\u0005V4g-\u001a:TSj,W#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0007%sG\u000f\u0003\u0004\u001e\u0001\u0001\u0006IAF\u0001\u0014aJ|G-^2fe\n+hMZ3s'&TX\r\t\u0005\b?\u0001\u0011\r\u0011\"\u0003\u0016\u0003U\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKNDa!\t\u0001!\u0002\u00131\u0012AF:feZ,'/T3tg\u0006<W-T1y\u0005f$Xm\u001d\u0011\t\u000f\r\u0002!\u0019!C\u0005+\u0005ia.^7QCJ$\u0018\u000e^5p]NDa!\n\u0001!\u0002\u00131\u0012A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\bO\u0001\u0011\r\u0011\"\u0001\u0016\u0003)qW/\\*feZ,'o\u001d\u0005\u0007S\u0001\u0001\u000b\u0011\u0002\f\u0002\u00179,XnU3sm\u0016\u00148\u000f\t\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0003-yW\u000f\u001e9viR{\u0007/[2\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\t1\fgn\u001a\u0006\u0002e\u0005!!.\u0019<b\u0013\t!tF\u0001\u0004TiJLgn\u001a\u0005\u0007m\u0001\u0001\u000b\u0011B\u0017\u0002\u0019=,H\u000f];u)>\u0004\u0018n\u0019\u0011\t\u000fa\u0002!\u0019!C\u0005Y\u0005Q\u0011N\u001c9viR{\u0007/[2\t\ri\u0002\u0001\u0015!\u0003.\u0003-Ig\u000e];u)>\u0004\u0018n\u0019\u0011\t\u000fq\u0002!\u0019!C\u0001{\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001?!\ty$)D\u0001A\u0015\t\t\u0015'\u0001\u0003vi&d\u0017BA\"A\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002 \u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0003\"B$\u0001\t\u0003B\u0015aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003%\u00032A\u0013*V\u001d\tY\u0005K\u0004\u0002M\u001f6\tQJ\u0003\u0002O\r\u00051AH]8pizJ\u0011!G\u0005\u0003#b\tq\u0001]1dW\u0006<W-\u0003\u0002T)\n\u00191+Z9\u000b\u0005EC\u0002C\u0001,Z\u001b\u00059&B\u0001-\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!l\u0016\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003]\u0001\u0011\u0005Q,A\tuKN$(I]8lKJ4\u0015-\u001b7ve\u0016$\u0012A\u0018\t\u0003/}K!\u0001\u0019\r\u0003\tUs\u0017\u000e\u001e\u0015\u00037\n\u0004\"a\u00195\u000e\u0003\u0011T!!\u001a4\u0002\u000b),h.\u001b;\u000b\u0003\u001d\f1a\u001c:h\u0013\tIGM\u0001\u0003UKN$\b\"B6\u0001\t\u0013a\u0017AI2sK\u0006$XmQ8ogVlWM]!oIN+(m]2sS\n,Gk\u001c+pa&\u001c7\u000f\u0006\u0004n}\u0006=\u0011\u0011\u0004\t\u0005]ZD\b0D\u0001p\u0015\t\u0001\u0018/\u0001\u0005d_:\u001cX/\\3s\u0015\t\u00118/A\u0004dY&,g\u000e^:\u000b\u0005\u0015!(BA;g\u0003\u0019\t\u0007/Y2iK&\u0011qo\u001c\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u0007]I80\u0003\u0002{1\t)\u0011I\u001d:bsB\u0011q\u0003`\u0005\u0003{b\u0011AAQ=uK\"1qP\u001ba\u0001\u0003\u0003\tqa\u001a:pkBLE\r\u0005\u0003\u0002\u0004\u0005-a\u0002BA\u0003\u0003\u000f\u0001\"\u0001\u0014\r\n\u0007\u0005%\u0001$\u0001\u0004Qe\u0016$WMZ\u0005\u0004i\u00055!bAA\u00051!9\u0011\u0011\u00036A\u0002\u0005M\u0011A\u0002;pa&\u001c7\u000fE\u0003K\u0003+\t\t!C\u0002\u0002\u0018Q\u0013A\u0001T5ti\"I\u00111\u00046\u0011\u0002\u0003\u0007\u0011QD\u0001\u000ee\u0016\fGmQ8n[&$H/\u001a3\u0011\u0007]\ty\"C\u0002\u0002\"a\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002&\u0001!I!a\n\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0015\u0005\u0005%\u0002CBA\u0016\u0003k1b#\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003%IW.\\;uC\ndWMC\u0002\u00024a\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9$!\f\u0003\u00075\u000b\u0007O\u0002\u0004\u0002<\u0001!\u0011Q\b\u0002\u0010\u0005>,hnY3TG\",G-\u001e7feN!\u0011\u0011HA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#\t\u0005)Q\u000f^5mg&!\u0011\u0011JA\"\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u000f=\tI\u0004\"\u0001\u0002NQ\u0011\u0011q\n\t\u0005\u0003#\nI$D\u0001\u0001\u0011\u001d\t)&!\u000f\u0005Bu\u000ba\u0001Z8X_J\\\u0007bBA-\u0003s!\t%X\u0001\tg\",H\u000fZ8x]\"I\u0011Q\f\u0001\u0012\u0002\u0013%\u0011qL\u0001-GJ,\u0017\r^3D_:\u001cX/\\3s\u0003:$7+\u001e2tGJL'-\u001a+p)>\u0004\u0018nY:%I\u00164\u0017-\u001e7uIM*\"!!\u0019+\t\u0005u\u00111M\u0016\u0003\u0003K\u0002B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u000e\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002t\u0005%$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class TransactionsBounceTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int kafka$api$TransactionsBounceTest$$numPartitions;
    private final int numServers;
    private final String kafka$api$TransactionsBounceTest$$outputTopic;
    private final String inputTopic;
    private final Properties overridingProps = new Properties();

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    public int kafka$api$TransactionsBounceTest$$numPartitions() {
        return this.kafka$api$TransactionsBounceTest$$numPartitions;
    }

    public int numServers() {
        return this.numServers;
    }

    public String kafka$api$TransactionsBounceTest$$outputTopic() {
        return this.kafka$api$TransactionsBounceTest$$outputTopic;
    }

    private String inputTopic() {
        return this.inputTopic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), true, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testBrokerFailure() {
        String consumerGroup = "myGroup";
        int numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndSubscribeToTopics(consumerGroup, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.inputTopic()})), this.createConsumerAndSubscribeToTopics$default$3());
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer("test-txn", (Seq<KafkaServer>)this.servers(), 512, TestUtils$.MODULE$.createTransactionalProducer$default$4());
        producer.initTransactions();
        BounceScheduler scheduler = new BounceScheduler();
        scheduler.start();
        IntRef numMessagesProcessed = IntRef.create((int)0);
        IntRef iteration = IntRef.create((int)0);
        try {
            while (numMessagesProcessed.elem < numInputRecords) {
                int toRead = Math.min(200, numInputRecords - numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": About to read ", " messages, processed ", " so far.."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iteration$1.elem), BoxesRunTime.boxToInteger((int)toRead), BoxesRunTime.boxToInteger((int)numMessagesProcessed$1.elem)})));
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, toRead);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received ", " messages, sending them transactionally to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.size()), this.kafka$api$TransactionsBounceTest$$outputTopic()})));
                producer.beginTransaction();
                boolean shouldAbort = iteration.elem % 3 == 0;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), !shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sent ", " messages. Committing offsets."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.size())})));
                producer.sendOffsetsToTransaction((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions(consumer)).asJava(), consumerGroup);
                if (shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Committed offsets. Aborting transaction of ", " messages."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.size())})));
                    producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Committed offsets. committing transaction of ", " messages."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.size())})));
                    producer.commitTransaction();
                    numMessagesProcessed.elem += records.size();
                }
                ++iteration.elem;
            }
        }
        finally {
            producer.close();
            consumer.close();
        }
        scheduler.shutdown();
        KafkaConsumer<byte[], byte[]> verifyingConsumer = this.createConsumerAndSubscribeToTopics("randomGroup", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$api$TransactionsBounceTest$$outputTopic()})), true);
        HashMap recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numInputRecords).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$7(recordsByPartition, record);
            return BoxedUnit.UNIT;
        });
        ListBuffer outputRecords = new ListBuffer();
        recordsByPartition.values().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$9(outputRecords, x0$1);
            return BoxedUnit.UNIT;
        });
        Set recordSet = outputRecords.toSet();
        Assert.assertEquals((long)numInputRecords, (long)recordSet.size());
        Set expectedValues = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInputRecords).toSet();
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing messages: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedValues.$minus$minus((GenTraversableOnce)recordSet)})), (Object)expectedValues, (Object)recordSet);
        verifyingConsumer.close();
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndSubscribeToTopics(String groupId, List<String> topics, boolean readCommitted) {
        Properties props = new Properties();
        Object object = readCommitted ? props.put("isolation.level", "read_committed") : BoxedUnit.UNIT;
        props.put("max.poll.records", "2000");
        props.put("enable.auto.commit", "false");
        props.put("session.timeout.ms", "10000");
        props.put("heartbeat.interval.ms", "3000");
        props.put("auto.offset.reset", "earliest");
        String x$2 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$3 = groupId;
        SecurityProtocol x$4 = SecurityProtocol.PLAINTEXT;
        Some x$5 = new Some((Object)props);
        String x$6 = TestUtils$.MODULE$.createNewConsumer$default$3();
        long x$7 = TestUtils$.MODULE$.createNewConsumer$default$4();
        String x$8 = TestUtils$.MODULE$.createNewConsumer$default$5();
        int x$9 = TestUtils$.MODULE$.createNewConsumer$default$6();
        Option<File> x$10 = TestUtils$.MODULE$.createNewConsumer$default$8();
        Option<Properties> x$11 = TestUtils$.MODULE$.createNewConsumer$default$9();
        ByteArrayDeserializer x$12 = TestUtils$.MODULE$.createNewConsumer$default$10();
        ByteArrayDeserializer x$13 = TestUtils$.MODULE$.createNewConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createNewConsumer(x$2, x$3, x$6, x$7, x$8, x$9, x$4, x$10, x$11, x$12, x$13, (Option<Properties>)x$5);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava());
        return consumer;
    }

    private boolean createConsumerAndSubscribeToTopics$default$3() {
        return false;
    }

    private scala.collection.immutable.Map<Object, Object> createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(this.inputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
        return this.createTopic(this.kafka$api$TransactionsBounceTest$$outputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
    }

    public static final /* synthetic */ void $anonfun$testBrokerFailure$7(HashMap recordsByPartition$1, ConsumerRecord record) {
        int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record))).toInt();
        TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
        ((BufferLike)recordsByPartition$1.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> new ListBuffer())).append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{value}));
    }

    public static final /* synthetic */ void $anonfun$testBrokerFailure$9(ListBuffer outputRecords$1, ListBuffer x0$1) {
        ListBuffer listBuffer = x0$1;
        Assert.assertEquals((String)"Out of order messages detected", (Object)listBuffer, (Object)listBuffer.sorted((Ordering)Ordering.Int$.MODULE$));
        outputRecords$1.appendAll((TraversableOnce)listBuffer);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TransactionsBounceTest() {
        this.producerBufferSize = 65536;
        this.kafka$api$TransactionsBounceTest$$numPartitions = 3;
        this.numServers = 4;
        this.kafka$api$TransactionsBounceTest$$outputTopic = "output-topic";
        this.inputTopic = "input-topic";
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
    }

    public class BounceScheduler
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                BounceScheduler.$anonfun$doWork$1(this, server);
                return BoxedUnit.UNIT;
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$numPartitions()).foreach((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)partition -> TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().zkClient(), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$outputTopic(), partition, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6()));
        }

        public void shutdown() {
            super.shutdown();
        }

        public /* synthetic */ TransactionsBounceTest kafka$api$TransactionsBounceTest$BounceScheduler$$$outer() {
            return TransactionsBounceTest.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$1(BounceScheduler $this, KafkaServer server) {
            $this.trace((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Shutting down server : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            server.shutdown();
            server.awaitShutdown();
            Thread.sleep(500L);
            $this.trace((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Server %s shut down. Starting it up again.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            server.startup();
            $this.trace((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Restarted server: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            Thread.sleep(500L);
        }

        public BounceScheduler() {
            if (TransactionsBounceTest.this == null) {
                throw null;
            }
            super("daemon-broker-bouncer", false);
        }
    }
}

