/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/js/dce/InputResource;", "", "name", "", "lastModified", "Lkotlin/Function0;", "", "reader", "Ljava/io/InputStream;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getName", "()Ljava/lang/String;", "getLastModified", "()Lkotlin/jvm/functions/Function0;", "getReader", "Companion", "js.dce"})
public final class InputResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Function0<Long> lastModified;
    @NotNull
    private final Function0<InputStream> reader;

    public InputResource(@NotNull String name2, @NotNull Function0<Long> lastModified, @NotNull Function0<? extends InputStream> reader) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(lastModified, "lastModified");
        Intrinsics.checkNotNullParameter(reader, "reader");
        this.name = name2;
        this.lastModified = lastModified;
        this.reader = reader;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Function0<Long> getLastModified() {
        return this.lastModified;
    }

    @NotNull
    public final Function0<InputStream> getReader() {
        return this.reader;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/dce/InputResource$Companion;", "", "<init>", "()V", "file", "Lorg/jetbrains/kotlin/js/dce/InputResource;", "path", "", "zipFile", "entryPath", "getZipModificationTime", "", "js.dce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InputResource file(@NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            return new InputResource(path, () -> Companion.file$lambda$0(path), () -> Companion.file$lambda$1(path));
        }

        @NotNull
        public final InputResource zipFile(@NotNull String path, @NotNull String entryPath) {
            Intrinsics.checkNotNullParameter(path, "path");
            Intrinsics.checkNotNullParameter(entryPath, "entryPath");
            return new InputResource(path + '!' + entryPath, () -> Companion.zipFile$lambda$2(path, entryPath), () -> Companion.zipFile$lambda$3(path, entryPath));
        }

        private final long getZipModificationTime(String path, String entryPath) {
            long result2 = new ZipFile(path).getEntry(entryPath).getTime();
            return result2 != -1L ? result2 : new File(path).lastModified();
        }

        private static final long file$lambda$0(String $path) {
            return new File($path).lastModified();
        }

        private static final InputStream file$lambda$1(String $path) {
            return new FileInputStream(new File($path));
        }

        private static final long zipFile$lambda$2(String $path, String $entryPath) {
            return Companion.getZipModificationTime($path, $entryPath);
        }

        private static final InputStream zipFile$lambda$3(String $path, String $entryPath) {
            ZipFile zipFile = new ZipFile($path);
            InputStream inputStream = zipFile.getInputStream(zipFile.getEntry($entryPath));
            Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
            return inputStream;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

