/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import net.sourceforge.squirrel_sql.fw.completion.CompletionCandidates;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.ICompletorModel;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.Bookmark;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookmarkCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.DefaultBookmarksFactory;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPlugin;

public class BookmarkManager
implements ICompletorModel {
    private FileWrapper bookmarkFile;
    private ArrayList<Bookmark> bookmarks = new ArrayList();
    private FileWrapperFactory fileWrapperFactory = new FileWrapperFactoryImpl();
    private HashMap<String, Integer> bookmarkIdx = new HashMap();
    private SQLBookmarkPlugin _plugin;

    public BookmarkManager(SQLBookmarkPlugin plugin) {
        try {
            this._plugin = plugin;
            this.bookmarkFile = this.fileWrapperFactory.create(this._plugin.getPluginUserSettingsFolder(), "bookmarks.xml");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean add(Bookmark bookmark) {
        Integer idxInt = this.bookmarkIdx.get(bookmark.getName());
        if (idxInt != null) {
            this.bookmarks.set(idxInt, bookmark);
            return true;
        }
        this.bookmarks.add(bookmark);
        idxInt = this.bookmarks.size() - 1;
        this.bookmarkIdx.put(bookmark.getName(), idxInt);
        return false;
    }

    protected Bookmark get(String name) {
        Integer idxInt = this.bookmarkIdx.get(name);
        if (idxInt != null) {
            return this.bookmarks.get(idxInt);
        }
        return null;
    }

    protected void load() throws IOException {
        try {
            XMLBeanReader xmlin = new XMLBeanReader();
            if (this.bookmarkFile.exists()) {
                xmlin.load(this.bookmarkFile, this.getClass().getClassLoader());
                for (Object bean : xmlin) {
                    if (!(bean instanceof Bookmark)) continue;
                    this.add((Bookmark)bean);
                }
            }
        }
        catch (XMLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void save() {
        try {
            XMLBeanWriter xmlout = new XMLBeanWriter();
            for (Bookmark bookmark : this.bookmarks) {
                xmlout.addToRoot((Object)bookmark);
            }
            xmlout.save(this.bookmarkFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Iterator<Bookmark> iterator() {
        return this.bookmarks.iterator();
    }

    public CompletionCandidates getCompletionCandidates(String bookmarkNameBegin) {
        int i;
        Vector<BookmarkCompletionInfo> ret = new Vector<BookmarkCompletionInfo>();
        int maxNameLen = 0;
        for (int i2 = 0; i2 < this.bookmarks.size(); ++i2) {
            Bookmark bookmark = this.bookmarks.get(i2);
            if (!bookmark.getName().startsWith(bookmarkNameBegin)) continue;
            ret.add(new BookmarkCompletionInfo(bookmark));
            maxNameLen = Math.max(maxNameLen, bookmark.getName().length());
        }
        String defaultMarksInPopup = this._plugin.getBookmarkProperties().getProperty("squirrelMarksInPopup", "false");
        if (Boolean.valueOf(defaultMarksInPopup).booleanValue()) {
            Bookmark[] defaultBookmarks = DefaultBookmarksFactory.getDefaultBookmarks();
            for (i = 0; i < defaultBookmarks.length; ++i) {
                if (!defaultBookmarks[i].getName().startsWith(bookmarkNameBegin)) continue;
                ret.add(new BookmarkCompletionInfo(defaultBookmarks[i]));
                maxNameLen = Math.max(maxNameLen, defaultBookmarks[i].getName().length());
            }
        }
        CompletionInfo[] candidates = ret.toArray(new BookmarkCompletionInfo[ret.size()]);
        for (i = 0; i < candidates.length; ++i) {
            candidates[i].setMaxCandidateNameLen(maxNameLen);
        }
        return new CompletionCandidates(candidates);
    }

    public void removeAll() {
        this.bookmarks = new ArrayList();
        this.bookmarkIdx = new HashMap();
    }

    public void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull((String)"setFileWrapperFactory", (Object[])new Object[]{"fileWrapperFactory", fileWrapperFactory});
        this.fileWrapperFactory = fileWrapperFactory;
    }
}

