/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ColorSchemeTransform;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.painter.border.ClassicBorderPainter;
import org.jvnet.substance.painter.border.CompositeBorderPainter;
import org.jvnet.substance.painter.border.DelegateBorderPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.MatteDecorationPainter;
import org.jvnet.substance.painter.decoration.SubstanceDecorationUtilities;
import org.jvnet.substance.painter.gradient.StandardGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class TwilightSkin
extends SubstanceSkin {
    public static final String NAME = "Twilight";

    public TwilightSkin() {
        Map<String, SubstanceColorScheme> schemes = SubstanceSkin.getColorSchemes(TwilightSkin.class.getClassLoader().getResource("org/jvnet/substance/skin/twilight.colorschemes"));
        SubstanceColorScheme activeScheme = schemes.get("Twilight Active");
        SubstanceColorScheme defaultScheme = schemes.get("Twilight Default");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, defaultScheme);
        defaultSchemeBundle.registerColorScheme(defaultScheme, 0.5f, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme borderDisabledSelectedScheme = schemes.get("Twilight Disabled Selected Border");
        SubstanceColorScheme borderScheme = schemes.get("Twilight Border");
        defaultSchemeBundle.registerColorScheme(borderDisabledSelectedScheme, ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(borderScheme, ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        SubstanceColorScheme markActiveScheme = schemes.get("Twilight Mark Active");
        defaultSchemeBundle.registerColorScheme(markActiveScheme, ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        SubstanceColorScheme separatorScheme = schemes.get("Twilight Separator");
        defaultSchemeBundle.registerColorScheme(separatorScheme, ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme watermarkScheme = schemes.get("Twilight Watermark");
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, watermarkScheme, DecorationAreaType.NONE);
        SubstanceColorSchemeBundle decorationsSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, defaultScheme);
        decorationsSchemeBundle.registerColorScheme(defaultScheme, 0.5f, ComponentState.DISABLED_UNSELECTED);
        decorationsSchemeBundle.registerColorScheme(borderDisabledSelectedScheme, ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        decorationsSchemeBundle.registerColorScheme(borderScheme, ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        decorationsSchemeBundle.registerColorScheme(markActiveScheme, ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        SubstanceColorScheme separatorDecorationsScheme = schemes.get("Twilight Decorations Separator");
        decorationsSchemeBundle.registerColorScheme(separatorDecorationsScheme, ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme decorationsWatermarkScheme = schemes.get("Twilight Decorations Watermark");
        this.registerDecorationAreaSchemeBundle(decorationsSchemeBundle, decorationsWatermarkScheme, DecorationAreaType.TOOLBAR, DecorationAreaType.GENERAL, DecorationAreaType.FOOTER);
        SubstanceColorSchemeBundle headerSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, defaultScheme);
        headerSchemeBundle.registerColorScheme(defaultScheme, 0.5f, ComponentState.DISABLED_UNSELECTED);
        headerSchemeBundle.registerColorScheme(borderDisabledSelectedScheme, ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        headerSchemeBundle.registerColorScheme(borderScheme, ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        headerSchemeBundle.registerColorScheme(markActiveScheme, ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, 0.7f, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ROLLOVER_ARMED, ComponentState.ARMED);
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, 0.8f, ComponentState.SELECTED);
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, 1.0f, ComponentState.ROLLOVER_SELECTED);
        SubstanceColorScheme headerWatermarkScheme = schemes.get("Twilight Header Watermark");
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, headerWatermarkScheme, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER);
        this.setSelectedTabFadeStart(0.2);
        this.setSelectedTabFadeEnd(0.9);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = null;
        this.gradientPainter = new StandardGradientPainter();
        this.decorationPainter = new TwilightDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new CompositeBorderPainter(NAME, new ClassicBorderPainter(), new DelegateBorderPainter("Twilight Inner", new ClassicBorderPainter(), 0x40FFFFFF, 0x20FFFFFF, 0xFFFFFF, new ColorSchemeTransform(){

            @Override
            public SubstanceColorScheme transform(SubstanceColorScheme scheme) {
                return scheme.tint(0.3);
            }
        }));
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    private class TwilightDecorationPainter
    extends MatteDecorationPainter {
        private TwilightDecorationPainter() {
        }

        @Override
        public String getDisplayName() {
            return TwilightSkin.NAME;
        }

        @Override
        public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
            SubstanceColorScheme colorScheme;
            float borderStrokeWidth;
            int fontSize;
            Component c;
            Component topMostWithSameDecorationAreaType = c = comp;
            while (c != null) {
                if (SubstanceDecorationUtilities.getImmediateDecorationType(c) == decorationAreaType) {
                    topMostWithSameDecorationAreaType = c;
                }
                c = c.getParent();
            }
            int topHeight = topMostWithSameDecorationAreaType.getHeight();
            Point inTopMost = SwingUtilities.convertPoint(comp, new Point(0, 0), topMostWithSameDecorationAreaType);
            int dy = inTopMost.y;
            SubstanceColorScheme fillScheme = skin.getBackgroundColorScheme(decorationAreaType);
            Graphics2D fillGraphics = (Graphics2D)graphics.create();
            fillGraphics.translate(0, -dy);
            fillGraphics.setColor(fillScheme.getMidColor());
            fillGraphics.fillRect(0, 0, width, topHeight);
            int shadowHeight = 4;
            GradientPaint fillPaint = new GradientPaint(0.0f, topHeight - shadowHeight, SubstanceColorUtilities.getAlphaColor(fillScheme.getUltraDarkColor().darker(), 0), 0.0f, topHeight, SubstanceColorUtilities.getAlphaColor(fillScheme.getUltraDarkColor().darker(), 128));
            fillGraphics.setPaint(fillPaint);
            fillGraphics.fillRect(0, topHeight - shadowHeight, width, shadowHeight);
            fillGraphics.dispose();
            if (decorationAreaType == DecorationAreaType.TOOLBAR) {
                fontSize = SubstanceSizeUtils.getComponentFontSize(c);
                borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(fontSize);
                graphics.setStroke(new BasicStroke(borderStrokeWidth));
                colorScheme = skin.getColorScheme(comp, ComponentState.DEFAULT);
                graphics.setColor(SubstanceColorUtilities.getAlphaColor(colorScheme.getForegroundColor(), 32));
                graphics.translate(0, -dy - 1);
                graphics.drawLine(0, (int)borderStrokeWidth, width, (int)borderStrokeWidth);
                graphics.setColor(colorScheme.getUltraDarkColor());
                graphics.drawLine(0, 1 + topMostWithSameDecorationAreaType.getHeight() - (int)borderStrokeWidth, width, 1 + topMostWithSameDecorationAreaType.getHeight() - (int)borderStrokeWidth);
            }
            if (decorationAreaType == DecorationAreaType.FOOTER) {
                graphics.translate(0, -dy);
                fontSize = SubstanceSizeUtils.getComponentFontSize(c);
                borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(fontSize);
                graphics.setStroke(new BasicStroke(borderStrokeWidth));
                colorScheme = skin.getColorScheme(comp, ComponentState.DEFAULT);
                graphics.setColor(colorScheme.getUltraDarkColor());
                graphics.drawLine(0, (int)borderStrokeWidth, width, (int)borderStrokeWidth);
                graphics.setColor(SubstanceColorUtilities.getAlphaColor(colorScheme.getForegroundColor(), 32));
                graphics.drawLine(0, (int)(2.0f * borderStrokeWidth), width, (int)(2.0f * borderStrokeWidth));
            }
        }
    }
}

