/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.io.IOException;
import org.caffinitas.ohc.linked.AbstractDataInput;
import org.caffinitas.ohc.linked.HashEntries;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;

final class HashEntryValueInput
extends AbstractDataInput {
    HashEntryValueInput(long hashEntryAdr) {
        super(hashEntryAdr, 56L + Util.roundUpTo8(HashEntries.getKeyLen(hashEntryAdr)), HashEntries.getValueLen(hashEntryAdr));
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.assertAvail(1);
        return Uns.getBoolean(this.blkAdr, this.blkOff++);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.assertAvail(1);
        return Uns.getByte(this.blkAdr, this.blkOff++) & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        this.assertAvail(2);
        short r = Uns.getShort(this.blkAdr, this.blkOff);
        this.blkOff += 2L;
        return r;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.assertAvail(2);
        short r = Uns.getShort(this.blkAdr, this.blkOff);
        this.blkOff += 2L;
        return r & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        this.assertAvail(2);
        char r = Uns.getChar(this.blkAdr, this.blkOff);
        this.blkOff += 2L;
        return r;
    }

    @Override
    public int readInt() throws IOException {
        this.assertAvail(4);
        int r = Uns.getInt(this.blkAdr, this.blkOff);
        this.blkOff += 4L;
        return r;
    }

    @Override
    public long readLong() throws IOException {
        this.assertAvail(8);
        long r = Uns.getLong(this.blkAdr, this.blkOff);
        this.blkOff += 8L;
        return r;
    }

    @Override
    public float readFloat() throws IOException {
        this.assertAvail(4);
        float r = Uns.getFloat(this.blkAdr, this.blkOff);
        this.blkOff += 4L;
        return r;
    }

    @Override
    public double readDouble() throws IOException {
        this.assertAvail(8);
        double r = Uns.getDouble(this.blkAdr, this.blkOff);
        this.blkOff += 8L;
        return r;
    }
}

