/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.AnticompactionTask;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.repair.RepairSession;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.RepairOption;
import org.apache.cassandra.repair.messages.SyncComplete;
import org.apache.cassandra.repair.messages.ValidationComplete;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveRepairService
implements IEndpointStateChangeSubscriber,
IFailureDetectionEventListener {
    private boolean registeredForEndpointChanges = false;
    public static CassandraVersion SUPPORTS_GLOBAL_PREPARE_FLAG_VERSION = new CassandraVersion("2.2.1");
    private static final Logger logger = LoggerFactory.getLogger(ActiveRepairService.class);
    public static final ActiveRepairService instance = new ActiveRepairService(FailureDetector.instance, Gossiper.instance);
    public static final long UNREPAIRED_SSTABLE = 0L;
    private final ConcurrentMap<UUID, RepairSession> sessions = new ConcurrentHashMap<UUID, RepairSession>();
    private final ConcurrentMap<UUID, ParentRepairSession> parentRepairSessions = new ConcurrentHashMap<UUID, ParentRepairSession>();
    private final IFailureDetector failureDetector;
    private final Gossiper gossiper;

    public ActiveRepairService(IFailureDetector failureDetector, Gossiper gossiper) {
        this.failureDetector = failureDetector;
        this.gossiper = gossiper;
    }

    public RepairSession submitRepairSession(UUID parentRepairSession, Collection<Range<Token>> range, String keyspace, RepairParallelism parallelismDegree, Set<InetAddress> endpoints, long repairedAt, boolean pullRepair, ListeningExecutorService executor, String ... cfnames) {
        if (endpoints.isEmpty()) {
            return null;
        }
        if (cfnames.length == 0) {
            return null;
        }
        final RepairSession session = new RepairSession(parentRepairSession, UUIDGen.getTimeUUID(), range, keyspace, parallelismDegree, endpoints, repairedAt, pullRepair, cfnames);
        this.sessions.put(session.getId(), session);
        this.registerOnFdAndGossip(session);
        session.addListener(new Runnable(){

            @Override
            public void run() {
                ActiveRepairService.this.sessions.remove(session.getId());
            }
        }, MoreExecutors.directExecutor());
        session.start(executor);
        return session;
    }

    private <T extends AbstractFuture & IFailureDetectionEventListener> void registerOnFdAndGossip(final T task) {
        this.gossiper.register((IEndpointStateChangeSubscriber)task);
        this.failureDetector.registerFailureDetectionEventListener(task);
        task.addListener(new Runnable(){

            @Override
            public void run() {
                ActiveRepairService.this.failureDetector.unregisterFailureDetectionEventListener((IFailureDetectionEventListener)task);
                ActiveRepairService.this.gossiper.unregister((IEndpointStateChangeSubscriber)task);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public synchronized void terminateSessions() {
        IOException cause = new IOException("Terminate session is called");
        for (RepairSession session : this.sessions.values()) {
            session.forceShutdown(cause);
        }
        this.parentRepairSessions.clear();
    }

    public static Set<InetAddress> getNeighbors(String keyspaceName, Collection<Range<Token>> keyspaceLocalRanges, Range<Token> toRepair, Collection<String> dataCenters, Collection<String> hosts) {
        StorageService ss = StorageService.instance;
        Map<Range<Token>, List<InetAddress>> replicaSets = ss.getRangeToAddressMap(keyspaceName);
        Range<Token> rangeSuperSet = null;
        for (Range<Token> range : keyspaceLocalRanges) {
            if (range.contains((Token)((Object)toRepair))) {
                rangeSuperSet = range;
                break;
            }
            if (!range.intersects(toRepair)) continue;
            throw new IllegalArgumentException(String.format("Requested range %s intersects a local range (%s) but is not fully contained in one; this would lead to imprecise repair. keyspace: %s", toRepair.toString(), range.toString(), keyspaceName));
        }
        if (rangeSuperSet == null || !replicaSets.containsKey(rangeSuperSet)) {
            return Collections.emptySet();
        }
        HashSet<InetAddress> neighbors = new HashSet<InetAddress>((Collection)replicaSets.get(rangeSuperSet));
        neighbors.remove(FBUtilities.getBroadcastAddress());
        if (dataCenters != null && !dataCenters.isEmpty()) {
            TokenMetadata.Topology topology = ss.getTokenMetadata().cloneOnlyTokenMap().getTopology();
            HashSet dcEndpoints = Sets.newHashSet();
            Multimap<String, InetAddress> dcEndpointsMap = topology.getDatacenterEndpoints();
            for (String dc : dataCenters) {
                Collection c = dcEndpointsMap.get((Object)dc);
                if (c == null) continue;
                dcEndpoints.addAll(c);
            }
            return Sets.intersection(neighbors, (Set)dcEndpoints);
        }
        if (hosts != null && !hosts.isEmpty()) {
            HashSet<InetAddress> specifiedHost = new HashSet<InetAddress>();
            for (String host : hosts) {
                try {
                    InetAddress endpoint = InetAddress.getByName(host.trim());
                    if (!endpoint.equals(FBUtilities.getBroadcastAddress()) && !neighbors.contains(endpoint)) continue;
                    specifiedHost.add(endpoint);
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Unknown host specified " + host, e);
                }
            }
            if (!specifiedHost.contains(FBUtilities.getBroadcastAddress())) {
                throw new IllegalArgumentException("The current host must be part of the repair");
            }
            if (specifiedHost.size() <= 1) {
                String msg = "Specified hosts %s do not share range %s needed for repair. Either restrict repair ranges with -st/-et options, or specify one of the neighbors that share this range with this node: %s.";
                throw new IllegalArgumentException(String.format(msg, hosts, toRepair, neighbors));
            }
            specifiedHost.remove(FBUtilities.getBroadcastAddress());
            return specifiedHost;
        }
        return neighbors;
    }

    public UUID prepareForRepair(UUID parentRepairSession, InetAddress coordinator, Set<InetAddress> endpoints, RepairOption options, List<ColumnFamilyStore> columnFamilyStores) {
        long timestamp = Clock.instance.currentTimeMillis();
        this.registerParentRepairSession(parentRepairSession, coordinator, columnFamilyStores, options.getRanges(), options.isIncremental(), timestamp, options.isGlobal());
        final CountDownLatch prepareLatch = new CountDownLatch(endpoints.size());
        final AtomicBoolean status = new AtomicBoolean(true);
        final Set failedNodes = Collections.synchronizedSet(new HashSet());
        IAsyncCallbackWithFailure callback = new IAsyncCallbackWithFailure(){

            @Override
            public void response(MessageIn msg) {
                prepareLatch.countDown();
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }

            @Override
            public void onFailure(InetAddress from, RequestFailureReason failureReason) {
                status.set(false);
                failedNodes.add(from.getHostAddress());
                prepareLatch.countDown();
            }
        };
        ArrayList<UUID> cfIds = new ArrayList<UUID>(columnFamilyStores.size());
        for (ColumnFamilyStore cfs : columnFamilyStores) {
            cfIds.add(cfs.metadata.cfId);
        }
        for (InetAddress neighbour : endpoints) {
            if (FailureDetector.instance.isAlive(neighbour)) {
                PrepareMessage message = new PrepareMessage(parentRepairSession, cfIds, options.getRanges(), options.isIncremental(), timestamp, options.isGlobal());
                MessageOut<RepairMessage> msg = message.createMessage();
                MessagingService.instance().sendRR(msg, neighbour, callback, TimeUnit.HOURS.toMillis(1L), true);
                continue;
            }
            this.failRepair(parentRepairSession, "Endpoint not alive: " + neighbour);
        }
        try {
            if (!prepareLatch.await(1L, TimeUnit.HOURS)) {
                this.failRepair(parentRepairSession, "Did not get replies from all endpoints.");
            }
        }
        catch (InterruptedException e) {
            this.failRepair(parentRepairSession, "Interrupted while waiting for prepare repair response.");
        }
        if (!status.get()) {
            this.failRepair(parentRepairSession, "Got negative replies from endpoints " + failedNodes);
        }
        return parentRepairSession;
    }

    private void failRepair(UUID parentRepairSession, String errorMsg) {
        this.removeParentRepairSession(parentRepairSession);
        throw new RuntimeException(errorMsg);
    }

    public synchronized void registerParentRepairSession(UUID parentRepairSession, InetAddress coordinator, List<ColumnFamilyStore> columnFamilyStores, Collection<Range<Token>> ranges, boolean isIncremental, long timestamp, boolean isGlobal) {
        if (!this.registeredForEndpointChanges) {
            Gossiper.instance.register(this);
            FailureDetector.instance.registerFailureDetectionEventListener(this);
            this.registeredForEndpointChanges = true;
        }
        if (!this.parentRepairSessions.containsKey(parentRepairSession)) {
            this.parentRepairSessions.put(parentRepairSession, new ParentRepairSession(coordinator, columnFamilyStores, ranges, isIncremental, timestamp, isGlobal));
        }
    }

    public Set<SSTableReader> currentlyRepairing(UUID cfId, UUID parentRepairSession) {
        HashSet<SSTableReader> repairing = new HashSet<SSTableReader>();
        for (Map.Entry entry : this.parentRepairSessions.entrySet()) {
            Set sstables = ((ParentRepairSession)entry.getValue()).getActiveSSTables(cfId);
            if (sstables == null || ((UUID)entry.getKey()).equals(parentRepairSession)) continue;
            repairing.addAll(sstables);
        }
        return repairing;
    }

    public synchronized ListenableFuture finishParentSession(UUID parentSession, Set<InetAddress> neighbors, Collection<Range<Token>> successfulRanges) {
        ArrayList<AnticompactionTask> tasks = new ArrayList<AnticompactionTask>(neighbors.size() + 1);
        for (InetAddress neighbor : neighbors) {
            AnticompactionTask task = new AnticompactionTask(parentSession, neighbor, successfulRanges);
            this.registerOnFdAndGossip(task);
            tasks.add(task);
            task.run();
        }
        tasks.add((AnticompactionTask)this.doAntiCompaction(parentSession, successfulRanges));
        return Futures.successfulAsList(tasks);
    }

    public ParentRepairSession getParentRepairSession(UUID parentSessionId) {
        ParentRepairSession session = (ParentRepairSession)this.parentRepairSessions.get(parentSessionId);
        if (session == null) {
            throw new RuntimeException("Parent repair session with id = " + parentSessionId + " has failed.");
        }
        return session;
    }

    public synchronized ParentRepairSession removeParentRepairSession(UUID parentSessionId) {
        String snapshotName = parentSessionId.toString();
        for (ColumnFamilyStore cfs : this.getParentRepairSession(parentSessionId).columnFamilyStores.values()) {
            if (!cfs.snapshotExists(snapshotName)) continue;
            cfs.clearSnapshot(snapshotName);
        }
        return (ParentRepairSession)this.parentRepairSessions.remove(parentSessionId);
    }

    public ListenableFuture<List<Object>> doAntiCompaction(final UUID parentRepairSession, Collection<Range<Token>> successfulRanges) {
        assert (parentRepairSession != null);
        ParentRepairSession prs = this.getParentRepairSession(parentRepairSession);
        if (!prs.isGlobal) {
            logger.info("[repair #{}] Not a global repair, will not do anticompaction", (Object)parentRepairSession);
            this.removeParentRepairSession(parentRepairSession);
            return Futures.immediateFuture(Collections.emptyList());
        }
        assert (prs.ranges.containsAll(successfulRanges)) : "Trying to perform anticompaction on unknown ranges";
        ArrayList futures = new ArrayList();
        if (!successfulRanges.isEmpty()) {
            for (Map.Entry columnFamilyStoreEntry : prs.columnFamilyStores.entrySet()) {
                Refs<SSTableReader> sstables = prs.getActiveRepairedSSTableRefsForAntiCompaction((UUID)columnFamilyStoreEntry.getKey(), parentRepairSession);
                ColumnFamilyStore cfs = (ColumnFamilyStore)columnFamilyStoreEntry.getValue();
                futures.add(CompactionManager.instance.submitAntiCompaction(cfs, successfulRanges, sstables, prs.repairedAt, parentRepairSession));
            }
        }
        ListenableFuture allAntiCompactionResults = Futures.successfulAsList(futures);
        allAntiCompactionResults.addListener(new Runnable(){

            @Override
            public void run() {
                ActiveRepairService.this.removeParentRepairSession(parentRepairSession);
            }
        }, MoreExecutors.directExecutor());
        return allAntiCompactionResults;
    }

    public void handleMessage(InetAddress endpoint, RepairMessage message) {
        RepairJobDesc desc = message.desc;
        RepairSession session = (RepairSession)this.sessions.get(desc.sessionId);
        if (session == null) {
            return;
        }
        switch (message.messageType) {
            case VALIDATION_COMPLETE: {
                ValidationComplete validation = (ValidationComplete)message;
                session.validationComplete(desc, endpoint, validation.trees);
                break;
            }
            case SYNC_COMPLETE: {
                SyncComplete sync = (SyncComplete)message;
                session.syncComplete(desc, sync.nodes, sync.success);
                break;
            }
        }
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
    }

    @Override
    public void beforeChange(InetAddress endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState state) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void convict(InetAddress ep, double phi) {
        if (phi < 2.0 * DatabaseDescriptor.getPhiConvictThreshold() || this.parentRepairSessions.isEmpty()) {
            return;
        }
        HashSet toRemove = new HashSet();
        for (Map.Entry repairSessionEntry : this.parentRepairSessions.entrySet()) {
            if (!((ParentRepairSession)repairSessionEntry.getValue()).coordinator.equals(ep)) continue;
            toRemove.add(repairSessionEntry.getKey());
        }
        if (!toRemove.isEmpty()) {
            logger.debug("Removing {} in parent repair sessions", toRemove);
            for (UUID id : toRemove) {
                this.removeParentRepairSession(id);
            }
        }
    }

    public static class ParentRepairSession {
        private final Map<UUID, ColumnFamilyStore> columnFamilyStores = new HashMap<UUID, ColumnFamilyStore>();
        private final Collection<Range<Token>> ranges;
        public final Map<UUID, Set<String>> sstableMap = new HashMap<UUID, Set<String>>();
        public final boolean isIncremental;
        public final boolean isGlobal;
        public final long repairedAt;
        public final InetAddress coordinator;
        private final Set<UUID> marked = new HashSet<UUID>();

        public ParentRepairSession(InetAddress coordinator, List<ColumnFamilyStore> columnFamilyStores, Collection<Range<Token>> ranges, boolean isIncremental, long repairedAt, boolean isGlobal) {
            this.coordinator = coordinator;
            for (ColumnFamilyStore cfs : columnFamilyStores) {
                this.columnFamilyStores.put(cfs.metadata.cfId, cfs);
                this.sstableMap.put(cfs.metadata.cfId, new HashSet());
            }
            this.ranges = ranges;
            this.repairedAt = repairedAt;
            this.isIncremental = isIncremental;
            this.isGlobal = isGlobal;
        }

        public synchronized void markSSTablesRepairing(UUID cfId, UUID parentSessionId) {
            if (!this.marked.contains(cfId)) {
                List<SSTableReader> sstables = this.columnFamilyStores.get((Object)cfId).select(View.select((SSTableSet)SSTableSet.CANONICAL, (Predicate<SSTableReader>)(Predicate)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$markSSTablesRepairing$0(org.apache.cassandra.io.sstable.format.SSTableReader ), (Lorg/apache/cassandra/io/sstable/format/SSTableReader;)Z)((ParentRepairSession)this))).sstables;
                Set<SSTableReader> currentlyRepairing = instance.currentlyRepairing(cfId, parentSessionId);
                if (!Sets.intersection(currentlyRepairing, (Set)Sets.newHashSet(sstables)).isEmpty()) {
                    logger.error("Cannot start multiple repair sessions over the same sstables");
                    throw new RuntimeException("Cannot start multiple repair sessions over the same sstables");
                }
                this.addSSTables(cfId, sstables);
                this.marked.add(cfId);
            }
        }

        public synchronized Refs<SSTableReader> getActiveRepairedSSTableRefsForAntiCompaction(UUID cfId, UUID parentSessionId) {
            Set<SSTableReader> sstables;
            assert (this.marked.contains(cfId));
            if (!this.columnFamilyStores.containsKey(cfId)) {
                throw new RuntimeException("Not possible to get sstables for anticompaction for " + cfId);
            }
            boolean isSnapshotRepair = this.columnFamilyStores.get(cfId).snapshotExists(parentSessionId.toString());
            ImmutableMap.Builder references = ImmutableMap.builder();
            Set<SSTableReader> set = sstables = isSnapshotRepair ? this.getSSTablesForSnapshotRepair(cfId, parentSessionId) : this.getActiveSSTables(cfId);
            assert (sstables != null);
            for (SSTableReader sstable : sstables) {
                Ref<SSTableReader> ref = sstable.tryRef();
                if (ref == null) {
                    this.sstableMap.get(cfId).remove(sstable.getFilename());
                    continue;
                }
                references.put((Object)sstable, ref);
            }
            return new Refs<SSTableReader>((Map<SSTableReader, Ref<SSTableReader>>)references.build());
        }

        private Set<SSTableReader> getSSTablesForSnapshotRepair(UUID cfId, UUID parentSessionId) {
            HashSet<SSTableReader> activeSSTables = new HashSet<SSTableReader>();
            ColumnFamilyStore cfs = this.columnFamilyStores.get(cfId);
            if (cfs == null) {
                return null;
            }
            HashSet<Integer> snapshotGenerations = new HashSet<Integer>();
            try (Refs<SSTableReader> snapshottedSSTables = cfs.getSnapshotSSTableReader(parentSessionId.toString());){
                for (SSTableReader sstable : snapshottedSSTables) {
                    snapshotGenerations.add(sstable.descriptor.generation);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                if (!snapshotGenerations.contains(sstable.descriptor.generation)) continue;
                activeSSTables.add(sstable);
            }
            return activeSSTables;
        }

        public synchronized void maybeSnapshot(UUID cfId, UUID parentSessionId) {
            String snapshotName = parentSessionId.toString();
            if (!this.columnFamilyStores.get(cfId).snapshotExists(snapshotName)) {
                Set<SSTableReader> snapshottedSSTables = this.columnFamilyStores.get(cfId).snapshot(snapshotName, new Predicate<SSTableReader>(){

                    public boolean apply(SSTableReader sstable) {
                        return sstable != null && (!isIncremental || !sstable.isRepaired()) && !sstable.metadata.isIndex() && ((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(ranges);
                    }
                }, true, false);
                if (this.isAlreadyRepairing(cfId, parentSessionId, snapshottedSSTables)) {
                    this.columnFamilyStores.get(cfId).clearSnapshot(parentSessionId.toString());
                    logger.error("Cannot start multiple repair sessions over the same sstables");
                    throw new RuntimeException("Cannot start multiple repair sessions over the same sstables");
                }
                this.addSSTables(cfId, snapshottedSSTables);
                this.marked.add(cfId);
            }
        }

        private boolean isAlreadyRepairing(UUID cfId, UUID parentSessionId, Collection<SSTableReader> sstables) {
            Set<SSTableReader> currentlyRepairing = instance.currentlyRepairing(cfId, parentSessionId);
            HashSet<Integer> currentlyRepairingGenerations = new HashSet<Integer>();
            HashSet<Integer> newRepairingGenerations = new HashSet<Integer>();
            for (SSTableReader sstable : currentlyRepairing) {
                currentlyRepairingGenerations.add(sstable.descriptor.generation);
            }
            for (SSTableReader sstable : sstables) {
                newRepairingGenerations.add(sstable.descriptor.generation);
            }
            return !Sets.intersection(currentlyRepairingGenerations, newRepairingGenerations).isEmpty();
        }

        private Set<SSTableReader> getActiveSSTables(UUID cfId) {
            if (!this.columnFamilyStores.containsKey(cfId)) {
                return null;
            }
            Set<String> repairedSSTables = this.sstableMap.get(cfId);
            HashSet<SSTableReader> activeSSTables = new HashSet<SSTableReader>();
            HashSet<String> activeSSTableNames = new HashSet<String>();
            ColumnFamilyStore cfs = this.columnFamilyStores.get(cfId);
            for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                if (!repairedSSTables.contains(sstable.getFilename())) continue;
                activeSSTables.add(sstable);
                activeSSTableNames.add(sstable.getFilename());
            }
            this.sstableMap.put(cfId, activeSSTableNames);
            return activeSSTables;
        }

        private void addSSTables(UUID cfId, Collection<SSTableReader> sstables) {
            for (SSTableReader sstable : sstables) {
                this.sstableMap.get(cfId).add(sstable.getFilename());
            }
        }

        public long getRepairedAt() {
            if (this.isGlobal) {
                return this.repairedAt;
            }
            return 0L;
        }

        public String toString() {
            return "ParentRepairSession{columnFamilyStores=" + this.columnFamilyStores + ", ranges=" + this.ranges + ", sstableMap=" + this.sstableMap + ", repairedAt=" + this.repairedAt + '}';
        }

        private /* synthetic */ boolean lambda$markSSTablesRepairing$0(SSTableReader s) {
            return !this.isIncremental || !s.isRepaired();
        }
    }

    @Deprecated
    public static enum Status {
        STARTED,
        SESSION_SUCCESS,
        SESSION_FAILED,
        FINISHED;

    }
}

