/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.ArrayList;
import javax.management.ObjectName;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;

public class StandardPipeline
implements Pipeline,
Contained,
Lifecycle {
    private static Log log = LogFactory.getLog((Class)StandardPipeline.class);
    protected Valve basic = null;
    protected Container container = null;
    protected String info = "org.apache.catalina.core.StandardPipeline/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean started = false;
    protected Valve first = null;

    public StandardPipeline() {
        this(null);
    }

    public StandardPipeline(Container container) {
        this.setContainer(container);
    }

    public String getInfo() {
        return this.info;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardPipeline.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.started = true;
        Valve current = this.first;
        if (current == null) {
            current = this.basic;
        }
        while (current != null) {
            if (current instanceof Lifecycle) {
                ((Lifecycle)((Object)current)).start();
            }
            this.registerValve(current);
            current = current.getNext();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardPipeline.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        Valve current = this.first;
        if (current == null) {
            current = this.basic;
        }
        while (current != null) {
            if (current instanceof Lifecycle) {
                ((Lifecycle)((Object)current)).stop();
            }
            this.unregisterValve(current);
            current = current.getNext();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    private void registerValve(Valve valve) {
        if (valve instanceof ValveBase && ((ValveBase)valve).getObjectName() == null) {
            try {
                ObjectName vname;
                String domain = ((ContainerBase)this.container).getDomain();
                if (this.container instanceof StandardContext) {
                    domain = ((StandardContext)this.container).getEngineName();
                }
                if (this.container instanceof StandardWrapper) {
                    Container ctx = ((StandardWrapper)this.container).getParent();
                    domain = ((StandardContext)ctx).getEngineName();
                }
                if ((vname = ((ValveBase)valve).createObjectName(domain, ((ContainerBase)this.container).getJmxName())) != null) {
                    ((ValveBase)valve).setObjectName(vname);
                    Registry.getRegistry(null, null).registerComponent((Object)valve, vname, valve.getClass().getName());
                    ((ValveBase)valve).setController(((ContainerBase)this.container).getJmxName());
                }
            }
            catch (Throwable t) {
                log.info((Object)("Can't register valve " + valve), t);
            }
        }
    }

    private void unregisterValve(Valve valve) {
        if (valve instanceof ValveBase) {
            try {
                ValveBase vb = (ValveBase)valve;
                if (vb.getController() != null && vb.getController() == ((ContainerBase)this.container).getJmxName()) {
                    ObjectName vname = vb.getObjectName();
                    Registry.getRegistry(null, null).getMBeanServer().unregisterMBean(vname);
                    ((ValveBase)valve).setObjectName(null);
                }
            }
            catch (Throwable t) {
                log.info((Object)("Can't unregister valve " + valve), t);
            }
        }
    }

    public Valve getBasic() {
        return this.basic;
    }

    public void setBasic(Valve valve) {
        Valve oldBasic = this.basic;
        if (oldBasic == valve) {
            return;
        }
        if (oldBasic != null) {
            if (this.started && oldBasic instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldBasic)).stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)"StandardPipeline.setBasic: stop", (Throwable)e);
                }
            }
            if (oldBasic instanceof Contained) {
                try {
                    ((Contained)((Object)oldBasic)).setContainer(null);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (valve == null) {
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"StandardPipeline.setBasic: start", (Throwable)e);
                return;
            }
        }
        for (Valve current = this.first; current != null; current = current.getNext()) {
            if (current.getNext() != oldBasic) continue;
            current.setNext(valve);
            break;
        }
        this.basic = valve;
    }

    public void addValve(Valve valve) {
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.started) {
            if (valve instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)valve)).start();
                }
                catch (LifecycleException e) {
                    log.error((Object)"StandardPipeline.addValve: start: ", (Throwable)e);
                }
            }
            this.registerValve(valve);
        }
        if (this.first == null) {
            this.first = valve;
            valve.setNext(this.basic);
        } else {
            for (Valve current = this.first; current != null; current = current.getNext()) {
                if (current.getNext() != this.basic) continue;
                current.setNext(valve);
                valve.setNext(this.basic);
                break;
            }
        }
    }

    public Valve[] getValves() {
        ArrayList<Valve> valveList = new ArrayList<Valve>();
        Valve current = this.first;
        if (current == null) {
            current = this.basic;
        }
        while (current != null) {
            valveList.add(current);
            current = current.getNext();
        }
        return valveList.toArray(new Valve[0]);
    }

    public ObjectName[] getValveObjectNames() {
        ArrayList<ObjectName> valveList = new ArrayList<ObjectName>();
        Valve current = this.first;
        if (current == null) {
            current = this.basic;
        }
        while (current != null) {
            if (current instanceof ValveBase) {
                valveList.add(((ValveBase)current).getObjectName());
            }
            current = current.getNext();
        }
        return valveList.toArray(new ObjectName[0]);
    }

    public void removeValve(Valve valve) {
        Valve current;
        if (this.first == valve) {
            this.first = this.first.getNext();
            current = null;
        } else {
            current = this.first;
        }
        while (current != null) {
            if (current.getNext() == valve) {
                current.setNext(valve.getNext());
                break;
            }
            current = current.getNext();
        }
        if (this.first == this.basic) {
            this.first = null;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(null);
        }
        if (this.started) {
            if (valve instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)valve)).stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)"StandardPipeline.removeValve: stop: ", (Throwable)e);
                }
            }
            this.unregisterValve(valve);
        }
    }

    public Valve getFirst() {
        if (this.first != null) {
            return this.first;
        }
        return this.basic;
    }
}

