/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ImageAttribute;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.ImageAttributeBaseCmd;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetImageAttribute
extends ImageAttributeBaseCmd {
    private static final String PROFILE_DESC = "Reset the OS-profile associated with the AKI.";
    private static final String RAMDISK_DESC = "Reset the ramdisk id the AMI will be launched with.";
    private static final String KERNEL_DESC = "Reset the kernel id the AMI will be launched with.";
    private static final String BLOCK_DEVICE_MAPPING_DESC = "Reset the block-device mapping associated with the specified AMI.";
    private static final String LAUNCH_PERMISSION_DESC = "Reset launch permissions granted on your AMI.";
    public static final String[] RESET_ATTRIBUTE_ARGS = new String[]{"launch-permission"};

    public ResetImageAttribute(String[] args) {
        super("ec2rimatt", new String[]{"ec2-reset-image-attribute", "ec2ratt"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"launch-permission");
        OptionBuilder.withDescription((String)this.joinDescription(LAUNCH_PERMISSION_DESC));
        result.addOption(OptionBuilder.create((String)"l"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return null;
    }

    @Override
    protected List<String> getOptionStrings() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("IMAGE -l");
        return options;
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("launch-permission");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Reset an attribute of an Amazon Image. The IMAGE parameter is the ID of");
        System.out.println("     the Amazon Image to reset an attribute for. An Amazon Image may be:");
        System.out.println("     \t- an Amazon Machine Image (AMI) or");
        System.out.println("     \t- an Amazon Kernel  Image (AKI) or");
        System.out.println("     \t- an Amazon Ramdisk Image (ARI).");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String imageId = this.getAmiId();
        this.assertAtLeastOneOptionSet(RESET_ATTRIBUTE_ARGS);
        this.assertOnlyOneOptionSet(RESET_ATTRIBUTE_ARGS);
        ImageAttribute.ImageAttributeType attributeType = this.getImageAttributeType(jec2);
        RequestResultPair rsp = jec2.resetImageAttribute(imageId, attributeType);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.output(System.out, imageId, attributeType);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    public ImageAttribute.ImageAttributeType getImageAttribute() {
        this.assertOnlyOneOptionSet(RESET_ATTRIBUTE_ARGS);
        if (this.isOptionSet("launch-permission")) {
            return ImageAttribute.ImageAttributeType.launchPermission;
        }
        throw new MissingArgument("launch-permission");
    }

    public static void main(String[] args) {
        new ResetImageAttribute(args).invoke();
    }
}

