/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativePrivilegeStore
extends AbstractComponent {
    private static final Collector<Tuple<String, String>, ?, Map<String, List<String>>> TUPLES_TO_MAP = Collectors.toMap(Tuple::v1, t -> CollectionUtils.newSingletonArrayList((Object)((String)t.v2())), (a, b) -> {
        a.addAll(b);
        return a;
    });
    private final Settings settings;
    private final Client client;
    private final SecurityClient securityClient;
    private final SecurityIndexManager securityIndexManager;

    public NativePrivilegeStore(Settings settings, Client client, SecurityIndexManager securityIndexManager) {
        this.settings = settings;
        this.client = client;
        this.securityClient = new SecurityClient((ElasticsearchClient)client);
        this.securityIndexManager = securityIndexManager;
    }

    public void getPrivileges(Collection<String> applications, Collection<String> names, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndexManager.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyList());
        } else if (!frozenSecurityIndex.isAvailable()) {
            listener.onFailure((Exception)frozenSecurityIndex.getUnavailableReason());
        } else if (applications != null && applications.size() == 1 && names != null && names.size() == 1) {
            this.getPrivilege(Objects.requireNonNull((String)Iterables.get(applications, (int)0)), Objects.requireNonNull((String)Iterables.get(names, (int)0)), (ActionListener<ApplicationPrivilegeDescriptor>)ActionListener.wrap(privilege -> listener.onResponse(privilege == null ? Collections.emptyList() : Collections.singletonList(privilege)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.securityIndexManager.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                TermQueryBuilder query;
                TermQueryBuilder typeQuery = QueryBuilders.termQuery((String)ApplicationPrivilegeDescriptor.Fields.TYPE.getPreferredName(), (String)"application-privilege");
                if (NativePrivilegeStore.isEmpty(applications) && NativePrivilegeStore.isEmpty(names)) {
                    query = typeQuery;
                } else if (NativePrivilegeStore.isEmpty(names)) {
                    query = QueryBuilders.boolQuery().filter((QueryBuilder)typeQuery).filter((QueryBuilder)QueryBuilders.termsQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName(), (Collection)applications));
                } else if (NativePrivilegeStore.isEmpty(applications)) {
                    query = QueryBuilders.boolQuery().filter((QueryBuilder)typeQuery).filter((QueryBuilder)QueryBuilders.termsQuery((String)ApplicationPrivilegeDescriptor.Fields.NAME.getPreferredName(), (Collection)names));
                } else {
                    String[] docIds = (String[])applications.stream().flatMap(a -> names.stream().map(n -> NativePrivilegeStore.toDocId(a, n))).toArray(String[]::new);
                    query = QueryBuilders.boolQuery().filter((QueryBuilder)typeQuery).filter((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{"doc"}).addIds(docIds));
                }
                Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("security");){
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                    this.logger.trace(() -> NativePrivilegeStore.lambda$getPrivileges$6(names, (QueryBuilder)query));
                    request.indicesOptions().ignoreUnavailable();
                    ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, listener), hit -> this.buildPrivilege(hit.getId(), hit.getSourceRef()));
                }
            });
        }
    }

    private static boolean isEmpty(Collection<String> collection) {
        return collection == null || collection.isEmpty();
    }

    void getPrivilege(String application, final String name, final ActionListener<ApplicationPrivilegeDescriptor> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndexManager.freeze();
        if (!frozenSecurityIndex.isAvailable()) {
            this.logger.warn((Message)new ParameterizedMessage("failed to load privilege [{}] index not available", (Object)name), (Throwable)frozenSecurityIndex.getUnavailableReason());
            listener.onResponse(null);
        } else {
            this.securityIndexManager.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((GetRequest)this.client.prepareGet(".security", "doc", NativePrivilegeStore.toDocId(application, name)).request()), (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    if (response.isExists()) {
                        listener.onResponse((Object)NativePrivilegeStore.this.buildPrivilege(response.getId(), response.getSourceAsBytesRef()));
                    } else {
                        listener.onResponse(null);
                    }
                }

                public void onFailure(Exception e) {
                    if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                        NativePrivilegeStore.this.logger.warn((Message)new ParameterizedMessage("failed to load privilege [{}] index not available", (Object)name), (Throwable)e);
                        listener.onResponse(null);
                    } else {
                        NativePrivilegeStore.this.logger.error((Message)new ParameterizedMessage("failed to load privilege [{}]", (Object)name), (Throwable)e);
                        listener.onFailure(e);
                    }
                }
            }, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1)));
        }
    }

    public void putPrivileges(Collection<ApplicationPrivilegeDescriptor> privileges, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Map<String, List<String>>> listener) {
        this.securityIndexManager.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            GroupedActionListener groupListener = new GroupedActionListener(ActionListener.wrap(responses -> {
                Map<String, List<String>> createdNames = responses.stream().filter(r -> r.getResult() == DocWriteResponse.Result.CREATED).map(r -> r.getId()).map(NativePrivilegeStore::nameFromDocId).collect(TUPLES_TO_MAP);
                this.clearRolesCache(listener, createdNames);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), privileges.size(), Collections.emptyList());
            for (ApplicationPrivilegeDescriptor privilege : privileges) {
                this.innerPutPrivilege(privilege, refreshPolicy, (ActionListener<IndexResponse>)groupListener);
            }
        });
    }

    private void innerPutPrivilege(ApplicationPrivilegeDescriptor privilege, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<IndexResponse> listener) {
        try {
            String name = privilege.getName();
            XContentBuilder xContentBuilder = privilege.toXContent(XContentFactory.jsonBuilder(), true);
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security", "doc", NativePrivilegeStore.toDocId(privilege.getApplication(), name)).setSource(xContentBuilder).setRefreshPolicy(refreshPolicy)).request()), listener, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
        }
        catch (Exception e) {
            this.logger.warn("Failed to put privilege {} - {}", (Object)Strings.toString((ToXContent)privilege), (Object)e.toString());
            listener.onFailure(e);
        }
    }

    public void deletePrivileges(String application, Collection<String> names, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Map<String, List<String>>> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndexManager.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyMap());
        } else if (!frozenSecurityIndex.isAvailable()) {
            listener.onFailure((Exception)frozenSecurityIndex.getUnavailableReason());
        } else {
            this.securityIndexManager.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                GroupedActionListener groupListener = new GroupedActionListener(ActionListener.wrap(responses -> {
                    Map<String, List<String>> deletedNames = responses.stream().filter(r -> r.getResult() == DocWriteResponse.Result.DELETED).map(r -> r.getId()).map(NativePrivilegeStore::nameFromDocId).collect(TUPLES_TO_MAP);
                    this.clearRolesCache(listener, deletedNames);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), names.size(), Collections.emptyList());
                for (String name : names) {
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((DeleteRequest)((DeleteRequestBuilder)this.client.prepareDelete(".security", "doc", NativePrivilegeStore.toDocId(application, name)).setRefreshPolicy(refreshPolicy)).request()), (ActionListener)groupListener, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
                }
            });
        }
    }

    private <T> void clearRolesCache(final ActionListener<T> listener, final T value) {
        ClearRolesCacheRequest request = new ClearRolesCacheRequest();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)new ActionListener<ClearRolesCacheResponse>(){

            public void onResponse(ClearRolesCacheResponse nodes) {
                listener.onResponse(value);
            }

            public void onFailure(Exception e) {
                NativePrivilegeStore.this.logger.error("unable to clear role cache", (Throwable)e);
                listener.onFailure((Exception)new ElasticsearchException("clearing the role cache failed. please clear the role cache manually", (Throwable)e, new Object[0]));
            }
        }, (arg_0, arg_1) -> ((SecurityClient)this.securityClient).clearRolesCache(arg_0, arg_1));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ApplicationPrivilegeDescriptor buildPrivilege(String docId, BytesReference source) {
        this.logger.trace("Building privilege from [{}] [{}]", (Object)docId, (Object)(source == null ? "<<null>>" : source.utf8ToString()));
        if (source == null) {
            return null;
        }
        Tuple<String, String> name = NativePrivilegeStore.nameFromDocId(docId);
        try (StreamInput input = source.streamInput();){
            ApplicationPrivilegeDescriptor applicationPrivilegeDescriptor;
            block17: {
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)input);
                try {
                    ApplicationPrivilegeDescriptor privilege = ApplicationPrivilegeDescriptor.parse((XContentParser)parser, null, null, (boolean)true);
                    assert (privilege.getApplication().equals(name.v1())) : "Incorrect application name for privilege. Expected [" + (String)name.v1() + "] but was " + privilege.getApplication();
                    assert (privilege.getName().equals(name.v2())) : "Incorrect name for application privilege. Expected [" + (String)name.v2() + "] but was " + privilege.getName();
                    applicationPrivilegeDescriptor = privilege;
                    if (parser == null) break block17;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return applicationPrivilegeDescriptor;
        }
        catch (IOException | XContentParseException e) {
            this.logger.error((Message)new ParameterizedMessage("cannot parse application privilege [{}]", name), e);
            return null;
        }
    }

    private static Tuple<String, String> nameFromDocId(String docId) {
        String name = docId.substring("application-privilege".length() + 1);
        assert (name != null && name.length() > 0) : "Invalid name '" + name + "'";
        int colon = name.indexOf(58);
        assert (colon > 0) : "Invalid name '" + name + "' (missing colon)";
        return new Tuple((Object)name.substring(0, colon), (Object)name.substring(colon + 1));
    }

    private static String toDocId(String application, String name) {
        return "application-privilege_" + application + ":" + name;
    }

    private static /* synthetic */ Message lambda$getPrivileges$6(Collection names, QueryBuilder query) {
        return new ParameterizedMessage("Searching for privileges [{}] with query [{}]", (Object)names, (Object)Strings.toString((ToXContent)query));
    }
}

