/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.AcknowledgedBitrateEstimatorInterface;
import org.jitsi.nlj.rtp.bandwidthestimation2.AcknowledgedBitrateEstimatorKt;
import org.jitsi.nlj.rtp.bandwidthestimation2.BitrateEstimator;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketResult;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.DataSize;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\b\u0014J\u000f\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/AcknowledgedBitrateEstimator;", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/AcknowledgedBitrateEstimatorInterface;", "bitrateEstimator", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateEstimator;", "<init>", "(Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateEstimator;)V", "()V", "getBitrateEstimator", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateEstimator;", "alrEndedTime", "Ljava/time/Instant;", "inAlr", "", "incomingPacketFeedbackVector", "", "packetFeedbackVector", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacketResult;", "bitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "bitrate-4yB3KFE", "peekRate", "peekRate-4yB3KFE", "setAlr", "setAlrEndedTime", "jitsi-media-transform"})
public final class AcknowledgedBitrateEstimator
implements AcknowledgedBitrateEstimatorInterface {
    @NotNull
    private final BitrateEstimator bitrateEstimator;
    @Nullable
    private Instant alrEndedTime;
    private boolean inAlr;

    public AcknowledgedBitrateEstimator(@NotNull BitrateEstimator bitrateEstimator) {
        Intrinsics.checkNotNullParameter(bitrateEstimator, "bitrateEstimator");
        this.bitrateEstimator = bitrateEstimator;
    }

    @NotNull
    public final BitrateEstimator getBitrateEstimator() {
        return this.bitrateEstimator;
    }

    public AcknowledgedBitrateEstimator() {
        this(new BitrateEstimator());
    }

    @Override
    public void incomingPacketFeedbackVector(@NotNull List<PacketResult> packetFeedbackVector) {
        Intrinsics.checkNotNullParameter(packetFeedbackVector, "packetFeedbackVector");
        if (!AcknowledgedBitrateEstimatorKt.access$isSortedByReceiveTime(packetFeedbackVector)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        for (PacketResult packet : packetFeedbackVector) {
            if (this.alrEndedTime != null && packet.getSentPacket().getSendTime().compareTo(this.alrEndedTime) > 0) {
                this.bitrateEstimator.expectFastRateChange();
                this.alrEndedTime = null;
            }
            DataSize acknowledgedEstimate = packet.getSentPacket().getSize().plus(packet.getSentPacket().getPriorUnackedData());
            this.bitrateEstimator.update(packet.getReceiveTime(), acknowledgedEstimate, this.inAlr);
        }
    }

    @Override
    @Nullable
    public Bandwidth bitrate-4yB3KFE() {
        return this.bitrateEstimator.bitrate-4yB3KFE();
    }

    @Override
    @Nullable
    public Bandwidth peekRate-4yB3KFE() {
        return this.bitrateEstimator.peekRate-4yB3KFE();
    }

    @Override
    public void setAlr(boolean inAlr) {
        this.inAlr = inAlr;
    }

    @Override
    public void setAlrEndedTime(@NotNull Instant alrEndedTime) {
        Intrinsics.checkNotNullParameter(alrEndedTime, "alrEndedTime");
        this.alrEndedTime = alrEndedTime;
    }
}

