/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.spider;

import java.io.IOException;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.spider.Collector;
import org.parosproxy.paros.core.spider.Html;
import org.parosproxy.paros.core.spider.QueueItem;
import org.parosproxy.paros.core.spider.Spider;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpStatusCode;

public class SpiderThread
extends Thread {
    private static final String[] NEGLECT_SUFFIXES = new String[]{"gif", "jpg", "bmp", "mp3", "arj", "doc", "swf", "pdf", "mpg", "wmv", "zip", "exe", "cab", "iso", "avi"};
    private Spider parent = null;
    private boolean stop = false;
    private List queue = null;
    private boolean completed = false;
    private Collector collector = null;
    private boolean emptyQueue = false;

    boolean isEmptyQueue() {
        return this.emptyQueue;
    }

    SpiderThread(Spider spider) {
        this.parent = spider;
        this.queue = spider.getQueue();
        this.collector = new Collector(this);
        this.setDaemon(true);
        this.setPriority(3);
    }

    boolean isStop() {
        return this.stop;
    }

    void setStop(boolean bl) {
        this.stop = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        QueueItem queueItem = null;
        while (!this.isStop() && !this.parent.isAllThreadEmptyQueue()) {
            try {
                List list = this.queue;
                synchronized (list) {
                    do {
                        queueItem = null;
                        if (this.queue.isEmpty()) {
                            try {
                                this.setEmptyQueue(true);
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        queueItem = (QueueItem)this.queue.remove(0);
                        this.setEmptyQueue(false);
                    } while (!this.stop && queueItem != null && this.parent.isInVisitedLink(queueItem.getMessage()));
                }
                if (queueItem != null) {
                    this.parent.SpiderProgress(queueItem);
                    this.crawl(queueItem.getMessage(), queueItem.getDepth());
                    queueItem.getHistoryReference().delete();
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (this.stop) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.queue.isEmpty()) {
            this.completed = true;
        }
        this.parent.checkIfAllThreadCompleted();
    }

    private void readMsgResponse(HttpMessage httpMessage) throws HttpException, IOException, HttpMalformedHeaderException {
        httpMessage.getRequestHeader().setHeader("If-Modified-Since", null);
        httpMessage.getRequestHeader().setHeader("If-None-Match", null);
        httpMessage.getRequestHeader().setContentLength(httpMessage.getRequestBody().length());
        this.parent.getHttpSender().sendAndReceive(httpMessage);
        httpMessage.getResponseHeader().setHeader("Transfer-encoding", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void crawl(HttpMessage httpMessage, int n) {
        block11: {
            block10: {
                block9: {
                    Html html = null;
                    try {
                        try {
                            if (this.isNeglectCrawl(httpMessage)) {
                                this.parent.readURI(httpMessage);
                                Object var6_4 = null;
                                httpMessage.setResponseHeader(new HttpResponseHeader());
                                httpMessage.getResponseBody().setBody("");
                                this.parent.addVisitedLink(httpMessage);
                                return;
                            }
                            this.readMsgResponse(httpMessage);
                            if (!HttpStatusCode.isSuccess(httpMessage.getResponseHeader().getStatusCode())) {
                                break block9;
                            }
                            if (httpMessage.getResponseHeader().getContentLength() > 200000) {
                                httpMessage.setResponseHeader(new HttpResponseHeader());
                                httpMessage.getResponseBody().setBody("");
                            }
                            this.parent.readURI(httpMessage);
                            if (this.isNeglectResponse(httpMessage.getResponseHeader())) {
                                break block10;
                            }
                            html = new Html(httpMessage.getRequestHeader().getURI(), httpMessage.getResponseBody().toString());
                            this.collector.collect(html, n);
                            break block11;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var6_8 = null;
                            httpMessage.setResponseHeader(new HttpResponseHeader());
                            httpMessage.getResponseBody().setBody("");
                            this.parent.addVisitedLink(httpMessage);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        httpMessage.setResponseHeader(new HttpResponseHeader());
                        httpMessage.getResponseBody().setBody("");
                        this.parent.addVisitedLink(httpMessage);
                        throw throwable;
                    }
                }
                Object var6_5 = null;
                httpMessage.setResponseHeader(new HttpResponseHeader());
                httpMessage.getResponseBody().setBody("");
                this.parent.addVisitedLink(httpMessage);
                return;
            }
            Object var6_6 = null;
            httpMessage.setResponseHeader(new HttpResponseHeader());
            httpMessage.getResponseBody().setBody("");
            this.parent.addVisitedLink(httpMessage);
            return;
        }
        Object var6_7 = null;
        httpMessage.setResponseHeader(new HttpResponseHeader());
        httpMessage.getResponseBody().setBody("");
        this.parent.addVisitedLink(httpMessage);
    }

    private URI buildURI(URI uRI, String string) throws URIException {
        URI uRI2 = null;
        uRI2 = new URI(uRI, string, true);
        return uRI2;
    }

    void foundURI(HttpMessage httpMessage, String string, int n) throws URIException {
        httpMessage.getRequestHeader().setHeader("Referer", string);
        this.parent.foundURI(httpMessage, n + 1);
    }

    private boolean isNeglectCrawl(HttpMessage httpMessage) {
        boolean bl = false;
        URI uRI = httpMessage.getRequestHeader().getURI();
        try {
            if (this.parent.getSpiderParam().isSkipURL(uRI)) {
                return true;
            }
            if (uRI.getPath() != null) {
                String string = uRI.getPath().toLowerCase();
                for (int i = 0; i < NEGLECT_SUFFIXES.length; ++i) {
                    String string2 = "." + NEGLECT_SUFFIXES[i];
                    if (!string.endsWith(string2)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private boolean isNeglectResponse(HttpResponseHeader httpResponseHeader) {
        if (!HttpStatusCode.isSuccess(httpResponseHeader.getStatusCode())) {
            return true;
        }
        if (httpResponseHeader.isImage()) {
            return true;
        }
        if (httpResponseHeader.isText()) {
            return false;
        }
        return httpResponseHeader.getContentLength() > 200000;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    private void setEmptyQueue(boolean bl) {
        this.emptyQueue = bl;
    }

    Spider getParent() {
        return this.parent;
    }
}

