/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.io;

import edu.berkeley.nlp.lm.io.ArpaLmReaderCallback;
import edu.berkeley.nlp.lm.map.NgramMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class NgramMapAddingCallback<V>
implements ArpaLmReaderCallback<V> {
    private final NgramMap<V> map;
    private final List<int[]> failures;
    private final boolean canFail;

    public NgramMapAddingCallback(NgramMap<V> map, List<int[]> failures) {
        this.map = map;
        this.canFail = failures == null;
        this.failures = this.canFail ? new ArrayList() : failures;
    }

    @Override
    public void call(int[] ngram, int startPos, int endPos, V v, String words) {
        long add = this.map.put(ngram, startPos, endPos, v);
        if (add < 0L) {
            if (this.canFail) {
                for (int endPos_ = endPos - 1; endPos_ > startPos; --endPos_) {
                    if (this.map.contains(ngram, startPos, endPos_)) continue;
                    this.failures.add(Arrays.copyOfRange(ngram, startPos, endPos_));
                }
                for (int startPos_ = startPos + 1; startPos_ < endPos; ++startPos_) {
                    if (this.map.contains(ngram, startPos_, endPos)) continue;
                    this.failures.add(Arrays.copyOfRange(ngram, startPos_, endPos));
                }
            } else {
                throw new RuntimeException("Failed to add line " + words);
            }
        }
    }

    @Override
    public void handleNgramOrderFinished(int order) {
        for (int[] ngram : this.failures) {
            if (ngram.length != order) continue;
            this.map.put(ngram, 0, ngram.length, null);
        }
        this.map.handleNgramsFinished(order);
    }

    @Override
    public void cleanup() {
        if (this.failures.isEmpty() || !this.canFail) {
            this.map.trim();
        }
    }

    @Override
    public void initWithLengths(List<Long> numNGrams) {
        this.map.initWithLengths(numNGrams);
    }

    public List<int[]> getFailures() {
        return this.failures;
    }

    @Override
    public void handleNgramOrderStarted(int order) {
    }
}

