/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.util.TMXProp;

public class ImportFromAutoTMX {
    final RealProject project;
    Map<String, List<SourceTextEntry>> existEntries = new HashMap<String, List<SourceTextEntry>>();

    public ImportFromAutoTMX(RealProject project, List<SourceTextEntry> allProjectEntries) {
        this.project = project;
        for (SourceTextEntry ste : allProjectEntries) {
            List<SourceTextEntry> list = this.existEntries.get(ste.getSrcText());
            if (list == null) {
                list = new ArrayList<SourceTextEntry>();
                this.existEntries.put(ste.getSrcText(), list);
            }
            list.add(ste);
        }
    }

    void process(ExternalTMX tmx, boolean isEnforcedTMX) {
        for (ITMXEntry e : tmx.getEntries()) {
            List<SourceTextEntry> list = this.existEntries.get(e.getSourceText());
            if (list == null) continue;
            for (SourceTextEntry ste : list) {
                TMXEntry existTranslation = this.project.getTranslationInfo(ste);
                String id = ste.getKey().id;
                boolean hasICE = id != null && e.hasPropValue("x-ice", id);
                boolean has100PC = id != null && e.hasPropValue("x-100pc", id);
                boolean hasAlternateTranslations = this.altTranslationMatches(e, ste.getKey());
                if (e.hasPropValue("foreignMatch", "true")) continue;
                if (!hasICE && !has100PC) {
                    boolean isDefaultTranslation;
                    boolean bl = isDefaultTranslation = !this.isAltTranslation(e);
                    if (!existTranslation.defaultTranslation && isDefaultTranslation || !isDefaultTranslation && !hasAlternateTranslations) continue;
                    if (isEnforcedTMX && (!existTranslation.isTranslated() || existTranslation.linked != TMXEntry.ExternalLinked.xENFORCED || !isDefaultTranslation && existTranslation.defaultTranslation)) {
                        this.setTranslation(ste, e, isDefaultTranslation, TMXEntry.ExternalLinked.xENFORCED);
                        continue;
                    }
                    if (existTranslation.isTranslated() && (isDefaultTranslation || !hasAlternateTranslations)) continue;
                    this.setTranslation(ste, e, isDefaultTranslation, TMXEntry.ExternalLinked.xAUTO);
                    continue;
                }
                if (!existTranslation.isTranslated() || existTranslation.defaultTranslation) {
                    if (hasICE) {
                        this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.xICE);
                        continue;
                    }
                    if (!has100PC) continue;
                    this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.x100PC);
                    continue;
                }
                if (existTranslation.linked == TMXEntry.ExternalLinked.xICE || existTranslation.linked == TMXEntry.ExternalLinked.x100PC) {
                    if (!hasICE || Objects.equals(existTranslation.getTranslationText(), e.getTranslationText())) continue;
                    this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.xICE);
                    continue;
                }
                if (existTranslation.linked != TMXEntry.ExternalLinked.x100PC || !has100PC || Objects.equals(existTranslation.getTranslationText(), e.getTranslationText())) continue;
                this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.x100PC);
            }
        }
    }

    private boolean isAltTranslation(ITMXEntry entry) {
        if (!entry.hasProperties()) {
            return false;
        }
        boolean hasFileProp = false;
        boolean hasOtherProp = false;
        for (TMXProp p : entry.getProperties()) {
            if (p.getType().equals("file")) {
                hasFileProp = true;
                continue;
            }
            if (!p.getType().equals("id") && !p.getType().equals("tuid") && !p.getType().equals("next") && !p.getType().equals("path") && !p.getType().equals("prev")) continue;
            hasOtherProp = true;
        }
        return EntryKey.isIgnoreFileContext() ? hasOtherProp : hasFileProp;
    }

    private boolean altTranslationMatches(ITMXEntry entry, EntryKey key) {
        if (!entry.hasProperties()) {
            return false;
        }
        String file = null;
        String id = null;
        String next = null;
        String prev = null;
        String path = null;
        for (TMXProp p : entry.getProperties()) {
            if ("file".equals(p.getType())) {
                file = p.getValue();
                continue;
            }
            if ("id".equals(p.getType())) {
                id = p.getValue();
                continue;
            }
            if ("tuid".equals(p.getType()) && id == null) {
                id = p.getValue();
                continue;
            }
            if ("next".equals(p.getType())) {
                next = p.getValue();
                continue;
            }
            if ("prev".equals(p.getType())) {
                prev = p.getValue();
                continue;
            }
            if (!"path".equals(p.getType())) continue;
            path = p.getValue();
        }
        return key.equals(new EntryKey(file, entry.getSourceText(), id, prev, next, path));
    }

    private void setTranslation(SourceTextEntry entry, ITMXEntry trans, boolean defaultTranslation, TMXEntry.ExternalLinked externalLinked) {
        TMXEntry newTrEntry = !trans.isTranslated() && !trans.hasNote() ? null : new TMXEntry(trans, defaultTranslation, externalLinked);
        this.project.projectTMX.setTranslation(entry, newTrEntry, defaultTranslation);
    }
}

