/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.CellError;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public final class UnboundSlot
extends CellError {
    public UnboundSlot(LispObject initArgs) {
        super(StandardClass.UNBOUND_SLOT);
        this.initialize(initArgs);
    }

    @Override
    protected void initialize(LispObject initArgs) {
        super.initialize(initArgs);
        while (initArgs != Lisp.NIL) {
            LispObject first = initArgs.car();
            initArgs = initArgs.cdr();
            if (first == Keyword.INSTANCE) {
                this.setInstance(initArgs.car());
                break;
            }
            initArgs = initArgs.cdr();
        }
    }

    public LispObject getInstance() {
        return this.getInstanceSlotValue(Symbol.INSTANCE);
    }

    private void setInstance(LispObject instance) {
        this.setInstanceSlotValue(Symbol.INSTANCE, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage() {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(Symbol.PRINT_ESCAPE, Lisp.T);
        try {
            StringBuilder sb = new StringBuilder("The slot ");
            sb.append(this.getCellName().princToString());
            sb.append(" is unbound in the object ");
            sb.append(this.getInstance().princToString());
            sb.append('.');
            String string = sb.toString();
            return string;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    @Override
    public LispObject typeOf() {
        return Symbol.UNBOUND_SLOT;
    }

    @Override
    public LispObject classOf() {
        return StandardClass.UNBOUND_SLOT;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.UNBOUND_SLOT) {
            return Lisp.T;
        }
        if (type == StandardClass.UNBOUND_SLOT) {
            return Lisp.T;
        }
        return super.typep(type);
    }
}

