/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.PrintNotReadable;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.protocol.Hashtable;

public class WeakHashTable
extends LispObject
implements Hashtable {
    protected static final float loadFactor = 0.75f;
    protected final LispObject rehashSize;
    protected final LispObject rehashThreshold;
    protected int threshold;
    protected volatile HashEntry[] buckets;
    protected volatile int count;
    final Comparator comparator;
    private final ReentrantLock lock = new ReentrantLock();
    HashEntry bucketType;
    final LispObject weakness;
    ReferenceQueue<LispObject> queue = new ReferenceQueue();
    Map<Reference, HashEntry> entryLookup = Collections.synchronizedMap(new HashMap());

    private WeakHashTable(Comparator c, int size, LispObject rehashSize, LispObject rehashThreshold, LispObject weakness) {
        this.rehashSize = rehashSize;
        this.rehashThreshold = rehashThreshold;
        this.bucketType = null;
        this.weakness = weakness;
        if (weakness.equals(Keyword.KEY)) {
            this.bucketType = new HashEntryWeakKey();
        } else if (weakness.equals(Keyword.VALUE)) {
            this.bucketType = new HashEntryWeakValue();
        } else if (weakness.equals(Keyword.KEY_AND_VALUE)) {
            this.bucketType = new HashEntryWeakKeyAndValue();
        } else if (weakness.equals(Keyword.KEY_OR_VALUE)) {
            this.bucketType = new HashEntryWeakKeyOrValue();
        } else assert (false) : "Bad weakness argument to WeakHashTable type constructor.";
        this.buckets = this.bucketType.makeArray(size);
        this.threshold = (int)((float)size * 0.75f);
        this.comparator = c;
    }

    protected static int calculateInitialCapacity(int size) {
        int capacity;
        for (capacity = 1; capacity < size; capacity <<= 1) {
        }
        return capacity;
    }

    public static WeakHashTable newEqHashTable(int size, LispObject rehashSize, LispObject rehashThreshold, LispObject weakness) {
        return new WeakHashTable(new Comparator(), size, rehashSize, rehashThreshold, weakness);
    }

    public static WeakHashTable newEqlHashTable(int size, LispObject rehashSize, LispObject rehashThreshold, LispObject weakness) {
        return new WeakHashTable(new EqlComparator(), size, rehashSize, rehashThreshold, weakness);
    }

    public static WeakHashTable newEqualHashTable(int size, LispObject rehashSize, LispObject rehashThreshold, LispObject weakness) {
        return new WeakHashTable(new EqualComparator(), size, rehashSize, rehashThreshold, weakness);
    }

    public static WeakHashTable newEqualpHashTable(int size, LispObject rehashSize, LispObject rehashThreshold, LispObject weakness) {
        return new WeakHashTable(new EqualpComparator(), size, rehashSize, rehashThreshold, weakness);
    }

    public final LispObject getRehashSize() {
        return this.rehashSize;
    }

    public final LispObject getRehashThreshold() {
        return this.rehashThreshold;
    }

    public int getSize() {
        HashEntry[] b = this.getTable();
        return b.length;
    }

    public int getCount() {
        this.getTable();
        return this.count;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.HASH_TABLE;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.HASH_TABLE;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.HASH_TABLE) {
            return Lisp.T;
        }
        if (type == BuiltInClass.HASH_TABLE) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public boolean equalp(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WeakHashTable) {
            WeakHashTable ht = (WeakHashTable)obj;
            if (this.count != ht.count) {
                return false;
            }
            if (this.getTest() != ht.getTest()) {
                return false;
            }
            for (LispObject entries = this.ENTRIES(); entries != Lisp.NIL; entries = entries.cdr()) {
                LispObject entry = entries.car();
                LispObject key = entry.car();
                LispObject value = entry.cdr();
                if (value.equalp(ht.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public LispObject getParts() {
        HashEntry[] b = this.getTable();
        LispObject parts = Lisp.NIL;
        for (int i = 0; i < b.length; ++i) {
            for (HashEntry e = b[i]; e != null; e = e.getNext()) {
                LispObject key = e.getKey();
                LispObject value = e.getValue();
                if (key != null && value != null) {
                    parts = parts.push(new Cons("KEY [bucket " + i + "]", key));
                    parts = parts.push(new Cons("VALUE", value));
                    continue;
                }
                assert (false) : "Dangling hash entries encountered.";
            }
        }
        return parts.nreverse();
    }

    public void clear() {
        this.lock.lock();
        try {
            this.buckets = this.bucketType.makeArray(this.buckets.length);
            this.count = 0;
            while (this.queue.poll() != null) {
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public LispObject gethash(LispObject key) {
        Symbol presentp;
        LispObject value = this.get(key);
        if (value == null) {
            presentp = Lisp.NIL;
            value = presentp;
        } else {
            presentp = Lisp.T;
        }
        return LispThread.currentThread().setValues(value, presentp);
    }

    public LispObject gethash(LispObject key, LispObject defaultValue) {
        Symbol presentp;
        LispObject value = this.get(key);
        if (value == null) {
            value = defaultValue;
            presentp = Lisp.NIL;
        } else {
            presentp = Lisp.T;
        }
        return LispThread.currentThread().setValues(value, presentp);
    }

    public LispObject gethash1(LispObject key) {
        LispObject value = this.get(key);
        return value != null ? value : Lisp.NIL;
    }

    public LispObject puthash(LispObject key, LispObject newValue) {
        this.put(key, newValue);
        return newValue;
    }

    public LispObject remhash(LispObject key) {
        return this.remove(key) != null ? Lisp.T : Lisp.NIL;
    }

    @Override
    public String printObject() {
        if (Symbol.PRINT_READABLY.symbolValue(LispThread.currentThread()) != Lisp.NIL) {
            Lisp.error(new PrintNotReadable(Lisp.list(Keyword.OBJECT, this)));
            return null;
        }
        StringBuilder sb = new StringBuilder(this.getTest().princToString());
        sb.append(' ');
        sb.append(Symbol.HASH_TABLE.princToString());
        sb.append(' ');
        if (this.bucketType instanceof HashEntryWeakKey) {
            sb.append("WEAKNESS :KEY");
        } else if (this.bucketType instanceof HashEntryWeakValue) {
            sb.append("WEAKNESS :VALUE");
        } else if (this.bucketType instanceof HashEntryWeakKeyAndValue) {
            sb.append("WEAKNESS :KEY-AND-VALUE");
        } else if (this.bucketType instanceof HashEntryWeakKeyOrValue) {
            sb.append("WEAKNESS :KEY-OR-VALUE");
        }
        sb.append(' ');
        sb.append(this.count);
        if (this.count == 1) {
            sb.append(" entry");
        } else {
            sb.append(" entries");
        }
        sb.append(", ");
        sb.append(this.buckets.length);
        sb.append(" buckets");
        return this.unreadableString(sb.toString());
    }

    public Symbol getTest() {
        return this.comparator.getTest();
    }

    public LispObject getWeakness() {
        return this.weakness;
    }

    HashEntry[] getTable() {
        this.lock.lock();
        try {
            this.bucketType.expungeQueue();
            HashEntry[] hashEntryArray = this.buckets;
            return hashEntryArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected HashEntry getEntry(LispObject key) {
        HashEntry[] b = this.getTable();
        int hash = this.comparator.hash(key);
        for (HashEntry e = b[hash & b.length - 1]; e != null; e = e.getNext()) {
            if (hash != e.getHash() || key != e.getKey() && !this.comparator.keysEqual(key, e.getKey())) continue;
            return e;
        }
        return null;
    }

    public LispObject get(LispObject key) {
        LispObject v;
        HashEntry e = this.getEntry(key);
        LispObject lispObject = v = e == null ? null : e.getValue();
        if (e == null || v != null) {
            return v;
        }
        return e.getValue();
    }

    public void put(LispObject key, LispObject value) {
        HashEntry e = this.getEntry(key);
        if (e != null) {
            e.setValue(value);
        } else {
            if (++this.count > this.threshold) {
                this.rehash();
            }
            int hash = this.comparator.hash(key);
            int index = hash & this.buckets.length - 1;
            this.buckets[index] = this.bucketType.makeInstance(key, hash, value, this.buckets[index], index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject remove(LispObject key) {
        this.lock.lock();
        try {
            this.bucketType.expungeQueue();
            int index = this.comparator.hash(key) & this.buckets.length - 1;
            HashEntry last2 = null;
            for (HashEntry e = this.buckets[index]; e != null; e = e.getNext()) {
                LispObject entryKey = e.getKey();
                if (entryKey == null) {
                    e.clear();
                    if (last2 == null) {
                        this.buckets[index] = e.getNext();
                    } else {
                        last2.setNext(e.getNext());
                    }
                    --this.count;
                } else if (this.comparator.keysEqual(key, entryKey)) {
                    e.clear();
                    if (last2 == null) {
                        this.buckets[index] = e.getNext();
                    } else {
                        last2.setNext(e.getNext());
                    }
                    --this.count;
                    LispObject lispObject = e.getValue();
                    return lispObject;
                }
                last2 = e;
            }
            LispObject lispObject = null;
            return lispObject;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void remove(Reference ref) {
        assert (this.lock.isHeldByCurrentThread());
        HashEntry entry = this.entryLookup.get(ref);
        if (entry == null) {
            return;
        }
        int index = entry.getSlot();
        HashEntry last2 = null;
        for (HashEntry e = this.buckets[index]; e != null; e = e.getNext()) {
            if (e.equals(entry)) {
                if (last2 == null) {
                    this.buckets[index] = e.getNext();
                } else {
                    last2.setNext(e.getNext());
                }
                --this.count;
                break;
            }
            last2 = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rehash() {
        this.lock.lock();
        try {
            int newCapacity = this.buckets.length * 2;
            this.threshold = (int)((float)newCapacity * 0.75f);
            int mask = newCapacity - 1;
            HashEntry[] newBuckets = this.bucketType.makeArray(newCapacity);
            int i = this.buckets.length;
            while (i-- > 0) {
                HashEntry e = this.buckets[i];
                while (e != null) {
                    LispObject key = e.getKey();
                    LispObject value = e.getValue();
                    if (key == null || value == null) {
                        e.clear();
                        e = e.getNext();
                        continue;
                    }
                    int index = this.comparator.hash(key) & mask;
                    e.clear();
                    newBuckets[index] = this.bucketType.makeInstance(key, e.getHash(), value, newBuckets[index], index);
                    e = e.getNext();
                }
            }
            this.buckets = newBuckets;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Deprecated
    public LispObject ENTRIES() {
        return this.getEntries();
    }

    @Override
    public LispObject getEntries() {
        HashEntry[] b = this.getTable();
        LispObject list = Lisp.NIL;
        int i = b.length;
        while (i-- > 0) {
            for (HashEntry e = b[i]; e != null; e = e.getNext()) {
                LispObject key = e.getKey();
                LispObject value = e.getValue();
                if (key != null && value != null) {
                    list = new Cons(new Cons(key, value), list);
                    continue;
                }
                assert (false) : "ENTRIES encounted dangling entries.";
            }
        }
        return list;
    }

    public LispObject MAPHASH(LispObject function) {
        HashEntry[] b = this.getTable();
        int i = b.length;
        while (i-- > 0) {
            for (HashEntry e = b[i]; e != null; e = e.getNext()) {
                LispObject key = e.getKey();
                LispObject value = e.getValue();
                if (key != null && value != null) {
                    function.execute(key, value);
                    continue;
                }
                assert (false) : "MAPHASH encountered dangling entries.";
            }
        }
        return Lisp.NIL;
    }

    @Override
    public int psxhash() {
        long result = 2062775257L;
        result = Lisp.mix(result, this.count);
        result = Lisp.mix(result, this.getTest().sxhash());
        return (int)(result & Integer.MAX_VALUE);
    }

    abstract class HashEntry {
        LispObject key;
        int hash;
        volatile LispObject value;
        HashEntry next;
        int slot;

        public HashEntry() {
        }

        public HashEntry(LispObject key, int hash, LispObject value, HashEntry next, int slot) {
            this.key = key;
            this.hash = hash;
            this.value = value;
            this.next = next;
            this.slot = slot;
        }

        public LispObject getKey() {
            return this.key;
        }

        public void setKey(LispObject key) {
            this.key = key;
        }

        public int getHash() {
            return this.hash;
        }

        public void setHash(int hash) {
            this.hash = hash;
        }

        public LispObject getValue() {
            return this.value;
        }

        public void setValue(LispObject value) {
            this.value = value;
        }

        public HashEntry getNext() {
            return this.next;
        }

        public void setNext(HashEntry next) {
            this.next = next;
        }

        public int getSlot() {
            return this.slot;
        }

        public void setSlot(int slot) {
            this.slot = slot;
        }

        abstract HashEntry[] makeArray(int var1);

        abstract HashEntry makeInstance(LispObject var1, int var2, LispObject var3, HashEntry var4, int var5);

        abstract void expungeQueue();

        abstract void clear();
    }

    class HashEntryWeakKey
    extends HashEntry {
        private WeakReference<LispObject> key;

        public HashEntryWeakKey() {
        }

        public HashEntryWeakKey(LispObject key, int hash, LispObject value, HashEntry next, int slot) {
            this.hash = hash;
            this.value = value;
            this.next = next;
            this.slot = slot;
            this.key = new WeakReference<LispObject>(key, WeakHashTable.this.queue);
            WeakHashTable.this.entryLookup.put(this.key, this);
        }

        @Override
        public LispObject getKey() {
            return (LispObject)this.key.get();
        }

        @Override
        public void setKey(LispObject key) {
            WeakReference<LispObject> old = this.key;
            old.clear();
            this.key = new WeakReference<LispObject>(key, WeakHashTable.this.queue);
            WeakHashTable.this.entryLookup.put(this.key, this);
        }

        HashEntryWeakKey[] makeArray(int length) {
            return new HashEntryWeakKey[length];
        }

        @Override
        HashEntry makeInstance(LispObject key, int hash, LispObject value, HashEntry next, int slot) {
            return new HashEntryWeakKey(key, hash, value, next, slot);
        }

        @Override
        void expungeQueue() {
            Reference<LispObject> ref = WeakHashTable.this.queue.poll();
            while (ref != null) {
                WeakHashTable.this.remove(ref);
                WeakHashTable.this.entryLookup.remove(ref);
                ref = WeakHashTable.this.queue.poll();
            }
        }

        @Override
        void clear() {
            this.key.clear();
            assert (WeakHashTable.this.entryLookup.containsKey(this.key)) : "Key was not in lookup table";
            WeakHashTable.this.entryLookup.remove(this.key);
        }
    }

    class HashEntryWeakValue
    extends HashEntry {
        private WeakReference<LispObject> value;

        public HashEntryWeakValue() {
        }

        public HashEntryWeakValue(LispObject key, int hash, LispObject value, HashEntry next, int slot) {
            this.hash = hash;
            this.key = key;
            this.next = next;
            this.slot = slot;
            this.value = new WeakReference<LispObject>(value, WeakHashTable.this.queue);
            WeakHashTable.this.entryLookup.put(this.value, this);
        }

        @Override
        public LispObject getValue() {
            return (LispObject)this.value.get();
        }

        @Override
        public void setValue(LispObject value) {
            WeakReference<LispObject> old = this.value;
            old.clear();
            this.value = new WeakReference<LispObject>(value, WeakHashTable.this.queue);
            WeakHashTable.this.entryLookup.put(this.value, this);
        }

        HashEntryWeakValue[] makeArray(int length) {
            return new HashEntryWeakValue[length];
        }

        @Override
        HashEntryWeakValue makeInstance(LispObject key, int hash, LispObject value, HashEntry next, int slot) {
            return new HashEntryWeakValue(key, hash, value, next, slot);
        }

        @Override
        void expungeQueue() {
            Reference<LispObject> ref = WeakHashTable.this.queue.poll();
            while (ref != null) {
                WeakHashTable.this.remove(ref);
                WeakHashTable.this.entryLookup.remove(ref);
                ref = WeakHashTable.this.queue.poll();
            }
        }

        @Override
        void clear() {
            this.value.clear();
            assert (WeakHashTable.this.entryLookup.containsKey(this.value)) : "Value was not in lookup table.";
            WeakHashTable.this.entryLookup.remove(this.value);
        }
    }

    class HashEntryWeakKeyAndValue
    extends HashEntry {
        private WeakReference<LispObject> key;
        private WeakReference<LispObject> value;

        public HashEntryWeakKeyAndValue() {
        }

        public HashEntryWeakKeyAndValue(LispObject key, int hash, LispObject value, HashEntry next, int slot) {
            this.hash = hash;
            this.next = next;
            this.slot = slot;
            this.key = new WeakReference<LispObject>(key, WeakHashTable.this.queue);
            WeakHashTable.this.entryLookup.put(this.key, this);
            this.value = new WeakReference<LispObject>(value, WeakHashTable.this.queue);
            WeakHashTable.this.entryLookup.put(this.value, this);
        }

        @Override
        public LispObject getKey() {
            return (LispObject)this.key.get();
        }

        @Override
        public void setKey(LispObject key) {
            WeakReference<LispObject> old = this.key;
            WeakHashTable.this.entryLookup.remove(old);
            old.clear();
            this.key = new WeakReference<LispObject>(key, WeakHashTable.this.queue);
            WeakHashTable.this.entryLookup.put(this.key, this);
        }

        @Override
        public LispObject getValue() {
            return (LispObject)this.value.get();
        }

        @Override
        public void setValue(LispObject value) {
            WeakReference<LispObject> old = this.value;
            WeakHashTable.this.entryLookup.remove(old);
            old.clear();
            this.value = new WeakReference<LispObject>(value, WeakHashTable.this.queue);
            WeakHashTable.this.entryLookup.put(this.value, this);
        }

        HashEntryWeakKeyAndValue[] makeArray(int length) {
            return new HashEntryWeakKeyAndValue[length];
        }

        @Override
        HashEntryWeakKeyAndValue makeInstance(LispObject key, int hash, LispObject value, HashEntry next, int slot) {
            return new HashEntryWeakKeyAndValue(key, hash, value, next, slot);
        }

        @Override
        void expungeQueue() {
            Reference<LispObject> ref = WeakHashTable.this.queue.poll();
            while (ref != null) {
                HashEntry entry = WeakHashTable.this.entryLookup.get(ref);
                if (entry == null) {
                    ref = WeakHashTable.this.queue.poll();
                    continue;
                }
                if (entry.getKey() == null && entry.getValue() == null) {
                    WeakHashTable.this.remove(ref);
                    WeakHashTable.this.entryLookup.remove(ref);
                } else {
                    WeakHashTable.this.entryLookup.remove(ref);
                }
                ref = WeakHashTable.this.queue.poll();
            }
        }

        @Override
        void clear() {
            this.key.clear();
            this.value.clear();
            WeakHashTable.this.entryLookup.remove(this.key);
            WeakHashTable.this.entryLookup.remove(this.value);
        }
    }

    class HashEntryWeakKeyOrValue
    extends HashEntryWeakKeyAndValue {
        public HashEntryWeakKeyOrValue() {
        }

        public HashEntryWeakKeyOrValue(LispObject key, int hash, LispObject value, HashEntry next, int slot) {
            super(key, hash, value, next, slot);
        }

        HashEntryWeakKeyOrValue[] makeArray(int length) {
            return new HashEntryWeakKeyOrValue[length];
        }

        @Override
        HashEntryWeakKeyOrValue makeInstance(LispObject key, int hash, LispObject value, HashEntry next, int slot) {
            return new HashEntryWeakKeyOrValue(key, hash, value, next, slot);
        }

        @Override
        void expungeQueue() {
            Reference<LispObject> ref = WeakHashTable.this.queue.poll();
            while (ref != null) {
                HashEntry entry = WeakHashTable.this.entryLookup.get(ref);
                if (entry == null) {
                    ref = WeakHashTable.this.queue.poll();
                    continue;
                }
                WeakHashTable.this.remove(ref);
                WeakHashTable.this.entryLookup.remove(entry.key);
                WeakHashTable.this.entryLookup.remove(entry.value);
                ref = WeakHashTable.this.queue.poll();
            }
        }
    }

    protected static class Comparator {
        protected Comparator() {
        }

        Symbol getTest() {
            return Symbol.EQ;
        }

        boolean keysEqual(LispObject key1, LispObject key2) {
            return key1 == key2;
        }

        int hash(LispObject key) {
            return key.sxhash();
        }
    }

    protected static class EqlComparator
    extends Comparator {
        protected EqlComparator() {
        }

        @Override
        Symbol getTest() {
            return Symbol.EQL;
        }

        @Override
        boolean keysEqual(LispObject key1, LispObject key2) {
            return key1.eql(key2);
        }
    }

    protected static class EqualComparator
    extends Comparator {
        protected EqualComparator() {
        }

        @Override
        Symbol getTest() {
            return Symbol.EQUAL;
        }

        @Override
        boolean keysEqual(LispObject key1, LispObject key2) {
            return key1.equal(key2);
        }
    }

    protected static class EqualpComparator
    extends Comparator {
        protected EqualpComparator() {
        }

        @Override
        Symbol getTest() {
            return Symbol.EQUALP;
        }

        @Override
        boolean keysEqual(LispObject key1, LispObject key2) {
            return key1.equalp(key2);
        }

        @Override
        int hash(LispObject key) {
            return key.psxhash();
        }
    }

    static enum WeaknessType {
        KEY,
        VALUE,
        KEY_AND_VALUE,
        KEY_OR_VALUE;

    }

    static enum ReferenceType {
        NORMAL,
        WEAK,
        SOFT;

    }
}

