/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.ejb.BorlandDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.EJBDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.IPlanetDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.JbossDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.JonasDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.WeblogicDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.WeblogicTOPLinkDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.WebsphereDeploymentTool;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.xml.sax.SAXException;

public class EjbJar
extends MatchingTask {
    private Config config = new Config();
    private File destDir;
    private String genericJarSuffix = "-generic.jar";
    private ArrayList deploymentTools = new ArrayList();

    protected void addDeploymentTool(EJBDeploymentTool deploymentTool) {
        deploymentTool.setTask((Task)this);
        this.deploymentTools.add(deploymentTool);
    }

    public WeblogicDeploymentTool createWeblogic() {
        WeblogicDeploymentTool tool = new WeblogicDeploymentTool();
        this.addDeploymentTool(tool);
        return tool;
    }

    public WebsphereDeploymentTool createWebsphere() {
        WebsphereDeploymentTool tool = new WebsphereDeploymentTool();
        this.addDeploymentTool(tool);
        return tool;
    }

    public BorlandDeploymentTool createBorland() {
        this.log("Borland deployment tools", 3);
        BorlandDeploymentTool tool = new BorlandDeploymentTool();
        tool.setTask((Task)this);
        this.deploymentTools.add(tool);
        return tool;
    }

    public IPlanetDeploymentTool createIplanet() {
        this.log("iPlanet Application Server deployment tools", 3);
        IPlanetDeploymentTool tool = new IPlanetDeploymentTool();
        this.addDeploymentTool(tool);
        return tool;
    }

    public JbossDeploymentTool createJboss() {
        JbossDeploymentTool tool = new JbossDeploymentTool();
        this.addDeploymentTool(tool);
        return tool;
    }

    public JonasDeploymentTool createJonas() {
        this.log("JOnAS deployment tools", 3);
        JonasDeploymentTool tool = new JonasDeploymentTool();
        this.addDeploymentTool(tool);
        return tool;
    }

    public WeblogicTOPLinkDeploymentTool createWeblogictoplink() {
        this.log("The <weblogictoplink> element is no longer required. Please use the <weblogic> element and set newCMP=\"true\"", 2);
        WeblogicTOPLinkDeploymentTool tool = new WeblogicTOPLinkDeploymentTool();
        this.addDeploymentTool(tool);
        return tool;
    }

    public Path createClasspath() {
        if (this.config.classpath == null) {
            this.config.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.config.classpath.createPath();
    }

    public DTDLocation createDTD() {
        DTDLocation dtdLocation = new DTDLocation();
        this.config.dtdLocations.add(dtdLocation);
        return dtdLocation;
    }

    public FileSet createSupport() {
        FileSet supportFileSet = new FileSet();
        this.config.supportFileSets.add(supportFileSet);
        return supportFileSet;
    }

    public void setManifest(File manifest) {
        this.config.manifest = manifest;
    }

    public void setSrcdir(File inDir) {
        this.config.srcDir = inDir;
    }

    public void setDescriptordir(File inDir) {
        this.config.descriptorDir = inDir;
    }

    public void setDependency(String analyzer) {
        this.config.analyzer = analyzer;
    }

    public void setBasejarname(String inValue) {
        this.config.baseJarName = inValue;
        if (this.config.namingScheme == null) {
            this.config.namingScheme = new NamingScheme();
            this.config.namingScheme.setValue("basejarname");
        } else if (!this.config.namingScheme.getValue().equals("basejarname")) {
            throw new BuildException("The basejarname attribute is not compatible with the " + this.config.namingScheme.getValue() + " naming scheme");
        }
    }

    public void setNaming(NamingScheme namingScheme) {
        this.config.namingScheme = namingScheme;
        if (!this.config.namingScheme.getValue().equals("basejarname") && this.config.baseJarName != null) {
            throw new BuildException("The basejarname attribute is not compatible with the " + this.config.namingScheme.getValue() + " naming scheme");
        }
    }

    public void setDestdir(File inDir) {
        this.destDir = inDir;
    }

    public void setClasspath(Path classpath) {
        this.config.classpath = classpath;
    }

    public void setFlatdestdir(boolean inValue) {
        this.config.flatDestDir = inValue;
    }

    public void setGenericjarsuffix(String inString) {
        this.genericJarSuffix = inString;
    }

    public void setBasenameterminator(String inValue) {
        this.config.baseNameTerminator = inValue;
    }

    private void validateConfig() throws BuildException {
        if (this.config.srcDir == null) {
            throw new BuildException("The srcDir attribute must be specified");
        }
        if (this.config.descriptorDir == null) {
            this.config.descriptorDir = this.config.srcDir;
        }
        if (this.config.namingScheme == null) {
            this.config.namingScheme = new NamingScheme();
            this.config.namingScheme.setValue("descriptor");
        } else if (this.config.namingScheme.getValue().equals("basejarname") && this.config.baseJarName == null) {
            throw new BuildException("The basejarname attribute must be specified with the basejarname naming scheme");
        }
    }

    public void execute() throws BuildException {
        String msg;
        this.validateConfig();
        if (this.deploymentTools.size() == 0) {
            GenericDeploymentTool genericTool = new GenericDeploymentTool();
            genericTool.setTask((Task)this);
            genericTool.setDestdir(this.destDir);
            genericTool.setGenericJarSuffix(this.genericJarSuffix);
            this.deploymentTools.add(genericTool);
        }
        Iterator i = ((AbstractList)this.deploymentTools).iterator();
        while (i.hasNext()) {
            EJBDeploymentTool tool = (EJBDeploymentTool)i.next();
            tool.configure(this.config);
            tool.validateConfigured();
        }
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            DirectoryScanner ds = this.getDirectoryScanner(this.config.descriptorDir);
            ds.scan();
            String[] files = ds.getIncludedFiles();
            this.log(files.length + " deployment descriptors located.", 3);
            for (int index = 0; index < files.length; ++index) {
                Iterator i2 = ((AbstractList)this.deploymentTools).iterator();
                while (i2.hasNext()) {
                    EJBDeploymentTool tool = (EJBDeploymentTool)i2.next();
                    tool.processDescriptor(files[index], saxParser);
                }
            }
        }
        catch (SAXException se) {
            msg = "SAXException while creating parser.  Details: " + se.getMessage();
            throw new BuildException(msg, (Throwable)se);
        }
        catch (ParserConfigurationException pce) {
            msg = "ParserConfigurationException while creating parser. Details: " + pce.getMessage();
            throw new BuildException(msg, (Throwable)pce);
        }
    }

    public static class NamingScheme
    extends EnumeratedAttribute {
        public static final String EJB_NAME = "ejb-name";
        public static final String DIRECTORY = "directory";
        public static final String DESCRIPTOR = "descriptor";
        public static final String BASEJARNAME = "basejarname";

        public String[] getValues() {
            return new String[]{EJB_NAME, DIRECTORY, DESCRIPTOR, BASEJARNAME};
        }
    }

    static class Config {
        public File srcDir;
        public File descriptorDir;
        public String baseNameTerminator = "-";
        public String baseJarName;
        public boolean flatDestDir = false;
        public Path classpath;
        public List supportFileSets = new ArrayList();
        public ArrayList dtdLocations = new ArrayList();
        public NamingScheme namingScheme;
        public File manifest;
        public String analyzer;

        Config() {
        }
    }

    public static class DTDLocation
    extends org.apache.tools.ant.types.DTDLocation {
    }
}

