/*
 * Decompiled with CFR 0.152.
 */
package imp;

import blbutil.Utilities;
import imp.ImpData;
import imp.ImpIbs;
import imp.ImpLSBaum;
import imp.StateProbs;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ImpLS {
    private ImpLS() {
    }

    public static AtomicReferenceArray<StateProbs> stateProbs(ImpData impData) {
        int n = impData.par().nthreads();
        int n2 = impData.targGT().nHaps();
        AtomicReferenceArray<StateProbs> atomicReferenceArray = new AtomicReferenceArray<StateProbs>(n2);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        ImpIbs impIbs = new ImpIbs(impData);
        try {
            for (int i = 0; i < n; ++i) {
                ImpLSBaum impLSBaum = new ImpLSBaum(impData, impIbs);
                executorService.submit(() -> {
                    try {
                        int n2 = atomicInteger.getAndIncrement();
                        while (n2 >= 0 && n2 < n2) {
                            StateProbs stateProbs = impLSBaum.impute(n2);
                            atomicReferenceArray.set(n2, stateProbs);
                            n2 = atomicInteger.getAndIncrement();
                        }
                    }
                    catch (Throwable throwable) {
                        Utilities.exit(throwable);
                    }
                });
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit(throwable);
        }
        return atomicReferenceArray;
    }
}

