/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.PlaybackInfo;
import org.igoweb.igoweb.shared.Subscription;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.AList;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.SortedListModel;
import org.igoweb.util.swing.TBlock;

public class PlaybackChooser
extends DFrame {
    private static final long FIRST_LECTURE = 1101067253126L;
    private final Client client;
    private JComboBox<String> yearIn = new JComboBox();
    private JComboBox<String> monthIn = new JComboBox();
    private SortedListModel<PlaybackInfo> lectureList = new SortedListModel<PlaybackInfo>(new Comparator<PlaybackInfo>(){

        @Override
        public int compare(PlaybackInfo a, PlaybackInfo b) {
            return a.id > b.id ? 1 : (a.id == b.id ? 0 : -1);
        }
    });
    private AList<PlaybackInfo> lecturesOut = new AList<PlaybackInfo>(new LectureRenderer(), 4, this.lectureList);
    private HashMap<String, Integer> yearStringToYear = new HashMap();
    private HashMap<String, Integer> monthStringToMonth = new HashMap();
    private long startDate;
    private long endDate;
    private EventListener clientListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            if (event.type == 112 || event.type == 113) {
                PlaybackChooser.this.updateList();
            }
        }
    };

    public PlaybackChooser(Client client, AFrame parent) {
        super(Defs.getString(-903340459), parent);
        int minYear;
        this.client = client;
        Calendar cal = Calendar.getInstance();
        int lastYear = cal.get(1);
        cal.setTime(new Date(1101067253126L));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        for (int year = minYear = cal.get(1); year <= lastYear; ++year) {
            cal.set(1, year);
            String yearStr = sdf.format(cal.getTime());
            this.yearIn.addItem(yearStr);
            this.yearStringToYear.put(yearStr, new Integer(year));
        }
        sdf.applyPattern("MMMMM");
        for (int month = cal.getMinimum(2); month <= cal.getMaximum(2); ++month) {
            cal.set(2, month);
            String monthStr = sdf.format(cal.getTime());
            this.monthIn.addItem(monthStr);
            this.monthStringToMonth.put(monthStr, new Integer(month));
        }
        TreeMap<Long, PlaybackInfo> pbl = client.getPlaybackList();
        if (!pbl.isEmpty()) {
            cal.setTime(new Date(pbl.lastKey()));
            this.yearIn.setSelectedIndex(cal.get(1) - minYear);
            this.monthIn.setSelectedIndex(cal.get(2) - cal.getMinimum(2));
        }
        this.getMainPanel().add("xSpan=2,yGrow=f", new TBlock(Defs.getString(-903340685), 15));
        this.getMainPanel().add("x=0,xSpan=1,xGrow=t", this.yearIn);
        this.getMainPanel().add(this.monthIn);
        client.addListener(this.clientListener);
        this.getMainPanel().add("x=0,xSpan=2,yGrow=t", this.lecturesOut);
        ActionListener dateChangeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PlaybackChooser.this.dateChanged();
            }
        };
        this.yearIn.addActionListener(dateChangeListener);
        this.monthIn.addActionListener(dateChangeListener);
        this.dateChanged();
        this.lecturesOut.addListener(new EventListener(){

            @Override
            public void handleEvent(Event event) {
                PlaybackChooser.this.handleLectureSelection((PlaybackInfo)event.arg);
            }
        });
        this.addButton(Defs.getString(1436228514), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PlaybackChooser.this.dispose();
            }
        });
        this.pack(parent);
        this.setVisible(true);
    }

    private void updateList() {
        ArrayList<PlaybackInfo> currentList = new ArrayList<PlaybackInfo>();
        for (Object e : this.lectureList) {
            currentList.add((PlaybackInfo)e);
        }
        boolean changed = false;
        for (PlaybackInfo playback : this.client.getPlaybackList().subMap(new Long(this.startDate), new Long(this.endDate)).values()) {
            if (currentList.remove(playback)) continue;
            changed = true;
            this.lectureList.add(playback);
        }
        if (changed || !currentList.isEmpty()) {
            this.lectureList.removeAll(currentList);
            this.lectureList.sortNow();
        }
    }

    public void dateChanged() {
        int year = this.yearStringToYear.get(this.yearIn.getSelectedItem());
        int month = this.monthStringToMonth.get(this.monthIn.getSelectedItem());
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, cal.getMinimum(5));
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        this.startDate = cal.getTime().getTime();
        cal.add(2, 1);
        this.endDate = cal.getTime().getTime();
        this.client.sendPlaybackListReq(this.startDate, this.endDate);
        this.updateList();
    }

    @Override
    public void dispose() {
        this.client.removeListener(this.clientListener);
        super.dispose();
    }

    @Override
    protected String getSavePositionPref() {
        return "i\"9}02NQ";
    }

    private void handleLectureSelection(PlaybackInfo playback) {
        if (this.isPlaybackEnabled(playback)) {
            this.client.sendStartPlayback(playback.id);
        } else {
            new MsgOut(Defs.getString(-903340547), Defs.getString(-903340630, Config.get("webHost")), 2, (Component)this);
        }
    }

    public boolean isPlaybackEnabled(PlaybackInfo playback) {
        return PlaybackChooser.isPlaybackEnabled(playback, this.client);
    }

    public static boolean isPlaybackEnabled(PlaybackInfo playback, Client client) {
        return playback != null && (!playback.subscribersOnly || client.getMe().getAuthLevel() >= 4 || client.getMe().isSubscribed() && Subscription.isSubscribed(playback.id, client.getSubscriptions()));
    }

    private class LectureRenderer
    extends DefaultListCellRenderer {
        private DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        private final int stdH = UIManager.getInt("org.igoweb.fontH");

        private LectureRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            PlaybackInfo playback = (PlaybackInfo)value;
            this.setText(playback == null ? "" : playback.gameSummary.getLocalDesc() + " \u2014 " + this.df.format(new Date(playback.id)));
            this.setBackground(UIManager.getColor(isSelected ? "ComboBox.selectionBackground" : "org.igoweb.inputBg"));
            this.setEnabled(list.isEnabled() && PlaybackChooser.this.isPlaybackEnabled(playback));
            return this;
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.stdH, this.stdH);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }
}

