/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.util.JMFI18N;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.bean.playerbean.MediaPlayer;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.FormatChangeEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.util.BufferToImage;
import jmapps.jmstudio.AboutDialog;
import jmapps.jmstudio.CaptureControlsDialog;
import jmapps.jmstudio.CaptureDialog;
import jmapps.jmstudio.OpenRtpDialog;
import jmapps.jmstudio.OpenUrlDialog;
import jmapps.jmstudio.SaveAsDialog;
import jmapps.jmstudio.TransmitWizard;
import jmapps.rtp.SessionControlDialog;
import jmapps.rtp.TransmissionStatsDialog;
import jmapps.ui.ImageArea;
import jmapps.ui.JMDialog;
import jmapps.ui.JMFrame;
import jmapps.ui.MessageDialog;
import jmapps.ui.PlayerFrame;
import jmapps.ui.SnapFrame;
import jmapps.ui.VideoPanel;
import jmapps.ui.WizardDialog;
import jmapps.util.CDSWrapper;
import jmapps.util.JMAppsCfg;
import jmapps.util.JMFUtils;

public class JMStudio
extends PlayerFrame
implements ItemListener,
ReceiveStreamListener {
    private Menu menuRecentUrl;
    private Menu menuAE;
    private Menu menuVE;
    private MenuItem menuFileClose;
    private MenuItem menuFileExport;
    private MenuItem menuCapture;
    private CheckboxMenuItem menuAutoPlay;
    private CheckboxMenuItem menuAutoLoop;
    private CheckboxMenuItem menuKeepAspect;
    private MenuItem menuFullScreen;
    private MenuItem menuSnapShot;
    private MenuItem menuPlugins;
    private MenuItem menuCaptureControl;
    private MenuItem menuRtpSessionControl;
    private MenuItem menuTransmissionStats;
    private Dimension dimFrameSizeBeforeFullScreen = null;
    private Window windowFullScreen = null;
    private MouseListener listenerMouseFullScreen;
    private Control controlPlugins = null;
    private Component componentPlugins = null;
    private FrameGrabbingControl controlGrabber = null;
    private FileDialog dlgOpenFile = null;
    private JMFRegistry jmfRegistry = null;
    private Vector vectorRtpFrames = null;
    private SnapFrame frameSnap = null;
    private TransmissionStatsDialog dlgTransmissionStats = null;
    private SessionControlDialog dlgSessionControl = null;
    private String strOptionalTitle = "";
    private DataSource dataSourceCurrent = null;
    private String nameCaptureDeviceAudio = null;
    private String nameCaptureDeviceVideo = null;
    private String audioEffect = null;
    private String videoEffect = null;
    private CaptureControlsDialog dlgCaptureControls = null;
    private RTPSessionMgr mngrSessionRtp = null;
    private Vector vectorMngrSessions = null;
    private Vector vectorStreams = null;
    private Vector vectorStreamLabels = null;
    boolean killed = false;
    boolean recvRTP = false;
    public static final String APPNAME = JMFI18N.getResource("jmstudio.appname");
    private static final String MENU_FILE = JMFI18N.getResource("jmstudio.menu.file");
    private static final String MENU_FILE_NEWWINDOW = JMFI18N.getResource("jmstudio.menu.file.newwindow");
    private static final String MENU_FILE_OPENFILE = JMFI18N.getResource("jmstudio.menu.file.openfile");
    private static final String MENU_FILE_OPENURL = JMFI18N.getResource("jmstudio.menu.file.openurl");
    private static final String MENU_FILE_OPENRTP = JMFI18N.getResource("jmstudio.menu.file.openrtp");
    private static final String MENU_FILE_CAPTURE = JMFI18N.getResource("jmstudio.menu.file.capture");
    private static final String MENU_FILE_RECENTURL = JMFI18N.getResource("jmstudio.menu.file.recent");
    private static final String MENU_FILE_CLOSE = JMFI18N.getResource("jmstudio.menu.file.close");
    private static final String MENU_FILE_EXPORT = JMFI18N.getResource("jmstudio.menu.file.export");
    private static final String MENU_FILE_TRANSMIT = JMFI18N.getResource("jmstudio.menu.file.transmit");
    private static final String MENU_FILE_PREFERENCES = JMFI18N.getResource("jmstudio.menu.file.preferences");
    private static final String MENU_FILE_EXIT = JMFI18N.getResource("jmstudio.menu.file.exit");
    private static final String MENU_PLAYER = JMFI18N.getResource("jmstudio.menu.player");
    private static final String MENU_PLAYER_AUTOPLAY = JMFI18N.getResource("jmstudio.menu.player.autoplay");
    private static final String MENU_PLAYER_AUTOLOOP = JMFI18N.getResource("jmstudio.menu.player.autoloop");
    private static final String MENU_PLAYER_KEEPASPECT = JMFI18N.getResource("jmstudio.menu.player.keepaspect");
    private static final String MENU_PLAYER_FULLSCREEN = JMFI18N.getResource("jmstudio.menu.player.fullscreen");
    private static final String MENU_PLAYER_SNAPSHOT = JMFI18N.getResource("jmstudio.menu.player.snapshot");
    private static final String MENU_PLAYER_PLUGINS = JMFI18N.getResource("jmstudio.menu.player.plugins");
    private static final String MENU_PLAYER_CAPTURE = JMFI18N.getResource("jmstudio.menu.player.capturecontrols");
    private static final String MENU_PLAYER_RTPSESSION = JMFI18N.getResource("jmstudio.menu.player.rtpsession");
    private static final String MENU_PLAYER_TRANSMISSION = JMFI18N.getResource("jmstudio.menu.player.transmission");
    private static final String MENU_HELP = JMFI18N.getResource("jmstudio.menu.help");
    private static final String MENU_HELP_ABOUT = JMFI18N.getResource("jmstudio.menu.help.about");
    private static Vector vectorFrames = new Vector();
    private static JMAppsCfg cfgJMApps = null;
    private static double dDefaultScale = 1.0;
    private String hostAddress;
    private String port;
    RTPTimer rtptimer = null;

    public JMStudio() {
        super(null, APPNAME);
        this.updateMenu();
        this.killed = false;
        this.recvRTP = false;
    }

    public void addNotify() {
        super.addNotify();
    }

    public void pack() {
        super.pack();
    }

    protected void initFrame() {
        this.createMenu();
        super.initFrame();
    }

    private void createMenu() {
        MenuBar menu = new MenuBar();
        this.setMenuBar(menu);
        Menu menuFile = new Menu(MENU_FILE);
        menu.add(menuFile);
        MenuShortcut shortcut = new MenuShortcut(78);
        MenuItem itemMenu = new MenuItem(MENU_FILE_NEWWINDOW, shortcut);
        itemMenu.addActionListener(this);
        menuFile.add(itemMenu);
        shortcut = new MenuShortcut(79);
        itemMenu = new MenuItem(MENU_FILE_OPENFILE, shortcut);
        itemMenu.addActionListener(this);
        menuFile.add(itemMenu);
        shortcut = new MenuShortcut(85);
        itemMenu = new MenuItem(MENU_FILE_OPENURL, shortcut);
        itemMenu.addActionListener(this);
        menuFile.add(itemMenu);
        shortcut = new MenuShortcut(82);
        itemMenu = new MenuItem(MENU_FILE_OPENRTP, shortcut);
        itemMenu.addActionListener(this);
        menuFile.add(itemMenu);
        shortcut = new MenuShortcut(80);
        this.menuCapture = new MenuItem(MENU_FILE_CAPTURE, shortcut);
        this.menuCapture.addActionListener(this);
        menuFile.add(this.menuCapture);
        Vector vector = CaptureDeviceManager.getDeviceList(null);
        if (vector == null || vector.size() < 1) {
            this.menuCapture.setEnabled(false);
        } else {
            this.menuCapture.setEnabled(true);
        }
        this.menuRecentUrl = new Menu(MENU_FILE_RECENTURL);
        this.updateRecentUrlMenu();
        menuFile.add(this.menuRecentUrl);
        shortcut = new MenuShortcut(87);
        this.menuFileClose = new MenuItem(MENU_FILE_CLOSE, shortcut);
        this.menuFileClose.addActionListener(this);
        menuFile.add(this.menuFileClose);
        menuFile.addSeparator();
        shortcut = new MenuShortcut(69);
        this.menuFileExport = new MenuItem(MENU_FILE_EXPORT, shortcut);
        this.menuFileExport.addActionListener(this);
        menuFile.add(this.menuFileExport);
        shortcut = new MenuShortcut(84);
        itemMenu = new MenuItem(MENU_FILE_TRANSMIT, shortcut);
        itemMenu.addActionListener(this);
        menuFile.add(itemMenu);
        menuFile.addSeparator();
        itemMenu = new MenuItem(MENU_FILE_PREFERENCES);
        itemMenu.addActionListener(this);
        menuFile.add(itemMenu);
        shortcut = new MenuShortcut(88);
        itemMenu = new MenuItem(MENU_FILE_EXIT, shortcut);
        itemMenu.addActionListener(this);
        menuFile.add(itemMenu);
        Menu menuPlayer = new Menu(MENU_PLAYER);
        menu.add(menuPlayer);
        this.addNotify();
        boolean boolValue = cfgJMApps != null ? cfgJMApps.getAutoPlay() : false;
        this.menuAutoPlay = new CheckboxMenuItem(MENU_PLAYER_AUTOPLAY, boolValue);
        this.menuAutoPlay.addItemListener(this);
        menuPlayer.add(this.menuAutoPlay);
        boolValue = cfgJMApps != null ? cfgJMApps.getAutoLoop() : true;
        this.menuAutoLoop = new CheckboxMenuItem(MENU_PLAYER_AUTOLOOP, boolValue);
        this.menuAutoLoop.addItemListener(this);
        menuPlayer.add(this.menuAutoLoop);
        boolValue = cfgJMApps != null ? cfgJMApps.getKeepAspectRatio() : false;
        this.menuKeepAspect = new CheckboxMenuItem(MENU_PLAYER_KEEPASPECT, boolValue);
        this.menuKeepAspect.addItemListener(this);
        menuPlayer.add(this.menuKeepAspect);
        menuPlayer.addSeparator();
        shortcut = new MenuShortcut(70);
        this.menuFullScreen = new MenuItem(MENU_PLAYER_FULLSCREEN, shortcut);
        this.menuFullScreen.addActionListener(this);
        menuPlayer.add(this.menuFullScreen);
        shortcut = new MenuShortcut(83);
        this.menuSnapShot = new MenuItem(MENU_PLAYER_SNAPSHOT, shortcut);
        this.menuSnapShot.addActionListener(this);
        menuPlayer.add(this.menuSnapShot);
        menuPlayer.addSeparator();
        this.menuPlugins = new MenuItem(MENU_PLAYER_PLUGINS);
        this.menuPlugins.addActionListener(this);
        menuPlayer.add(this.menuPlugins);
        this.menuCaptureControl = new MenuItem(MENU_PLAYER_CAPTURE);
        this.menuCaptureControl.addActionListener(this);
        menuPlayer.add(this.menuCaptureControl);
        this.menuRtpSessionControl = new MenuItem(MENU_PLAYER_RTPSESSION);
        this.menuRtpSessionControl.addActionListener(this);
        menuPlayer.add(this.menuRtpSessionControl);
        this.menuTransmissionStats = new MenuItem(MENU_PLAYER_TRANSMISSION);
        this.menuTransmissionStats.addActionListener(this);
        menuPlayer.add(this.menuTransmissionStats);
        menuPlayer.addSeparator();
        Vector videoEffects = this.getEffectList(new VideoFormat(null));
        Vector audioEffects = this.getEffectList(new AudioFormat(null));
        if (videoEffects.size() > 0) {
            this.menuVE = new Menu("Insert Video Effect");
            this.fillEffectList(this.menuVE, videoEffects);
            menuPlayer.add(this.menuVE);
        }
        if (audioEffects.size() > 0) {
            this.menuAE = new Menu("Insert Audio Effect");
            this.fillEffectList(this.menuAE, audioEffects);
            menuPlayer.add(this.menuAE);
        }
        Menu menuHelp = new Menu(MENU_HELP);
        menu.add(menuHelp);
        shortcut = new MenuShortcut(72);
        itemMenu = new MenuItem(MENU_HELP_ABOUT, shortcut);
        itemMenu.addActionListener(this);
        menuHelp.add(itemMenu);
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        Object objSource = event.getSource();
        if (strCmd == null && objSource instanceof MenuItem) {
            strCmd = ((MenuItem)objSource).getActionCommand();
        }
        if (strCmd == null) {
            return;
        }
        if (strCmd.equals(MENU_FILE_NEWWINDOW)) {
            JMStudio.createNewFrame();
        } else if (strCmd.equals(MENU_FILE_OPENFILE)) {
            this.openFile();
        } else if (strCmd.equals(MENU_FILE_OPENURL)) {
            this.openUrl();
        } else if (strCmd.equals(MENU_FILE_OPENRTP)) {
            this.openRtp();
        } else if (strCmd.equals(MENU_FILE_CAPTURE)) {
            this.captureMedia();
        } else if (strCmd.equals(MENU_FILE_RECENTURL)) {
            if (objSource instanceof MenuItem) {
                String nameUrl = ((MenuItem)objSource).getLabel();
                this.open(nameUrl);
            }
        } else if (strCmd.equals(MENU_FILE_CLOSE)) {
            this.killCurrentPlayer();
        } else if (strCmd.equals(MENU_FILE_EXPORT)) {
            this.exportMedia();
        } else if (strCmd.equals(MENU_FILE_TRANSMIT)) {
            this.transmitMedia();
        } else if (strCmd.equals(MENU_FILE_PREFERENCES)) {
            if (this.jmfRegistry == null) {
                this.jmfRegistry = new JMFRegistry();
            }
            this.jmfRegistry.setVisible(true);
            this.jmfRegistry.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    Vector vector = CaptureDeviceManager.getDeviceList(null);
                    if (vector == null || vector.size() < 1) {
                        JMStudio.this.menuCapture.setEnabled(false);
                    } else {
                        JMStudio.this.menuCapture.setEnabled(true);
                    }
                }
            });
        } else if (strCmd.equals(MENU_FILE_EXIT)) {
            JMStudio.closeAll();
        } else if (!(strCmd.equals(MENU_PLAYER_AUTOPLAY) || strCmd.equals(MENU_PLAYER_AUTOLOOP) || strCmd.equals(MENU_PLAYER_KEEPASPECT))) {
            if (strCmd.equals(MENU_PLAYER_FULLSCREEN)) {
                this.setFullScreen(true);
            } else if (strCmd.equals(MENU_PLAYER_SNAPSHOT)) {
                this.doSnapShot();
            } else if (strCmd.equals(MENU_PLAYER_PLUGINS)) {
                if (this.componentPlugins != null) {
                    this.componentPlugins.setVisible(true);
                } else if (this.controlPlugins != null && this.controlPlugins instanceof Component) {
                    this.componentPlugins = (Component)((Object)this.controlPlugins);
                    this.componentPlugins.setVisible(true);
                    Component component = this.componentPlugins;
                    while (component != null) {
                        if (component instanceof Frame) {
                            Frame frame = (Frame)component;
                            JMFrame.autoPosition(frame, this);
                            break;
                        }
                        component = component.getParent();
                    }
                }
            } else if (strCmd.equals(MENU_PLAYER_CAPTURE)) {
                if (this.dlgCaptureControls != null) {
                    this.dlgCaptureControls.setVisible(true);
                    this.dlgCaptureControls.toFront();
                }
            } else if (strCmd.equals(MENU_PLAYER_RTPSESSION)) {
                if (this.dlgSessionControl != null) {
                    this.dlgSessionControl.setVisible(true);
                    this.dlgSessionControl.toFront();
                }
            } else if (strCmd.equals(MENU_PLAYER_TRANSMISSION)) {
                if (this.dlgTransmissionStats != null) {
                    this.dlgTransmissionStats.setVisible(true);
                    this.dlgTransmissionStats.toFront();
                }
            } else if (strCmd.equals(MENU_HELP_ABOUT)) {
                AboutDialog.createDialog(this);
            } else {
                super.actionPerformed(event);
            }
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object objSource = event.getSource();
        if (objSource == this.menuAutoPlay) {
            if (cfgJMApps != null) {
                cfgJMApps.setAutoPlay(this.menuAutoPlay.getState());
            }
        } else if (objSource == this.menuAutoLoop) {
            if (this.mediaPlayerCurrent != null) {
                this.mediaPlayerCurrent.setPlaybackLoop(this.menuAutoLoop.getState());
            }
            if (cfgJMApps != null) {
                cfgJMApps.setAutoLoop(this.menuAutoLoop.getState());
            }
        } else if (objSource == this.menuKeepAspect) {
            if (this.mediaPlayerCurrent != null) {
                this.mediaPlayerCurrent.setFixedAspectRatio(this.menuKeepAspect.getState());
                if (this.panelVideo != null) {
                    this.panelVideo.resizeVisualComponent();
                }
            }
            if (cfgJMApps != null) {
                cfgJMApps.setKeepAspectRatio(this.menuKeepAspect.getState());
            }
        }
    }

    public void windowClosing(WindowEvent event) {
        this.killCurrentPlayer();
        this.dispose();
    }

    public void windowClosed(WindowEvent event) {
        super.windowClosed(event);
        if (this.frameSnap != null) {
            this.frameSnap.dispose();
        }
        if (vectorFrames.contains(this)) {
            Point pointLocation = this.getLocation();
            int nIndex = vectorFrames.indexOf(this);
            if (cfgJMApps != null) {
                cfgJMApps.setJMStudioFrameLocation(pointLocation, nIndex);
            }
            vectorFrames.removeElement(this);
        }
        if (vectorFrames.size() < 1) {
            JMStudio.exitApllication();
        }
    }

    public synchronized void update(ReceiveStreamEvent event) {
        if (event instanceof NewReceiveStreamEvent) {
            this.recvRTP = true;
            RTPSessionMgr mngrSession = (RTPSessionMgr)event.getSource();
            ReceiveStream stream = ((NewReceiveStreamEvent)event).getReceiveStream();
            DataSource dataSource = stream.getDataSource();
            this.strOptionalTitle = this.hostAddress + ":" + this.port;
            this.mngrSessionRtp = null;
            if (this.vectorRtpFrames != null && this.vectorMngrSessions != null && this.vectorMngrSessions.size() > 0 && this.vectorMngrSessions.firstElement() == mngrSession) {
                PlayerFrame frame = new PlayerFrame(this, this.strOptionalTitle);
                this.vectorRtpFrames.addElement(frame);
                frame.open(dataSource);
                frame.setVisible(true);
            } else {
                this.open(dataSource, false);
                this.vectorMngrSessions = new Vector();
                this.vectorMngrSessions.addElement(mngrSession);
                this.vectorStreams = new Vector();
                this.vectorStreams.addElement(stream);
                this.dlgSessionControl = new SessionControlDialog((Frame)this, mngrSession);
                this.updateMenu();
                this.vectorRtpFrames = new Vector();
            }
        }
    }

    protected void processRealizeComplete(RealizeCompleteEvent event) {
        this.killCurrentView();
        this.setCursor(this.cursorNormal);
        this.panelVideo = new VideoPanel(this.mediaPlayerCurrent);
        this.panelVideo.setZoom(dDefaultScale);
        this.panelVideo.addMenuZoomActionListener(this);
        this.compControl = this.mediaPlayerCurrent.getControlPanelComponent();
        Dimension dimVideo = this.panelVideo.getPreferredSize();
        if (this.compControl != null) {
            Dimension dimControlPanel = this.compControl.getPreferredSize();
            this.compControl.setBounds(0, dimVideo.height, dimVideo.width, dimControlPanel.height);
        }
        this.panelContent.add((Component)this.panelVideo, "Center");
        if (this.compControl != null) {
            this.panelContent.add(this.compControl, "South");
            this.compControl.repaint();
        }
        this.controlPlugins = this.mediaPlayerCurrent.getControl("com.sun.media.JMD");
        this.controlGrabber = (FrameGrabbingControl)this.mediaPlayerCurrent.getControl("javax.media.control.FrameGrabbingControl");
        Component compVis = this.panelVideo.getVisualComponent();
        if (compVis != null) {
            while (!compVis.isVisible()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        this.mediaPlayerCurrent.prefetch();
        String strMediaLocation = this.mediaPlayerCurrent.getMediaLocation();
        if (strMediaLocation == null || strMediaLocation.trim().length() < 1) {
            strMediaLocation = this.strOptionalTitle;
        }
        this.setTitle(strMediaLocation + " - " + APPNAME);
        this.updateMenu();
    }

    protected void processPrefetchComplete(PrefetchCompleteEvent event) {
        if (this.menuAutoPlay.getState() && this.mediaPlayerCurrent != null && this.mediaPlayerCurrent.getTargetState() != 600) {
            this.mediaPlayerCurrent.start();
        }
    }

    protected void processFormatChange(FormatChangeEvent event) {
        this.killCurrentView();
        this.panelVideo = new VideoPanel(this.mediaPlayerCurrent);
        this.panelVideo.setZoom(dDefaultScale);
        this.panelVideo.addMenuZoomActionListener(this);
        this.panelContent.add((Component)this.panelVideo, "Center");
        this.compControl = this.mediaPlayerCurrent.getControlPanelComponent();
        if (this.compControl != null) {
            this.panelContent.add(this.compControl, "South");
        }
    }

    private void openFile() {
        String nameFile = null;
        if (this.dlgOpenFile == null) {
            this.dlgOpenFile = new FileDialog((Frame)this, MENU_FILE_OPENFILE, 0);
        }
        if (cfgJMApps != null) {
            nameFile = cfgJMApps.getLastOpenFile();
        }
        if (nameFile != null) {
            this.dlgOpenFile.setFile(nameFile);
        }
        this.dlgOpenFile.show();
        nameFile = this.dlgOpenFile.getFile();
        if (nameFile == null) {
            return;
        }
        nameFile = this.dlgOpenFile.getDirectory() + nameFile;
        if (cfgJMApps != null) {
            cfgJMApps.setLastOpenFile(nameFile);
        }
        String nameUrl = "file:" + nameFile;
        this.open(nameUrl);
    }

    private void openUrl() {
        String nameUrl = null;
        if (cfgJMApps != null) {
            nameUrl = cfgJMApps.getLastOpenUrl();
        }
        OpenUrlDialog dlgOpenUrl = new OpenUrlDialog((Frame)this, nameUrl);
        dlgOpenUrl.show();
        String strAction = dlgOpenUrl.getAction();
        if (!strAction.equals(JMDialog.ACTION_OPEN)) {
            return;
        }
        nameUrl = dlgOpenUrl.getUrl();
        if (nameUrl == null) {
            return;
        }
        if (cfgJMApps != null) {
            cfgJMApps.setLastOpenUrl(nameUrl);
        }
        this.open(nameUrl);
    }

    private void openRtp() {
        OpenRtpDialog dlgOpenRtp = new OpenRtpDialog((Frame)this, cfgJMApps);
        dlgOpenRtp.show();
        String strAction = dlgOpenRtp.getAction();
        if (!strAction.equals(JMDialog.ACTION_OPEN)) {
            return;
        }
        String strAddress = dlgOpenRtp.getAddress();
        String strPort = dlgOpenRtp.getPort();
        String strTtl = dlgOpenRtp.getTtl();
        this.hostAddress = strAddress;
        this.port = strPort;
        this.killCurrentPlayer();
        this.rtptimer = new RTPTimer(this);
        this.killed = false;
        this.recvRTP = false;
        this.rtptimer.start();
        this.mngrSessionRtp = JMFUtils.createSessionManager(strAddress, strPort, strTtl, (ReceiveStreamListener)this);
        if (this.mngrSessionRtp == null) {
            MessageDialog.createErrorDialog((Frame)this, JMFI18N.getResource("jmstudio.error.sessionmngr.create"));
            this.killed = true;
            if (this.rtptimer != null && this.rtptimer.isAlive()) {
                this.rtptimer.interrupt();
                this.rtptimer = null;
            }
            return;
        }
        this.updateMenu();
    }

    public void open(String nameUrl) {
        MediaPlayer mediaPlayer = JMFUtils.createMediaPlayer(nameUrl, this, this.audioEffect, this.videoEffect);
        this.dataSourceCurrent = null;
        boolean boolResult = this.open(mediaPlayer, true);
        if (boolResult) {
            this.addToRecentUrlList(nameUrl);
        }
    }

    public void open(DataSource dataSource) {
        this.open(dataSource, true);
    }

    public void open(DataSource dataSource, boolean killPrevious) {
        MediaPlayer mediaPlayer = JMFUtils.createMediaPlayer(dataSource, (Frame)this);
        boolean boolResult = this.open(mediaPlayer, killPrevious);
        if (boolResult) {
            this.dataSourceCurrent = dataSource;
        }
    }

    public boolean open(MediaPlayer mediaPlayer) {
        return this.open(mediaPlayer, true);
    }

    public boolean open(MediaPlayer mediaPlayer, boolean killPrevious) {
        if (mediaPlayer == null) {
            return false;
        }
        if (killPrevious) {
            this.killCurrentPlayer();
        }
        this.setCursor(this.cursorWait);
        this.mediaPlayerCurrent = mediaPlayer;
        this.killed = false;
        mediaPlayer.setPlaybackLoop(this.menuAutoLoop.getState());
        mediaPlayer.setFixedAspectRatio(this.menuKeepAspect.getState());
        mediaPlayer.setPopupActive(false);
        mediaPlayer.setControlPanelVisible(false);
        mediaPlayer.addControllerListener(this);
        mediaPlayer.realize();
        this.updateMenu();
        return true;
    }

    private void exportMediaOld() {
        AudioFormat formatAudioDevice = null;
        VideoFormat formatVideoDevice = null;
        String nameUrl = this.mediaPlayerCurrent.getMediaLocation();
        if (this.dataSourceCurrent != null && this.dataSourceCurrent instanceof CaptureDevice) {
            FormatControl[] fcs = ((CaptureDevice)((Object)this.dataSourceCurrent)).getFormatControls();
            int i2 = 0;
            while (i2 < fcs.length) {
                Format format = fcs[i2].getFormat();
                if (format instanceof AudioFormat) {
                    formatAudioDevice = (AudioFormat)format;
                } else if (format instanceof VideoFormat) {
                    formatVideoDevice = (VideoFormat)format;
                }
                ++i2;
            }
        }
        if (nameUrl != null && nameUrl.length() > 1 && this.closeCapture()) {
            if (this.nameCaptureDeviceAudio != null || this.nameCaptureDeviceVideo != null) {
                DataSource dataSource = JMFUtils.createCaptureDataSource(this.nameCaptureDeviceAudio, formatAudioDevice, this.nameCaptureDeviceVideo, formatVideoDevice);
                if (dataSource == null) {
                    System.err.println("DataSource is null");
                }
                SaveAsDialog dlgSaveAs = new SaveAsDialog((Frame)this, dataSource, cfgJMApps);
            } else {
                SaveAsDialog dlgSaveAs = new SaveAsDialog((Frame)this, nameUrl, null, cfgJMApps);
            }
        }
    }

    private void exportMedia() {
        Object formatAudioDevice = null;
        Object formatVideoDevice = null;
        String nameUrl = this.mediaPlayerCurrent.getMediaLocation();
        if (this.dataSourceCurrent != null && this.dataSourceCurrent instanceof CDSWrapper) {
            DataSource dataSource = this.dataSourceCurrent;
            this.dataSourceCurrent = null;
            this.killCurrentPlayer();
            SaveAsDialog dlgSaveAs = new SaveAsDialog((Frame)this, dataSource, cfgJMApps);
        } else if (nameUrl != null && nameUrl.trim().length() > 0) {
            SaveAsDialog dlgSaveAs = new SaveAsDialog((Frame)this, nameUrl, null, cfgJMApps);
        } else if (this.vectorMngrSessions.size() > 0 && this.vectorStreams.size() > 0) {
            RTPSessionMgr mngrSession = (RTPSessionMgr)this.vectorMngrSessions.firstElement();
            InetAddress addrInet = null;
            try {
                addrInet = InetAddress.getByName(this.hostAddress);
            }
            catch (UnknownHostException e2) {
                e2.printStackTrace();
            }
            nameUrl = "rtp://" + this.hostAddress + ":" + this.port;
            Control[] arrControls = this.mediaPlayerCurrent.getControls();
            int nCount = arrControls.length;
            int i2 = 0;
            while (i2 < nCount) {
                if (arrControls[i2] instanceof TrackControl) {
                    Format format = ((TrackControl)arrControls[i2]).getFormat();
                    if (format instanceof AudioFormat) {
                        nameUrl = nameUrl + "/audio";
                        break;
                    }
                    if (format instanceof VideoFormat) {
                        nameUrl = nameUrl + "/video";
                        break;
                    }
                }
                ++i2;
            }
            if (!addrInet.isMulticastAddress()) {
                String strResult = MessageDialog.createOKCancelDialog(this, JMFI18N.getResource("jmstudio.query.savertp.unicast"));
                if (!strResult.equals(JMDialog.ACTION_OK)) {
                    return;
                }
                this.killCurrentPlayer();
            }
            SaveAsDialog dlgSaveAs = new SaveAsDialog((Frame)this, nameUrl, null, cfgJMApps);
        }
    }

    private void captureMedia() {
        DataSource dataSource;
        this.nameCaptureDeviceAudio = null;
        this.nameCaptureDeviceVideo = null;
        CaptureDialog dialogCapture = new CaptureDialog((Frame)this, cfgJMApps);
        dialogCapture.show();
        if (dialogCapture.getAction() == JMDialog.ACTION_CANCEL) {
            return;
        }
        CaptureDeviceInfo cdi = dialogCapture.getAudioDevice();
        if (cdi != null && dialogCapture.isAudioDeviceUsed()) {
            this.nameCaptureDeviceAudio = cdi.getName();
        }
        if ((cdi = dialogCapture.getVideoDevice()) != null && dialogCapture.isVideoDeviceUsed()) {
            this.nameCaptureDeviceVideo = cdi.getName();
        }
        if ((dataSource = JMFUtils.createCaptureDataSource(this.nameCaptureDeviceAudio, dialogCapture.getAudioFormat(), this.nameCaptureDeviceVideo, dialogCapture.getVideoFormat())) != null) {
            if (dataSource instanceof CaptureDevice && dataSource instanceof PushBufferDataSource) {
                CDSWrapper cdswrapper = new CDSWrapper((PushBufferDataSource)dataSource);
                dataSource = cdswrapper;
                try {
                    ((DataSource)cdswrapper).connect();
                }
                catch (IOException ioe) {
                    dataSource = null;
                    this.nameCaptureDeviceAudio = null;
                    this.nameCaptureDeviceVideo = null;
                    MessageDialog.createErrorDialog((Frame)this, JMFI18N.getResource("jmstudio.error.captureds"));
                }
            }
            this.open(dataSource);
            if (dataSource != null) {
                this.dlgCaptureControls = new CaptureControlsDialog((Frame)this, dataSource);
                if (this.dlgCaptureControls.isEmpty()) {
                    this.dlgCaptureControls = null;
                }
            }
        } else {
            this.nameCaptureDeviceAudio = null;
            this.nameCaptureDeviceVideo = null;
            MessageDialog.createErrorDialog((Frame)this, JMFI18N.getResource("jmstudio.error.captureds"));
        }
    }

    private void transmitMedia() {
        String urlString = null;
        DataSource dataSource = null;
        if (this.dataSourceCurrent != null && this.dataSourceCurrent instanceof CDSWrapper) {
            dataSource = this.dataSourceCurrent;
            this.dataSourceCurrent = null;
            this.killCurrentPlayer();
            urlString = "Capture";
        } else if (this.mediaPlayerCurrent != null) {
            urlString = this.mediaPlayerCurrent.getMediaLocation();
        }
        TransmitWizard dlgTransmit = new TransmitWizard((Frame)this, urlString, dataSource, cfgJMApps);
        dlgTransmit.show();
        String strAction = dlgTransmit.getAction();
        if (!strAction.equals(WizardDialog.ACTION_FINISH)) {
            return;
        }
        Processor processorTransmit = dlgTransmit.getProcessor();
        if (processorTransmit == null) {
            return;
        }
        this.strOptionalTitle = JMFI18N.getResource("jmstudio.playerwindow.transcoding");
        MediaPlayer mediaPlayer = JMFUtils.createMediaPlayer(processorTransmit, (Frame)this);
        boolean boolResult = this.open(mediaPlayer);
        if (boolResult) {
            this.vectorMngrSessions = dlgTransmit.getMngrSessions();
            this.vectorStreams = dlgTransmit.getStreams();
            this.vectorStreamLabels = dlgTransmit.getStreamLabels();
            this.dlgTransmissionStats = new TransmissionStatsDialog((Frame)this, this.vectorMngrSessions, this.vectorStreamLabels);
            this.updateMenu();
        }
    }

    private void setFullScreen(boolean boolFullScreen) {
        if (this.panelVideo == null) {
            return;
        }
        if (boolFullScreen && this.panelVideo.getParent() != this.windowFullScreen) {
            this.dimFrameSizeBeforeFullScreen = this.getSize();
            Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.windowFullScreen == null) {
                this.windowFullScreen = new Window(this);
                this.windowFullScreen.setLayout(null);
                ((Component)this.windowFullScreen).setBackground(Color.black);
            }
            ((Component)this.windowFullScreen).setBounds(0, 0, dimScreen.width, dimScreen.height);
            this.panelContent.remove(this.panelVideo);
            Dimension dimPrefSize = this.panelVideo.getPreferredSize();
            if (this.compControl != null) {
                this.panelContent.remove(this.compControl);
            }
            Rectangle rectVideo = new Rectangle(0, 0, dimScreen.width, dimScreen.height);
            if ((float)dimPrefSize.width / (float)dimPrefSize.height >= (float)dimScreen.width / (float)dimScreen.height) {
                rectVideo.height = dimPrefSize.height * dimScreen.width / dimPrefSize.width;
                rectVideo.y = (dimScreen.height - rectVideo.height) / 2;
            } else {
                rectVideo.width = dimPrefSize.width * dimScreen.height / dimPrefSize.height;
                rectVideo.x = (dimScreen.width - rectVideo.width) / 2;
            }
            Toolkit.getDefaultToolkit().sync();
            this.windowFullScreen.add(this.panelVideo);
            ((Component)this.windowFullScreen).setVisible(true);
            this.panelVideo.setBounds(rectVideo);
            this.windowFullScreen.validate();
            this.listenerMouseFullScreen = new MouseAdapter(){

                public void mouseClicked(MouseEvent event) {
                    JMStudio.this.setFullScreen(false);
                }
            };
            this.panelVideo.getVisualComponent().addMouseListener(this.listenerMouseFullScreen);
        } else if (!boolFullScreen && this.panelVideo.getParent() == this.windowFullScreen) {
            this.panelVideo.getVisualComponent().removeMouseListener(this.listenerMouseFullScreen);
            Toolkit.getDefaultToolkit().sync();
            ((Component)this.windowFullScreen).setVisible(false);
            this.windowFullScreen.remove(this.panelVideo);
            this.panelContent.add((Component)this.panelVideo, "Center");
            if (this.compControl != null) {
                this.panelContent.add(this.compControl, "South");
            }
            if (this.dimFrameSizeBeforeFullScreen != null) {
                ((Component)this).setSize(this.dimFrameSizeBeforeFullScreen);
                this.validate();
            }
            this.setVisible(true);
        }
    }

    private void doSnapShot() {
        Buffer bufferFrame = this.controlGrabber.grabFrame();
        BufferToImage bufferToImage = new BufferToImage((VideoFormat)bufferFrame.getFormat());
        Image image = bufferToImage.createImage(bufferFrame);
        if (image == null) {
            return;
        }
        if (this.frameSnap == null) {
            this.frameSnap = new SnapFrame(image, this);
        } else {
            this.frameSnap.setImage(image);
        }
        this.frameSnap.setTitle(this.getTitle() + " - " + JMFI18N.getResource("jmstudio.snapshot"));
    }

    protected void killCurrentView() {
        if (this.componentPlugins != null) {
            this.componentPlugins.setVisible(false);
            this.componentPlugins = null;
        }
        this.controlGrabber = null;
        super.killCurrentView();
    }

    protected void killCurrentPlayer() {
        int i2;
        int nCount;
        this.nameCaptureDeviceAudio = null;
        this.nameCaptureDeviceVideo = null;
        if (this.dlgCaptureControls != null) {
            this.dlgCaptureControls.dispose();
        }
        this.dlgCaptureControls = null;
        if (this.dlgTransmissionStats != null) {
            this.dlgTransmissionStats.dispose();
        }
        this.dlgTransmissionStats = null;
        if (this.dlgSessionControl != null) {
            this.dlgSessionControl.dispose();
        }
        this.dlgSessionControl = null;
        if (this.vectorRtpFrames != null) {
            nCount = this.vectorRtpFrames.size();
            i2 = 0;
            while (i2 < nCount) {
                PlayerFrame frame = (PlayerFrame)this.vectorRtpFrames.elementAt(i2);
                frame.dispose();
                ++i2;
            }
            this.vectorRtpFrames.removeAllElements();
            this.vectorRtpFrames = null;
        }
        if (this.vectorStreams != null) {
            nCount = this.vectorStreams.size();
            i2 = 0;
            while (i2 < nCount) {
                RTPStream streamRtp = (RTPStream)this.vectorStreams.elementAt(i2);
                if (streamRtp instanceof SendStream) {
                    ((SendStream)streamRtp).close();
                }
                ++i2;
            }
            this.vectorStreams.removeAllElements();
            this.vectorStreams = null;
        }
        if (this.vectorMngrSessions != null) {
            nCount = this.vectorMngrSessions.size();
            i2 = 0;
            while (i2 < nCount) {
                RTPSessionMgr mngrSession = (RTPSessionMgr)this.vectorMngrSessions.elementAt(i2);
                if (this.mngrSessionRtp == mngrSession) {
                    this.mngrSessionRtp = null;
                }
                mngrSession.removeTargets("Transmission terminated.");
                mngrSession.dispose();
                ++i2;
            }
            this.vectorMngrSessions.removeAllElements();
            this.vectorMngrSessions = null;
        }
        if (this.mngrSessionRtp != null) {
            this.mngrSessionRtp.removeTargets("Transmission terminated.");
            this.mngrSessionRtp.dispose();
            this.mngrSessionRtp = null;
        }
        super.killCurrentPlayer();
        if (this.dataSourceCurrent != null && this.dataSourceCurrent instanceof CDSWrapper) {
            ((CDSWrapper)this.dataSourceCurrent).close();
        }
        this.dataSourceCurrent = null;
        this.setTitle(APPNAME);
        this.killed = true;
        if (this.rtptimer != null && this.rtptimer.isAlive()) {
            this.rtptimer.interrupt();
            this.rtptimer = null;
        }
        this.updateMenu();
    }

    private boolean closeCapture() {
        if (this.mediaPlayerCurrent == null) {
            return true;
        }
        if (this.dataSourceCurrent != null) {
            String strMessage = JMFI18N.getResource("jmstudio.query.erooropencapture.closepreview");
            String strAction = MessageDialog.createOKCancelDialog(this, strMessage);
            if (strAction != null && strAction.equals(JMDialog.ACTION_OK)) {
                this.killCurrentPlayer();
                return true;
            }
            return false;
        }
        return true;
    }

    public void updateMenu() {
        boolean boolEnable = this.mediaPlayerCurrent != null;
        this.menuFileExport.setEnabled(boolEnable);
        this.menuFileClose.setEnabled(boolEnable || this.mngrSessionRtp != null || this.vectorMngrSessions != null && !this.vectorMngrSessions.isEmpty());
        this.menuKeepAspect.setEnabled(boolEnable && this.panelVideo != null && this.panelVideo.getVisualComponent() != null);
        this.menuFullScreen.setEnabled(boolEnable && this.panelVideo != null && this.panelVideo.getVisualComponent() != null);
        this.menuSnapShot.setEnabled(boolEnable && this.controlGrabber != null);
        this.menuPlugins.setEnabled(boolEnable && this.controlPlugins != null);
        this.menuCaptureControl.setEnabled(boolEnable && this.dlgCaptureControls != null);
        this.menuTransmissionStats.setEnabled(boolEnable && this.dlgTransmissionStats != null);
        this.menuRtpSessionControl.setEnabled(boolEnable && this.dlgSessionControl != null);
    }

    private void addToRecentUrlList(String strUrl) {
        if (cfgJMApps == null) {
            return;
        }
        int nPos = strUrl.lastIndexOf(".");
        String strUrlType = strUrl.substring(0, 4).equalsIgnoreCase("rtp:") ? "RTP" : (nPos < 1 || nPos == strUrl.length() - 1 ? "Other" : strUrl.substring(nPos + 1).toUpperCase());
        cfgJMApps.addRecentUrls(strUrlType, strUrl);
        this.updateRecentUrlMenu();
    }

    /*
     * Unable to fully structure code
     */
    private void updateRecentUrlMenu() {
        if (JMStudio.cfgJMApps == null) {
            return;
        }
        this.menuRecentUrl.removeAll();
        enumUrlTypes = JMStudio.cfgJMApps.getRecentUrlTypes();
        if (enumUrlTypes != null) ** GOTO lbl24
        return;
lbl-1000:
        // 1 sources

        {
            objUrlType = enumUrlTypes.nextElement();
            menuUrlType = new Menu(objUrlType.toString());
            this.menuRecentUrl.add(menuUrlType);
            vectorUrls = JMStudio.cfgJMApps.getRecentUrls(objUrlType.toString());
            if (vectorUrls == null) continue;
            nSize = vectorUrls.size();
            i = 0;
            while (i < nSize) {
                objUrl = vectorUrls.elementAt(i);
                menuItem = new MenuItem(objUrl.toString());
                menuItem.setActionCommand(JMStudio.MENU_FILE_RECENTURL);
                menuItem.addActionListener(this);
                menuUrlType.add(menuItem);
                ++i;
            }
lbl24:
            // 3 sources

            ** while (enumUrlTypes.hasMoreElements())
        }
lbl25:
        // 1 sources

    }

    static void initProps() {
        Properties props = new Properties(System.getProperties());
        props = new Properties(props);
        String sep = File.separator;
        File theUserPropertiesFile = new File(System.getProperty("user.home") + sep + ".hotjava" + sep + "properties");
        try {
            FileInputStream in = new FileInputStream(theUserPropertiesFile);
            props.load(new BufferedInputStream(in));
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(props);
    }

    public static void main(String[] args) {
        MessageDialog.titleDefault = APPNAME;
        cfgJMApps = new JMAppsCfg();
        try {
            JMStudio.initProps();
        }
        catch (Throwable t) {
            System.out.println("Unable to read Http Proxy information from the appletviewer settings");
        }
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].equals("-x")) {
                if (args.length > i2 + 1) {
                    try {
                        dDefaultScale = Double.valueOf(args[i2 + 1]);
                        ++i2;
                    }
                    catch (Exception exception) {
                        dDefaultScale = 1.0;
                    }
                }
            } else {
                String strMedia = args[i2];
                if (strMedia.indexOf(":") < 2) {
                    if (strMedia.indexOf("/") != 0) {
                        strMedia = "/" + strMedia;
                    }
                    strMedia = "file:" + strMedia;
                }
                JMStudio jmStudio = JMStudio.createNewFrame();
                jmStudio.open(strMedia);
            }
            ++i2;
        }
        if (vectorFrames.size() < 1) {
            JMStudio jMStudio = JMStudio.createNewFrame();
        }
    }

    public static JMStudio createNewFrame() {
        JMStudio jmStudio = new JMStudio();
        if (cfgJMApps != null) {
            int nIndex = vectorFrames.size();
            Point point = cfgJMApps.getJMStudioFrameLocation(nIndex);
            Dimension dim = jmStudio.getSize();
            Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
            if (point.x + dim.width > dimScreen.width) {
                point.x = dimScreen.width - dim.width;
            }
            if (point.y + dim.height > dimScreen.height) {
                point.y = dimScreen.height - dim.height;
            }
            ((Component)jmStudio).setLocation(point);
            jmStudio.setVisible(true);
            jmStudio.invalidate();
            jmStudio.pack();
        }
        vectorFrames.addElement(jmStudio);
        return jmStudio;
    }

    public static void closeAll() {
        int i2 = vectorFrames.size();
        while (i2 > 0) {
            JMStudio jmStudio = (JMStudio)vectorFrames.elementAt(--i2);
            jmStudio.killCurrentPlayer();
            jmStudio.dispose();
        }
    }

    public static void exitApllication() {
        JMStudio.cleanUp();
        System.exit(0);
    }

    private static void cleanUp() {
        if (cfgJMApps != null) {
            cfgJMApps.save();
        }
    }

    private Vector getEffectList(Format format) {
        Vector v = PlugInManager.getPlugInList(format, null, 3);
        return v;
    }

    private void fillEffectList(Menu menu, Vector list) {
        boolean first = true;
        int i2 = 0;
        while (i2 < list.size()) {
            String className = (String)list.elementAt(i2);
            try {
                CheckboxMenuItem mi;
                Class<?> cClass = Class.forName(className);
                Codec codec = (Codec)cClass.newInstance();
                String name = codec.getName();
                if (first) {
                    first = false;
                    mi = new CheckboxMenuItem("None");
                    mi.setName("");
                    menu.add(mi);
                    mi.setState(true);
                    this.addEffectListener(mi);
                }
                mi = new CheckboxMenuItem(name);
                mi.setName(className);
                menu.add(mi);
                mi.setState(false);
                this.addEffectListener(mi);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ++i2;
        }
    }

    private void addEffectListener(CheckboxMenuItem mi) {
        mi.addItemListener(new EffectListener(mi));
    }

    class EffectListener
    implements ItemListener {
        CheckboxMenuItem mi;

        public EffectListener(CheckboxMenuItem mi) {
            this.mi = mi;
        }

        public void itemStateChanged(ItemEvent ie) {
            String name;
            boolean state = this.mi.getState();
            Menu menu = (Menu)this.mi.getParent();
            int i2 = 0;
            while (i2 < menu.getItemCount()) {
                if (menu.getItem(i2) != this.mi) {
                    ((CheckboxMenuItem)menu.getItem(i2)).setState(false);
                }
                ++i2;
            }
            if (!state) {
                ((CheckboxMenuItem)menu.getItem(0)).setState(true);
            }
            if ((name = this.mi.getName()) == null || name.length() < 1) {
                name = null;
            }
            if (menu == JMStudio.this.menuAE) {
                JMStudio.this.audioEffect = name;
            } else {
                JMStudio.this.videoEffect = name;
            }
        }
    }

    class WaitOnVis
    extends Thread {
        VideoPanel vp;
        MediaPlayer mp;

        public WaitOnVis(VideoPanel vp, MediaPlayer mp) {
            this.vp = vp;
            this.mp = mp;
        }

        public void run() {
            Component compVis = this.vp.getVisualComponent();
            if (compVis != null) {
                while (!compVis.isVisible()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.err.println("sleeping");
                }
            }
            this.mp.prefetch();
        }
    }

    class RTPTimer
    extends Thread {
        JMStudio outer = null;

        public RTPTimer(JMStudio outer) {
            this.outer = outer;
        }

        public void run() {
            String newtime;
            MessageDialog dlg = null;
            String answer = "";
            Image image = null;
            try {
                Thread.sleep(7000L);
            }
            catch (InterruptedException ie) {
                return;
            }
            if (!JMStudio.this.killed && !JMStudio.this.recvRTP) {
                image = ImageArea.loadImage("iconInfo.gif");
                dlg = new MessageDialog(this.outer, "Waiting for data", "7 seconds elasped", image, false, false);
                dlg.setLocationCenter();
                dlg.show();
            }
            int count = 7;
            while (!(JMStudio.this.killed || JMStudio.this.recvRTP || Thread.currentThread().isInterrupted() || count >= 60)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    if (dlg != null) {
                        dlg.dispose();
                        dlg = null;
                    }
                    return;
                }
                newtime = new Integer(++count).toString() + " seconds elasped";
                if (dlg == null) continue;
                dlg.getTextView().setText(newtime);
            }
            if (!(JMStudio.this.killed || JMStudio.this.recvRTP || Thread.currentThread().isInterrupted())) {
                answer = MessageDialog.createYesNoDialog(this.outer, "Waing for data", "You have been waiting for 60 secs. Continue to wait?");
            }
            if (!JMStudio.this.killed && !JMStudio.this.recvRTP && !Thread.currentThread().isInterrupted() && answer.equals("No")) {
                if (dlg != null) {
                    dlg.dispose();
                    dlg = null;
                }
                this.outer.killCurrentPlayer();
                return;
            }
            count = 60;
            while (!(JMStudio.this.killed || JMStudio.this.recvRTP || Thread.currentThread().isInterrupted())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    if (dlg != null) {
                        dlg.dispose();
                        dlg = null;
                    }
                    return;
                }
                newtime = new Integer(++count).toString() + " seconds elasped";
                if (dlg == null) continue;
                dlg.getTextView().setText(newtime);
            }
        }
    }
}

