/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JFrame;
import net.sf.gogui.gui.GtpShell;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.utils.Preferences;
import net.sf.gogui.utils.StringUtils;

public final class Session {
    public static void restoreLocation(Window window, Preferences preferences, String string, int n) {
        if (!preferences.contains(string = string + "-" + n)) {
            return;
        }
        String[] stringArray = StringUtils.splitArguments(preferences.getString(string));
        if (stringArray.length < 2) {
            return;
        }
        try {
            int n2;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n3 = Math.max(0, Integer.parseInt(stringArray[0]));
            if (n3 > dimension.width) {
                n3 = 0;
            }
            if ((n2 = Math.max(0, Integer.parseInt(stringArray[1]))) > dimension.height) {
                n2 = 0;
            }
            window.setLocation(n3, n2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void restoreSize(Window window, Preferences preferences, String string, int n) {
        if (!preferences.contains(string = string + "-" + n)) {
            return;
        }
        String[] stringArray = StringUtils.splitArguments(preferences.getString(string));
        if (stringArray.length < 4) {
            return;
        }
        try {
            int n2;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n3 = Math.max(0, Integer.parseInt(stringArray[0]));
            if (n3 > dimension.width) {
                n3 = 0;
            }
            if ((n2 = Math.max(0, Integer.parseInt(stringArray[1]))) > dimension.height) {
                n2 = 0;
            }
            int n4 = Integer.parseInt(stringArray[2]);
            n4 = Math.min(n4, dimension.width);
            int n5 = Integer.parseInt(stringArray[3]);
            n5 = Math.min(n5, dimension.height);
            if (window instanceof GtpShell) {
                ((GtpShell)window).setFinalSize(n3, n2, n4, n5);
            } else {
                window.setBounds(n3, n2, n4, n5);
                window.validate();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void saveLocation(Window window, Preferences preferences, String string, int n) {
        if (Session.isFrameSpecialMode(window)) {
            return;
        }
        string = string + "-" + n;
        Point point = window.getLocation();
        String string2 = Integer.toString(point.x) + " " + point.y;
        preferences.setString(string, string2);
    }

    public static void saveSize(Window window, Preferences preferences, String string, int n) {
        if (Session.isFrameSpecialMode(window)) {
            return;
        }
        string = string + "-" + n;
        Point point = window.getLocation();
        Dimension dimension = window.getSize();
        String string2 = Integer.toString(point.x) + " " + point.y + " " + dimension.width + " " + dimension.height;
        preferences.setString(string, string2);
    }

    public static void saveSizeAndVisible(Window window, Preferences preferences, String string, int n) {
        if (window != null) {
            Session.saveSize(window, preferences, "window-" + string, n);
        }
        boolean bl = window != null && window.isVisible();
        preferences.setBool("show-" + string, bl);
    }

    private Session() {
    }

    private static boolean isFrameSpecialMode(Window window) {
        return window instanceof JFrame && !GuiUtils.isNormalSizeMode((JFrame)window);
    }
}

