/*-
 * Copyright (c) 2003-2004 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *  @(#)$Id: ipa_sdb.h,v 1.2 2011/01/23 21:43:36 simon Exp $
 */

#ifndef IPA_SDB_H
#define IPA_SDB_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef IPA_SDB_CONFIG_H
# error "You should #include ipa_sdb_config.h before ipa_sdb.h"
#endif

#ifndef ATTR_PACKED
# ifndef USE_PRAGMA_PACK_PUSH_POP
#  define IPA_SDB_NOT_PACKED
#  ifdef __GNUC__
#   warning "Data structures are not packed."
#   warning "Do not use database on another architecture."
#  endif
# else
#  pragma pack(push, 1)
# endif
# define ATTR_PACKED
#endif

#define IPA_SDB_DB_DIR		"/var/ipa_sdb"

#define IPA_SDB_INFO_FILE	"info"
#define IPA_SDB_LIMITS_DIR	"limits"
#define IPA_SDB_LIMIT_CURRENT	"current"
#define IPA_SDB_THRESHOLDS_DIR	"thresholds"
#define IPA_SDB_THRESHOLD_STATE	"state"

/*
 * A rule name cannot contain any white-space characters,
 * so this name for a file in the database directory is valid.
 */
#define IPA_SDB_VERSION_FILE	"db version"

/* Database format version. */
#define IPA_SDB_FORMAT_VERSION 1

/* Length of IPA_SDB_FORMAT_VERSION string. */
#define IPA_SDB_FORMAT_VERSION_LEN 1

struct ipa_sdb_rule_record {
	uint8_t		mday;
	uint8_t		h1;
	uint8_t		m1;
	uint8_t		s1;
	uint8_t		h2;
	uint8_t		m2;
	uint8_t		s2;
	uint32_t	c_high;
	uint32_t	c_low;
} ATTR_PACKED;

struct ipa_sdb_date_struct {
	uint16_t	year;
	uint8_t		mon;
	uint8_t		mday;
	uint8_t		hour;
	uint8_t		min;
	uint8_t		sec;
} ATTR_PACKED;

typedef struct ipa_sdb_date_struct ipa_sdb_date;

#define IPA_SDB_LIMIT_EVENT_START_SET		0x01
#define IPA_SDB_LIMIT_EVENT_RESTART_SET		0x02
#define IPA_SDB_LIMIT_EVENT_RESTART_EXEC_SET	0x04
#define IPA_SDB_LIMIT_EVENT_REACH_SET		0x08
#define IPA_SDB_LIMIT_EVENT_REACH_EXEC_SET	0x10
#define IPA_SDB_LIMIT_EVENT_EXPIRE_SET		0x20
#define IPA_SDB_LIMIT_EVENT_EXPIRE_EXEC_SET	0x40
#define IPA_SDB_LIMIT_EVENT_UPDATED_SET		0x80

struct ipa_sdb_limit_record {
	uint8_t		set;
	ipa_sdb_date	start;
	ipa_sdb_date	restart;
	ipa_sdb_date	restart_exec;
	ipa_sdb_date	reach;
	ipa_sdb_date	reach_exec;
	ipa_sdb_date	expire;
	ipa_sdb_date	expire_exec;
	uint32_t	l_high;
	uint32_t	l_low;
	ipa_sdb_date	updated;
	uint32_t	c_high;
	uint32_t	c_low;
} ATTR_PACKED;

struct ipa_sdb_threshold_record {
	uint32_t	t_high;
	uint32_t	t_low;
	uint32_t	c_high;
	uint32_t	c_low;
	ipa_sdb_date	tm_started;
	ipa_sdb_date	tm_updated;
} ATTR_PACKED;

#ifdef USE_PRAGMA_PACK_PUSH_POP
# pragma pack(pop)
# undef USE_PRAGMA_PACK_PUSH_POP
#endif

#undef ATTR_PACKED

#ifdef __cplusplus
}
#endif

#endif /* !IPA_SDB_H */
