/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board.prefs;

import free.chess.Chess;
import free.chess.Move;
import free.chess.Position;
import free.chess.Square;
import free.chess.event.MoveEvent;
import free.chess.event.MoveListener;
import free.jin.BadChangesException;
import free.jin.I18n;
import free.jin.board.BoardManager;
import free.jin.board.JinBoard;
import free.jin.board.prefs.BoardModifyingPrefsPanel;
import free.util.swing.ColorChooser;
import free.util.swing.PreferredSizedPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MoveInputPanel
extends BoardModifyingPrefsPanel {
    protected final JRadioButton dragndrop;
    protected final JRadioButton clicknclick;
    protected final JCheckBox autoPromote;
    protected final JCheckBox pieceFollowsCursor;
    protected final JCheckBox highlightMadeMoveSquares;
    protected final ColorChooser madeMoveSquaresHighlightColor;
    protected final JRadioButton disallowMoveInAdvance;
    protected final JRadioButton immediateSendMove;
    protected final JRadioButton premove;
    private final JRadioButton none;
    private final JRadioButton targetSquare;
    private final JRadioButton bothSquares;
    private final JRadioButton arrow;
    private final JCheckBox highlightOwnMoves;
    private final ColorChooser highlightColor;
    private Move lastMove = null;

    public MoveInputPanel(BoardManager boardManager, JinBoard jinBoard) {
        super(boardManager, jinBoard);
        I18n i18n = I18n.get((Class)MoveInputPanel.class);
        this.dragndrop = i18n.createRadioButton("dragndropRadioButton");
        this.clicknclick = i18n.createRadioButton("clicknclickRadioButton");
        this.dragndrop.setSelected(boardManager.getMoveInputStyle() == 1);
        this.clicknclick.setSelected(boardManager.getMoveInputStyle() == 2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.dragndrop);
        buttonGroup.add(this.clicknclick);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MoveInputPanel.this.previewBoard.setMoveInputStyle(MoveInputPanel.this.getMoveInputStyle());
                MoveInputPanel.this.fireStateChanged();
            }
        };
        this.dragndrop.addActionListener(actionListener);
        this.clicknclick.addActionListener(actionListener);
        this.autoPromote = i18n.createCheckBox("autoPromoteCheckBox");
        this.autoPromote.setSelected(boardManager.isAutoPromote());
        this.autoPromote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MoveInputPanel.this.previewBoard.setManualPromote(!MoveInputPanel.this.autoPromote.isSelected());
                MoveInputPanel.this.fireStateChanged();
            }
        });
        this.pieceFollowsCursor = i18n.createCheckBox("pieceFollowsCursorCheckBox");
        this.pieceFollowsCursor.setSelected(boardManager.isPieceFollowsCursor());
        this.pieceFollowsCursor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MoveInputPanel.this.previewBoard.setPieceFollowsCursor(MoveInputPanel.this.pieceFollowsCursor.isSelected());
                MoveInputPanel.this.fireStateChanged();
            }
        });
        this.highlightMadeMoveSquares = i18n.createCheckBox("highlightMadeMoveSquaresCheckBox");
        this.highlightMadeMoveSquares.setSelected(boardManager.isHighlightMadeMoveSquares());
        this.highlightMadeMoveSquares.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = MoveInputPanel.this.highlightMadeMoveSquares.isSelected();
                MoveInputPanel.this.previewBoard.setHighlightMadeMoveSquares(bl);
                MoveInputPanel.this.madeMoveSquaresHighlightColor.setEnabled(bl);
                MoveInputPanel.this.fireStateChanged();
            }
        });
        this.madeMoveSquaresHighlightColor = i18n.createColorChooser("madeMoveSquaresHighlightColorChooser");
        this.madeMoveSquaresHighlightColor.setColor(boardManager.getMadeMoveSquaresHighlightColor());
        this.madeMoveSquaresHighlightColor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MoveInputPanel.this.previewBoard.setMadeMoveSquaresHighlightColor(MoveInputPanel.this.madeMoveSquaresHighlightColor.getColor());
                MoveInputPanel.this.fireStateChanged();
            }
        });
        this.disallowMoveInAdvance = i18n.createRadioButton("disallowMoveInAdvanceRadioButton");
        this.immediateSendMove = i18n.createRadioButton("immediateSendMoveRadioButton");
        this.premove = i18n.createRadioButton("premoveRadioButton");
        this.disallowMoveInAdvance.setSelected(boardManager.getMoveSendingMode() == 1);
        this.immediateSendMove.setSelected(boardManager.getMoveSendingMode() == 2);
        this.premove.setSelected(boardManager.getMoveSendingMode() == 3);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.disallowMoveInAdvance);
        buttonGroup2.add(this.immediateSendMove);
        buttonGroup2.add(this.premove);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardManager boardManager = MoveInputPanel.this.boardManager;
                if (boardManager.isUserPlaying()) {
                    I18n i18n = I18n.get((Class)(class$free$jin$board$prefs$MoveInputPanel == null ? (class$free$jin$board$prefs$MoveInputPanel = MoveInputPanel.class$("free.jin.board.prefs.MoveInputPanel")) : class$free$jin$board$prefs$MoveInputPanel));
                    i18n.error("moveInAdvanceChangeError", (Component)((Object)MoveInputPanel.this));
                    MoveInputPanel.this.disallowMoveInAdvance.setSelected(boardManager.getMoveSendingMode() == 1);
                    MoveInputPanel.this.immediateSendMove.setSelected(boardManager.getMoveSendingMode() == 2);
                    MoveInputPanel.this.premove.setSelected(boardManager.getMoveSendingMode() == 3);
                    return;
                }
                MoveInputPanel.this.fireStateChanged();
            }
        };
        this.disallowMoveInAdvance.addActionListener(actionListener2);
        this.immediateSendMove.addActionListener(actionListener2);
        this.premove.addActionListener(actionListener2);
        int n = boardManager.getMoveHighlightingStyle();
        this.none = i18n.createRadioButton("noMoveHighlightRadioButton");
        this.targetSquare = i18n.createRadioButton("targetSquareHighlightRadioButton");
        this.bothSquares = i18n.createRadioButton("bothSquaresHighlightRadioButton");
        this.arrow = i18n.createRadioButton("arrowHighlightRadioButton");
        this.none.setSelected(n == 0);
        this.targetSquare.setSelected(n == 1);
        this.bothSquares.setSelected(n == 2);
        this.arrow.setSelected(n == 3);
        this.highlightOwnMoves = i18n.createCheckBox("highlightOwnMovesCheckBox");
        this.highlightOwnMoves.setSelected(boardManager.isHighlightingOwnMoves());
        this.highlightColor = i18n.createColorChooser("moveHighlightColorChooser");
        this.highlightColor.setColor(boardManager.getMoveHighlightingColor());
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.none);
        buttonGroup3.add(this.targetSquare);
        buttonGroup3.add(this.bothSquares);
        buttonGroup3.add(this.arrow);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MoveInputPanel.this.previewBoard.setMoveHighlightingStyle(MoveInputPanel.this.getMoveHighlightingStyle());
                MoveInputPanel.this.highlightOwnMoves.setEnabled(!MoveInputPanel.this.none.isSelected());
                MoveInputPanel.this.highlightColor.setEnabled(!MoveInputPanel.this.none.isSelected());
                MoveInputPanel.this.fireStateChanged();
            }
        };
        this.none.addActionListener(actionListener3);
        this.targetSquare.addActionListener(actionListener3);
        this.bothSquares.addActionListener(actionListener3);
        this.arrow.addActionListener(actionListener3);
        this.highlightOwnMoves.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MoveInputPanel.this.lastMove.getPlayer().isWhite()) {
                    MoveInputPanel.this.previewBoard.setHighlightedMove(MoveInputPanel.this.highlightOwnMoves.isSelected() ? MoveInputPanel.this.lastMove : null);
                }
                MoveInputPanel.this.fireStateChanged();
            }
        });
        this.highlightColor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MoveInputPanel.this.previewBoard.setMoveHighlightingColor(MoveInputPanel.this.highlightColor.getColor());
                MoveInputPanel.this.fireStateChanged();
            }
        });
        jinBoard.getPosition().addMoveListener(new MoveListener(){

            public void moveMade(MoveEvent moveEvent) {
                Move move = moveEvent.getMove();
                if (move.getPlayer().isBlack() || MoveInputPanel.this.highlightOwnMoves.isSelected()) {
                    MoveInputPanel.this.previewBoard.setHighlightedMove(move);
                } else {
                    MoveInputPanel.this.previewBoard.setHighlightedMove(null);
                }
                MoveInputPanel.this.lastMove = move;
            }
        });
        JComponent jComponent = this.createMoveInputUI();
        JComponent jComponent2 = this.createPromotionUI();
        JComponent jComponent3 = this.createMoveVisualizationUI();
        JComponent jComponent4 = this.createMovingInAdvanceUI();
        JComponent jComponent5 = this.createMoveHighlightUI();
        this.madeMoveSquaresHighlightColor.setEnabled(this.highlightMadeMoveSquares.isSelected());
        PreferredSizedPanel preferredSizedPanel = new PreferredSizedPanel();
        preferredSizedPanel.setLayout(new BoxLayout((Container)preferredSizedPanel, 0));
        jComponent.setAlignmentY(0.0f);
        jComponent2.setAlignmentY(0.0f);
        preferredSizedPanel.add(jComponent);
        preferredSizedPanel.add(Box.createHorizontalStrut(10));
        preferredSizedPanel.add(jComponent2);
        preferredSizedPanel.add(Box.createHorizontalGlue());
        PreferredSizedPanel preferredSizedPanel2 = new PreferredSizedPanel();
        preferredSizedPanel2.setLayout(new BoxLayout((Container)preferredSizedPanel2, 0));
        preferredSizedPanel2.add(jComponent3);
        preferredSizedPanel2.add(Box.createHorizontalStrut(10));
        preferredSizedPanel2.add(jComponent4);
        preferredSizedPanel2.add(Box.createHorizontalGlue());
        PreferredSizedPanel preferredSizedPanel3 = new PreferredSizedPanel();
        preferredSizedPanel3.setLayout(new BoxLayout((Container)preferredSizedPanel3, 0));
        preferredSizedPanel3.add(jComponent5);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 10));
        preferredSizedPanel.setAlignmentX(0.0f);
        preferredSizedPanel2.setAlignmentX(0.0f);
        preferredSizedPanel3.setAlignmentX(0.0f);
        this.add((Component)preferredSizedPanel);
        this.add(Box.createVerticalStrut(10));
        this.add((Component)preferredSizedPanel2);
        this.add(Box.createVerticalStrut(10));
        this.add((Component)preferredSizedPanel3);
        this.add(Box.createVerticalGlue());
    }

    private int getMoveInputStyle() {
        if (this.dragndrop.isSelected()) {
            return 1;
        }
        if (this.clicknclick.isSelected()) {
            return 2;
        }
        throw new IllegalStateException("None of the radio buttons are selected");
    }

    private int getMoveSendingMode() {
        if (this.disallowMoveInAdvance.isSelected()) {
            return 1;
        }
        if (this.immediateSendMove.isSelected()) {
            return 2;
        }
        if (this.premove.isSelected()) {
            return 3;
        }
        throw new IllegalStateException("None of the radio buttons are selected");
    }

    private int getMoveHighlightingStyle() {
        if (this.none.isSelected()) {
            return 0;
        }
        if (this.targetSquare.isSelected()) {
            return 1;
        }
        if (this.bothSquares.isSelected()) {
            return 2;
        }
        if (this.arrow.isSelected()) {
            return 3;
        }
        throw new IllegalStateException("None of the radio buttons are selected");
    }

    public void initPreviewBoard() {
        this.previewBoard.setMoveInputStyle(this.getMoveInputStyle());
        this.previewBoard.setPieceFollowsCursor(this.pieceFollowsCursor.isSelected());
        this.previewBoard.setHighlightMadeMoveSquares(this.highlightMadeMoveSquares.isSelected());
        this.previewBoard.setManualPromote(!this.autoPromote.isSelected());
        this.previewBoard.setMoveHighlightingStyle(this.getMoveHighlightingStyle());
        this.previewBoard.setMoveHighlightingColor(this.highlightColor.getColor());
        Position position = this.previewBoard.getPosition();
        Move move = Chess.getInstance().createMove(position, Square.parseSquare((String)"f5"), Square.parseSquare((String)"c8"), null, "Bc8");
        position.makeMove(move);
        this.previewBoard.setHighlightedMove(move);
    }

    private JComponent createMoveInputUI() {
        PreferredSizedPanel preferredSizedPanel = new PreferredSizedPanel();
        preferredSizedPanel.setLayout(new BoxLayout((Container)preferredSizedPanel, 1));
        preferredSizedPanel.setBorder(BorderFactory.createCompoundBorder(I18n.get((Class)MoveInputPanel.class).createTitledBorder("moveInputPanel"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.dragndrop.setAlignmentX(0.0f);
        this.clicknclick.setAlignmentX(0.0f);
        preferredSizedPanel.add(this.dragndrop);
        preferredSizedPanel.add(this.clicknclick);
        preferredSizedPanel.add(Box.createVerticalGlue());
        return preferredSizedPanel;
    }

    private JComponent createPromotionUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(I18n.get((Class)MoveInputPanel.class).createTitledBorder("promotionPanel"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.autoPromote.setAlignmentX(0.0f);
        jPanel.add(this.autoPromote);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private JComponent createMoveVisualizationUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(I18n.get((Class)MoveInputPanel.class).createTitledBorder("moveVisualizationPanel"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.pieceFollowsCursor.setAlignmentX(0.0f);
        this.highlightMadeMoveSquares.setAlignmentX(0.0f);
        this.madeMoveSquaresHighlightColor.setAlignmentX(0.0f);
        jPanel.add(this.pieceFollowsCursor);
        jPanel.add(this.highlightMadeMoveSquares);
        jPanel.add((Component)this.madeMoveSquaresHighlightColor);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private JComponent createMovingInAdvanceUI() {
        I18n i18n = I18n.get((Class)MoveInputPanel.class);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(i18n.createTitledBorder("movingInAdvancePanel"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.disallowMoveInAdvance.setAlignmentX(0.0f);
        this.immediateSendMove.setAlignmentX(0.0f);
        this.premove.setAlignmentX(0.0f);
        jPanel.add(this.disallowMoveInAdvance);
        jPanel.add(this.immediateSendMove);
        jPanel.add(this.premove);
        jPanel.add(Box.createVerticalStrut(5));
        String[] stringArray = i18n.getString("moveInAdvanceChangeWarning").split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            jPanel.add(new JLabel(stringArray[i]));
        }
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private JComponent createMoveHighlightUI() {
        I18n i18n = I18n.get((Class)MoveInputPanel.class);
        PreferredSizedPanel preferredSizedPanel = new PreferredSizedPanel();
        preferredSizedPanel.setLayout(new BoxLayout((Container)preferredSizedPanel, 1));
        preferredSizedPanel.setBorder(BorderFactory.createCompoundBorder(i18n.createTitledBorder("moveHighlightPanel"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.none.setAlignmentX(0.0f);
        this.targetSquare.setAlignmentX(0.0f);
        this.bothSquares.setAlignmentX(0.0f);
        this.arrow.setAlignmentX(0.0f);
        this.highlightOwnMoves.setAlignmentX(0.0f);
        this.highlightColor.setAlignmentX(0.0f);
        preferredSizedPanel.add(this.none);
        preferredSizedPanel.add(this.targetSquare);
        preferredSizedPanel.add(this.bothSquares);
        preferredSizedPanel.add(this.arrow);
        preferredSizedPanel.add(this.highlightOwnMoves);
        preferredSizedPanel.add((Component)this.highlightColor);
        preferredSizedPanel.add(Box.createVerticalGlue());
        preferredSizedPanel.setAlignmentX(0.0f);
        return preferredSizedPanel;
    }

    public void applyChanges() throws BadChangesException {
        this.boardManager.setMoveInputStyle(this.getMoveInputStyle());
        this.boardManager.setAutoPromote(this.autoPromote.isSelected());
        this.boardManager.setPieceFollowsCursor(this.pieceFollowsCursor.isSelected());
        this.boardManager.setHighlightMadeMoveSquares(this.highlightMadeMoveSquares.isSelected());
        this.boardManager.setMadeMoveSquaresHighlightColor(this.madeMoveSquaresHighlightColor.getColor());
        this.boardManager.setMoveSendingMode(this.getMoveSendingMode());
        this.boardManager.setMoveHighlightingStyle(this.getMoveHighlightingStyle());
        this.boardManager.setHighlightingOwnMoves(this.highlightOwnMoves.isSelected());
        this.boardManager.setMoveHighlightingColor(this.highlightColor.getColor());
    }
}

