/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.I18n;
import free.jin.Jin;
import free.jin.ui.DialogPanel;
import free.util.IOUtilities;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class AboutPanel
extends DialogPanel {
    public AboutPanel() {
        this.createUI();
    }

    protected String getTitle() {
        I18n i18n = I18n.get(AboutPanel.class);
        String string = Jin.getInstance().getAppName();
        return i18n.getFormattedString("title", new Object[]{string});
    }

    public void display() {
        super.askResult();
    }

    private void createUI() {
        JComponent jComponent;
        Object object;
        String string;
        I18n i18n = I18n.get(AboutPanel.class);
        this.setLayout(new BoxLayout(this, 1));
        ImageIcon imageIcon = new ImageIcon(Jin.class.getResource("resources/logo.gif"));
        JLabel jLabel = new JLabel(Jin.getInstance().getAppName() + " " + Jin.getInstance().getAppVersion(), imageIcon, 0);
        jLabel.setFont(new Font("Serif", 0, 36));
        jLabel.setAlignmentX(0.5f);
        this.add(jLabel);
        this.add(Box.createVerticalStrut(5));
        this.add(new JSeparator());
        this.add(Box.createVerticalStrut(5));
        try {
            string = IOUtilities.loadText(Jin.class.getResourceAsStream("legal/copyright.txt"));
        }
        catch (IOException iOException) {
            this.add(new JLabel("Unable to load copyright file"));
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        Font font = new Font("SansSerif", 0, 12);
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            jComponent = new JLabel(((String)object).trim(), 0);
            jComponent.setAlignmentX(0.5f);
            jComponent.setFont(font);
            this.add(jComponent);
        }
        this.add(Box.createVerticalStrut(10));
        object = new JLabel("This program is dedicated to my Love.", 0);
        ((JComponent)object).setAlignmentX(0.5f);
        this.add((Component)object);
        ((JComponent)object).setFont(font);
        this.add(Box.createVerticalStrut(10));
        jComponent = i18n.createButton("closeButton");
        ((AbstractButton)jComponent).addActionListener(new DialogPanel.ClosingListener(this, null));
        jComponent.setAlignmentX(0.5f);
        this.add(jComponent);
        this.setDefaultButton((JButton)jComponent);
    }
}

