/*
 * Decompiled with CFR 0.152.
 */
package free.jin.chessclub;

import free.chess.Chess;
import free.chess.ChessMove;
import free.chess.ChesslikeGenericVariant;
import free.chess.Move;
import free.chess.Piece;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;
import free.chess.WildVariant;
import free.chess.variants.NoCastlingVariant;
import free.chess.variants.atomic.Atomic;
import free.chess.variants.fischerrandom.FischerRandom;
import free.chess.variants.giveaway.Giveaway;
import free.chess.variants.kriegspiel.Kriegspiel;
import free.chess.variants.shuffleboth.ShuffleBoth;
import free.chessclub.ChessclubConnection;
import free.chessclub.level2.Datagram;
import free.chessclub.level2.DatagramEvent;
import free.chessclub.level2.DatagramListener;
import free.jin.Connection;
import free.jin.Game;
import free.jin.GameListConnection;
import free.jin.GameListItem;
import free.jin.HistoryListItem;
import free.jin.I18n;
import free.jin.Jin;
import free.jin.LibListItem;
import free.jin.PGNConnection;
import free.jin.SearchListItem;
import free.jin.Seek;
import free.jin.SeekConnection;
import free.jin.StoredListItem;
import free.jin.UserSeek;
import free.jin.chessclub.ChessEvent;
import free.jin.chessclub.ChessclubListenerManager;
import free.jin.chessclub.NoSuchGameException;
import free.jin.chessclub.event.ArrowEvent;
import free.jin.chessclub.event.ChessEventEvent;
import free.jin.chessclub.event.CircleEvent;
import free.jin.event.BoardFlipEvent;
import free.jin.event.ChatEvent;
import free.jin.event.ClockAdjustmentEvent;
import free.jin.event.GameEndEvent;
import free.jin.event.GameEvent;
import free.jin.event.GameListEvent;
import free.jin.event.GameListListenerManager;
import free.jin.event.GameStartEvent;
import free.jin.event.IllegalMoveEvent;
import free.jin.event.ListenerManager;
import free.jin.event.MoveMadeEvent;
import free.jin.event.OfferEvent;
import free.jin.event.PlainTextEvent;
import free.jin.event.PositionChangedEvent;
import free.jin.event.SeekEvent;
import free.jin.event.SeekListener;
import free.jin.event.SeekListenerManager;
import free.jin.event.TakebackEvent;
import free.util.Pair;
import free.util.TextUtilities;
import free.util.Utilities;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class JinChessclubConnection
extends ChessclubConnection
implements DatagramListener,
Connection,
SeekConnection,
GameListConnection,
PGNConnection {
    private final ChessclubListenerManager listenerManager = new ChessclubListenerManager(this);
    private static WildVariant[] wildVariants;
    private final Hashtable gameNumbersToGameInfo = new Hashtable(1);
    private final Hashtable nonStartedGames = new Hashtable(1);
    private final Hashtable unechoedMoves = new Hashtable(1);
    private int userGamesCount = 0;
    private final Hashtable seeks = new Hashtable();
    private GameListInfo curGameListInfo = null;
    private final Hashtable chessEvents = new Hashtable();
    static /* synthetic */ Class class$free$jin$HistoryListItem;
    static /* synthetic */ Class class$free$jin$SearchListItem;
    static /* synthetic */ Class class$free$jin$LibListItem;
    static /* synthetic */ Class class$free$jin$StoredListItem;

    public JinChessclubConnection(String string, String string2) {
        super(string, string2, System.out);
        this.setInterface(Jin.getInstance().getAppName() + " " + Jin.getInstance().getAppVersion() + " (" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + ", " + System.getProperty("os.name") + " " + JinChessclubConnection.getSafeOSVersion() + ")");
    }

    private static String getSafeOSVersion() {
        String string = System.getProperty("os.version");
        int n = string.indexOf(".", string.indexOf(".") + 1);
        if (n != -1) {
            string = string.substring(0, n) + ".x";
        }
        return string;
    }

    public ChessclubListenerManager getChessclubListenerManager() {
        return this.listenerManager;
    }

    public ListenerManager getListenerManager() {
        return this.getChessclubListenerManager();
    }

    public void initiateConnectAndLogin(String string, int n) {
        this.listenerManager.fireConnectionAttempted(this, string, n);
        this.initiateConnect(string, n);
    }

    protected void handleConnected() {
        this.listenerManager.fireConnectionEstablished(this);
        super.handleConnected();
    }

    protected void handleConnectingFailed(IOException iOException) {
        this.listenerManager.fireConnectingFailed(this, iOException.getMessage());
        super.handleConnectingFailed(iOException);
    }

    protected void handleLoginSucceeded() {
        this.sendCommand("set-quietly wrap 0");
        if (this.isDGOn(103)) {
            this.setDGOnAgain(103);
        }
        this.listenerManager.fireLoginSucceeded(this);
        super.handleLoginSucceeded();
    }

    protected void handleLoginFailed(String string) {
        this.listenerManager.fireLoginFailed(this, string);
        super.handleLoginFailed(string);
    }

    protected void handleDisconnection(IOException iOException) {
        this.listenerManager.fireConnectionLost(this);
        super.handleDisconnection(iOException);
    }

    public static String displayableTitle(String string) {
        if (string.length() == 0) {
            return "";
        }
        return "(" + string + ")";
    }

    public static boolean isComputer(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("C")) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnrated(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("U")) continue;
            return true;
        }
        return false;
    }

    protected Socket connectImpl(String string, int n) throws IOException {
        Socket socket = null;
        try {
            Class<?> clazz = Class.forName("free.chessclub.timestamp.TimestampingSocket");
            Constructor<?> constructor = clazz.getConstructor(String.class, Integer.TYPE);
            socket = (Socket)constructor.newInstance(string, new Integer(n));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            invocationTargetException.printStackTrace();
        }
        if (socket == null) {
            socket = new Socket(string, n);
        }
        return socket;
    }

    private WildVariant getVariant(int n) {
        String string = this.getVariantName(n);
        if (string == null) {
            string = "w" + n;
        }
        switch (n) {
            case 0: {
                return Chess.getInstance();
            }
            case 1: {
                return ShuffleBoth.getInstance();
            }
            case 16: {
                return Kriegspiel.getInstance();
            }
            case 22: {
                return FischerRandom.getInstance();
            }
            case 23: {
                return null;
            }
            case 24: {
                return null;
            }
            case 26: {
                return Giveaway.getInstance();
            }
            case 27: {
                return Atomic.getInstance();
            }
            case 28: {
                return null;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new NoCastlingVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", string);
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: {
                return new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", string);
            }
        }
        return null;
    }

    private int getWildNumber(WildVariant wildVariant) {
        if (wildVariant == null) {
            throw new IllegalArgumentException("Null variant");
        }
        Object[] objectArray = new String[]{"Chess", "Shuffle both", "Shuffle mirror", "Random mirror", "Random shuffle", "Reversed", "Empty board", "KPPP vs KPPP", "Advanced pawns", "Two kings each", "Pawn+move odds", "Knight odds", "Rook odds", "Queen odds", "Rook odds a3", "KBN vs K", "Kriegspiel", "Loser's chess", "Power chess", "KNN vs KP", "Loadgame", "Thematic", "Fischer random", "Crazyhouse", "Bughouse", "Three checks", "Giveaway", "Atomic", "Shatranj", "Random Wild"};
        return Utilities.indexOf((Object[])objectArray, (Object)wildVariant.getName());
    }

    public WildVariant[] getSupportedVariants() {
        if (wildVariants == null) {
            wildVariants = new WildVariant[]{Chess.getInstance(), ShuffleBoth.getInstance(), new NoCastlingVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Shuffle mirror"), new NoCastlingVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Random shuffle"), new NoCastlingVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Reversed"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Empty board"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "KPPP vs KPPP"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Advanced pawns"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Two kings each"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Pawn+move odds"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Knight odds"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Rook odds"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Queen odds"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Rood odds a3"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "KBN vs K"), Kriegspiel.getInstance(), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Loser's chess"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Power chess"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "KNN vs KP"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Loadgame"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Thematic"), FischerRandom.getInstance(), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Three checks"), Giveaway.getInstance(), Atomic.getInstance(), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Random Wild")};
        }
        return (WildVariant[])wildVariants.clone();
    }

    protected void warnVariantUnsupported(int n) {
        String string = this.getVariantName(n);
        if (string == null) {
            string = "w" + n;
        }
        String string2 = I18n.get((Class)JinChessclubConnection.class).getFormattedString("unsupportedVariantMessage", new Object[]{string});
        String[] stringArray = string2.split("\n");
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= n2) continue;
            n2 = stringArray[i].length();
        }
        String string3 = TextUtilities.padStart((String)"", (char)'*', (int)(n2 + 4));
        this.processLine(string3);
        for (int i = 0; i < stringArray.length; ++i) {
            this.processLine("* " + TextUtilities.padEnd((String)stringArray[i], (char)' ', (int)n2) + " *");
        }
        this.processLine(string3);
    }

    public void exit() {
        this.quit();
    }

    protected void processLine(String string) {
        this.listenerManager.firePlainTextEvent(new PlainTextEvent((Connection)this, string));
    }

    public void datagramReceived(DatagramEvent datagramEvent) {
        Datagram datagram = datagramEvent.getDatagram();
        switch (datagram.getId()) {
            case 31: {
                this.processPersonalTellDG(datagram);
                break;
            }
            case 83: {
                this.processPersonalQTellDG(datagram);
                break;
            }
            case 32: {
                this.processShoutDG(datagram);
                break;
            }
            case 28: {
                this.processChannelTellDG(datagram);
                break;
            }
            case 82: {
                this.processChannelQTellDG(datagram);
                break;
            }
            case 26: {
                this.processKibitzDG(datagram);
                break;
            }
            case 15: {
                this.processMyGameStartedDG(datagram);
                break;
            }
            case 18: {
                this.processStartedObservingDG(datagram);
                break;
            }
            case 40: {
                this.processIsolatedBoardDG(datagram);
                break;
            }
            case 100: {
                this.processMyGameChangeDG(datagram);
                break;
            }
            case 16: {
                this.processMyGameResultDG(datagram);
                break;
            }
            case 101: {
                this.processPositionBeginDG(datagram);
                break;
            }
            case 43: {
                this.processMyRelationToGameDG(datagram);
                break;
            }
            case 24: {
                this.processSendMovesDG(datagram);
                break;
            }
            case 23: {
                this.processBackwardDG(datagram);
                break;
            }
            case 22: {
                this.processTakebackDG(datagram);
                break;
            }
            case 42: {
                this.processIllegalMoveDG(datagram);
                break;
            }
            case 56: {
                this.processMsecDG(datagram);
                break;
            }
            case 21: {
                this.processOffersInMyGameDG(datagram);
                break;
            }
            case 61: {
                this.processMoretimeDG(datagram);
                break;
            }
            case 39: {
                this.processFlipDG(datagram);
                break;
            }
            case 60: {
                this.processArrowDG(datagram);
                break;
            }
            case 90: {
                this.processUnarrowDG(datagram);
                break;
            }
            case 59: {
                this.processCircleDG(datagram);
                break;
            }
            case 89: {
                this.processUncircleDG(datagram);
                break;
            }
            case 50: {
                this.processSeekDG(datagram);
                break;
            }
            case 51: {
                this.processSeekRemovedDG(datagram);
                break;
            }
            case 72: {
                this.processGamelistBeginDG(datagram);
                break;
            }
            case 73: {
                this.processGamelistItemDG(datagram);
                break;
            }
            case 103: {
                this.processTourneyDG(datagram);
                break;
            }
            case 104: {
                this.processRemoveTourneyDG(datagram);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled datagram received: " + datagram);
            }
        }
    }

    private void processPersonalTellDG(Datagram datagram) {
        this.processPersonalTell(datagram.getString(0), datagram.getString(1), datagram.getString(2), datagram.getInteger(3));
    }

    protected void processPersonalTell(String string, String string2, String string3, int n) {
        String string4;
        switch (n) {
            case 1: {
                string4 = "tell";
                break;
            }
            case 0: {
                string4 = "say";
                break;
            }
            case 2: {
                string4 = "ptell";
                break;
            }
            case 3: {
                string4 = "qtell";
                break;
            }
            case 4: {
                string4 = "atell";
                break;
            }
            default: {
                return;
            }
        }
        String string5 = JinChessclubConnection.displayableTitle(string2);
        ChatEvent chatEvent = new ChatEvent((Connection)this, string4, 0, string, string5, -1, string3, null);
        this.listenerManager.fireChatEvent(chatEvent);
    }

    private void processPersonalQTellDG(Datagram datagram) {
        this.processPersonalQTell(datagram.getString(0), datagram.getString(1), datagram.getString(2));
    }

    protected void processPersonalQTell(String string, String string2, String string3) {
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "qtell", 0, string, JinChessclubConnection.displayableTitle(string2), -1, string3, null));
    }

    private void processShoutDG(Datagram datagram) {
        this.processShout(datagram.getString(0), datagram.getString(1), datagram.getInteger(2), datagram.getString(3));
    }

    protected void processShout(String string, String string2, int n, String string3) {
        String string4;
        switch (n) {
            case 0: {
                string4 = "shout";
                break;
            }
            case 1: {
                string4 = "ishout";
                break;
            }
            case 2: {
                string4 = "sshout";
                break;
            }
            case 3: {
                string4 = "announcement";
                break;
            }
            default: {
                return;
            }
        }
        String string5 = JinChessclubConnection.displayableTitle(string2);
        ChatEvent chatEvent = n == 3 ? new ChatEvent((Connection)this, string4, 2, string, string5, -1, string3, null) : new ChatEvent((Connection)this, string4, 3, string, string5, -1, string3, null);
        this.listenerManager.fireChatEvent(chatEvent);
    }

    private void processChannelTellDG(Datagram datagram) {
        this.processChannelTell(datagram.getInteger(0), datagram.getString(1), datagram.getString(2), datagram.getString(3), datagram.getInteger(4));
    }

    protected void processChannelTell(int n, String string, String string2, String string3, int n2) {
        String string4;
        switch (n2) {
            case 1: {
                string4 = "channel-tell";
                break;
            }
            case 4: {
                string4 = "channel-atell";
                break;
            }
            default: {
                return;
            }
        }
        String string5 = JinChessclubConnection.displayableTitle(string2);
        ChatEvent chatEvent = new ChatEvent((Connection)this, string4, 3, string, string5, -1, string3, (Object)new Integer(n));
        this.listenerManager.fireChatEvent(chatEvent);
    }

    private void processChannelQTellDG(Datagram datagram) {
        this.processChannelQTell(datagram.getInteger(0), datagram.getString(1), datagram.getString(2), datagram.getString(3));
    }

    protected void processChannelQTell(int n, String string, String string2, String string3) {
        ChatEvent chatEvent = new ChatEvent((Connection)this, "channel-qtell", 3, string, JinChessclubConnection.displayableTitle(string2), -1, string3, (Object)new Integer(n));
        this.listenerManager.fireChatEvent(chatEvent);
    }

    private void processKibitzDG(Datagram datagram) {
        this.processKibitz(datagram.getInteger(0), datagram.getString(1), datagram.getString(2), datagram.getBoolean(3), datagram.getString(4));
    }

    protected void processKibitz(int n, String string, String string2, boolean bl, String string3) {
        String string4 = bl ? "kibitz" : "whisper";
        String string5 = JinChessclubConnection.displayableTitle(string2);
        ChatEvent chatEvent = new ChatEvent((Connection)this, string4, 1, string, string5, -1, string3, (Object)new Integer(n));
        this.listenerManager.fireChatEvent(chatEvent);
    }

    void lastGameListenerRemoved() {
    }

    private GameInfo getGameInfo(int n) throws NoSuchGameException {
        GameInfo gameInfo = (GameInfo)this.gameNumbersToGameInfo.get(new Integer(n));
        if (gameInfo == null) {
            throw new NoSuchGameException();
        }
        return gameInfo;
    }

    private void addGameInfo(int n, GameInfo gameInfo) {
        this.gameNumbersToGameInfo.put(new Integer(n), gameInfo);
        if (gameInfo.game.getGameType() == 1) {
            ++this.userGamesCount;
        }
    }

    private GameInfo removeGameInfo(int n) {
        GameInfo gameInfo = (GameInfo)this.gameNumbersToGameInfo.remove(new Integer(n));
        if (gameInfo != null && gameInfo.game.getGameType() == 1) {
            --this.userGamesCount;
        }
        return gameInfo;
    }

    private boolean gameExists(int n) {
        return this.gameNumbersToGameInfo.containsKey(new Integer(n));
    }

    private void addNonStartedGame(int n, int n2, String string, String string2, WildVariant wildVariant, String string3, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, String string4, int n7, int n8, long l, String string5, String string6, boolean bl3, boolean bl4, boolean bl5, String string7) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("WhiteName", string);
        hashtable.put("BlackName", string2);
        hashtable.put("Variant", wildVariant);
        hashtable.put("RatingCategoryString", string3);
        hashtable.put("IsRated", bl ? Boolean.TRUE : Boolean.FALSE);
        hashtable.put("WhiteInitial", new Integer(n3));
        hashtable.put("WhiteIncrement", new Integer(n4));
        hashtable.put("BlackInitial", new Integer(n5));
        hashtable.put("BlackIncrement", new Integer(n6));
        hashtable.put("IsPlayedGame", bl2 ? Boolean.TRUE : Boolean.FALSE);
        hashtable.put("WhiteRating", new Integer(n7));
        hashtable.put("BlackRating", new Integer(n8));
        hashtable.put("WhiteTitles", JinChessclubConnection.displayableTitle(string5));
        hashtable.put("BlackTitles", JinChessclubConnection.displayableTitle(string6));
        hashtable.put("GameType", new Integer(n));
        this.nonStartedGames.put(new Integer(n2), hashtable);
    }

    private boolean existsNonStarted(int n) {
        return this.nonStartedGames.containsKey(new Integer(n));
    }

    private Object getPropertyForNonStarted(int n, String string) {
        Hashtable hashtable = (Hashtable)this.nonStartedGames.get(new Integer(n));
        return hashtable.get(string);
    }

    private void putPropertyForNonStarted(int n, String string, Object object) {
        Hashtable hashtable = (Hashtable)this.nonStartedGames.get(new Integer(n));
        hashtable.put(string, object);
    }

    private Game createGameFromNonStarted(int n, Position position) {
        Player player;
        Hashtable hashtable = (Hashtable)this.nonStartedGames.remove(new Integer(n));
        String string = (String)hashtable.get("WhiteName");
        String string2 = (String)hashtable.get("BlackName");
        String string3 = (String)hashtable.get("RatingCategoryString");
        boolean bl = (Boolean)hashtable.get("IsRated");
        int n2 = 60000 * (Integer)hashtable.get("WhiteInitial");
        int n3 = 1000 * (Integer)hashtable.get("WhiteIncrement");
        int n4 = 60000 * (Integer)hashtable.get("BlackInitial");
        int n5 = 1000 * (Integer)hashtable.get("BlackIncrement");
        boolean bl2 = (Boolean)hashtable.get("IsPlayedGame");
        int n6 = (Integer)hashtable.get("WhiteRating");
        int n7 = (Integer)hashtable.get("BlackRating");
        String string4 = (String)hashtable.get("WhiteTitles");
        String string5 = (String)hashtable.get("BlackTitles");
        int n8 = (Integer)hashtable.get("GameType");
        boolean bl3 = (Boolean)hashtable.get("InitiallyFlipped");
        if (n8 == 3) {
            player = null;
        } else if (n8 == 2) {
            player = null;
        } else {
            String string6 = this.getUsername();
            player = bl2 ? (string.equals(string6) ? Player.WHITE_PLAYER : Player.BLACK_PLAYER) : null;
        }
        return new Game(n8, position, 0, string, string2, n2, n3, n4, n5, n6, n7, (Object)new Integer(n), string3, bl, bl2, string4, string5, bl3, player);
    }

    private void processMyGameStartedDG(Datagram datagram) {
        int n = datagram.getInteger(0);
        String string = datagram.getString(1);
        String string2 = datagram.getString(2);
        int n2 = datagram.getInteger(3);
        String string3 = datagram.getString(4);
        boolean bl = datagram.getBoolean(5);
        int n3 = datagram.getInteger(6);
        int n4 = datagram.getInteger(7);
        int n5 = datagram.getInteger(8);
        int n6 = datagram.getInteger(9);
        boolean bl2 = datagram.getBoolean(10);
        String string4 = datagram.getString(11);
        int n7 = datagram.getInteger(12);
        int n8 = datagram.getInteger(13);
        long l = datagram.getLong(14);
        String string5 = datagram.getString(15);
        String string6 = datagram.getString(16);
        boolean bl3 = datagram.getBoolean(17);
        boolean bl4 = datagram.getBoolean(18);
        boolean bl5 = datagram.getBoolean(19);
        String string7 = datagram.getString(20);
        this.processMyGameStarted(n, string, string2, n2, string3, bl, n3, n4, n5, n6, bl2, string4, n7, n8, l, string5, string6, bl3, bl4, bl5, string7);
    }

    protected void processMyGameStarted(int n, String string, String string2, int n2, String string3, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, String string4, int n7, int n8, long l, String string5, String string6, boolean bl3, boolean bl4, boolean bl5, String string7) {
        WildVariant wildVariant = this.getVariant(n2);
        if (wildVariant == null) {
            this.warnVariantUnsupported(n2);
            return;
        }
        this.addNonStartedGame(1, n, string, string2, wildVariant, string3, bl, n3, n4, n5, n6, bl2, string4, n7, n8, l, string5, string6, bl3, bl4, bl5, string7);
    }

    private void processStartedObservingDG(Datagram datagram) {
        int n = datagram.getInteger(0);
        String string = datagram.getString(1);
        String string2 = datagram.getString(2);
        int n2 = datagram.getInteger(3);
        String string3 = datagram.getString(4);
        boolean bl = datagram.getBoolean(5);
        int n3 = datagram.getInteger(6);
        int n4 = datagram.getInteger(7);
        int n5 = datagram.getInteger(8);
        int n6 = datagram.getInteger(9);
        boolean bl2 = datagram.getBoolean(10);
        String string4 = datagram.getString(11);
        int n7 = datagram.getInteger(12);
        int n8 = datagram.getInteger(13);
        long l = datagram.getLong(14);
        String string5 = datagram.getString(15);
        String string6 = datagram.getString(16);
        boolean bl3 = datagram.getBoolean(17);
        boolean bl4 = datagram.getBoolean(18);
        boolean bl5 = datagram.getBoolean(19);
        String string7 = datagram.getString(20);
        this.processStartedObserving(n, string, string2, n2, string3, bl, n3, n4, n5, n6, bl2, string4, n7, n8, l, string5, string6, bl3, bl4, bl5, string7);
    }

    protected void processStartedObserving(int n, String string, String string2, int n2, String string3, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, String string4, int n7, int n8, long l, String string5, String string6, boolean bl3, boolean bl4, boolean bl5, String string7) {
        WildVariant wildVariant = this.getVariant(n2);
        if (wildVariant == null) {
            this.warnVariantUnsupported(n2);
            return;
        }
        this.addNonStartedGame(2, n, string, string2, wildVariant, string3, bl, n3, n4, n5, n6, bl2, string4, n7, n8, l, string5, string6, bl3, bl4, bl5, string7);
    }

    private void processIsolatedBoardDG(Datagram datagram) {
        int n = datagram.getInteger(0);
        String string = datagram.getString(1);
        String string2 = datagram.getString(2);
        int n2 = datagram.getInteger(3);
        String string3 = datagram.getString(4);
        boolean bl = datagram.getBoolean(5);
        int n3 = datagram.getInteger(6);
        int n4 = datagram.getInteger(7);
        int n5 = datagram.getInteger(8);
        int n6 = datagram.getInteger(9);
        boolean bl2 = datagram.getBoolean(10);
        String string4 = datagram.getString(11);
        int n7 = datagram.getInteger(12);
        int n8 = datagram.getInteger(13);
        long l = datagram.getLong(14);
        String string5 = datagram.getString(15);
        String string6 = datagram.getString(16);
        boolean bl3 = datagram.getBoolean(17);
        boolean bl4 = datagram.getBoolean(18);
        boolean bl5 = datagram.getBoolean(19);
        String string7 = datagram.getString(20);
        this.processIsolatedBoard(n, string, string2, n2, string3, bl, n3, n4, n5, n6, bl2, string4, n7, n8, l, string5, string6, bl3, bl4, bl5, string7);
    }

    protected void processIsolatedBoard(int n, String string, String string2, int n2, String string3, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, String string4, int n7, int n8, long l, String string5, String string6, boolean bl3, boolean bl4, boolean bl5, String string7) {
        WildVariant wildVariant = this.getVariant(n2);
        if (wildVariant == null) {
            this.warnVariantUnsupported(n2);
            return;
        }
        this.addNonStartedGame(3, n, string, string2, wildVariant, string3, bl, n3, n4, n5, n6, bl2, string4, n7, n8, l, string5, string6, bl3, bl4, bl5, string7);
    }

    private void processMyGameChangeDG(Datagram datagram) {
        int n = datagram.getInteger(0);
        String string = datagram.getString(1);
        String string2 = datagram.getString(2);
        int n2 = datagram.getInteger(3);
        String string3 = datagram.getString(4);
        boolean bl = datagram.getBoolean(5);
        int n3 = datagram.getInteger(6);
        int n4 = datagram.getInteger(7);
        int n5 = datagram.getInteger(8);
        int n6 = datagram.getInteger(9);
        boolean bl2 = datagram.getBoolean(10);
        String string4 = datagram.getString(11);
        int n7 = datagram.getInteger(12);
        int n8 = datagram.getInteger(13);
        long l = datagram.getLong(14);
        String string5 = datagram.getString(15);
        String string6 = datagram.getString(16);
        boolean bl3 = datagram.getBoolean(17);
        boolean bl4 = datagram.getBoolean(18);
        boolean bl5 = datagram.getBoolean(19);
        String string7 = datagram.getString(20);
        this.processMyGameChange(n, string, string2, n2, string3, bl, n3, n4, n5, n6, bl2, string4, n7, n8, l, string5, string6, bl3, bl4, bl5, string7);
    }

    protected void processMyGameChange(int n, String string, String string2, int n2, String string3, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, String string4, int n7, int n8, long l, String string5, String string6, boolean bl3, boolean bl4, boolean bl5, String string7) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            this.updateGame(game.getGameType(), n, string, string2, string3, bl, 60000 * n3, 1000 * n4, 60000 * n5, 1000 * n6, bl2, n7, n8, String.valueOf(l), string5, string6);
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void processMyGameResultDG(Datagram datagram) {
        this.processMyGameResult(datagram.getInteger(0), datagram.getBoolean(1), datagram.getString(2), datagram.getString(3), datagram.getString(4));
    }

    protected void processMyGameResult(int n, boolean bl, String string, String string2, String string3) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            try {
                int n2 = "1-0".equals(string2) ? 1 : ("0-1".equals(string2) ? 2 : ("1/2-1/2".equals(string2) ? 3 : 4));
                game.setResult(n2);
                if (bl) {
                    if (game.getGameType() == 2) {
                        this.updateGame(game.getGameType(), n, game.getWhiteName(), game.getBlackName(), game.getRatingCategoryString(), game.isRated(), game.getWhiteTime(), game.getWhiteInc(), game.getBlackTime(), game.getBlackInc(), false, game.getWhiteRating(), game.getBlackRating(), game.getID(), game.getWhiteTitles(), game.getBlackTitles());
                    }
                } else if (game.getGameType() == 3) {
                    this.fireGameEvent((GameEvent)new GameEndEvent((Connection)this, game, n2));
                }
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
            }
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    protected void updateGame(int n, int n2, String string, String string2, String string3, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, int n7, int n8, Object object, String string4, String string5) {
        try {
            GameInfo gameInfo = this.getGameInfo(n2);
            Game game = gameInfo.game;
            game.setGameType(n);
            game.setId((Object)new Integer(n2));
            game.setWhiteName(string);
            game.setBlackName(string2);
            game.setRatingCategoryString(string3);
            game.setRated(bl);
            game.setWhiteTime(n3);
            game.setWhiteInc(n4);
            game.setBlackTime(n5);
            game.setBlackInc(n6);
            game.setPlayed(bl2);
            game.setWhiteRating(n7);
            game.setBlackRating(n8);
            game.setWhiteTitles(string4);
            game.setBlackTitles(string5);
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void processPositionBeginDG(Datagram datagram) {
        this.processPositionBegin(datagram.getInteger(0), datagram.getString(1), datagram.getInteger(2));
    }

    protected void processPositionBegin(int n, String string, int n2) {
        if (this.existsNonStarted(n)) {
            WildVariant wildVariant = (WildVariant)this.getPropertyForNonStarted(n, "Variant");
            Position position = new Position(wildVariant);
            if (!string.equals("")) {
                position.setFEN(string);
            }
            Game game = this.createGameFromNonStarted(n, position);
            GameInfo gameInfo = new GameInfo(game, new Position(position), n2);
            this.addGameInfo(n, gameInfo);
            this.fireGameEvent((GameEvent)new GameStartEvent((Connection)this, game));
        } else {
            try {
                GameInfo gameInfo = this.getGameInfo(n);
                Game game = gameInfo.game;
                Position position = new Position(game.getVariant());
                position.setFEN(string);
                game.setInitialPosition(position);
                game.setPliesSinceStart(0);
                gameInfo.moves.removeAllElements();
                gameInfo.position.copyFrom(game.getInitialPosition());
                gameInfo.numMovesToFollow = n2;
                this.fireGameEvent((GameEvent)new PositionChangedEvent((Connection)this, game, gameInfo.position));
            }
            catch (NoSuchGameException noSuchGameException) {
                // empty catch block
            }
        }
    }

    private void processMyRelationToGameDG(Datagram datagram) {
        this.processMyRelationToGame(datagram.getInteger(0), datagram.getString(1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processMyRelationToGame(int n, String string) {
        if ("X".equals(string)) {
            int n2;
            GameInfo gameInfo = this.removeGameInfo(n);
            if (gameInfo == null) {
                return;
            }
            Game game = gameInfo.game;
            this.unechoedMoves.remove(game);
            int n3 = n2 = game.getResult() == 5 ? 4 : game.getResult();
            if (game.getResult() == 5) {
                game.setResult(n2);
            }
            this.clearOffers(gameInfo, Player.WHITE_PLAYER);
            this.clearOffers(gameInfo, Player.BLACK_PLAYER);
            this.fireGameEvent((GameEvent)new GameEndEvent((Connection)this, game, n2));
            return;
        } else {
            int n4;
            int n5 = n4 = "O".equals(string) ? 2 : 1;
            if (this.gameExists(n)) {
                try {
                    GameInfo gameInfo = this.getGameInfo(n);
                    Game game = gameInfo.game;
                    boolean bl = game.isPlayed();
                    if ("E".equals(string)) {
                        bl = false;
                    }
                    if (game.isPlayed() == bl && n4 == game.getGameType()) return;
                    this.updateGame(n4, n, game.getWhiteName(), game.getBlackName(), game.getRatingCategoryString(), game.isRated(), game.getWhiteTime(), game.getWhiteInc(), game.getBlackTime(), game.getBlackInc(), bl, game.getWhiteRating(), game.getBlackRating(), game.getID(), game.getWhiteTitles(), game.getBlackTitles());
                    return;
                }
                catch (NoSuchGameException noSuchGameException) {
                    throw new IllegalStateException("This isn't supposed to happen - we checked that the game exists");
                }
            } else {
                if (!this.existsNonStarted(n)) return;
                this.putPropertyForNonStarted(n, "GameType", new Integer(n4));
            }
        }
    }

    private void processSendMovesDG(Datagram datagram) {
        int n = 0;
        int n2 = datagram.getInteger(n++);
        String string = datagram.getString(n++);
        String string2 = datagram.getString(n++);
        if (this.isDGOn(35)) {
            ++n;
        }
        if (this.isDGOn(36)) {
            // empty if block
        }
        int n3 = ++n;
        ++n;
        int n4 = datagram.getInteger(n3);
        this.processSendMoves(n2, string, string2, n4);
    }

    protected void processSendMoves(int n, String string, String string2, int n2) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            Position position = gameInfo.position;
            Move move = this.parseWarrenSmith(string2, position, string);
            position.makeMove(move);
            gameInfo.moves.addElement(move);
            boolean bl = n2 != 0 && n2 != 2;
            this.clearOffers(gameInfo, move.getPlayer().getOpponent());
            this.fireGameEvent((GameEvent)new MoveMadeEvent((Connection)this, game, move, bl));
            if (gameInfo.numMovesToFollow > 0) {
                --gameInfo.numMovesToFollow;
            } else {
                Move move2;
                Vector vector = (Vector)this.unechoedMoves.get(game);
                if (vector != null && vector.size() != 0 && JinChessclubConnection.isSameMove(game, move, move2 = (Move)vector.elementAt(0))) {
                    vector.removeElementAt(0);
                }
            }
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private static boolean isSameMove(Game game, Move move, Move move2) {
        try {
            String string = JinChessclubConnection.moveToString(game, move);
            String string2 = JinChessclubConnection.moveToString(game, move2);
            return string.equals(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private Move parseWarrenSmith(String string, Position position, String string2) {
        WildVariant wildVariant = position.getVariant();
        if (wildVariant.equals(Kriegspiel.getInstance()) && string.indexOf("?") != -1) {
            if (string.equals("?")) {
                return wildVariant.createMove(position, null, null, null, string2);
            }
            Square square = Square.parseSquare((String)string.substring(2, 4));
            return wildVariant.createMove(position, null, square, null, string2);
        }
        return Move.parseWarrenSmith((String)string, (Position)position, (String)string2);
    }

    private void processBackwardDG(Datagram datagram) {
        this.processBackward(datagram.getInteger(0), datagram.getInteger(1));
    }

    protected void processBackward(int n, int n2) {
        try {
            int n3;
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            Position position = gameInfo.position;
            Vector vector = gameInfo.moves;
            int n4 = vector.size() - n2;
            for (n3 = vector.size() - 1; n3 >= n4; --n3) {
                vector.removeElementAt(n3);
            }
            position.copyFrom(game.getInitialPosition());
            for (n3 = 0; n3 < n4; ++n3) {
                position.makeMove((Move)vector.elementAt(n3));
            }
            this.fireGameEvent((GameEvent)new TakebackEvent((Connection)this, game, n2));
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void processTakebackDG(Datagram datagram) {
        this.processTakeback(datagram.getInteger(0), datagram.getInteger(1));
    }

    protected void processTakeback(int n, int n2) {
        try {
            int n3;
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            Position position = gameInfo.position;
            Vector vector = gameInfo.moves;
            int n4 = vector.size() - n2;
            for (n3 = vector.size() - 1; n3 >= n4; --n3) {
                vector.removeElementAt(n3);
            }
            position.copyFrom(game.getInitialPosition());
            for (n3 = 0; n3 < n4; ++n3) {
                position.makeMove((Move)vector.elementAt(n3));
            }
            this.fireGameEvent((GameEvent)new TakebackEvent((Connection)this, game, n2));
            this.updateTakebackOffer(gameInfo, Player.WHITE_PLAYER, 0);
            this.updateTakebackOffer(gameInfo, Player.BLACK_PLAYER, 0);
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void processOffersInMyGameDG(Datagram datagram) {
        int n = datagram.getInteger(0);
        boolean bl = datagram.getBoolean(1);
        boolean bl2 = datagram.getBoolean(2);
        boolean bl3 = datagram.getBoolean(3);
        boolean bl4 = datagram.getBoolean(4);
        boolean bl5 = datagram.getBoolean(5);
        boolean bl6 = datagram.getBoolean(6);
        int n2 = datagram.getInteger(7);
        int n3 = datagram.getInteger(8);
        this.processOffersInMyGame(n, bl, bl2, bl3, bl4, bl5, bl6, n2, n3);
    }

    protected void processOffersInMyGame(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, int n3) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            this.updateOffer(gameInfo, 1, Player.WHITE_PLAYER, bl);
            this.updateOffer(gameInfo, 1, Player.BLACK_PLAYER, bl2);
            this.updateOffer(gameInfo, 2, Player.WHITE_PLAYER, bl3);
            this.updateOffer(gameInfo, 2, Player.BLACK_PLAYER, bl4);
            this.updateOffer(gameInfo, 3, Player.WHITE_PLAYER, bl5);
            this.updateOffer(gameInfo, 3, Player.BLACK_PLAYER, bl6);
            this.updateTakebackOffer(gameInfo, Player.WHITE_PLAYER, n2);
            this.updateTakebackOffer(gameInfo, Player.BLACK_PLAYER, n3);
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void updateOffer(GameInfo gameInfo, int n, Player player, boolean bl) {
        if (bl ^ gameInfo.isOfferred(n, player)) {
            gameInfo.setOffer(n, player, bl);
            this.fireGameEvent((GameEvent)new OfferEvent((Connection)this, gameInfo.game, n, bl, player));
        }
    }

    private void updateTakebackOffer(GameInfo gameInfo, Player player, int n) {
        int n2 = gameInfo.getTakebackOffer(player);
        if (n2 != n) {
            if (n2 != 0) {
                this.fireGameEvent((GameEvent)new OfferEvent((Connection)this, gameInfo.game, false, player, n2));
            }
            gameInfo.setTakebackOffer(player, n);
            if (n != 0) {
                this.fireGameEvent((GameEvent)new OfferEvent((Connection)this, gameInfo.game, true, player, n));
            }
        }
    }

    private void clearOffers(GameInfo gameInfo, Player player) {
        this.updateOffer(gameInfo, 1, player, false);
        this.updateOffer(gameInfo, 2, player, false);
        this.updateOffer(gameInfo, 3, player, false);
        this.updateTakebackOffer(gameInfo, player, 0);
    }

    private void processIllegalMoveDG(Datagram datagram) {
        this.processIllegalMove(datagram.getInteger(0), datagram.getString(1), datagram.getInteger(2));
    }

    protected void processIllegalMove(int n, String string, int n2) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            Vector vector = (Vector)this.unechoedMoves.get(game);
            if (vector == null || vector.size() == 0) {
                return;
            }
            Move move = (Move)vector.elementAt(0);
            if (JinChessclubConnection.moveToString(game, move).equals(string)) {
                vector.removeAllElements();
                this.fireGameEvent((GameEvent)new IllegalMoveEvent((Connection)this, game, move));
            }
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void processMsecDG(Datagram datagram) {
        this.processMsec(datagram.getInteger(0), datagram.getString(1).equals("W"), datagram.getInteger(2), datagram.getBoolean(3));
    }

    protected void processMsec(int n, boolean bl, int n2, boolean bl2) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            if (bl) {
                gameInfo.setWhiteClock(n2, bl2);
            } else {
                gameInfo.setBlackClock(n2, bl2);
            }
            Player player = bl ? Player.WHITE_PLAYER : Player.BLACK_PLAYER;
            this.fireGameEvent((GameEvent)new ClockAdjustmentEvent((Connection)this, game, player, n2, bl2 && game.isPlayed()));
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void processMoretimeDG(Datagram datagram) {
        this.processMoretime(datagram.getInteger(0), datagram.getString(1).equals("W"), datagram.getInteger(2));
    }

    protected void processMoretime(int n, boolean bl, int n2) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            if (bl) {
                int n3 = gameInfo.getWhiteTime() + n2 * 1000;
                boolean bl2 = gameInfo.isWhiteClockRunning();
                if (bl2) {
                    n3 -= (int)(System.currentTimeMillis() - gameInfo.getWhiteTimestamp());
                }
                gameInfo.setWhiteClock(n3, bl2);
                this.fireGameEvent((GameEvent)new ClockAdjustmentEvent((Connection)this, game, Player.WHITE_PLAYER, n3, bl2));
            } else {
                int n4 = gameInfo.getBlackTime() + n2 * 1000;
                boolean bl3 = gameInfo.isBlackClockRunning();
                if (bl3) {
                    n4 -= (int)(System.currentTimeMillis() - gameInfo.getBlackTimestamp());
                }
                gameInfo.setBlackClock(n4, bl3);
                this.fireGameEvent((GameEvent)new ClockAdjustmentEvent((Connection)this, game, Player.BLACK_PLAYER, n4, bl3));
            }
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void processFlipDG(Datagram datagram) {
        this.processFlip(datagram.getInteger(0), datagram.getBoolean(1));
    }

    protected void processFlip(int n, boolean bl) {
        if (this.existsNonStarted(n)) {
            this.putPropertyForNonStarted(n, "InitiallyFlipped", bl ? Boolean.TRUE : Boolean.FALSE);
        } else {
            try {
                GameInfo gameInfo = this.getGameInfo(n);
                Game game = gameInfo.game;
                gameInfo.isFlipped = bl;
                this.fireGameEvent((GameEvent)new BoardFlipEvent((Connection)this, game, bl));
            }
            catch (NoSuchGameException noSuchGameException) {
                // empty catch block
            }
        }
    }

    private void processCircleDG(Datagram datagram) {
        this.processCircle(datagram.getInteger(0), datagram.getString(1), datagram.getString(2));
    }

    protected void processCircle(int n, String string, String string2) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            Square square = Square.parseSquare((String)string2);
            this.fireGameEvent(new CircleEvent(this, game, 1, square));
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void processUncircleDG(Datagram datagram) {
        this.processUncircle(datagram.getInteger(0), datagram.getString(1), datagram.getString(2));
    }

    protected void processUncircle(int n, String string, String string2) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            Square square = Square.parseSquare((String)string2);
            this.fireGameEvent(new CircleEvent(this, game, 2, square));
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void processArrowDG(Datagram datagram) {
        this.processArrow(datagram.getInteger(0), datagram.getString(1), datagram.getString(2), datagram.getString(3));
    }

    protected void processArrow(int n, String string, String string2, String string3) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            Square square = Square.parseSquare((String)string2);
            Square square2 = Square.parseSquare((String)string3);
            this.fireGameEvent(new ArrowEvent(this, game, 1, square, square2));
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void processUnarrowDG(Datagram datagram) {
        this.processUnarrow(datagram.getInteger(0), datagram.getString(1), datagram.getString(2), datagram.getString(3));
    }

    protected void processUnarrow(int n, String string, String string2, String string3) {
        try {
            GameInfo gameInfo = this.getGameInfo(n);
            Game game = gameInfo.game;
            Square square = Square.parseSquare((String)string2);
            Square square2 = Square.parseSquare((String)string3);
            this.fireGameEvent(new ArrowEvent(this, game, 2, square, square2));
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void fireGameEvent(GameEvent gameEvent) {
        this.listenerManager.fireGameEvent(gameEvent);
    }

    public void quitGame(Game game) {
        Object object = game.getID();
        switch (game.getGameType()) {
            case 1: {
                if (game.isPlayed()) {
                    this.resign(game);
                    break;
                }
                this.sendCommand("unexamine");
                break;
            }
            case 2: {
                this.sendCommand("unobserve " + object);
                break;
            }
        }
    }

    public void makeMove(Game game, Move move) {
        String string = JinChessclubConnection.moveToString(game, move);
        if (this.userGamesCount > 1) {
            this.sendCommand("; goto " + game.getID() + " ; chessmove " + string);
        } else {
            this.sendCommand("chessmove " + string);
        }
        Vector<Move> vector = (Vector<Move>)this.unechoedMoves.get(game);
        if (vector == null) {
            vector = new Vector<Move>(2);
            this.unechoedMoves.put(game, vector);
        }
        vector.addElement(move);
    }

    private static String moveToString(Game game, Move move) {
        WildVariant wildVariant = game.getVariant();
        if (move instanceof ChessMove) {
            ChessMove chessMove = (ChessMove)move;
            if (chessMove.isShortCastling()) {
                return "O-O";
            }
            if (chessMove.isLongCastling()) {
                return "O-O-O";
            }
            String string = chessMove.getStartingSquare().toString() + chessMove.getEndingSquare().toString();
            if (chessMove.isPromotion()) {
                return string + "=" + wildVariant.pieceToString((Piece)chessMove.getPromotionTarget());
            }
            return string;
        }
        throw new IllegalArgumentException("Unsupported Move type: " + move.getClass());
    }

    private void checkGameMineAndPlayed(Game game) {
        if (game.getGameType() != 1 || !game.isPlayed()) {
            throw new IllegalArgumentException("The given game must be of type Game.MY_GAME and a played one");
        }
    }

    private void checkGameMineAndExamined(Game game) {
        if (game.getGameType() != 1 || game.isPlayed()) {
            throw new IllegalArgumentException("The given game must be of type Game.MY_GAME and an examined one");
        }
    }

    public void resign(Game game) {
        this.checkGameMineAndPlayed(game);
        if (this.userGamesCount > 1) {
            this.sendCommand("; goto " + game.getID() + " ; resign");
        } else {
            this.sendCommand("resign");
        }
    }

    public void requestDraw(Game game) {
        this.checkGameMineAndPlayed(game);
        if (this.userGamesCount > 1) {
            this.sendCommand("; goto " + game.getID() + " ; draw");
        } else {
            this.sendCommand("draw");
        }
    }

    public boolean isAbortSupported() {
        return true;
    }

    public void requestAbort(Game game) {
        this.checkGameMineAndPlayed(game);
        if (this.userGamesCount > 1) {
            this.sendCommand("; goto " + game.getID() + " ; abort");
        } else {
            this.sendCommand("abort");
        }
    }

    public boolean isAdjournSupported() {
        return true;
    }

    public void requestAdjourn(Game game) {
        this.checkGameMineAndPlayed(game);
        if (this.userGamesCount > 1) {
            this.sendCommand("; goto " + game.getID() + " ; adjourn");
        } else {
            this.sendCommand("adjourn");
        }
    }

    public boolean isTakebackSupported() {
        return true;
    }

    public void requestTakeback(Game game) {
        this.checkGameMineAndPlayed(game);
        this.sendCommand("takeback 1");
    }

    public boolean isMultipleTakebackSupported() {
        return true;
    }

    public void requestTakeback(Game game, int n) {
        this.checkGameMineAndPlayed(game);
        if (n < 1) {
            throw new IllegalArgumentException("Illegal ply count: " + n);
        }
        this.sendCommand("takeback " + n);
    }

    public void goBackward(Game game, int n) {
        this.checkGameMineAndExamined(game);
        if (n < 1) {
            throw new IllegalArgumentException("Illegal ply count: " + n);
        }
        this.sendCommand("backward " + n);
    }

    public void goForward(Game game, int n) {
        this.checkGameMineAndExamined(game);
        if (n < 1) {
            throw new IllegalArgumentException("Illegal ply count: " + n);
        }
        this.sendCommand("forward " + n);
    }

    public void goToBeginning(Game game) {
        this.checkGameMineAndExamined(game);
        this.sendCommand("backward 9999");
    }

    public void goToEnd(Game game) {
        this.checkGameMineAndExamined(game);
        this.sendCommand("forward 9999");
    }

    public void showServerHelp() {
        this.sendCommand("help");
    }

    public void sendHelpQuestion(String string) {
        this.sendCommand("tell 1 * " + string);
    }

    public SeekListenerManager getSeekListenerManager() {
        return this.getChessclubListenerManager();
    }

    void notFirstListenerAdded(SeekListener seekListener) {
        Enumeration enumeration = this.seeks.elements();
        while (enumeration.hasMoreElements()) {
            Seek seek = (Seek)enumeration.nextElement();
            SeekEvent seekEvent = new SeekEvent((SeekConnection)this, 1, seek);
            seekListener.seekAdded(seekEvent);
        }
    }

    void lastSeekListenerRemoved() {
        this.seeks.clear();
    }

    private void processSeekDG(Datagram datagram) {
        int n = datagram.getInteger(0);
        String string = datagram.getString(1);
        String string2 = datagram.getString(2);
        int n2 = datagram.getInteger(3);
        int n3 = datagram.getInteger(4);
        int n4 = datagram.getInteger(5);
        String string3 = datagram.getString(6);
        int n5 = datagram.getInteger(7);
        int n6 = datagram.getInteger(8);
        boolean bl = datagram.getBoolean(9);
        int n7 = datagram.getInteger(10);
        int n8 = datagram.getInteger(11);
        int n9 = datagram.getInteger(12);
        boolean bl2 = datagram.getBoolean(13);
        boolean bl3 = datagram.getBoolean(14);
        String string4 = datagram.getString(15);
        this.processSeek(n, string, string2, n2, n3, n4, string3, n5, n6, bl, n7, n8, n9, bl2, bl3, string4);
    }

    protected void processSeek(int n, String string, String string2, int n2, int n3, int n4, String string3, int n5, int n6, boolean bl, int n7, int n8, int n9, boolean bl2, boolean bl3, String string4) {
        boolean bl4;
        WildVariant wildVariant = this.getVariant(n4);
        if (wildVariant == null) {
            return;
        }
        boolean bl5 = bl4 = n3 != 2;
        Object object = n7 == 1 ? Player.WHITE_PLAYER : (n7 == 0 ? Player.BLACK_PLAYER : null);
        boolean bl6 = n2 != 0;
        boolean bl7 = !JinChessclubConnection.isUnrated(string2);
        boolean bl8 = JinChessclubConnection.isComputer(string2);
        boolean bl9 = n8 != 0 || n9 != 9999;
        String string5 = JinChessclubConnection.displayableTitle(string2);
        Seek seek = new Seek(String.valueOf(n), string, string5, n2, bl4, bl6, bl7, bl8, wildVariant, string3, n5 * 60 * 1000, n6 * 1000, bl, object, bl9, n8, n9, !bl2, bl3);
        this.seeks.put(new Integer(n), seek);
        this.listenerManager.fireSeekEvent(new SeekEvent((SeekConnection)this, 1, seek));
    }

    private void processSeekRemovedDG(Datagram datagram) {
        this.processSeekRemoved(datagram.getInteger(0), datagram.getInteger(1));
    }

    protected void processSeekRemoved(int n, int n2) {
        Seek seek = (Seek)this.seeks.remove(new Integer(n));
        if (seek == null) {
            return;
        }
        this.listenerManager.fireSeekEvent(new SeekEvent((SeekConnection)this, 2, seek));
    }

    public void acceptSeek(Seek seek) {
        if (!this.seeks.contains(seek)) {
            throw new IllegalArgumentException("The specified seek is not on the seek list");
        }
        this.sendCommand("play " + seek.getID());
    }

    public void issueSeek(UserSeek userSeek) {
        int n = this.getWildNumber(userSeek.getVariant());
        if (n == -1) {
            throw new IllegalArgumentException("Unsupported sought wild variant: " + userSeek.getVariant());
        }
        Player player = userSeek.getColor();
        String string = "seek " + userSeek.getTime() + " " + userSeek.getInc() + " " + (userSeek.isRated() ? "r" : "u") + " " + "w" + n + " " + (player == null ? "" : (player.isWhite() ? "white " : "black ")) + (userSeek.isManualAccept() ? "manual " : "auto ") + (userSeek.getMinRating() == Integer.MIN_VALUE ? "0" : String.valueOf(userSeek.getMinRating())) + "-" + (userSeek.getMaxRating() == Integer.MAX_VALUE ? "9999" : String.valueOf(userSeek.getMaxRating())) + " " + (userSeek.isFormula() ? "f" : "");
        this.sendCommand(string);
    }

    public GameListListenerManager getGameListListenerManager() {
        return this.getChessclubListenerManager();
    }

    private void processGamelistBeginDG(Datagram datagram) {
        this.processGamelistBegin(datagram.getString(0), datagram.getString(1), datagram.getInteger(2), datagram.getInteger(3), datagram.getInteger(4), datagram.getString(5));
    }

    protected void processGamelistBegin(String string, String string2, int n, int n2, int n3, String string3) {
        int n4;
        if (string.equalsIgnoreCase("history")) {
            n4 = 1;
        } else if (string.equalsIgnoreCase("search")) {
            n4 = 2;
        } else if (string.equalsIgnoreCase("liblist")) {
            n4 = 3;
        } else if (string.equalsIgnoreCase("stored")) {
            n4 = 4;
        } else {
            return;
        }
        this.curGameListInfo = new GameListInfo(n4, string, string2, n, n2, n3, string3);
    }

    private void processGamelistItemDG(Datagram datagram) {
        int n = datagram.getInteger(0);
        String string = datagram.getString(1);
        String string2 = datagram.getString(2);
        String string3 = datagram.getString(3);
        String string4 = datagram.getString(4);
        String string5 = datagram.getString(5);
        int n2 = datagram.getString(6).equals("?") ? -1 : datagram.getInteger(6);
        String string6 = datagram.getString(7);
        int n3 = datagram.getString(8).equals("?") ? -1 : datagram.getInteger(8);
        boolean bl = datagram.getBoolean(9);
        int n4 = datagram.getInteger(10);
        int n5 = datagram.getInteger(11);
        int n6 = datagram.getInteger(12);
        int n7 = datagram.getInteger(13);
        int n8 = datagram.getInteger(14);
        int n9 = datagram.getInteger(15);
        String string7 = datagram.getString(16);
        int n10 = datagram.getInteger(17);
        boolean bl2 = datagram.getInteger(18) == 1;
        int n11 = datagram.getInteger(19);
        String string8 = datagram.getString(20);
        boolean bl3 = datagram.getBoolean(21);
        this.processGamelistItem(n, string, string2, string3, string4, string5, n2, string6, n3, bl, n4, n5, n6, n7, n8, n9, string7, n10, bl2, n11, string8, bl3);
    }

    protected void processGamelistItem(int n, String string, String string2, String string3, String string4, String string5, int n2, String string6, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, int n9, String string7, int n10, boolean bl2, int n11, String string8, boolean bl3) {
        String string9;
        SearchListItem searchListItem;
        Object object;
        int n12;
        if (this.curGameListInfo == null) {
            return;
        }
        String string10 = "w" + n5;
        String string11 = this.getRatingCategoryName(n4);
        String string12 = this.getEndExplanationString(n10, n11, bl2);
        switch (n10) {
            case 0: {
                if (bl2) {
                    n12 = 1;
                    break;
                }
                n12 = 0;
                break;
            }
            case 1: {
                n12 = 2;
                break;
            }
            case 2: {
                n12 = 3;
                break;
            }
            case 3: {
                n12 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown result status encountered");
            }
        }
        switch (this.curGameListInfo.gameListEventID) {
            case 1: {
                if (this.curGameListInfo.args.indexOf(string5) != -1) {
                    object = Player.WHITE_PLAYER;
                } else if (this.curGameListInfo.args.indexOf(string6) != -1) {
                    object = Player.BLACK_PLAYER;
                } else {
                    throw new IllegalArgumentException("Unable to determine the player whose history is being retrieved");
                }
                searchListItem = new HistoryListItem(n, string, string3, string4, string5, string6, n6 * 60 * 1000, n7 * 1000, n8 * 60 * 1000, n9 * 1000, n2, n3, bl, string10, string11, string7, string12, n12, object);
                break;
            }
            case 2: {
                searchListItem = new SearchListItem(n, string, string3, string4, string5, string6, n6 * 60 * 1000, n7 * 1000, n8 * 60 * 1000, n9 * 1000, n2, n3, bl, string10, string11, string7, string12, n12);
                break;
            }
            case 3: {
                searchListItem = new LibListItem(n, string, string3, string4, string5, string6, n6 * 60 * 1000, n7 * 1000, n8 * 60 * 1000, n9 * 1000, n2, n3, bl, string10, string11, string7, string12, n12, string8);
                break;
            }
            case 4: {
                if (this.curGameListInfo.args.indexOf(string5) != -1) {
                    object = Player.WHITE_PLAYER;
                } else if (this.curGameListInfo.args.indexOf(string6) != -1) {
                    object = Player.BLACK_PLAYER;
                } else {
                    throw new IllegalArgumentException("Unable to determine the player whose stored game is being retrieved");
                }
                if (n12 != 3) {
                    throw new IllegalArgumentException("ResultStatus is not \"ADJOURNED\" for a stored game");
                }
                string9 = this.getAdjournmentReason(n11, bl2 ? string5 : string6);
                searchListItem = new StoredListItem(n, string, string3, string4, string5, string6, n6 * 60 * 1000, n7 * 1000, n8 * 60 * 1000, n9 * 1000, n2, n3, bl, string10, string11, string7, bl3, string9, object);
                break;
            }
            default: {
                throw new IllegalStateException("Attempted to create a GameListInfo with an unknown item type");
            }
        }
        this.curGameListInfo.gameList[this.curGameListInfo.gameList.length - this.curGameListInfo.numItemsLeft] = searchListItem;
        --this.curGameListInfo.numItemsLeft;
        if (this.curGameListInfo.numItemsLeft == 0) {
            object = this.curGameListInfo.summary + " (" + this.curGameListInfo.command + " " + this.curGameListInfo.args + ")";
            string9 = new GameListEvent((Connection)this, this.curGameListInfo.gameListEventID, this.curGameListInfo.gameList, (String)object, this.curGameListInfo.totalNumItems, this.curGameListInfo.firstIndex, this.curGameListInfo.lastIndex);
            this.listenerManager.fireGameListEvent((GameListEvent)string9);
            this.curGameListInfo = null;
        }
    }

    protected String getEndExplanationString(int n, int n2, boolean bl) {
        I18n i18n = I18n.get(this.getClass());
        String string = i18n.getString("whitePlayer");
        String string2 = i18n.getString("blackPlayer");
        String string3 = bl ? string2 : string;
        String string4 = bl ? string : string2;
        String string5 = bl ? "(0-1)" : "(1-0)";
        try {
            String string6 = "gameEndExplanationS" + n + "M" + n2;
            return i18n.getFormattedString(string6, new Object[]{string3, string4, string5});
        }
        catch (MissingResourceException missingResourceException) {
            return i18n.getString("defaultGameEndExplanation");
        }
    }

    protected String getAdjournmentReason(int n, String string) {
        I18n i18n = I18n.get(this.getClass());
        try {
            String string2 = "adjournmentReason" + n;
            return i18n.getFormattedString(string2, new Object[]{string});
        }
        catch (MissingResourceException missingResourceException) {
            return "";
        }
    }

    private void processTourneyDG(Datagram datagram) {
        int n = datagram.getInteger(0);
        int n2 = datagram.getInteger(1);
        boolean bl = (n2 & 1) != 0;
        boolean bl2 = (n2 & 2) != 0;
        boolean bl3 = (n2 & 4) != 0;
        boolean bl4 = (n2 & 8) != 0;
        String string = datagram.getString(2);
        String[] stringArray = JinChessclubConnection.parseDGTourneyCommandList(datagram.getString(3));
        String[] stringArray2 = JinChessclubConnection.parseDGTourneyCommandList(datagram.getString(4));
        String[] stringArray3 = JinChessclubConnection.parseDGTourneyCommandList(datagram.getString(5));
        String string2 = datagram.getString(6);
        this.processTourney(n, bl, bl2, bl3, bl4, string, stringArray, stringArray2, stringArray3, string2);
    }

    private static String[] parseDGTourneyCommandList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            int n2 = string2.length();
            int n3 = 0;
            while (n3 < n2) {
                if (string2.charAt(n3) == '\\') {
                    stringBuffer.append(string2.charAt(n3 + 1));
                    n3 += 2;
                    continue;
                }
                stringBuffer.append(string2.charAt(n3));
                ++n3;
            }
            stringArray[n++] = stringBuffer.toString();
        }
        return stringArray;
    }

    protected void processTourney(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String string2) {
        ChessEvent chessEvent = new ChessEvent(n, string, stringArray.length == 0 ? null : stringArray, stringArray2.length == 0 ? null : stringArray2, stringArray3.length == 0 ? null : stringArray3, string2);
        ChessEvent chessEvent2 = this.chessEvents.put(new Integer(n), chessEvent);
        if (chessEvent2 != null) {
            this.listenerManager.fireChessEventEvent(new ChessEventEvent(this, 2, chessEvent2));
        }
        this.listenerManager.fireChessEventEvent(new ChessEventEvent(this, 1, chessEvent));
    }

    private void processRemoveTourneyDG(Datagram datagram) {
        this.processRemoveTourney(datagram.getInteger(0));
    }

    protected void processRemoveTourney(int n) {
        ChessEvent chessEvent = (ChessEvent)this.chessEvents.get(new Integer(n));
        if (chessEvent == null) {
            return;
        }
        this.listenerManager.fireChessEventEvent(new ChessEventEvent(this, 2, chessEvent));
    }

    public void execRunnable(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    private static class GameListInfo {
        public final int gameListEventID;
        public final String command;
        public final String args;
        public final int totalNumItems;
        public final int firstIndex;
        public final int lastIndex;
        public final String summary;
        public int numItemsLeft;
        public final GameListItem[] gameList;

        public GameListInfo(int n, String string, String string2, int n2, int n3, int n4, String string3) {
            Class clazz;
            this.gameListEventID = n;
            this.command = string;
            this.args = string2;
            this.totalNumItems = n2;
            this.firstIndex = n3;
            this.lastIndex = n4;
            this.summary = string3;
            this.numItemsLeft = n4 - n3 + 1;
            switch (this.gameListEventID) {
                case 1: {
                    clazz = class$free$jin$HistoryListItem == null ? (class$free$jin$HistoryListItem = JinChessclubConnection.class$("free.jin.HistoryListItem")) : class$free$jin$HistoryListItem;
                    break;
                }
                case 2: {
                    clazz = class$free$jin$SearchListItem == null ? (class$free$jin$SearchListItem = JinChessclubConnection.class$("free.jin.SearchListItem")) : class$free$jin$SearchListItem;
                    break;
                }
                case 3: {
                    clazz = class$free$jin$LibListItem == null ? (class$free$jin$LibListItem = JinChessclubConnection.class$("free.jin.LibListItem")) : class$free$jin$LibListItem;
                    break;
                }
                case 4: {
                    clazz = class$free$jin$StoredListItem == null ? (class$free$jin$StoredListItem = JinChessclubConnection.class$("free.jin.StoredListItem")) : class$free$jin$StoredListItem;
                    break;
                }
                default: {
                    throw new IllegalStateException("Attempted to create a GameListInfo with an unknown item type");
                }
            }
            this.gameList = (GameListItem[])Array.newInstance(clazz, this.numItemsLeft);
        }
    }

    private static class GameInfo {
        public final Game game;
        public final Position position;
        public final Vector moves;
        public int numMovesToFollow;
        public boolean isFlipped;
        private int whiteTime;
        private boolean isWhiteRunning;
        private long whiteTimestamp;
        private int blackTime;
        private boolean isBlackRunning;
        private long blackTimestamp;
        private final Hashtable offers = new Hashtable();
        private int whiteTakeback;
        private int blackTakeback;

        public GameInfo(Game game, Position position, int n) {
            this.game = game;
            this.position = position;
            this.moves = new Vector();
            this.numMovesToFollow = n;
            this.isFlipped = game.isBoardInitiallyFlipped();
            this.setWhiteClock(game.getWhiteTime(), false);
            this.setBlackClock(game.getBlackTime(), false);
        }

        public void setWhiteClock(int n, boolean bl) {
            this.whiteTime = n;
            this.isWhiteRunning = bl;
            this.whiteTimestamp = System.currentTimeMillis();
        }

        public void setBlackClock(int n, boolean bl) {
            this.blackTime = n;
            this.isBlackRunning = bl;
            this.blackTimestamp = System.currentTimeMillis();
        }

        public int getWhiteTime() {
            return this.whiteTime;
        }

        public boolean isWhiteClockRunning() {
            return this.isWhiteRunning;
        }

        public long getWhiteTimestamp() {
            return this.whiteTimestamp;
        }

        public int getBlackTime() {
            return this.blackTime;
        }

        public boolean isBlackClockRunning() {
            return this.isBlackRunning;
        }

        public long getBlackTimestamp() {
            return this.blackTimestamp;
        }

        public void setOffer(int n, Player player, boolean bl) {
            Pair pair = new Pair((Object)player, (Object)new Integer(n));
            if (bl) {
                this.offers.put(pair, pair);
            } else {
                this.offers.remove(pair);
            }
        }

        public void setTakebackOffer(Player player, int n) {
            if (player.isWhite()) {
                this.whiteTakeback = n;
            } else {
                this.blackTakeback = n;
            }
        }

        public boolean isOfferred(int n, Player player) {
            return this.offers.containsKey(new Pair((Object)player, (Object)new Integer(n)));
        }

        public int getTakebackOffer(Player player) {
            if (player.isWhite()) {
                return this.whiteTakeback;
            }
            return this.blackTakeback;
        }
    }
}

