/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.spreadsheet;

import com.projectlibre1.association.InvalidAssociationException;
import com.projectlibre1.datatype.Duration;
import com.projectlibre1.field.Field;
import com.projectlibre1.field.FieldParseException;
import com.projectlibre1.graphic.configuration.ActionList;
import com.projectlibre1.graphic.configuration.CellStyle;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.pm.dependency.Dependency;
import com.projectlibre1.pm.dependency.DependencyService;
import com.projectlibre1.pm.dependency.DependencyType;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetColumnModel;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetUtils;
import com.projectlibre1.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projectlibre1.util.ClassUtils;
import com.projectlibre1.util.Environment;
import java.util.LinkedList;

public class SpreadSheetModel
extends CommonSpreadSheetModel {
    protected boolean readOnly;

    public SpreadSheetModel(NodeModelCache nodeModelCache, SpreadSheetColumnModel spreadSheetColumnModel, CellStyle cellStyle, ActionList actionList) {
        super(nodeModelCache, spreadSheetColumnModel, cellStyle, actionList);
    }

    @Override
    public int getColumnCount() {
        return this.colModel.getFieldColumnCount();
    }

    @Override
    public Field getFieldInColumn(int n) {
        return SpreadSheetUtils.getFieldInColumn(n, this.colModel);
    }

    public Field getFieldInNonTranslatedColumn(int n) {
        return this.colModel.getFieldInNonTranslatedColumn(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return SpreadSheetUtils.getValueAt(n, n2, this.getRowMultiple(), this.cache, this.colModel, this.fieldContext);
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "";
        }
        return this.getFieldInColumn(n).getName();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.isReadOnly()) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        Field field = this.getFieldInColumn(n2);
        boolean bl = "Field.userRole".equals(field.getId());
        NodeModel nodeModel = this.getCache().getModel();
        if (!(nodeModel.isLocal() || nodeModel.isMaster() || Environment.getStandAlone() || bl)) {
            return;
        }
        Object object2 = this.getValueAt(n, n2);
        if (object2 == null && "".equals(object)) {
            return;
        }
        Node node = this.getNodeInRow(n);
        try {
            if (node.isVoid()) {
                if (object == null) {
                    this.getCache().getModel().setFieldValue(field, node, this, object, this.fieldContext, 3);
                } else {
                    Node node2;
                    LinkedList linkedList = this.getPreviousVisibleNodesFromRow(n);
                    if (linkedList != null && (node2 = this.getNextNonVoidSiblingFromRow(n)) != null && node2.getParent() == linkedList.getFirst()) {
                        linkedList = null;
                    }
                    this.getCache().getModel().replaceImplAndSetFieldValue(node, linkedList, this.getFieldInColumn(n2), this, object, this.fieldContext, 3);
                }
            } else if (node.getImpl() instanceof Dependency) {
                Dependency dependency = (Dependency)node.getImpl();
                DependencyService dependencyService = DependencyService.getInstance();
                try {
                    Duration duration = (Duration)(n2 == 4 ? object : this.getValueAt(n, 4));
                    int n3 = DependencyType.mapStringToValue((String)(n2 == 3 ? object : this.getValueAt(n, 3)));
                    dependencyService.setFields(dependency, duration.getEncodedMillis(), n3, this);
                    dependencyService.update(dependency, this);
                }
                catch (InvalidAssociationException invalidAssociationException) {
                    invalidAssociationException.printStackTrace();
                }
            } else {
                this.getCache().getModel().setFieldValue(field, node, this, object, this.fieldContext, 3);
            }
        }
        catch (FieldParseException fieldParseException) {
            throw new RuntimeException(fieldParseException);
        }
    }

    @Override
    public boolean isRowEditable(int n) {
        if (this.isReadOnly()) {
            return false;
        }
        NodeModel nodeModel = this.getCache().getModel();
        Node node = this.getNodeInRow(n);
        if (node.isVoid()) {
            return true;
        }
        return !ClassUtils.isObjectReadOnly(node.getImpl());
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.isReadOnly()) {
            return false;
        }
        if (n2 == 0) {
            return false;
        }
        Field field = this.getFieldInColumn(n2);
        if (field.getLookupTypes() != null) {
            return false;
        }
        Node node = this.getNodeInRow(n);
        NodeModel nodeModel = this.getCache().getModel();
        if (node.isVoid() && !nodeModel.isLocal() && !nodeModel.isMaster() && "Field.userRole".equals(field.getId())) {
            return false;
        }
        if (node.isVoid()) {
            return true;
        }
        return !field.isReadOnly(node, this.getCache().getWalkersModel(), null);
    }

    private int findFieldColumn(Field field) {
        return this.colModel.findFieldColumn(field);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }
}

