/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.report.XmlReportOutputter;
import org.apache.ivy.util.FileUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTProcess;

public class IvyRepositoryReport
extends IvyTask {
    private String organisation = "*";
    private String module;
    private String branch;
    private String revision = "latest.integration";
    private String matcher = "exactOrRegexp";
    private File todir;
    private boolean graph = false;
    private boolean dot = false;
    private boolean xml = true;
    private boolean xsl = false;
    private String xslFile;
    private String outputname = "ivy-repository-report";
    private String xslext = "html";
    private List params = new ArrayList();

    @Override
    public void doExecute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        if (this.xsl && this.xslFile == null) {
            throw new BuildException("xsl file is mandatory when using xsl generation");
        }
        if (this.module == null && "exact".equals(this.matcher)) {
            throw new BuildException("no module name provided for ivy repository graph task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this.module == null && !"exact".equals(this.matcher)) {
            this.module = "*";
        }
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(this.organisation, this.module, this.revision);
        try {
            ModuleRevisionId moduleRevisionId2 = null;
            moduleRevisionId2 = this.revision == null || ivySettings.getVersionMatcher().isDynamic(moduleRevisionId) ? new ModuleRevisionId(new ModuleId(this.organisation, this.module), this.branch, "*") : new ModuleRevisionId(new ModuleId(this.organisation, this.module), this.branch, this.revision);
            ModuleRevisionId[] moduleRevisionIdArray = ivy.listModules(moduleRevisionId2, ivySettings.getMatcher(this.matcher));
            HashSet<ModuleRevisionId> hashSet = new HashSet<ModuleRevisionId>();
            for (int i = 0; i < moduleRevisionIdArray.length; ++i) {
                hashSet.add(ModuleRevisionId.newInstance(moduleRevisionIdArray[i], this.revision));
            }
            moduleRevisionIdArray = hashSet.toArray(new ModuleRevisionId[hashSet.size()]);
            DefaultModuleDescriptor defaultModuleDescriptor = DefaultModuleDescriptor.newCallerInstance(moduleRevisionIdArray, true, false);
            String string = ResolveOptions.getDefaultResolveId(defaultModuleDescriptor);
            ResolveReport resolveReport = ivy.resolve(defaultModuleDescriptor, new ResolveOptions().setResolveId(string).setValidate(this.doValidate(ivySettings)));
            ResolutionCacheManager resolutionCacheManager = this.getIvyInstance().getResolutionCacheManager();
            new XmlReportOutputter().output(resolveReport, resolutionCacheManager, new ResolveOptions());
            if (this.graph) {
                this.gengraph(resolutionCacheManager, defaultModuleDescriptor.getModuleRevisionId().getOrganisation(), defaultModuleDescriptor.getModuleRevisionId().getName());
            }
            if (this.dot) {
                this.gendot(resolutionCacheManager, defaultModuleDescriptor.getModuleRevisionId().getOrganisation(), defaultModuleDescriptor.getModuleRevisionId().getName());
            }
            if (this.xml) {
                FileUtil.copy(resolutionCacheManager.getConfigurationResolveReportInCache(string, "default"), new File(this.getTodir(), this.outputname + ".xml"), null);
            }
            if (this.xsl) {
                this.genreport(resolutionCacheManager, defaultModuleDescriptor.getModuleRevisionId().getOrganisation(), defaultModuleDescriptor.getModuleRevisionId().getName());
            }
        }
        catch (Exception exception) {
            throw new BuildException("impossible to generate graph for " + moduleRevisionId + ": " + exception, (Throwable)exception);
        }
    }

    private void genreport(ResolutionCacheManager resolutionCacheManager, String string, String string2) throws IOException {
        XSLTProcess xSLTProcess = new XSLTProcess();
        xSLTProcess.setTaskName(this.getTaskName());
        xSLTProcess.setProject(this.getProject());
        xSLTProcess.init();
        String string3 = ResolveOptions.getDefaultResolveId(new ModuleId(string, string2));
        xSLTProcess.setIn(resolutionCacheManager.getConfigurationResolveReportInCache(string3, "default"));
        xSLTProcess.setOut(new File(this.getTodir(), this.outputname + "." + this.xslext));
        xSLTProcess.setStyle(this.xslFile);
        XSLTProcess.Param param2 = xSLTProcess.createParam();
        param2.setName("extension");
        param2.setExpression(this.xslext);
        for (XSLTProcess.Param param2 : this.params) {
            XSLTProcess.Param param3 = xSLTProcess.createParam();
            param3.setName(param2.getName());
            param3.setExpression(param2.getExpression());
        }
        xSLTProcess.execute();
    }

    private void gengraph(ResolutionCacheManager resolutionCacheManager, String string, String string2) throws IOException {
        this.gen(resolutionCacheManager, string, string2, this.getGraphStylePath(resolutionCacheManager.getResolutionCacheRoot()), "graphml");
    }

    private String getGraphStylePath(File file) throws IOException {
        File file2 = new File(file, "ivy-report-graph-all.xsl");
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report-graph-all.xsl"), file2, null);
        return file2.getAbsolutePath();
    }

    private void gendot(ResolutionCacheManager resolutionCacheManager, String string, String string2) throws IOException {
        this.gen(resolutionCacheManager, string, string2, this.getDotStylePath(resolutionCacheManager.getResolutionCacheRoot()), "dot");
    }

    private String getDotStylePath(File file) throws IOException {
        File file2 = new File(file, "ivy-report-dot-all.xsl");
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report-dot-all.xsl"), file2, null);
        return file2.getAbsolutePath();
    }

    private void gen(ResolutionCacheManager resolutionCacheManager, String string, String string2, String string3, String string4) throws IOException {
        XSLTProcess xSLTProcess = new XSLTProcess();
        xSLTProcess.setTaskName(this.getTaskName());
        xSLTProcess.setProject(this.getProject());
        xSLTProcess.init();
        String string5 = ResolveOptions.getDefaultResolveId(new ModuleId(string, string2));
        xSLTProcess.setIn(resolutionCacheManager.getConfigurationResolveReportInCache(string5, "default"));
        xSLTProcess.setOut(new File(this.getTodir(), this.outputname + "." + string4));
        xSLTProcess.setBasedir(resolutionCacheManager.getResolutionCacheRoot());
        xSLTProcess.setStyle(string3);
        xSLTProcess.execute();
    }

    public File getTodir() {
        if (this.todir == null && this.getProject() != null) {
            return this.getProject().getBaseDir();
        }
        return this.todir;
    }

    public void setTodir(File file) {
        this.todir = file;
    }

    public boolean isGraph() {
        return this.graph;
    }

    public void setGraph(boolean bl) {
        this.graph = bl;
    }

    public String getXslfile() {
        return this.xslFile;
    }

    public void setXslfile(String string) {
        this.xslFile = string;
    }

    public boolean isXml() {
        return this.xml;
    }

    public void setXml(boolean bl) {
        this.xml = bl;
    }

    public boolean isXsl() {
        return this.xsl;
    }

    public void setXsl(boolean bl) {
        this.xsl = bl;
    }

    public String getXslext() {
        return this.xslext;
    }

    public void setXslext(String string) {
        this.xslext = string;
    }

    public XSLTProcess.Param createParam() {
        XSLTProcess.Param param = new XSLTProcess.Param();
        this.params.add(param);
        return param;
    }

    public String getOutputname() {
        return this.outputname;
    }

    public void setOutputname(String string) {
        this.outputname = string;
    }

    public void setCache(File file) {
        this.cacheAttributeNotSupported();
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String string) {
        this.matcher = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public boolean isDot() {
        return this.dot;
    }

    public void setDot(boolean bl) {
        this.dot = bl;
    }
}

