/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff.actions;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbdiff.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbdiff.actions.AbstractDiffAction;
import net.sourceforge.squirrel_sql.plugins.dbdiff.commands.CompareCommand;
import net.sourceforge.squirrel_sql.plugins.dbdiff.gui.DiffPresentationFactoryImpl;

public class CompareAction
extends AbstractDiffAction
implements ISessionAction {
    private static final long serialVersionUID = 1L;
    private final SessionInfoProvider sessionInfoProv;
    private static final ILogger log = LoggerController.createLogger(CompareAction.class);

    public CompareAction(IApplication app, Resources rsrc, SessionInfoProvider prov) {
        super(app, rsrc);
        this.sessionInfoProv = prov;
    }

    public void actionPerformed(ActionEvent evt) {
        ISession sourceSession = this.sessionInfoProv.getSourceSession();
        ISession destSession = this.sessionInfoProv.getDestSession();
        IObjectTreeAPI api = destSession.getObjectTreeAPIOfActiveSessionWindow();
        if (api == null) {
            return;
        }
        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
        boolean clearSource = false;
        if (this.sourceExists()) {
            this.sessionInfoProv.setDestSelectedDatabaseObjects(dbObjs);
            clearSource = true;
        } else if (dbObjs.length == 2) {
            this.sessionInfoProv.setSourceSession(destSession);
            this.sessionInfoProv.setSourceSelectedDatabaseObjects(new IDatabaseObjectInfo[]{dbObjs[0]});
            this.sessionInfoProv.setDestSession(destSession);
            this.sessionInfoProv.setDestSelectedDatabaseObjects(new IDatabaseObjectInfo[]{dbObjs[1]});
            clearSource = true;
        } else {
            destSession.showErrorMessage("To compare, you must have exactly two tables selected in the object tree");
        }
        if (this.sessionInfoProv.getSourceSession() == null) {
            log.error((Object)"actionPerformed: Source session was null - A source session must be selected to perform a comparison.");
            return;
        }
        if (this.sessionInfoProv.getDestSession() == null) {
            log.error((Object)"actionPerformed: Source session was null - A destination session must be selected to perform a comparison.");
            return;
        }
        CompareCommand command = new CompareCommand(this.sessionInfoProv);
        DiffPresentationFactoryImpl diffPresentationFactory = new DiffPresentationFactoryImpl();
        command.setDiffPresentationFactory(diffPresentationFactory);
        command.setPluginPreferencesManager(this.pluginPreferencesManager);
        command.execute();
        if (clearSource) {
            this.sessionInfoProv.setSourceSelectedDatabaseObjects(new IDatabaseObjectInfo[0]);
        }
    }

    private boolean sourceExists() {
        return this.sessionInfoProv.getSourceSession() != null && null != this.sessionInfoProv.getSourceSelectedDatabaseObjects() && 0 < this.sessionInfoProv.getSourceSelectedDatabaseObjects().length;
    }

    public void setSession(ISession session) {
        this.sessionInfoProv.setDestSession(session);
    }
}

