/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.OptionalSqlClause;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;

public class ProgressDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private final ProgressDialectHelper _dialect = new ProgressDialectHelper();

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        return this._dialect.getTypeName(code, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return true;
    }

    @Override
    public String getLengthFunction(int dataType) {
        return "length";
    }

    @Override
    public String getMaxFunction() {
        return "max";
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 6) {
            return 15;
        }
        return 32;
    }

    @Override
    public int getMaxScale(int dataType) {
        return this.getMaxPrecision(dataType);
    }

    @Override
    public int getPrecisionDigits(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public int getColumnLength(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public String getDisplayName() {
        return "Progress";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase().startsWith("progress") || databaseProductName.trim().toLowerCase().startsWith("openedge");
    }

    public String[] getColumnAddSQL(TableColumnInfo info) throws UnsupportedOperationException {
        return new String[]{"Column add not yet supported"};
    }

    @Override
    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getColumnDropSQL(tableName, columnName, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, false, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{DialectUtils.getAddPrimaryKeySQL(ti, pkName, columns, false, qualifier, prefs, this)};
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        boolean featureId = false;
        String msg = DialectUtils.getUnsupportedMessage(this, 0);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ ALTER COLUMN $columnName$ SET $nullable$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", info.getTableName(), "columnName", info.getColumnName());
        if (info.isNullable().equalsIgnoreCase("YES")) {
            valuesMap.put("nullable", "NULL");
        } else {
            valuesMap.put("nullable", "NOT NULL");
        }
        return new String[]{DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs)};
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ RENAME COLUMN $oldColumnName$ to $newColumnName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", from.getTableName(), "oldColumnName", from.getColumnName(), "newColumnName", to.getColumnName());
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        boolean featureId = false;
        String msg = DialectUtils.getUnsupportedMessage(this, 0);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = null;
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", info.getTableName(), "columnName", info.getColumnName());
        if (info.getDefaultValue() != null) {
            st = new StringTemplate("ALTER TABLE $tableName$ ALTER $columnName$ SET DEFAULT $defaultValue$");
            if (JDBCTypeMapper.isNumberType(info.getDataType())) {
                valuesMap.put("defaultValue", info.getDefaultValue());
            } else {
                valuesMap.put("defaultValue", "'" + info.getDefaultValue() + "'");
            }
        } else {
            st = new StringTemplate("ALTER TABLE $tableName$ ALTER $columnName$ DROP DEFAULT");
        }
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 7;
        String msg = DialectUtils.getUnsupportedMessage(this, 7);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.PROGRESS;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String[] getIndexStorageOptions() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 16;
        String msg = DialectUtils.getUnsupportedMessage(this, 16);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = false;
        boolean addNullClause = true;
        return new String[]{DialectUtils.getAddColumSQL(column, this, true, false, true, qualifier, prefs)};
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean deferrableNotSupported = null;
        Boolean initiallyDeferredNotSupported = null;
        Boolean matchFullNotSupported = null;
        return DialectUtils.getAddForeignKeyConstraintSQL(localTableName, refTableName, constraintName, deferrableNotSupported, initiallyDeferredNotSupported, matchFullNotSupported, autoFKIndex, fkIndexName, localRefColumns, onUpdateAction, onDeleteAction, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "ALTER TABLE $tableName$ ADD CONSTRAINT $constraintName$ UNIQUE ($columnName;  separator=\",\"$)";
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ ADD CONSTRAINT $constraintName$ UNIQUE ($columnName;  separator=\",\"$)");
        String constraintNameValue = prefs.isQuoteConstraintNames() ? DialectUtils.shapeIdentifier(constraintName, prefs, this) : constraintName;
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", tableName, "constraintName", constraintNameValue);
        return new String[]{DialectUtils.getAddUniqueConstraintSQL(st, valuesMap, columns, qualifier, prefs, (HibernateDialect)this)};
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getSimulatedAlterSequenceSQL(sequenceName, increment, minimum, maximum, minimum, cache, cycle, qualifier, prefs, this);
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("CREATE ");
        if (unique) {
            result.append("UNIQUE ");
        }
        result.append(" INDEX ");
        result.append(indexName);
        result.append(" ON ");
        result.append(DialectUtils.shapeQualifiableIdentifier(tableName, qualifier, prefs, this));
        result.append("(");
        for (String column : columns) {
            result.append(column);
            result.append(",");
        }
        result.setLength(result.length() - 1);
        result.append(")");
        return result.toString();
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "CREATE SEQUENCE $sequenceName$ $startWith$ $increment$ $minimum$ $maximum$ $cache$ $cycle$";
        StringTemplate startClauseTemplate = new StringTemplate("START WITH $startWith$ ,");
        OptionalSqlClause startClause = new OptionalSqlClause(startClauseTemplate, "startWith", start);
        StringTemplate incrementByClauseTemplate = new StringTemplate("INCREMENT BY $incrementBy$ ,");
        OptionalSqlClause incrementClause = new OptionalSqlClause(incrementByClauseTemplate, "incrementBy", increment);
        StringTemplate maxClauseTemplate = new StringTemplate("MAXVALUE $maximum$ ,");
        OptionalSqlClause maxClause = new OptionalSqlClause(maxClauseTemplate, "maximum", maximum);
        StringTemplate minClauseTemplate = new StringTemplate("MINVALUE $minimum$ ,");
        OptionalSqlClause minClause = new OptionalSqlClause(minClauseTemplate, "minimum", minimum);
        StringTemplate st = new StringTemplate("CREATE SEQUENCE $sequenceName$ $startWith$ $increment$ $minimum$ $maximum$ $cache$ $cycle$");
        st.setAttribute("sequenceName", (Object)("PUB." + sequenceName));
        st.setAttribute("startWith", (Object)startClause.toString());
        st.setAttribute("increment", (Object)incrementClause.toString());
        st.setAttribute("maximum", (Object)maxClause.toString());
        st.setAttribute("minimum", (Object)minClause.toString());
        if (cycle) {
            st.setAttribute("cycle", (Object)"CYCLE");
        } else {
            st.setAttribute("cycle", (Object)"NOCYCLE");
        }
        return st.toString();
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE VIEW $viewName$ AS $selectStatement$ $withCheckOption$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("viewName", viewName, "selectStatement", definition);
        if (checkOption != null) {
            valuesMap.put("withcheckOption", "WITH CHECK OPTION");
        }
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropConstraintSQL(tableName, constraintName, qualifier, prefs, this);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP INDEX $indexName$ ON $tableName$");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("indexName", indexName);
        valuesMap.put("tableName", tableName);
        return DialectUtils.bindAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        DatabaseObjectQualifier pubQualifier = new DatabaseObjectQualifier(qualifier.getCatalog(), "PUB");
        SqlGenerationPreferences pubPrefs = new SqlGenerationPreferences();
        pubPrefs.setQualifyTableNames(true);
        return DialectUtils.getDropSequenceSQL(sequenceName, null, pubQualifier, pubPrefs, this);
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropViewSQL(viewName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $oldObjectName$ RENAME TO $newObjectName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("oldObjectName", oldTableName, "newObjectName", newTableName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{"blah"};
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return "SELECT PUB." + sequenceName + ".CURRVAL, \"SEQ-MAX\", \"SEQ-MIN\", \"USER-MISC\", " + "\"SEQ-INCR\", " + "case \"CYCLE-OK\" " + "when 0 then 0 " + "else 1 " + "end as CYCLE_FLAG " + "FROM SYSPROGRESS.SYSSEQUENCES " + "where \"SEQ-NAME\" = '" + sequenceName + "' ";
    }

    @Override
    public String[] getUpdateSQL(String tableName, String[] setColumns, String[] setValues, String[] fromTables, String[] whereColumns, String[] whereValues, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 24;
        String msg = DialectUtils.getUnsupportedMessage(this, 24);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAccessMethods() {
        return false;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return true;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return true;
    }

    @Override
    public boolean supportsRenameTable() {
        return true;
    }

    @Override
    public boolean supportsRenameView() {
        return false;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return true;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsUpdate() {
        return false;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "SELECT 'CREATE VIEW $viewName$ AS ' || VIEWTEXT FROM SYSPROGRESS.SYSVIEWS where VIEWNAME = '$viewName$' and OWNER = '$schemaName$' ";
        StringTemplate st = new StringTemplate("SELECT 'CREATE VIEW $viewName$ AS ' || VIEWTEXT FROM SYSPROGRESS.SYSVIEWS where VIEWNAME = '$viewName$' and OWNER = '$schemaName$' ");
        st.setAttribute("viewName", (Object)viewName);
        st.setAttribute("schemaName", (Object)qualifier.getSchema());
        return st.toString();
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return qualifier.getSchema() + "." + identifier;
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    @Override
    public boolean supportsDropPrimaryKey() {
        return false;
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return true;
    }

    @Override
    public int getTimestampMaximumFractionalDigits() {
        return 9;
    }

    private class ProgressDialectHelper
    extends Dialect {
        public ProgressDialectHelper() {
            this.registerColumnType(-5, "integer");
            this.registerColumnType(-2, 2000, "binary($l)");
            this.registerColumnType(-2, 31982, "varbinary($l)");
            this.registerColumnType(-2, "lvarbinary($l)");
            this.registerColumnType(-7, "bit");
            this.registerColumnType(2004, "lvarbinary($l)");
            this.registerColumnType(16, "bit");
            this.registerColumnType(1, 2000, "char($l)");
            this.registerColumnType(1, "char(2000)");
            this.registerColumnType(2005, "varchar($l)");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "numeric($p,2)");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "integer");
            this.registerColumnType(-4, 999999999, "lvarbinary($l)");
            this.registerColumnType(-4, "lvarbinary(999999999)");
            this.registerColumnType(-1, "varchar($l)");
            this.registerColumnType(2, "numeric($p,2)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "date");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, 31982, "varbinary($l)");
            this.registerColumnType(-3, "varbinary(31982)");
            this.registerColumnType(12, 31982, "varchar($l)");
            this.registerColumnType(12, "varchar(31982)");
        }
    }
}

