/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (c): Ruediger Klehn (2015)
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/


package GoGrinder;

import javax.swing.JOptionPane;
import java.nio.charset.*;
import java.io.*;

/**
 * @author  Ruediger Klehn
 */
// this is mainly used for getting the right decoding for SGF files, but if helps 
// also with the decoding of imported tags and testing the decoding preset from the settings file
public class CharsetWorks{
  private String msg = "";
  private final String NL = Main.NEW_LINE;
  private String useCharset = GS.getMyDefaultCharset(); 
  public static String charsetForFolder = "";
  private String currentFolder = "";
  private static String lastFolder = "";
  public File file;
  public static boolean foldersCharsetChanged = false;
  public boolean filesCharsetChanged = false; 
  public static boolean charsetIsValid;
  
  public CharsetWorks(){/*NOTHING*/}
  
  public CharsetWorks(File forFileF){
    file = forFileF;
  }
  
  public CharsetWorks(String forFile){
    file = new File(forFile);
  }

  public CharsetWorks(ProbData problem){ // would this make it easier to read in ChangeCharacterSet()?
    this(problem.getFile()); 
  }

  public String toString(){ // we use this for debugging
    String returnString = "useCharset: " + useCharset + NL 
                         + "charsetForFolder: " + charsetForFolder + NL 
                         + "lastFolder: " + lastFolder + NL 
                         + "currentFolder: " + currentFolder + NL 
                         + "file.toString(): " + file.toString() + NL 
                         + "foldersCharsetChanged (boolean): " + foldersCharsetChanged + NL 
                         + "filesCharsetChanged (boolean): " + filesCharsetChanged;
    return returnString;
  }

  public String getCharset(){ // coming from getSGF()
    String thisFilesCharset = "";
    currentFolder = file.getParent();
 //d.b.g("in getCharset() 1:\n" + toString());
    if (!currentFolder.equals(lastFolder) || foldersCharsetChanged){
 //d.b.g("HIER");
      charsetForFolder = readCharsetForFolder();
      foldersCharsetChanged = false;
      lastFolder = currentFolder;
    }
 //d.b.g("in getCharset() 2:\n" + toString());

    thisFilesCharset = getCharsetForFile(); // in stats folder, overrides all
// if(Main.DEBUG7)d.b.g(file.toString() + " - forFi - " + thisFilesCharset);
    if (!thisFilesCharset.equals("")) return thisFilesCharset;

    thisFilesCharset = getCharsetInFile(); // overrides default ... + folder setting
//if(Main.DEBUG7)d.b.g(file.toString() + " - inFi - " + thisFilesCharset + " - Value is valid: " + charsetIsValid);
    if (!thisFilesCharset.equals("") && charsetIsValid) return thisFilesCharset;

    if(!foldersCharsetChanged)thisFilesCharset = getCharsetForFolder(); // overrides only the default
    else thisFilesCharset = readCharsetForFolder(); // ######### ?? foldersCharsetChanged dann zurcksetzen?
//if(Main.DEBUG7)d.b.g(file.toString() + " - forFo - " + thisFilesCharset);
    if (!thisFilesCharset.equals("")) return thisFilesCharset;

    else{
//if(Main.DEBUG7)d.b.g(GS.getMyDefaultCharset());
      return GS.getMyDefaultCharset();
    }
  }

  private String getStatsParent(){
    String path = file.getPath();
    String subPath = path.substring(Main.pathToProblems.length(), path.length() - (file.getName().length() + 1) ); // clean
    return Main.pathToStats + subPath;
  }

  private String getCharsetFileForFile(){ // just building the name // should come from get/setCharsetForFile
    String fileNameBody = file.getName().substring(0, file.getName().length() - 4);
    String charsetFilePath = getStatsParent() + Main.SLASH + fileNameBody + ".char";
    return charsetFilePath;
  }
  
  public String getCharsetForFile(){ // overrides CharsetForFolder and charsetInFile
    String charsetFile = getCharsetFileForFile();
    if (new File(charsetFile).exists()){
      return FileWReadWrite.readFileLineDefaultCharset(getCharsetFileForFile());
      }
    return "";
  }

  public void resetCharsetForFile(){
    boolean dummy = new File(getCharsetFileForFile()).delete();
  }

  // a file NAME.char in the stats folder overrides charsetForFolder and charsetInFile
  public void setCharsetForFile(String thisCharset){ // should come from ChangeCharacterSet
     boolean result = FileWReadWrite.writeFileLine(getCharsetFileForFile(), thisCharset);
     if (!result) d.b.g("Couldn't write characterset marker for the current file.\n"
                      + "Check the log file for more info!");
  }

  public String getCharsetInFile(){ // (;FF[4]GM[1]CA[utf-8]... -> UTF-8
    String fileContent = "";
    String charsetInFile = ""; // if nothing found, then use: if(folderDefault) then (folderDefault) 
                               // else userDefault / machineDefault
                               // but this all is overwritten by charsetForFile in stats folder

    fileContent = FileWReadWrite.readFileStrCharset(file, "US-ASCII");
    charsetIsValid = false;
    int CAinFile = fileContent.indexOf("CA[");
    if (CAinFile < 0) return ""; // "CA[" not found
    int CAend = fileContent.indexOf("]", CAinFile); 
    if (CAend < 0) return ""; // closing bracket not found - this would be a code error!! - we catch that in the parser
    charsetInFile = fileContent.substring(CAinFile + 3, CAend);
    String returnValue = getGenuineCharset(charsetInFile, true); // true: fromSGF
    if (charsetIsValid) { // decided by getGenuineCharset
      return returnValue; // give back the canonical name: utf-8 -> UTF-8
    }
    else {
      msg ="File: " + file.getPath()
         + "\nCharacterset from file is not supported: " + charsetInFile;
      JOptionPane.showMessageDialog(null, msg);
      GoGrinder.sgf.SGFLog.SGFLog(msg);
      return returnValue; // here it is the default characterset
    }
  }
  
  public String readCharsetForFolder(){
    String charsetFile = getCharsetFileForFolder(); // this way we have less file reading
//    d.b.g("readCharsetForFolder(): \n" + toString());
    if (new File(charsetFile).exists()){ 
//d.b.g("exists");
      charsetForFolder = FileWReadWrite.readFileLineDefaultCharset(charsetFile);
      return charsetForFolder;
      }
//      d.b.g("not exists");
     return "";
  }
  
  public String getCharsetForFolder(){ // here we decide, if we use the saved charset or read the charset from the file
    currentFolder = file.getParent();
// d.b.g("in getCharsetForFolder(), \n" + toString());
    if (currentFolder.equals(lastFolder) && !foldersCharsetChanged ){
      foldersCharsetChanged = false;
      return charsetForFolder;
    }
       // possibly redundant now: 
 //d.b.g("HIER");
    lastFolder = currentFolder;
    foldersCharsetChanged = false;
    return readCharsetForFolder();
  }
  
  private String getCharsetFileForFolder(){ 
    String charsetFile = getStatsParent() + Main.SLASH + "DECODEWITH";
    return charsetFile;
  }
  
  public void setCharsetForFolder(String foldersCharset){  // should come from changeCharset...
      String charsetFileForFolder = getStatsParent() + Main.SLASH + "DECODEWITH";
      boolean result = FileWReadWrite.writeFileLine(charsetFileForFolder, foldersCharset);
  }

  public void resetCharsetForFolder(){
    boolean dummy = new File(getCharsetFileForFolder()).delete();
  }

  public void setUseCharset(String thisCharset){
    useCharset = thisCharset;
  }

  public static String getGenuineCharset(String thisCharset, boolean fromSGF){ // trim, isSupported, canonicalName, else default
    // we use this (at the moment) to check the validity of the Charset string in the grinder.ini
    // and for the Charset string in the sgf
    charsetIsValid = false;
    String returnValue = "";
    thisCharset = thisCharset.trim();
    try{
      if (Charset.isSupported(thisCharset)){
        returnValue = Charset.forName(thisCharset).name();
        charsetIsValid = true;
 //if(Main.DEBUG7)d.b.g("genuine = supported, >" + returnValue + "<");
      }
      else{
        throw new Exception();
      }
    }
    catch (Exception e){
      charsetIsValid = false;
      if (!fromSGF){
        String msg = "Characterset not supported: \"" + thisCharset + "\"";
        System.out.println(msg);
        ExceptionHandler.logCommonProblem(e, msg);
      }
      returnValue = GS.getMyDefaultCharset();
    }
    return returnValue;
  }
}